/*
 * Decompiled with CFR 0.152.
 */
package me.zhenxin.zmusic.player.decoder.flac;

import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import me.zhenxin.zmusic.player.decoder.flac.DataFormatException;
import me.zhenxin.zmusic.player.decoder.flac.FlacLowLevelInput;

public abstract class AbstractFlacLowLevelInput
implements FlacLowLevelInput {
    private long byteBufferStartPos;
    private byte[] byteBuffer = new byte[4096];
    private int byteBufferLen;
    private int byteBufferIndex;
    private long bitBuffer;
    private int bitBufferLen;
    private int crc8;
    private int crc16;
    private int crcStartIndex;
    private static final int RICE_DECODING_TABLE_BITS = 13;
    private static final int RICE_DECODING_TABLE_MASK = 8191;
    private static final byte[][] RICE_DECODING_CONSUMED_TABLES = new byte[31][8192];
    private static final int[][] RICE_DECODING_VALUE_TABLES = new int[31][8192];
    private static final int RICE_DECODING_CHUNK = 4;
    private static byte[] CRC8_TABLE;
    private static char[] CRC16_TABLE;

    public AbstractFlacLowLevelInput() {
        this.positionChanged(0L);
    }

    @Override
    public long getPosition() {
        return this.byteBufferStartPos + (long)this.byteBufferIndex - (long)((this.bitBufferLen + 7) / 8);
    }

    @Override
    public int getBitPosition() {
        return -this.bitBufferLen & 7;
    }

    protected void positionChanged(long pos) {
        this.byteBufferStartPos = pos;
        Arrays.fill(this.byteBuffer, (byte)0);
        this.byteBufferLen = 0;
        this.byteBufferIndex = 0;
        this.bitBuffer = 0L;
        this.bitBufferLen = 0;
        this.resetCrcs();
    }

    private void checkByteAligned() {
        if (this.bitBufferLen % 8 != 0) {
            throw new IllegalStateException("Not at a byte boundary");
        }
    }

    @Override
    public int readUint(int n) throws IOException {
        if (n < 0 || n > 32) {
            throw new IllegalArgumentException();
        }
        while (this.bitBufferLen < n) {
            int b = this.readUnderlying();
            if (b == -1) {
                throw new EOFException();
            }
            this.bitBuffer = this.bitBuffer << 8 | (long)b;
            this.bitBufferLen += 8;
            assert (0 <= this.bitBufferLen && this.bitBufferLen <= 64);
        }
        int result = (int)(this.bitBuffer >>> this.bitBufferLen - n);
        if (n != 32) assert ((result &= (1 << n) - 1) >>> n == 0);
        this.bitBufferLen -= n;
        assert (0 <= this.bitBufferLen && this.bitBufferLen <= 64);
        return result;
    }

    @Override
    public int readSignedInt(int n) throws IOException {
        int shift = 32 - n;
        return this.readUint(n) << shift >> shift;
    }

    @Override
    public void readRiceSignedInts(int param, long[] result, int start, int end) throws IOException {
        if (param < 0 || param > 31) {
            throw new IllegalArgumentException();
        }
        long unaryLimit = 1L << 53 - param;
        byte[] consumeTable = RICE_DECODING_CONSUMED_TABLES[param];
        int[] valueTable = RICE_DECODING_VALUE_TABLES[param];
        block0: while (true) {
            block10: {
                block11: {
                    if (start > end - 4) break block10;
                    if (this.bitBufferLen >= 52) break block11;
                    if (this.byteBufferIndex > this.byteBufferLen - 8) break block10;
                    this.fillBitBuffer();
                }
                int i = 0;
                while (true) {
                    if (i >= 4) continue block0;
                    int extractedBits = (int)(this.bitBuffer >>> this.bitBufferLen - 13) & 0x1FFF;
                    byte consumed = consumeTable[extractedBits];
                    if (consumed == 0) break;
                    this.bitBufferLen -= consumed;
                    result[start] = valueTable[extractedBits];
                    ++i;
                    ++start;
                }
            }
            if (start >= end) break;
            long val = 0L;
            while (this.readUint(1) == 0) {
                if (val >= unaryLimit) {
                    throw new DataFormatException("Residual value too large");
                }
                ++val;
            }
            val = val << param | (long)this.readUint(param);
            assert (val >>> 53 == 0L);
            val = val >>> 1 ^ -(val & 1L);
            assert (val >> 52 == 0L || val >> 52 == -1L);
            result[start] = val;
            ++start;
        }
    }

    private void fillBitBuffer() throws IOException {
        int i = this.byteBufferIndex;
        int n = Math.min(64 - this.bitBufferLen >>> 3, this.byteBufferLen - i);
        byte[] b = this.byteBuffer;
        if (n > 0) {
            int j = 0;
            while (j < n) {
                this.bitBuffer = this.bitBuffer << 8 | (long)(b[i] & 0xFF);
                ++j;
                ++i;
            }
            this.bitBufferLen += n << 3;
        } else if (this.bitBufferLen <= 56) {
            int temp = this.readUnderlying();
            if (temp == -1) {
                throw new EOFException();
            }
            this.bitBuffer = this.bitBuffer << 8 | (long)temp;
            this.bitBufferLen += 8;
        }
        assert (8 <= this.bitBufferLen && this.bitBufferLen <= 64);
        this.byteBufferIndex += n;
    }

    @Override
    public int readByte() throws IOException {
        this.checkByteAligned();
        if (this.bitBufferLen >= 8) {
            return this.readUint(8);
        }
        assert (this.bitBufferLen == 0);
        return this.readUnderlying();
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        Objects.requireNonNull(b);
        this.checkByteAligned();
        for (int i = 0; i < b.length; ++i) {
            b[i] = (byte)this.readUint(8);
        }
    }

    private int readUnderlying() throws IOException {
        if (this.byteBufferIndex >= this.byteBufferLen) {
            if (this.byteBufferLen == -1) {
                return -1;
            }
            this.byteBufferStartPos += (long)this.byteBufferLen;
            this.updateCrcs(0);
            this.byteBufferLen = this.readUnderlying(this.byteBuffer, 0, this.byteBuffer.length);
            this.crcStartIndex = 0;
            if (this.byteBufferLen <= 0) {
                return -1;
            }
            this.byteBufferIndex = 0;
        }
        assert (this.byteBufferIndex < this.byteBufferLen);
        int temp = this.byteBuffer[this.byteBufferIndex] & 0xFF;
        ++this.byteBufferIndex;
        return temp;
    }

    protected abstract int readUnderlying(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public void resetCrcs() {
        this.checkByteAligned();
        this.crcStartIndex = this.byteBufferIndex - this.bitBufferLen / 8;
        this.crc8 = 0;
        this.crc16 = 0;
    }

    @Override
    public int getCrc8() {
        this.checkByteAligned();
        this.updateCrcs(this.bitBufferLen / 8);
        if (this.crc8 >>> 8 != 0) {
            throw new AssertionError();
        }
        return this.crc8;
    }

    @Override
    public int getCrc16() {
        this.checkByteAligned();
        this.updateCrcs(this.bitBufferLen / 8);
        if (this.crc16 >>> 16 != 0) {
            throw new AssertionError();
        }
        return this.crc16;
    }

    private void updateCrcs(int unusedTrailingBytes) {
        int end = this.byteBufferIndex - unusedTrailingBytes;
        for (int i = this.crcStartIndex; i < end; ++i) {
            int b = this.byteBuffer[i] & 0xFF;
            this.crc8 = CRC8_TABLE[this.crc8 ^ b] & 0xFF;
            this.crc16 = CRC16_TABLE[this.crc16 >>> 8 ^ b] ^ (this.crc16 & 0xFF) << 8;
            assert (this.crc8 >>> 8 == 0);
            assert (this.crc16 >>> 16 == 0);
        }
        this.crcStartIndex = end;
    }

    @Override
    public void close() throws IOException {
        this.byteBuffer = null;
        this.byteBufferLen = -1;
        this.byteBufferIndex = -1;
        this.bitBuffer = 0L;
        this.bitBufferLen = -1;
        this.crc8 = -1;
        this.crc16 = -1;
        this.crcStartIndex = -1;
    }

    static {
        for (int param = 0; param < RICE_DECODING_CONSUMED_TABLES.length; ++param) {
            int numBits;
            byte[] consumed = RICE_DECODING_CONSUMED_TABLES[param];
            int[] values = RICE_DECODING_VALUE_TABLES[param];
            int i = 0;
            while ((numBits = (i >>> param) + 1 + param) <= 13) {
                int bits = 1 << param | i & (1 << param) - 1;
                int shift = 13 - numBits;
                for (int j = 0; j < 1 << shift; ++j) {
                    consumed[bits << shift | j] = (byte)numBits;
                    values[bits << shift | j] = i >>> 1 ^ -(i & 1);
                }
                ++i;
            }
            if (consumed[0] != 0) {
                throw new AssertionError();
            }
        }
        CRC8_TABLE = new byte[256];
        CRC16_TABLE = new char[256];
        for (int i = 0; i < CRC8_TABLE.length; ++i) {
            int temp8 = i;
            int temp16 = i << 8;
            for (int j = 0; j < 8; ++j) {
                temp8 = temp8 << 1 ^ (temp8 >>> 7) * 263;
                temp16 = temp16 << 1 ^ (temp16 >>> 15) * 98309;
            }
            AbstractFlacLowLevelInput.CRC8_TABLE[i] = (byte)temp8;
            AbstractFlacLowLevelInput.CRC16_TABLE[i] = (char)temp16;
        }
    }
}

