/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.ProgressBar;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.Pools;

public class Slider
extends ProgressBar {
    int button = -1;
    int draggingPointer = -1;
    boolean mouseOver;
    private Interpolation visualInterpolationInverse = Interpolation.linear;
    private float[] snapValues;
    private float threshold;

    public Slider(float min, float max, float stepSize, boolean vertical, Skin skin) {
        this(min, max, stepSize, vertical, skin.get("default-" + (vertical ? "vertical" : "horizontal"), SliderStyle.class));
    }

    public Slider(float min, float max, float stepSize, boolean vertical, Skin skin, String styleName) {
        this(min, max, stepSize, vertical, skin.get(styleName, SliderStyle.class));
    }

    public Slider(float min, float max, float stepSize, boolean vertical, SliderStyle style2) {
        super(min, max, stepSize, vertical, style2);
        this.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (Slider.this.disabled) {
                    return false;
                }
                if (Slider.this.button != -1 && Slider.this.button != button) {
                    return false;
                }
                if (Slider.this.draggingPointer != -1) {
                    return false;
                }
                Slider.this.draggingPointer = pointer;
                Slider.this.calculatePositionAndValue(x, y);
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (pointer != Slider.this.draggingPointer) {
                    return;
                }
                Slider.this.draggingPointer = -1;
                if (event.isTouchFocusCancel() || !Slider.this.calculatePositionAndValue(x, y)) {
                    ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
                    Slider.this.fire(changeEvent);
                    Pools.free(changeEvent);
                }
            }

            @Override
            public void touchDragged(InputEvent event, float x, float y, int pointer) {
                Slider.this.calculatePositionAndValue(x, y);
            }

            @Override
            public void enter(InputEvent event, float x, float y, int pointer, @Null Actor fromActor) {
                if (pointer == -1) {
                    Slider.this.mouseOver = true;
                }
            }

            @Override
            public void exit(InputEvent event, float x, float y, int pointer, @Null Actor toActor) {
                if (pointer == -1) {
                    Slider.this.mouseOver = false;
                }
            }
        });
    }

    @Override
    public SliderStyle getStyle() {
        return (SliderStyle)super.getStyle();
    }

    public boolean isOver() {
        return this.mouseOver;
    }

    @Override
    @Null
    protected Drawable getBackgroundDrawable() {
        SliderStyle style2 = (SliderStyle)super.getStyle();
        if (this.disabled && style2.disabledBackground != null) {
            return style2.disabledBackground;
        }
        if (this.isDragging() && style2.backgroundDown != null) {
            return style2.backgroundDown;
        }
        if (this.mouseOver && style2.backgroundOver != null) {
            return style2.backgroundOver;
        }
        return style2.background;
    }

    @Override
    @Null
    protected Drawable getKnobDrawable() {
        SliderStyle style2 = (SliderStyle)super.getStyle();
        if (this.disabled && style2.disabledKnob != null) {
            return style2.disabledKnob;
        }
        if (this.isDragging() && style2.knobDown != null) {
            return style2.knobDown;
        }
        if (this.mouseOver && style2.knobOver != null) {
            return style2.knobOver;
        }
        return style2.knob;
    }

    @Override
    protected Drawable getKnobBeforeDrawable() {
        SliderStyle style2 = (SliderStyle)super.getStyle();
        if (this.disabled && style2.disabledKnobBefore != null) {
            return style2.disabledKnobBefore;
        }
        if (this.isDragging() && style2.knobBeforeDown != null) {
            return style2.knobBeforeDown;
        }
        if (this.mouseOver && style2.knobBeforeOver != null) {
            return style2.knobBeforeOver;
        }
        return style2.knobBefore;
    }

    @Override
    protected Drawable getKnobAfterDrawable() {
        SliderStyle style2 = (SliderStyle)super.getStyle();
        if (this.disabled && style2.disabledKnobAfter != null) {
            return style2.disabledKnobAfter;
        }
        if (this.isDragging() && style2.knobAfterDown != null) {
            return style2.knobAfterDown;
        }
        if (this.mouseOver && style2.knobAfterOver != null) {
            return style2.knobAfterOver;
        }
        return style2.knobAfter;
    }

    boolean calculatePositionAndValue(float x, float y) {
        float value;
        SliderStyle style2 = this.getStyle();
        Drawable knob = style2.knob;
        Drawable bg = this.getBackgroundDrawable();
        float oldPosition = this.position;
        float min = this.getMinValue();
        float max = this.getMaxValue();
        if (this.vertical) {
            float height = this.getHeight() - bg.getTopHeight() - bg.getBottomHeight();
            float knobHeight = knob == null ? 0.0f : knob.getMinHeight();
            this.position = y - bg.getBottomHeight() - knobHeight * 0.5f;
            value = min + (max - min) * this.visualInterpolationInverse.apply(this.position / (height - knobHeight));
            this.position = Math.max(Math.min(0.0f, bg.getBottomHeight()), this.position);
            this.position = Math.min(height - knobHeight, this.position);
        } else {
            float width = this.getWidth() - bg.getLeftWidth() - bg.getRightWidth();
            float knobWidth = knob == null ? 0.0f : knob.getMinWidth();
            this.position = x - bg.getLeftWidth() - knobWidth * 0.5f;
            value = min + (max - min) * this.visualInterpolationInverse.apply(this.position / (width - knobWidth));
            this.position = Math.max(Math.min(0.0f, bg.getLeftWidth()), this.position);
            this.position = Math.min(width - knobWidth, this.position);
        }
        float oldValue = value;
        if (!Gdx.input.isKeyPressed(59) && !Gdx.input.isKeyPressed(60)) {
            value = this.snap(value);
        }
        boolean valueSet = this.setValue(value);
        if (value == oldValue) {
            this.position = oldPosition;
        }
        return valueSet;
    }

    protected float snap(float value) {
        if (this.snapValues == null || this.snapValues.length == 0) {
            return value;
        }
        float bestDiff = -1.0f;
        float bestValue = 0.0f;
        for (int i = 0; i < this.snapValues.length; ++i) {
            float snapValue = this.snapValues[i];
            float diff = Math.abs(value - snapValue);
            if (!(diff <= this.threshold) || bestDiff != -1.0f && !(diff < bestDiff)) continue;
            bestDiff = diff;
            bestValue = snapValue;
        }
        return bestDiff == -1.0f ? value : bestValue;
    }

    public void setSnapToValues(float threshold, float ... values) {
        if (values != null && values.length == 0) {
            throw new IllegalArgumentException("values cannot be empty.");
        }
        this.snapValues = values;
        this.threshold = threshold;
    }

    @Deprecated
    public void setSnapToValues(@Null float[] values, float threshold) {
        this.setSnapToValues(threshold, values);
    }

    @Null
    public float[] getSnapToValues() {
        return this.snapValues;
    }

    public float getSnapToValuesThreshold() {
        return this.threshold;
    }

    public boolean isDragging() {
        return this.draggingPointer != -1;
    }

    public void setButton(int button) {
        this.button = button;
    }

    public void setVisualInterpolationInverse(Interpolation interpolation) {
        this.visualInterpolationInverse = interpolation;
    }

    public void setVisualPercent(float percent) {
        this.setValue(this.min + (this.max - this.min) * this.visualInterpolationInverse.apply(percent));
    }

    public static class SliderStyle
    extends ProgressBar.ProgressBarStyle {
        @Null
        public Drawable backgroundOver;
        @Null
        public Drawable backgroundDown;
        @Null
        public Drawable knobOver;
        @Null
        public Drawable knobDown;
        @Null
        public Drawable knobBeforeOver;
        @Null
        public Drawable knobBeforeDown;
        @Null
        public Drawable knobAfterOver;
        @Null
        public Drawable knobAfterDown;

        public SliderStyle() {
        }

        public SliderStyle(@Null Drawable background, @Null Drawable knob) {
            super(background, knob);
        }

        public SliderStyle(SliderStyle style2) {
            super(style2);
            this.backgroundOver = style2.backgroundOver;
            this.backgroundDown = style2.backgroundDown;
            this.knobOver = style2.knobOver;
            this.knobDown = style2.knobDown;
            this.knobBeforeOver = style2.knobBeforeOver;
            this.knobBeforeDown = style2.knobBeforeDown;
            this.knobAfterOver = style2.knobAfterOver;
            this.knobAfterDown = style2.knobAfterDown;
        }
    }
}

