/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Tooltip;
import com.badlogic.gdx.scenes.scene2d.ui.TooltipManager;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Null;

public class TextTooltip
extends Tooltip<Label> {
    public TextTooltip(@Null String text, Skin skin) {
        this(text, TooltipManager.getInstance(), skin.get(TextTooltipStyle.class));
    }

    public TextTooltip(@Null String text, Skin skin, String styleName) {
        this(text, TooltipManager.getInstance(), skin.get(styleName, TextTooltipStyle.class));
    }

    public TextTooltip(@Null String text, TextTooltipStyle style2) {
        this(text, TooltipManager.getInstance(), style2);
    }

    public TextTooltip(@Null String text, TooltipManager manager, Skin skin) {
        this(text, manager, skin.get(TextTooltipStyle.class));
    }

    public TextTooltip(@Null String text, TooltipManager manager, Skin skin, String styleName) {
        this(text, manager, skin.get(styleName, TextTooltipStyle.class));
    }

    public TextTooltip(@Null String text, TooltipManager manager, TextTooltipStyle style2) {
        super(null, manager);
        this.container.setActor(this.newLabel(text, style2.label));
        this.setStyle(style2);
    }

    protected Label newLabel(String text, Label.LabelStyle style2) {
        return new Label((CharSequence)text, style2);
    }

    public void setStyle(TextTooltipStyle style2) {
        if (style2 == null) {
            throw new NullPointerException("style cannot be null");
        }
        this.container.setBackground(style2.background);
        this.container.maxWidth(style2.wrapWidth);
        boolean wrap = style2.wrapWidth != 0.0f;
        this.container.fill(wrap);
        Label label = (Label)this.container.getActor();
        label.setStyle(style2.label);
        label.setWrap(wrap);
    }

    public static class TextTooltipStyle {
        public Label.LabelStyle label;
        @Null
        public Drawable background;
        public float wrapWidth;

        public TextTooltipStyle() {
        }

        public TextTooltipStyle(Label.LabelStyle label, @Null Drawable background) {
            this.label = label;
            this.background = background;
        }

        public TextTooltipStyle(TextTooltipStyle style2) {
            this.label = new Label.LabelStyle(style2.label);
            this.background = style2.background;
            this.wrapWidth = style2.wrapWidth;
        }
    }
}

