/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.ObjectSet;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.Event;
import com.esotericsoftware.spine.IkConstraint;
import com.esotericsoftware.spine.PathConstraint;
import com.esotericsoftware.spine.PathConstraintData;
import com.esotericsoftware.spine.PhysicsConstraint;
import com.esotericsoftware.spine.PhysicsConstraintData;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.TransformConstraint;
import com.esotericsoftware.spine.TransformConstraintData;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.HasTextureRegion;
import com.esotericsoftware.spine.attachments.Sequence;
import com.esotericsoftware.spine.attachments.VertexAttachment;
import com.esotericsoftware.spine.utils.SpineUtils;

public class Animation {
    final String name;
    Array<Timeline> timelines;
    final ObjectSet<String> timelineIds;
    float duration;

    public Animation(String name, Array<Timeline> timelines, float duration) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        this.name = name;
        this.duration = duration;
        this.timelineIds = new ObjectSet(timelines.size);
        this.setTimelines(timelines);
    }

    public Array<Timeline> getTimelines() {
        return this.timelines;
    }

    public void setTimelines(Array<Timeline> timelines) {
        if (timelines == null) {
            throw new IllegalArgumentException("timelines cannot be null.");
        }
        this.timelines = timelines;
        int n2 = timelines.size;
        this.timelineIds.clear(n2);
        T[] items = timelines.items;
        for (int i = 0; i < n2; ++i) {
            this.timelineIds.addAll((String[])((Timeline)items[i]).getPropertyIds());
        }
    }

    public boolean hasTimeline(String[] propertyIds) {
        for (String id2 : propertyIds) {
            if (!this.timelineIds.contains(id2)) continue;
            return true;
        }
        return false;
    }

    public float getDuration() {
        return this.duration;
    }

    public void setDuration(float duration) {
        this.duration = duration;
    }

    public void apply(Skeleton skeleton, float lastTime, float time, boolean loop, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        if (loop && this.duration != 0.0f) {
            time %= this.duration;
            if (lastTime > 0.0f) {
                lastTime %= this.duration;
            }
        }
        T[] timelines = this.timelines.items;
        int n2 = this.timelines.size;
        for (int i = 0; i < n2; ++i) {
            ((Timeline)timelines[i]).apply(skeleton, lastTime, time, events, alpha, blend, direction);
        }
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public static abstract class Timeline {
        private final String[] propertyIds;
        final float[] frames;

        public Timeline(int frameCount, String ... propertyIds) {
            if (propertyIds == null) {
                throw new IllegalArgumentException("propertyIds cannot be null.");
            }
            this.propertyIds = propertyIds;
            this.frames = new float[frameCount * this.getFrameEntries()];
        }

        public String[] getPropertyIds() {
            return this.propertyIds;
        }

        public float[] getFrames() {
            return this.frames;
        }

        public int getFrameEntries() {
            return 1;
        }

        public int getFrameCount() {
            return this.frames.length / this.getFrameEntries();
        }

        public float getDuration() {
            return this.frames[this.frames.length - this.getFrameEntries()];
        }

        public abstract void apply(Skeleton var1, float var2, float var3, @Null Array<Event> var4, float var5, MixBlend var6, MixDirection var7);

        static int search(float[] frames, float time) {
            int n2 = frames.length;
            for (int i = 1; i < n2; ++i) {
                if (!(frames[i] > time)) continue;
                return i - 1;
            }
            return n2 - 1;
        }

        static int search(float[] frames, float time, int step) {
            int n2 = frames.length;
            for (int i = step; i < n2; i += step) {
                if (!(frames[i] > time)) continue;
                return i - step;
            }
            return n2 - step;
        }
    }

    public static enum MixBlend {
        setup,
        first,
        replace,
        add;

    }

    public static enum MixDirection {
        in,
        out;

    }

    public static class SequenceTimeline
    extends Timeline
    implements SlotTimeline {
        public static final int ENTRIES = 3;
        private static final int MODE = 1;
        private static final int DELAY = 2;
        final int slotIndex;
        final HasTextureRegion attachment;

        public SequenceTimeline(int frameCount, int slotIndex, Attachment attachment) {
            super(frameCount, Property.sequence.ordinal() + "|" + slotIndex + "|" + ((HasTextureRegion)((Object)attachment)).getSequence().getId());
            this.slotIndex = slotIndex;
            this.attachment = (HasTextureRegion)((Object)attachment);
        }

        @Override
        public int getFrameEntries() {
            return 3;
        }

        @Override
        public int getSlotIndex() {
            return this.slotIndex;
        }

        public Attachment getAttachment() {
            return (Attachment)((Object)this.attachment);
        }

        public void setFrame(int frame, float time, Sequence.SequenceMode mode, int index, float delay) {
            this.frames[frame *= 3] = time;
            this.frames[frame + 1] = mode.ordinal() | index << 4;
            this.frames[frame + 2] = delay;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
            Slot slot = skeleton.slots.get(this.slotIndex);
            if (!slot.bone.active) {
                return;
            }
            Attachment slotAttachment = slot.attachment;
            if (!(slotAttachment == this.attachment || slotAttachment instanceof VertexAttachment && ((VertexAttachment)slotAttachment).getTimelineAttachment() == this.attachment)) {
                return;
            }
            Sequence sequence = ((HasTextureRegion)((Object)slotAttachment)).getSequence();
            if (sequence == null) {
                return;
            }
            float[] frames = this.frames;
            if (time < frames[0]) {
                if (blend == MixBlend.setup || blend == MixBlend.first) {
                    slot.setSequenceIndex(-1);
                }
                return;
            }
            int i = SequenceTimeline.search(frames, time, 3);
            float before = frames[i];
            int modeAndIndex = (int)frames[i + 1];
            float delay = frames[i + 2];
            int index = modeAndIndex >> 4;
            int count = sequence.getRegions().length;
            Sequence.SequenceMode mode = Sequence.SequenceMode.values[modeAndIndex & 0xF];
            if (mode != Sequence.SequenceMode.hold) {
                index = (int)((float)index + ((time - before) / delay + 1.0E-4f));
                switch (mode) {
                    case once: {
                        index = Math.min(count - 1, index);
                        break;
                    }
                    case loop: {
                        index %= count;
                        break;
                    }
                    case pingpong: {
                        int n2 = (count << 1) - 2;
                        int n3 = index = n2 == 0 ? 0 : index % n2;
                        if (index < count) break;
                        index = n2 - index;
                        break;
                    }
                    case onceReverse: {
                        index = Math.max(count - 1 - index, 0);
                        break;
                    }
                    case loopReverse: {
                        index = count - 1 - index % count;
                        break;
                    }
                    case pingpongReverse: {
                        int n4 = (count << 1) - 2;
                        int n5 = index = n4 == 0 ? 0 : (index + count - 1) % n4;
                        if (index < count) break;
                        index = n4 - index;
                    }
                }
            }
            slot.setSequenceIndex(index);
        }
    }

    public static class PhysicsConstraintResetTimeline
    extends Timeline {
        private static final String[] propertyIds = new String[]{Integer.toString(Property.physicsConstraintReset.ordinal())};
        final int constraintIndex;

        public PhysicsConstraintResetTimeline(int frameCount, int physicsConstraintIndex) {
            super(frameCount, propertyIds);
            this.constraintIndex = physicsConstraintIndex;
        }

        public int getPhysicsConstraintIndex() {
            return this.constraintIndex;
        }

        @Override
        public int getFrameCount() {
            return this.frames.length;
        }

        public void setFrame(int frame, float time) {
            this.frames[frame] = time;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> firedEvents, float alpha, MixBlend blend, MixDirection direction) {
            PhysicsConstraint constraint = null;
            if (this.constraintIndex != -1) {
                constraint = skeleton.physicsConstraints.get(this.constraintIndex);
                if (!constraint.active) {
                    return;
                }
            }
            float[] frames = this.frames;
            if (lastTime > time) {
                this.apply(skeleton, lastTime, 2.1474836E9f, null, alpha, blend, direction);
                lastTime = -1.0f;
            } else if (lastTime >= frames[frames.length - 1]) {
                return;
            }
            if (time < frames[0]) {
                return;
            }
            if (lastTime < frames[0] || time >= frames[PhysicsConstraintResetTimeline.search(frames, lastTime) + 1]) {
                if (constraint != null) {
                    constraint.reset();
                } else {
                    T[] constraints = skeleton.physicsConstraints.items;
                    int n2 = skeleton.physicsConstraints.size;
                    for (int i = 0; i < n2; ++i) {
                        constraint = (PhysicsConstraint)constraints[i];
                        if (!constraint.active) continue;
                        constraint.reset();
                    }
                }
            }
        }
    }

    public static class PhysicsConstraintMixTimeline
    extends PhysicsConstraintTimeline {
        public PhysicsConstraintMixTimeline(int frameCount, int bezierCount, int physicsConstraintIndex) {
            super(frameCount, bezierCount, physicsConstraintIndex, Property.physicsConstraintMix);
        }

        @Override
        protected float setup(PhysicsConstraint constraint) {
            return constraint.data.mix;
        }

        @Override
        protected float get(PhysicsConstraint constraint) {
            return constraint.mix;
        }

        @Override
        protected void set(PhysicsConstraint constraint, float value) {
            constraint.mix = value;
        }

        @Override
        protected boolean global(PhysicsConstraintData constraint) {
            return constraint.mixGlobal;
        }
    }

    public static class PhysicsConstraintGravityTimeline
    extends PhysicsConstraintTimeline {
        public PhysicsConstraintGravityTimeline(int frameCount, int bezierCount, int physicsConstraintIndex) {
            super(frameCount, bezierCount, physicsConstraintIndex, Property.physicsConstraintGravity);
        }

        @Override
        protected float setup(PhysicsConstraint constraint) {
            return constraint.data.gravity;
        }

        @Override
        protected float get(PhysicsConstraint constraint) {
            return constraint.gravity;
        }

        @Override
        protected void set(PhysicsConstraint constraint, float value) {
            constraint.gravity = value;
        }

        @Override
        protected boolean global(PhysicsConstraintData constraint) {
            return constraint.gravityGlobal;
        }
    }

    public static class PhysicsConstraintWindTimeline
    extends PhysicsConstraintTimeline {
        public PhysicsConstraintWindTimeline(int frameCount, int bezierCount, int physicsConstraintIndex) {
            super(frameCount, bezierCount, physicsConstraintIndex, Property.physicsConstraintWind);
        }

        @Override
        protected float setup(PhysicsConstraint constraint) {
            return constraint.data.wind;
        }

        @Override
        protected float get(PhysicsConstraint constraint) {
            return constraint.wind;
        }

        @Override
        protected void set(PhysicsConstraint constraint, float value) {
            constraint.wind = value;
        }

        @Override
        protected boolean global(PhysicsConstraintData constraint) {
            return constraint.windGlobal;
        }
    }

    public static class PhysicsConstraintMassTimeline
    extends PhysicsConstraintTimeline {
        public PhysicsConstraintMassTimeline(int frameCount, int bezierCount, int physicsConstraintIndex) {
            super(frameCount, bezierCount, physicsConstraintIndex, Property.physicsConstraintMass);
        }

        @Override
        protected float setup(PhysicsConstraint constraint) {
            return 1.0f / constraint.data.massInverse;
        }

        @Override
        protected float get(PhysicsConstraint constraint) {
            return 1.0f / constraint.massInverse;
        }

        @Override
        protected void set(PhysicsConstraint constraint, float value) {
            constraint.massInverse = 1.0f / value;
        }

        @Override
        protected boolean global(PhysicsConstraintData constraint) {
            return constraint.massGlobal;
        }
    }

    public static class PhysicsConstraintDampingTimeline
    extends PhysicsConstraintTimeline {
        public PhysicsConstraintDampingTimeline(int frameCount, int bezierCount, int physicsConstraintIndex) {
            super(frameCount, bezierCount, physicsConstraintIndex, Property.physicsConstraintDamping);
        }

        @Override
        protected float setup(PhysicsConstraint constraint) {
            return constraint.data.damping;
        }

        @Override
        protected float get(PhysicsConstraint constraint) {
            return constraint.damping;
        }

        @Override
        protected void set(PhysicsConstraint constraint, float value) {
            constraint.damping = value;
        }

        @Override
        protected boolean global(PhysicsConstraintData constraint) {
            return constraint.dampingGlobal;
        }
    }

    public static class PhysicsConstraintStrengthTimeline
    extends PhysicsConstraintTimeline {
        public PhysicsConstraintStrengthTimeline(int frameCount, int bezierCount, int physicsConstraintIndex) {
            super(frameCount, bezierCount, physicsConstraintIndex, Property.physicsConstraintStrength);
        }

        @Override
        protected float setup(PhysicsConstraint constraint) {
            return constraint.data.strength;
        }

        @Override
        protected float get(PhysicsConstraint constraint) {
            return constraint.strength;
        }

        @Override
        protected void set(PhysicsConstraint constraint, float value) {
            constraint.strength = value;
        }

        @Override
        protected boolean global(PhysicsConstraintData constraint) {
            return constraint.strengthGlobal;
        }
    }

    public static class PhysicsConstraintInertiaTimeline
    extends PhysicsConstraintTimeline {
        public PhysicsConstraintInertiaTimeline(int frameCount, int bezierCount, int physicsConstraintIndex) {
            super(frameCount, bezierCount, physicsConstraintIndex, Property.physicsConstraintInertia);
        }

        @Override
        protected float setup(PhysicsConstraint constraint) {
            return constraint.data.inertia;
        }

        @Override
        protected float get(PhysicsConstraint constraint) {
            return constraint.inertia;
        }

        @Override
        protected void set(PhysicsConstraint constraint, float value) {
            constraint.inertia = value;
        }

        @Override
        protected boolean global(PhysicsConstraintData constraint) {
            return constraint.inertiaGlobal;
        }
    }

    public static abstract class PhysicsConstraintTimeline
    extends CurveTimeline1 {
        final int constraintIndex;

        public PhysicsConstraintTimeline(int frameCount, int bezierCount, int physicsConstraintIndex, Property property) {
            super(frameCount, bezierCount, property.ordinal() + "|" + physicsConstraintIndex);
            this.constraintIndex = physicsConstraintIndex;
        }

        public int getPhysicsConstraintIndex() {
            return this.constraintIndex;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
            if (this.constraintIndex == -1) {
                float value = time >= this.frames[0] ? this.getCurveValue(time) : 0.0f;
                T[] constraints = skeleton.physicsConstraints.items;
                int n2 = skeleton.physicsConstraints.size;
                for (int i = 0; i < n2; ++i) {
                    PhysicsConstraint constraint = (PhysicsConstraint)constraints[i];
                    if (!constraint.active || !this.global(constraint.data)) continue;
                    this.set(constraint, this.getAbsoluteValue(time, alpha, blend, this.get(constraint), this.setup(constraint), value));
                }
            } else {
                PhysicsConstraint constraint = skeleton.physicsConstraints.get(this.constraintIndex);
                if (constraint.active) {
                    this.set(constraint, this.getAbsoluteValue(time, alpha, blend, this.get(constraint), this.setup(constraint)));
                }
            }
        }

        protected abstract float setup(PhysicsConstraint var1);

        protected abstract float get(PhysicsConstraint var1);

        protected abstract void set(PhysicsConstraint var1, float var2);

        protected abstract boolean global(PhysicsConstraintData var1);
    }

    public static class PathConstraintMixTimeline
    extends CurveTimeline {
        public static final int ENTRIES = 4;
        private static final int ROTATE = 1;
        private static final int X = 2;
        private static final int Y = 3;
        final int constraintIndex;

        public PathConstraintMixTimeline(int frameCount, int bezierCount, int pathConstraintIndex) {
            super(frameCount, bezierCount, Property.pathConstraintMix.ordinal() + "|" + pathConstraintIndex);
            this.constraintIndex = pathConstraintIndex;
        }

        @Override
        public int getFrameEntries() {
            return 4;
        }

        public int getPathConstraintIndex() {
            return this.constraintIndex;
        }

        public void setFrame(int frame, float time, float mixRotate, float mixX, float mixY) {
            this.frames[frame <<= 2] = time;
            this.frames[frame + 1] = mixRotate;
            this.frames[frame + 2] = mixX;
            this.frames[frame + 3] = mixY;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
            float y;
            float x;
            float rotate;
            PathConstraint constraint = skeleton.pathConstraints.get(this.constraintIndex);
            if (!constraint.active) {
                return;
            }
            float[] frames = this.frames;
            if (time < frames[0]) {
                PathConstraintData data = constraint.data;
                switch (blend) {
                    case setup: {
                        constraint.mixRotate = data.mixRotate;
                        constraint.mixX = data.mixX;
                        constraint.mixY = data.mixY;
                        return;
                    }
                    case first: {
                        constraint.mixRotate += (data.mixRotate - constraint.mixRotate) * alpha;
                        constraint.mixX += (data.mixX - constraint.mixX) * alpha;
                        constraint.mixY += (data.mixY - constraint.mixY) * alpha;
                    }
                }
                return;
            }
            int i = PathConstraintMixTimeline.search(frames, time, 4);
            int curveType = (int)this.curves[i >> 2];
            switch (curveType) {
                case 0: {
                    float before = frames[i];
                    rotate = frames[i + 1];
                    x = frames[i + 2];
                    y = frames[i + 3];
                    float t2 = (time - before) / (frames[i + 4] - before);
                    rotate += (frames[i + 4 + 1] - rotate) * t2;
                    x += (frames[i + 4 + 2] - x) * t2;
                    y += (frames[i + 4 + 3] - y) * t2;
                    break;
                }
                case 1: {
                    rotate = frames[i + 1];
                    x = frames[i + 2];
                    y = frames[i + 3];
                    break;
                }
                default: {
                    rotate = this.getBezierValue(time, i, 1, curveType - 2);
                    x = this.getBezierValue(time, i, 2, curveType + 18 - 2);
                    y = this.getBezierValue(time, i, 3, curveType + 36 - 2);
                }
            }
            if (blend == MixBlend.setup) {
                PathConstraintData data = constraint.data;
                constraint.mixRotate = data.mixRotate + (rotate - data.mixRotate) * alpha;
                constraint.mixX = data.mixX + (x - data.mixX) * alpha;
                constraint.mixY = data.mixY + (y - data.mixY) * alpha;
            } else {
                constraint.mixRotate += (rotate - constraint.mixRotate) * alpha;
                constraint.mixX += (x - constraint.mixX) * alpha;
                constraint.mixY += (y - constraint.mixY) * alpha;
            }
        }
    }

    public static class PathConstraintSpacingTimeline
    extends CurveTimeline1 {
        final int constraintIndex;

        public PathConstraintSpacingTimeline(int frameCount, int bezierCount, int pathConstraintIndex) {
            super(frameCount, bezierCount, Property.pathConstraintSpacing.ordinal() + "|" + pathConstraintIndex);
            this.constraintIndex = pathConstraintIndex;
        }

        public int getPathConstraintIndex() {
            return this.constraintIndex;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
            PathConstraint constraint = skeleton.pathConstraints.get(this.constraintIndex);
            if (constraint.active) {
                constraint.spacing = this.getAbsoluteValue(time, alpha, blend, constraint.spacing, constraint.data.spacing);
            }
        }
    }

    public static class PathConstraintPositionTimeline
    extends CurveTimeline1 {
        final int constraintIndex;

        public PathConstraintPositionTimeline(int frameCount, int bezierCount, int pathConstraintIndex) {
            super(frameCount, bezierCount, Property.pathConstraintPosition.ordinal() + "|" + pathConstraintIndex);
            this.constraintIndex = pathConstraintIndex;
        }

        public int getPathConstraintIndex() {
            return this.constraintIndex;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
            PathConstraint constraint = skeleton.pathConstraints.get(this.constraintIndex);
            if (constraint.active) {
                constraint.position = this.getAbsoluteValue(time, alpha, blend, constraint.position, constraint.data.position);
            }
        }
    }

    public static class TransformConstraintTimeline
    extends CurveTimeline {
        public static final int ENTRIES = 7;
        private static final int ROTATE = 1;
        private static final int X = 2;
        private static final int Y = 3;
        private static final int SCALEX = 4;
        private static final int SCALEY = 5;
        private static final int SHEARY = 6;
        final int constraintIndex;

        public TransformConstraintTimeline(int frameCount, int bezierCount, int transformConstraintIndex) {
            super(frameCount, bezierCount, Property.transformConstraint.ordinal() + "|" + transformConstraintIndex);
            this.constraintIndex = transformConstraintIndex;
        }

        @Override
        public int getFrameEntries() {
            return 7;
        }

        public int getTransformConstraintIndex() {
            return this.constraintIndex;
        }

        public void setFrame(int frame, float time, float mixRotate, float mixX, float mixY, float mixScaleX, float mixScaleY, float mixShearY) {
            this.frames[frame *= 7] = time;
            this.frames[frame + 1] = mixRotate;
            this.frames[frame + 2] = mixX;
            this.frames[frame + 3] = mixY;
            this.frames[frame + 4] = mixScaleX;
            this.frames[frame + 5] = mixScaleY;
            this.frames[frame + 6] = mixShearY;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
            float shearY;
            float scaleY;
            float scaleX;
            float y;
            float x;
            float rotate;
            TransformConstraint constraint = skeleton.transformConstraints.get(this.constraintIndex);
            if (!constraint.active) {
                return;
            }
            float[] frames = this.frames;
            if (time < frames[0]) {
                TransformConstraintData data = constraint.data;
                switch (blend) {
                    case setup: {
                        constraint.mixRotate = data.mixRotate;
                        constraint.mixX = data.mixX;
                        constraint.mixY = data.mixY;
                        constraint.mixScaleX = data.mixScaleX;
                        constraint.mixScaleY = data.mixScaleY;
                        constraint.mixShearY = data.mixShearY;
                        return;
                    }
                    case first: {
                        constraint.mixRotate += (data.mixRotate - constraint.mixRotate) * alpha;
                        constraint.mixX += (data.mixX - constraint.mixX) * alpha;
                        constraint.mixY += (data.mixY - constraint.mixY) * alpha;
                        constraint.mixScaleX += (data.mixScaleX - constraint.mixScaleX) * alpha;
                        constraint.mixScaleY += (data.mixScaleY - constraint.mixScaleY) * alpha;
                        constraint.mixShearY += (data.mixShearY - constraint.mixShearY) * alpha;
                    }
                }
                return;
            }
            int i = TransformConstraintTimeline.search(frames, time, 7);
            int curveType = (int)this.curves[i / 7];
            switch (curveType) {
                case 0: {
                    float before = frames[i];
                    rotate = frames[i + 1];
                    x = frames[i + 2];
                    y = frames[i + 3];
                    scaleX = frames[i + 4];
                    scaleY = frames[i + 5];
                    shearY = frames[i + 6];
                    float t2 = (time - before) / (frames[i + 7] - before);
                    rotate += (frames[i + 7 + 1] - rotate) * t2;
                    x += (frames[i + 7 + 2] - x) * t2;
                    y += (frames[i + 7 + 3] - y) * t2;
                    scaleX += (frames[i + 7 + 4] - scaleX) * t2;
                    scaleY += (frames[i + 7 + 5] - scaleY) * t2;
                    shearY += (frames[i + 7 + 6] - shearY) * t2;
                    break;
                }
                case 1: {
                    rotate = frames[i + 1];
                    x = frames[i + 2];
                    y = frames[i + 3];
                    scaleX = frames[i + 4];
                    scaleY = frames[i + 5];
                    shearY = frames[i + 6];
                    break;
                }
                default: {
                    rotate = this.getBezierValue(time, i, 1, curveType - 2);
                    x = this.getBezierValue(time, i, 2, curveType + 18 - 2);
                    y = this.getBezierValue(time, i, 3, curveType + 36 - 2);
                    scaleX = this.getBezierValue(time, i, 4, curveType + 54 - 2);
                    scaleY = this.getBezierValue(time, i, 5, curveType + 72 - 2);
                    shearY = this.getBezierValue(time, i, 6, curveType + 90 - 2);
                }
            }
            if (blend == MixBlend.setup) {
                TransformConstraintData data = constraint.data;
                constraint.mixRotate = data.mixRotate + (rotate - data.mixRotate) * alpha;
                constraint.mixX = data.mixX + (x - data.mixX) * alpha;
                constraint.mixY = data.mixY + (y - data.mixY) * alpha;
                constraint.mixScaleX = data.mixScaleX + (scaleX - data.mixScaleX) * alpha;
                constraint.mixScaleY = data.mixScaleY + (scaleY - data.mixScaleY) * alpha;
                constraint.mixShearY = data.mixShearY + (shearY - data.mixShearY) * alpha;
            } else {
                constraint.mixRotate += (rotate - constraint.mixRotate) * alpha;
                constraint.mixX += (x - constraint.mixX) * alpha;
                constraint.mixY += (y - constraint.mixY) * alpha;
                constraint.mixScaleX += (scaleX - constraint.mixScaleX) * alpha;
                constraint.mixScaleY += (scaleY - constraint.mixScaleY) * alpha;
                constraint.mixShearY += (shearY - constraint.mixShearY) * alpha;
            }
        }
    }

    public static class IkConstraintTimeline
    extends CurveTimeline {
        public static final int ENTRIES = 6;
        private static final int MIX = 1;
        private static final int SOFTNESS = 2;
        private static final int BEND_DIRECTION = 3;
        private static final int COMPRESS = 4;
        private static final int STRETCH = 5;
        final int constraintIndex;

        public IkConstraintTimeline(int frameCount, int bezierCount, int ikConstraintIndex) {
            super(frameCount, bezierCount, Property.ikConstraint.ordinal() + "|" + ikConstraintIndex);
            this.constraintIndex = ikConstraintIndex;
        }

        @Override
        public int getFrameEntries() {
            return 6;
        }

        public int getIkConstraintIndex() {
            return this.constraintIndex;
        }

        public void setFrame(int frame, float time, float mix, float softness, int bendDirection, boolean compress, boolean stretch) {
            this.frames[frame *= 6] = time;
            this.frames[frame + 1] = mix;
            this.frames[frame + 2] = softness;
            this.frames[frame + 3] = bendDirection;
            this.frames[frame + 4] = compress ? 1.0f : 0.0f;
            this.frames[frame + 5] = stretch ? 1.0f : 0.0f;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
            float softness;
            float mix;
            IkConstraint constraint = skeleton.ikConstraints.get(this.constraintIndex);
            if (!constraint.active) {
                return;
            }
            float[] frames = this.frames;
            if (time < frames[0]) {
                switch (blend) {
                    case setup: {
                        constraint.mix = constraint.data.mix;
                        constraint.softness = constraint.data.softness;
                        constraint.bendDirection = constraint.data.bendDirection;
                        constraint.compress = constraint.data.compress;
                        constraint.stretch = constraint.data.stretch;
                        return;
                    }
                    case first: {
                        constraint.mix += (constraint.data.mix - constraint.mix) * alpha;
                        constraint.softness += (constraint.data.softness - constraint.softness) * alpha;
                        constraint.bendDirection = constraint.data.bendDirection;
                        constraint.compress = constraint.data.compress;
                        constraint.stretch = constraint.data.stretch;
                    }
                }
                return;
            }
            int i = IkConstraintTimeline.search(frames, time, 6);
            int curveType = (int)this.curves[i / 6];
            switch (curveType) {
                case 0: {
                    float before = frames[i];
                    mix = frames[i + 1];
                    softness = frames[i + 2];
                    float t2 = (time - before) / (frames[i + 6] - before);
                    mix += (frames[i + 6 + 1] - mix) * t2;
                    softness += (frames[i + 6 + 2] - softness) * t2;
                    break;
                }
                case 1: {
                    mix = frames[i + 1];
                    softness = frames[i + 2];
                    break;
                }
                default: {
                    mix = this.getBezierValue(time, i, 1, curveType - 2);
                    softness = this.getBezierValue(time, i, 2, curveType + 18 - 2);
                }
            }
            if (blend == MixBlend.setup) {
                constraint.mix = constraint.data.mix + (mix - constraint.data.mix) * alpha;
                constraint.softness = constraint.data.softness + (softness - constraint.data.softness) * alpha;
                if (direction == MixDirection.out) {
                    constraint.bendDirection = constraint.data.bendDirection;
                    constraint.compress = constraint.data.compress;
                    constraint.stretch = constraint.data.stretch;
                } else {
                    constraint.bendDirection = (int)frames[i + 3];
                    constraint.compress = frames[i + 4] != 0.0f;
                    constraint.stretch = frames[i + 5] != 0.0f;
                }
            } else {
                constraint.mix += (mix - constraint.mix) * alpha;
                constraint.softness += (softness - constraint.softness) * alpha;
                if (direction == MixDirection.in) {
                    constraint.bendDirection = (int)frames[i + 3];
                    constraint.compress = frames[i + 4] != 0.0f;
                    constraint.stretch = frames[i + 5] != 0.0f;
                }
            }
        }
    }

    public static class DrawOrderTimeline
    extends Timeline {
        private static final String[] propertyIds = new String[]{Integer.toString(Property.drawOrder.ordinal())};
        private final int[][] drawOrders;

        public DrawOrderTimeline(int frameCount) {
            super(frameCount, propertyIds);
            this.drawOrders = new int[frameCount][];
        }

        @Override
        public int getFrameCount() {
            return this.frames.length;
        }

        public int[][] getDrawOrders() {
            return this.drawOrders;
        }

        public void setFrame(int frame, float time, @Null int[] drawOrder) {
            this.frames[frame] = time;
            this.drawOrders[frame] = drawOrder;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
            if (direction == MixDirection.out) {
                if (blend == MixBlend.setup) {
                    SpineUtils.arraycopy(skeleton.slots.items, 0, skeleton.drawOrder.items, 0, skeleton.slots.size);
                }
                return;
            }
            if (time < this.frames[0]) {
                if (blend == MixBlend.setup || blend == MixBlend.first) {
                    SpineUtils.arraycopy(skeleton.slots.items, 0, skeleton.drawOrder.items, 0, skeleton.slots.size);
                }
                return;
            }
            int[] drawOrderToSetupIndex = this.drawOrders[DrawOrderTimeline.search(this.frames, time)];
            if (drawOrderToSetupIndex == null) {
                SpineUtils.arraycopy(skeleton.slots.items, 0, skeleton.drawOrder.items, 0, skeleton.slots.size);
            } else {
                T[] slots = skeleton.slots.items;
                T[] drawOrder = skeleton.drawOrder.items;
                int n2 = drawOrderToSetupIndex.length;
                for (int i = 0; i < n2; ++i) {
                    drawOrder[i] = slots[drawOrderToSetupIndex[i]];
                }
            }
        }
    }

    public static class EventTimeline
    extends Timeline {
        private static final String[] propertyIds = new String[]{Integer.toString(Property.event.ordinal())};
        private final Event[] events;

        public EventTimeline(int frameCount) {
            super(frameCount, propertyIds);
            this.events = new Event[frameCount];
        }

        @Override
        public int getFrameCount() {
            return this.frames.length;
        }

        public Event[] getEvents() {
            return this.events;
        }

        public void setFrame(int frame, Event event) {
            this.frames[frame] = event.time;
            this.events[frame] = event;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> firedEvents, float alpha, MixBlend blend, MixDirection direction) {
            int i;
            if (firedEvents == null) {
                return;
            }
            float[] frames = this.frames;
            int frameCount = frames.length;
            if (lastTime > time) {
                this.apply(skeleton, lastTime, 2.1474836E9f, firedEvents, alpha, blend, direction);
                lastTime = -1.0f;
            } else if (lastTime >= frames[frameCount - 1]) {
                return;
            }
            if (time < frames[0]) {
                return;
            }
            if (lastTime < frames[0]) {
                i = 0;
            } else {
                float frameTime = frames[i];
                for (i = EventTimeline.search(frames, lastTime) + 1; i > 0 && frames[i - 1] == frameTime; --i) {
                }
            }
            while (i < frameCount && time >= frames[i]) {
                firedEvents.add(this.events[i]);
                ++i;
            }
        }
    }

    public static class DeformTimeline
    extends CurveTimeline
    implements SlotTimeline {
        final int slotIndex;
        final VertexAttachment attachment;
        private final float[][] vertices;

        public DeformTimeline(int frameCount, int bezierCount, int slotIndex, VertexAttachment attachment) {
            super(frameCount, bezierCount, Property.deform.ordinal() + "|" + slotIndex + "|" + attachment.getId());
            this.slotIndex = slotIndex;
            this.attachment = attachment;
            this.vertices = new float[frameCount][];
        }

        @Override
        public int getFrameCount() {
            return this.frames.length;
        }

        @Override
        public int getSlotIndex() {
            return this.slotIndex;
        }

        public VertexAttachment getAttachment() {
            return this.attachment;
        }

        public float[][] getVertices() {
            return this.vertices;
        }

        public void setFrame(int frame, float time, float[] vertices) {
            this.frames[frame] = time;
            this.vertices[frame] = vertices;
        }

        @Override
        public void setBezier(int bezier, int frame, int value, float time1, float value1, float cx1, float cy1, float cx2, float cy2, float time2, float value2) {
            float[] curves = this.curves;
            int i = this.getFrameCount() + bezier * 18;
            if (value == 0) {
                curves[frame] = 2 + i;
            }
            float tmpx = (time1 - cx1 * 2.0f + cx2) * 0.03f;
            float tmpy = cy2 * 0.03f - cy1 * 0.06f;
            float dddx = ((cx1 - cx2) * 3.0f - time1 + time2) * 0.006f;
            float dddy = (cy1 - cy2 + 0.33333334f) * 0.018f;
            float ddx = tmpx * 2.0f + dddx;
            float ddy = tmpy * 2.0f + dddy;
            float dx = (cx1 - time1) * 0.3f + tmpx + dddx * 0.16666667f;
            float dy = cy1 * 0.3f + tmpy + dddy * 0.16666667f;
            float x = time1 + dx;
            float y = dy;
            int n2 = i + 18;
            while (i < n2) {
                curves[i] = x;
                curves[i + 1] = y;
                x += (dx += (ddx += dddx));
                y += (dy += (ddy += dddy));
                i += 2;
            }
        }

        private float getCurvePercent(float time, int frame) {
            float[] curves = this.curves;
            int i = (int)curves[frame];
            switch (i) {
                case 0: {
                    float x = this.frames[frame];
                    return (time - x) / (this.frames[frame + this.getFrameEntries()] - x);
                }
                case 1: {
                    return 0.0f;
                }
            }
            i -= 2;
            if (curves[i] > time) {
                float x = this.frames[frame];
                return curves[i + 1] * (time - x) / (curves[i] - x);
            }
            int n2 = i + 18;
            i += 2;
            while (i < n2) {
                if (curves[i] >= time) {
                    float x = curves[i - 2];
                    float y = curves[i - 1];
                    return y + (time - x) / (curves[i] - x) * (curves[i + 1] - y);
                }
                i += 2;
            }
            float x = curves[n2 - 2];
            float y = curves[n2 - 1];
            return y + (1.0f - y) * (time - x) / (this.frames[frame + this.getFrameEntries()] - x);
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
            Slot slot = skeleton.slots.get(this.slotIndex);
            if (!slot.bone.active) {
                return;
            }
            Attachment slotAttachment = slot.attachment;
            if (!(slotAttachment instanceof VertexAttachment) || ((VertexAttachment)slotAttachment).getTimelineAttachment() != this.attachment) {
                return;
            }
            FloatArray deformArray = slot.deform;
            if (deformArray.size == 0) {
                blend = MixBlend.setup;
            }
            float[][] vertices = this.vertices;
            int vertexCount = vertices[0].length;
            float[] frames = this.frames;
            if (time < frames[0]) {
                switch (blend) {
                    case setup: {
                        deformArray.clear();
                        return;
                    }
                    case first: {
                        if (alpha == 1.0f) {
                            deformArray.clear();
                            return;
                        }
                        float[] deform = deformArray.setSize(vertexCount);
                        VertexAttachment vertexAttachment = (VertexAttachment)slotAttachment;
                        if (vertexAttachment.getBones() == null) {
                            float[] setupVertices = vertexAttachment.getVertices();
                            for (int i = 0; i < vertexCount; ++i) {
                                int n2 = i;
                                deform[n2] = deform[n2] + (setupVertices[i] - deform[i]) * alpha;
                            }
                        } else {
                            alpha = 1.0f - alpha;
                            int i = 0;
                            while (i < vertexCount) {
                                int n3 = i++;
                                deform[n3] = deform[n3] * alpha;
                            }
                        }
                        break;
                    }
                }
                return;
            }
            float[] deform = deformArray.setSize(vertexCount);
            if (time >= frames[frames.length - 1]) {
                float[] lastVertices = vertices[frames.length - 1];
                if (alpha == 1.0f) {
                    if (blend == MixBlend.add) {
                        VertexAttachment vertexAttachment = (VertexAttachment)slotAttachment;
                        if (vertexAttachment.getBones() == null) {
                            float[] setupVertices = vertexAttachment.getVertices();
                            for (int i = 0; i < vertexCount; ++i) {
                                int n4 = i;
                                deform[n4] = deform[n4] + (lastVertices[i] - setupVertices[i]);
                            }
                        } else {
                            for (int i = 0; i < vertexCount; ++i) {
                                int n5 = i;
                                deform[n5] = deform[n5] + lastVertices[i];
                            }
                        }
                    } else {
                        SpineUtils.arraycopy(lastVertices, 0, deform, 0, vertexCount);
                    }
                } else {
                    switch (blend) {
                        case setup: {
                            VertexAttachment vertexAttachment = (VertexAttachment)slotAttachment;
                            if (vertexAttachment.getBones() == null) {
                                float[] setupVertices = vertexAttachment.getVertices();
                                for (int i = 0; i < vertexCount; ++i) {
                                    float setup = setupVertices[i];
                                    deform[i] = setup + (lastVertices[i] - setup) * alpha;
                                }
                            } else {
                                for (int i = 0; i < vertexCount; ++i) {
                                    deform[i] = lastVertices[i] * alpha;
                                }
                            }
                            break;
                        }
                        case first: 
                        case replace: {
                            for (int i = 0; i < vertexCount; ++i) {
                                int n6 = i;
                                deform[n6] = deform[n6] + (lastVertices[i] - deform[i]) * alpha;
                            }
                            break;
                        }
                        case add: {
                            VertexAttachment vertexAttachment = (VertexAttachment)slotAttachment;
                            if (vertexAttachment.getBones() == null) {
                                float[] setupVertices = vertexAttachment.getVertices();
                                for (int i = 0; i < vertexCount; ++i) {
                                    int n7 = i;
                                    deform[n7] = deform[n7] + (lastVertices[i] - setupVertices[i]) * alpha;
                                }
                            } else {
                                for (int i = 0; i < vertexCount; ++i) {
                                    int n8 = i;
                                    deform[n8] = deform[n8] + lastVertices[i] * alpha;
                                }
                            }
                            break;
                        }
                    }
                }
                return;
            }
            int frame = DeformTimeline.search(frames, time);
            float percent = this.getCurvePercent(time, frame);
            float[] prevVertices = vertices[frame];
            float[] nextVertices = vertices[frame + 1];
            if (alpha == 1.0f) {
                if (blend == MixBlend.add) {
                    VertexAttachment vertexAttachment = (VertexAttachment)slotAttachment;
                    if (vertexAttachment.getBones() == null) {
                        float[] setupVertices = vertexAttachment.getVertices();
                        for (int i = 0; i < vertexCount; ++i) {
                            float prev = prevVertices[i];
                            int n9 = i;
                            deform[n9] = deform[n9] + (prev + (nextVertices[i] - prev) * percent - setupVertices[i]);
                        }
                    } else {
                        for (int i = 0; i < vertexCount; ++i) {
                            float prev = prevVertices[i];
                            int n10 = i;
                            deform[n10] = deform[n10] + (prev + (nextVertices[i] - prev) * percent);
                        }
                    }
                } else {
                    for (int i = 0; i < vertexCount; ++i) {
                        float prev = prevVertices[i];
                        deform[i] = prev + (nextVertices[i] - prev) * percent;
                    }
                }
            } else {
                switch (blend) {
                    case setup: {
                        VertexAttachment vertexAttachment = (VertexAttachment)slotAttachment;
                        if (vertexAttachment.getBones() == null) {
                            float[] setupVertices = vertexAttachment.getVertices();
                            for (int i = 0; i < vertexCount; ++i) {
                                float prev = prevVertices[i];
                                float setup = setupVertices[i];
                                deform[i] = setup + (prev + (nextVertices[i] - prev) * percent - setup) * alpha;
                            }
                        } else {
                            for (int i = 0; i < vertexCount; ++i) {
                                float prev = prevVertices[i];
                                deform[i] = (prev + (nextVertices[i] - prev) * percent) * alpha;
                            }
                        }
                        break;
                    }
                    case first: 
                    case replace: {
                        for (int i = 0; i < vertexCount; ++i) {
                            float prev = prevVertices[i];
                            int n11 = i;
                            deform[n11] = deform[n11] + (prev + (nextVertices[i] - prev) * percent - deform[i]) * alpha;
                        }
                        break;
                    }
                    case add: {
                        VertexAttachment vertexAttachment = (VertexAttachment)slotAttachment;
                        if (vertexAttachment.getBones() == null) {
                            float[] setupVertices = vertexAttachment.getVertices();
                            for (int i = 0; i < vertexCount; ++i) {
                                float prev = prevVertices[i];
                                int n12 = i;
                                deform[n12] = deform[n12] + (prev + (nextVertices[i] - prev) * percent - setupVertices[i]) * alpha;
                            }
                        } else {
                            for (int i = 0; i < vertexCount; ++i) {
                                float prev = prevVertices[i];
                                int n13 = i;
                                deform[n13] = deform[n13] + (prev + (nextVertices[i] - prev) * percent) * alpha;
                            }
                        }
                        break;
                    }
                }
            }
        }
    }

    public static class AttachmentTimeline
    extends Timeline
    implements SlotTimeline {
        final int slotIndex;
        final String[] attachmentNames;

        public AttachmentTimeline(int frameCount, int slotIndex) {
            super(frameCount, Property.attachment.ordinal() + "|" + slotIndex);
            this.slotIndex = slotIndex;
            this.attachmentNames = new String[frameCount];
        }

        @Override
        public int getFrameCount() {
            return this.frames.length;
        }

        @Override
        public int getSlotIndex() {
            return this.slotIndex;
        }

        public String[] getAttachmentNames() {
            return this.attachmentNames;
        }

        public void setFrame(int frame, float time, String attachmentName) {
            this.frames[frame] = time;
            this.attachmentNames[frame] = attachmentName;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
            Slot slot = skeleton.slots.get(this.slotIndex);
            if (!slot.bone.active) {
                return;
            }
            if (direction == MixDirection.out) {
                if (blend == MixBlend.setup) {
                    this.setAttachment(skeleton, slot, slot.data.attachmentName);
                }
                return;
            }
            if (time < this.frames[0]) {
                if (blend == MixBlend.setup || blend == MixBlend.first) {
                    this.setAttachment(skeleton, slot, slot.data.attachmentName);
                }
                return;
            }
            this.setAttachment(skeleton, slot, this.attachmentNames[AttachmentTimeline.search(this.frames, time)]);
        }

        private void setAttachment(Skeleton skeleton, Slot slot, String attachmentName) {
            slot.setAttachment(attachmentName == null ? null : skeleton.getAttachment(this.slotIndex, attachmentName));
        }
    }

    public static class RGB2Timeline
    extends CurveTimeline
    implements SlotTimeline {
        public static final int ENTRIES = 7;
        private static final int R = 1;
        private static final int G = 2;
        private static final int B = 3;
        private static final int R2 = 4;
        private static final int G2 = 5;
        private static final int B2 = 6;
        final int slotIndex;

        public RGB2Timeline(int frameCount, int bezierCount, int slotIndex) {
            super(frameCount, bezierCount, Property.rgb.ordinal() + "|" + slotIndex, Property.rgb2.ordinal() + "|" + slotIndex);
            this.slotIndex = slotIndex;
        }

        @Override
        public int getFrameEntries() {
            return 7;
        }

        @Override
        public int getSlotIndex() {
            return this.slotIndex;
        }

        public void setFrame(int frame, float time, float r, float g, float b, float r2, float g2, float b2) {
            this.frames[frame *= 7] = time;
            this.frames[frame + 1] = r;
            this.frames[frame + 2] = g;
            this.frames[frame + 3] = b;
            this.frames[frame + 4] = r2;
            this.frames[frame + 5] = g2;
            this.frames[frame + 6] = b2;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
            float b2;
            float g2;
            float r2;
            float b;
            float g;
            float r;
            Slot slot = skeleton.slots.get(this.slotIndex);
            if (!slot.bone.active) {
                return;
            }
            float[] frames = this.frames;
            Color light = slot.color;
            Color dark = slot.darkColor;
            if (time < frames[0]) {
                Color setupLight = slot.data.color;
                Color setupDark = slot.data.darkColor;
                switch (blend) {
                    case setup: {
                        light.r = setupLight.r;
                        light.g = setupLight.g;
                        light.b = setupLight.b;
                        dark.r = setupDark.r;
                        dark.g = setupDark.g;
                        dark.b = setupDark.b;
                        return;
                    }
                    case first: {
                        light.r += (setupLight.r - light.r) * alpha;
                        light.g += (setupLight.g - light.g) * alpha;
                        light.b += (setupLight.b - light.b) * alpha;
                        dark.r += (setupDark.r - dark.r) * alpha;
                        dark.g += (setupDark.g - dark.g) * alpha;
                        dark.b += (setupDark.b - dark.b) * alpha;
                    }
                }
                return;
            }
            int i = RGB2Timeline.search(frames, time, 7);
            int curveType = (int)this.curves[i / 7];
            switch (curveType) {
                case 0: {
                    float before = frames[i];
                    r = frames[i + 1];
                    g = frames[i + 2];
                    b = frames[i + 3];
                    r2 = frames[i + 4];
                    g2 = frames[i + 5];
                    b2 = frames[i + 6];
                    float t2 = (time - before) / (frames[i + 7] - before);
                    r += (frames[i + 7 + 1] - r) * t2;
                    g += (frames[i + 7 + 2] - g) * t2;
                    b += (frames[i + 7 + 3] - b) * t2;
                    r2 += (frames[i + 7 + 4] - r2) * t2;
                    g2 += (frames[i + 7 + 5] - g2) * t2;
                    b2 += (frames[i + 7 + 6] - b2) * t2;
                    break;
                }
                case 1: {
                    r = frames[i + 1];
                    g = frames[i + 2];
                    b = frames[i + 3];
                    r2 = frames[i + 4];
                    g2 = frames[i + 5];
                    b2 = frames[i + 6];
                    break;
                }
                default: {
                    r = this.getBezierValue(time, i, 1, curveType - 2);
                    g = this.getBezierValue(time, i, 2, curveType + 18 - 2);
                    b = this.getBezierValue(time, i, 3, curveType + 36 - 2);
                    r2 = this.getBezierValue(time, i, 4, curveType + 54 - 2);
                    g2 = this.getBezierValue(time, i, 5, curveType + 72 - 2);
                    b2 = this.getBezierValue(time, i, 6, curveType + 90 - 2);
                }
            }
            if (alpha == 1.0f) {
                light.r = r;
                light.g = g;
                light.b = b;
                dark.r = r2;
                dark.g = g2;
                dark.b = b2;
            } else {
                if (blend == MixBlend.setup) {
                    Color setupLight = slot.data.color;
                    Color setupDark = slot.data.darkColor;
                    light.r = setupLight.r;
                    light.g = setupLight.g;
                    light.b = setupLight.b;
                    dark.r = setupDark.r;
                    dark.g = setupDark.g;
                    dark.b = setupDark.b;
                }
                light.r += (r - light.r) * alpha;
                light.g += (g - light.g) * alpha;
                light.b += (b - light.b) * alpha;
                dark.r += (r2 - dark.r) * alpha;
                dark.g += (g2 - dark.g) * alpha;
                dark.b += (b2 - dark.b) * alpha;
            }
        }
    }

    public static class RGBA2Timeline
    extends CurveTimeline
    implements SlotTimeline {
        public static final int ENTRIES = 8;
        private static final int R = 1;
        private static final int G = 2;
        private static final int B = 3;
        private static final int A = 4;
        private static final int R2 = 5;
        private static final int G2 = 6;
        private static final int B2 = 7;
        final int slotIndex;

        public RGBA2Timeline(int frameCount, int bezierCount, int slotIndex) {
            super(frameCount, bezierCount, Property.rgb.ordinal() + "|" + slotIndex, Property.alpha.ordinal() + "|" + slotIndex, Property.rgb2.ordinal() + "|" + slotIndex);
            this.slotIndex = slotIndex;
        }

        @Override
        public int getFrameEntries() {
            return 8;
        }

        @Override
        public int getSlotIndex() {
            return this.slotIndex;
        }

        public void setFrame(int frame, float time, float r, float g, float b, float a, float r2, float g2, float b2) {
            this.frames[frame <<= 3] = time;
            this.frames[frame + 1] = r;
            this.frames[frame + 2] = g;
            this.frames[frame + 3] = b;
            this.frames[frame + 4] = a;
            this.frames[frame + 5] = r2;
            this.frames[frame + 6] = g2;
            this.frames[frame + 7] = b2;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
            float b2;
            float g2;
            float r2;
            float a;
            float b;
            float g;
            float r;
            Slot slot = skeleton.slots.get(this.slotIndex);
            if (!slot.bone.active) {
                return;
            }
            float[] frames = this.frames;
            Color light = slot.color;
            Color dark = slot.darkColor;
            if (time < frames[0]) {
                Color setupLight = slot.data.color;
                Color setupDark = slot.data.darkColor;
                switch (blend) {
                    case setup: {
                        light.set(setupLight);
                        dark.r = setupDark.r;
                        dark.g = setupDark.g;
                        dark.b = setupDark.b;
                        return;
                    }
                    case first: {
                        light.add((setupLight.r - light.r) * alpha, (setupLight.g - light.g) * alpha, (setupLight.b - light.b) * alpha, (setupLight.a - light.a) * alpha);
                        dark.r += (setupDark.r - dark.r) * alpha;
                        dark.g += (setupDark.g - dark.g) * alpha;
                        dark.b += (setupDark.b - dark.b) * alpha;
                    }
                }
                return;
            }
            int i = RGBA2Timeline.search(frames, time, 8);
            int curveType = (int)this.curves[i >> 3];
            switch (curveType) {
                case 0: {
                    float before = frames[i];
                    r = frames[i + 1];
                    g = frames[i + 2];
                    b = frames[i + 3];
                    a = frames[i + 4];
                    r2 = frames[i + 5];
                    g2 = frames[i + 6];
                    b2 = frames[i + 7];
                    float t2 = (time - before) / (frames[i + 8] - before);
                    r += (frames[i + 8 + 1] - r) * t2;
                    g += (frames[i + 8 + 2] - g) * t2;
                    b += (frames[i + 8 + 3] - b) * t2;
                    a += (frames[i + 8 + 4] - a) * t2;
                    r2 += (frames[i + 8 + 5] - r2) * t2;
                    g2 += (frames[i + 8 + 6] - g2) * t2;
                    b2 += (frames[i + 8 + 7] - b2) * t2;
                    break;
                }
                case 1: {
                    r = frames[i + 1];
                    g = frames[i + 2];
                    b = frames[i + 3];
                    a = frames[i + 4];
                    r2 = frames[i + 5];
                    g2 = frames[i + 6];
                    b2 = frames[i + 7];
                    break;
                }
                default: {
                    r = this.getBezierValue(time, i, 1, curveType - 2);
                    g = this.getBezierValue(time, i, 2, curveType + 18 - 2);
                    b = this.getBezierValue(time, i, 3, curveType + 36 - 2);
                    a = this.getBezierValue(time, i, 4, curveType + 54 - 2);
                    r2 = this.getBezierValue(time, i, 5, curveType + 72 - 2);
                    g2 = this.getBezierValue(time, i, 6, curveType + 90 - 2);
                    b2 = this.getBezierValue(time, i, 7, curveType + 108 - 2);
                }
            }
            if (alpha == 1.0f) {
                light.set(r, g, b, a);
                dark.r = r2;
                dark.g = g2;
                dark.b = b2;
            } else {
                if (blend == MixBlend.setup) {
                    light.set(slot.data.color);
                    Color setupDark = slot.data.darkColor;
                    dark.r = setupDark.r;
                    dark.g = setupDark.g;
                    dark.b = setupDark.b;
                }
                light.add((r - light.r) * alpha, (g - light.g) * alpha, (b - light.b) * alpha, (a - light.a) * alpha);
                dark.r += (r2 - dark.r) * alpha;
                dark.g += (g2 - dark.g) * alpha;
                dark.b += (b2 - dark.b) * alpha;
            }
        }
    }

    public static class AlphaTimeline
    extends CurveTimeline1
    implements SlotTimeline {
        final int slotIndex;

        public AlphaTimeline(int frameCount, int bezierCount, int slotIndex) {
            super(frameCount, bezierCount, Property.alpha.ordinal() + "|" + slotIndex);
            this.slotIndex = slotIndex;
        }

        @Override
        public int getSlotIndex() {
            return this.slotIndex;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
            Slot slot = skeleton.slots.get(this.slotIndex);
            if (!slot.bone.active) {
                return;
            }
            float[] frames = this.frames;
            Color color = slot.color;
            if (time < frames[0]) {
                Color setup = slot.data.color;
                switch (blend) {
                    case setup: {
                        color.a = setup.a;
                        return;
                    }
                    case first: {
                        color.a += (setup.a - color.a) * alpha;
                    }
                }
                return;
            }
            float a = this.getCurveValue(time);
            if (alpha == 1.0f) {
                color.a = a;
            } else {
                if (blend == MixBlend.setup) {
                    color.a = slot.data.color.a;
                }
                color.a += (a - color.a) * alpha;
            }
        }
    }

    public static class RGBTimeline
    extends CurveTimeline
    implements SlotTimeline {
        public static final int ENTRIES = 4;
        private static final int R = 1;
        private static final int G = 2;
        private static final int B = 3;
        final int slotIndex;

        public RGBTimeline(int frameCount, int bezierCount, int slotIndex) {
            super(frameCount, bezierCount, Property.rgb.ordinal() + "|" + slotIndex);
            this.slotIndex = slotIndex;
        }

        @Override
        public int getFrameEntries() {
            return 4;
        }

        @Override
        public int getSlotIndex() {
            return this.slotIndex;
        }

        public void setFrame(int frame, float time, float r, float g, float b) {
            this.frames[frame <<= 2] = time;
            this.frames[frame + 1] = r;
            this.frames[frame + 2] = g;
            this.frames[frame + 3] = b;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
            float b;
            float g;
            float r;
            Slot slot = skeleton.slots.get(this.slotIndex);
            if (!slot.bone.active) {
                return;
            }
            float[] frames = this.frames;
            Color color = slot.color;
            if (time < frames[0]) {
                Color setup = slot.data.color;
                switch (blend) {
                    case setup: {
                        color.r = setup.r;
                        color.g = setup.g;
                        color.b = setup.b;
                        return;
                    }
                    case first: {
                        color.r += (setup.r - color.r) * alpha;
                        color.g += (setup.g - color.g) * alpha;
                        color.b += (setup.b - color.b) * alpha;
                    }
                }
                return;
            }
            int i = RGBTimeline.search(frames, time, 4);
            int curveType = (int)this.curves[i >> 2];
            switch (curveType) {
                case 0: {
                    float before = frames[i];
                    r = frames[i + 1];
                    g = frames[i + 2];
                    b = frames[i + 3];
                    float t2 = (time - before) / (frames[i + 4] - before);
                    r += (frames[i + 4 + 1] - r) * t2;
                    g += (frames[i + 4 + 2] - g) * t2;
                    b += (frames[i + 4 + 3] - b) * t2;
                    break;
                }
                case 1: {
                    r = frames[i + 1];
                    g = frames[i + 2];
                    b = frames[i + 3];
                    break;
                }
                default: {
                    r = this.getBezierValue(time, i, 1, curveType - 2);
                    g = this.getBezierValue(time, i, 2, curveType + 18 - 2);
                    b = this.getBezierValue(time, i, 3, curveType + 36 - 2);
                }
            }
            if (alpha == 1.0f) {
                color.r = r;
                color.g = g;
                color.b = b;
            } else {
                if (blend == MixBlend.setup) {
                    Color setup = slot.data.color;
                    color.r = setup.r;
                    color.g = setup.g;
                    color.b = setup.b;
                }
                color.r += (r - color.r) * alpha;
                color.g += (g - color.g) * alpha;
                color.b += (b - color.b) * alpha;
            }
        }
    }

    public static class RGBATimeline
    extends CurveTimeline
    implements SlotTimeline {
        public static final int ENTRIES = 5;
        private static final int R = 1;
        private static final int G = 2;
        private static final int B = 3;
        private static final int A = 4;
        final int slotIndex;

        public RGBATimeline(int frameCount, int bezierCount, int slotIndex) {
            super(frameCount, bezierCount, Property.rgb.ordinal() + "|" + slotIndex, Property.alpha.ordinal() + "|" + slotIndex);
            this.slotIndex = slotIndex;
        }

        @Override
        public int getFrameEntries() {
            return 5;
        }

        @Override
        public int getSlotIndex() {
            return this.slotIndex;
        }

        public void setFrame(int frame, float time, float r, float g, float b, float a) {
            this.frames[frame *= 5] = time;
            this.frames[frame + 1] = r;
            this.frames[frame + 2] = g;
            this.frames[frame + 3] = b;
            this.frames[frame + 4] = a;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
            float a;
            float b;
            float g;
            float r;
            Slot slot = skeleton.slots.get(this.slotIndex);
            if (!slot.bone.active) {
                return;
            }
            float[] frames = this.frames;
            Color color = slot.color;
            if (time < frames[0]) {
                Color setup = slot.data.color;
                switch (blend) {
                    case setup: {
                        color.set(setup);
                        return;
                    }
                    case first: {
                        color.add((setup.r - color.r) * alpha, (setup.g - color.g) * alpha, (setup.b - color.b) * alpha, (setup.a - color.a) * alpha);
                    }
                }
                return;
            }
            int i = RGBATimeline.search(frames, time, 5);
            int curveType = (int)this.curves[i / 5];
            switch (curveType) {
                case 0: {
                    float before = frames[i];
                    r = frames[i + 1];
                    g = frames[i + 2];
                    b = frames[i + 3];
                    a = frames[i + 4];
                    float t2 = (time - before) / (frames[i + 5] - before);
                    r += (frames[i + 5 + 1] - r) * t2;
                    g += (frames[i + 5 + 2] - g) * t2;
                    b += (frames[i + 5 + 3] - b) * t2;
                    a += (frames[i + 5 + 4] - a) * t2;
                    break;
                }
                case 1: {
                    r = frames[i + 1];
                    g = frames[i + 2];
                    b = frames[i + 3];
                    a = frames[i + 4];
                    break;
                }
                default: {
                    r = this.getBezierValue(time, i, 1, curveType - 2);
                    g = this.getBezierValue(time, i, 2, curveType + 18 - 2);
                    b = this.getBezierValue(time, i, 3, curveType + 36 - 2);
                    a = this.getBezierValue(time, i, 4, curveType + 54 - 2);
                }
            }
            if (alpha == 1.0f) {
                color.set(r, g, b, a);
            } else {
                if (blend == MixBlend.setup) {
                    color.set(slot.data.color);
                }
                color.add((r - color.r) * alpha, (g - color.g) * alpha, (b - color.b) * alpha, (a - color.a) * alpha);
            }
        }
    }

    public static class InheritTimeline
    extends Timeline
    implements BoneTimeline {
        public static final int ENTRIES = 2;
        private static final int INHERIT = 1;
        final int boneIndex;

        public InheritTimeline(int frameCount, int boneIndex) {
            super(frameCount, Property.inherit.ordinal() + "|" + boneIndex);
            this.boneIndex = boneIndex;
        }

        @Override
        public int getBoneIndex() {
            return this.boneIndex;
        }

        @Override
        public int getFrameEntries() {
            return 2;
        }

        public void setFrame(int frame, float time, BoneData.Inherit inherit) {
            this.frames[frame *= 2] = time;
            this.frames[frame + 1] = inherit.ordinal();
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
            Bone bone = skeleton.bones.get(this.boneIndex);
            if (!bone.active) {
                return;
            }
            if (direction == MixDirection.out) {
                if (blend == MixBlend.setup) {
                    bone.inherit = bone.data.inherit;
                }
                return;
            }
            float[] frames = this.frames;
            if (time < frames[0]) {
                if (blend == MixBlend.setup || blend == MixBlend.first) {
                    bone.inherit = bone.data.inherit;
                }
                return;
            }
            bone.inherit = BoneData.Inherit.values[(int)frames[InheritTimeline.search(frames, time, 2) + 1]];
        }
    }

    public static class ShearYTimeline
    extends CurveTimeline1
    implements BoneTimeline {
        final int boneIndex;

        public ShearYTimeline(int frameCount, int bezierCount, int boneIndex) {
            super(frameCount, bezierCount, Property.shearY.ordinal() + "|" + boneIndex);
            this.boneIndex = boneIndex;
        }

        @Override
        public int getBoneIndex() {
            return this.boneIndex;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
            Bone bone = skeleton.bones.get(this.boneIndex);
            if (bone.active) {
                bone.shearY = this.getRelativeValue(time, alpha, blend, bone.shearY, bone.data.shearY);
            }
        }
    }

    public static class ShearXTimeline
    extends CurveTimeline1
    implements BoneTimeline {
        final int boneIndex;

        public ShearXTimeline(int frameCount, int bezierCount, int boneIndex) {
            super(frameCount, bezierCount, Property.shearX.ordinal() + "|" + boneIndex);
            this.boneIndex = boneIndex;
        }

        @Override
        public int getBoneIndex() {
            return this.boneIndex;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
            Bone bone = skeleton.bones.get(this.boneIndex);
            if (bone.active) {
                bone.shearX = this.getRelativeValue(time, alpha, blend, bone.shearX, bone.data.shearX);
            }
        }
    }

    public static class ShearTimeline
    extends CurveTimeline2
    implements BoneTimeline {
        final int boneIndex;

        public ShearTimeline(int frameCount, int bezierCount, int boneIndex) {
            super(frameCount, bezierCount, Property.shearX.ordinal() + "|" + boneIndex, Property.shearY.ordinal() + "|" + boneIndex);
            this.boneIndex = boneIndex;
        }

        @Override
        public int getBoneIndex() {
            return this.boneIndex;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
            float y;
            float x;
            Bone bone = skeleton.bones.get(this.boneIndex);
            if (!bone.active) {
                return;
            }
            float[] frames = this.frames;
            if (time < frames[0]) {
                switch (blend) {
                    case setup: {
                        bone.shearX = bone.data.shearX;
                        bone.shearY = bone.data.shearY;
                        return;
                    }
                    case first: {
                        bone.shearX += (bone.data.shearX - bone.shearX) * alpha;
                        bone.shearY += (bone.data.shearY - bone.shearY) * alpha;
                    }
                }
                return;
            }
            int i = ShearTimeline.search(frames, time, 3);
            int curveType = (int)this.curves[i / 3];
            switch (curveType) {
                case 0: {
                    float before = frames[i];
                    x = frames[i + 1];
                    y = frames[i + 2];
                    float t2 = (time - before) / (frames[i + 3] - before);
                    x += (frames[i + 3 + 1] - x) * t2;
                    y += (frames[i + 3 + 2] - y) * t2;
                    break;
                }
                case 1: {
                    x = frames[i + 1];
                    y = frames[i + 2];
                    break;
                }
                default: {
                    x = this.getBezierValue(time, i, 1, curveType - 2);
                    y = this.getBezierValue(time, i, 2, curveType + 18 - 2);
                }
            }
            switch (blend) {
                case setup: {
                    bone.shearX = bone.data.shearX + x * alpha;
                    bone.shearY = bone.data.shearY + y * alpha;
                    break;
                }
                case first: 
                case replace: {
                    bone.shearX += (bone.data.shearX + x - bone.shearX) * alpha;
                    bone.shearY += (bone.data.shearY + y - bone.shearY) * alpha;
                    break;
                }
                case add: {
                    bone.shearX += x * alpha;
                    bone.shearY += y * alpha;
                }
            }
        }
    }

    public static class ScaleYTimeline
    extends CurveTimeline1
    implements BoneTimeline {
        final int boneIndex;

        public ScaleYTimeline(int frameCount, int bezierCount, int boneIndex) {
            super(frameCount, bezierCount, Property.scaleY.ordinal() + "|" + boneIndex);
            this.boneIndex = boneIndex;
        }

        @Override
        public int getBoneIndex() {
            return this.boneIndex;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
            Bone bone = skeleton.bones.get(this.boneIndex);
            if (bone.active) {
                bone.scaleY = this.getScaleValue(time, alpha, blend, direction, bone.scaleY, bone.data.scaleY);
            }
        }
    }

    public static class ScaleXTimeline
    extends CurveTimeline1
    implements BoneTimeline {
        final int boneIndex;

        public ScaleXTimeline(int frameCount, int bezierCount, int boneIndex) {
            super(frameCount, bezierCount, Property.scaleX.ordinal() + "|" + boneIndex);
            this.boneIndex = boneIndex;
        }

        @Override
        public int getBoneIndex() {
            return this.boneIndex;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
            Bone bone = skeleton.bones.get(this.boneIndex);
            if (bone.active) {
                bone.scaleX = this.getScaleValue(time, alpha, blend, direction, bone.scaleX, bone.data.scaleX);
            }
        }
    }

    public static class ScaleTimeline
    extends CurveTimeline2
    implements BoneTimeline {
        final int boneIndex;

        public ScaleTimeline(int frameCount, int bezierCount, int boneIndex) {
            super(frameCount, bezierCount, Property.scaleX.ordinal() + "|" + boneIndex, Property.scaleY.ordinal() + "|" + boneIndex);
            this.boneIndex = boneIndex;
        }

        @Override
        public int getBoneIndex() {
            return this.boneIndex;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
            float by;
            float bx;
            float y;
            float x;
            Bone bone = skeleton.bones.get(this.boneIndex);
            if (!bone.active) {
                return;
            }
            float[] frames = this.frames;
            if (time < frames[0]) {
                switch (blend) {
                    case setup: {
                        bone.scaleX = bone.data.scaleX;
                        bone.scaleY = bone.data.scaleY;
                        return;
                    }
                    case first: {
                        bone.scaleX += (bone.data.scaleX - bone.scaleX) * alpha;
                        bone.scaleY += (bone.data.scaleY - bone.scaleY) * alpha;
                    }
                }
                return;
            }
            int i = ScaleTimeline.search(frames, time, 3);
            int curveType = (int)this.curves[i / 3];
            switch (curveType) {
                case 0: {
                    float before = frames[i];
                    x = frames[i + 1];
                    y = frames[i + 2];
                    float t2 = (time - before) / (frames[i + 3] - before);
                    x += (frames[i + 3 + 1] - x) * t2;
                    y += (frames[i + 3 + 2] - y) * t2;
                    break;
                }
                case 1: {
                    x = frames[i + 1];
                    y = frames[i + 2];
                    break;
                }
                default: {
                    x = this.getBezierValue(time, i, 1, curveType - 2);
                    y = this.getBezierValue(time, i, 2, curveType + 18 - 2);
                }
            }
            x *= bone.data.scaleX;
            y *= bone.data.scaleY;
            if (alpha == 1.0f) {
                if (blend == MixBlend.add) {
                    bone.scaleX += x - bone.data.scaleX;
                    bone.scaleY += y - bone.data.scaleY;
                } else {
                    bone.scaleX = x;
                    bone.scaleY = y;
                }
            } else if (direction == MixDirection.out) {
                switch (blend) {
                    case setup: {
                        bx = bone.data.scaleX;
                        by = bone.data.scaleY;
                        bone.scaleX = bx + (Math.abs(x) * Math.signum(bx) - bx) * alpha;
                        bone.scaleY = by + (Math.abs(y) * Math.signum(by) - by) * alpha;
                        break;
                    }
                    case first: 
                    case replace: {
                        bx = bone.scaleX;
                        by = bone.scaleY;
                        bone.scaleX = bx + (Math.abs(x) * Math.signum(bx) - bx) * alpha;
                        bone.scaleY = by + (Math.abs(y) * Math.signum(by) - by) * alpha;
                        break;
                    }
                    case add: {
                        bone.scaleX += (x - bone.data.scaleX) * alpha;
                        bone.scaleY += (y - bone.data.scaleY) * alpha;
                    }
                }
            } else {
                switch (blend) {
                    case setup: {
                        bx = Math.abs(bone.data.scaleX) * Math.signum(x);
                        by = Math.abs(bone.data.scaleY) * Math.signum(y);
                        bone.scaleX = bx + (x - bx) * alpha;
                        bone.scaleY = by + (y - by) * alpha;
                        break;
                    }
                    case first: 
                    case replace: {
                        bx = Math.abs(bone.scaleX) * Math.signum(x);
                        by = Math.abs(bone.scaleY) * Math.signum(y);
                        bone.scaleX = bx + (x - bx) * alpha;
                        bone.scaleY = by + (y - by) * alpha;
                        break;
                    }
                    case add: {
                        bone.scaleX += (x - bone.data.scaleX) * alpha;
                        bone.scaleY += (y - bone.data.scaleY) * alpha;
                    }
                }
            }
        }
    }

    public static class TranslateYTimeline
    extends CurveTimeline1
    implements BoneTimeline {
        final int boneIndex;

        public TranslateYTimeline(int frameCount, int bezierCount, int boneIndex) {
            super(frameCount, bezierCount, Property.y.ordinal() + "|" + boneIndex);
            this.boneIndex = boneIndex;
        }

        @Override
        public int getBoneIndex() {
            return this.boneIndex;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
            Bone bone = skeleton.bones.get(this.boneIndex);
            if (bone.active) {
                bone.y = this.getRelativeValue(time, alpha, blend, bone.y, bone.data.y);
            }
        }
    }

    public static class TranslateXTimeline
    extends CurveTimeline1
    implements BoneTimeline {
        final int boneIndex;

        public TranslateXTimeline(int frameCount, int bezierCount, int boneIndex) {
            super(frameCount, bezierCount, Property.x.ordinal() + "|" + boneIndex);
            this.boneIndex = boneIndex;
        }

        @Override
        public int getBoneIndex() {
            return this.boneIndex;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
            Bone bone = skeleton.bones.get(this.boneIndex);
            if (bone.active) {
                bone.x = this.getRelativeValue(time, alpha, blend, bone.x, bone.data.x);
            }
        }
    }

    public static class TranslateTimeline
    extends CurveTimeline2
    implements BoneTimeline {
        final int boneIndex;

        public TranslateTimeline(int frameCount, int bezierCount, int boneIndex) {
            super(frameCount, bezierCount, Property.x.ordinal() + "|" + boneIndex, Property.y.ordinal() + "|" + boneIndex);
            this.boneIndex = boneIndex;
        }

        @Override
        public int getBoneIndex() {
            return this.boneIndex;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
            float y;
            float x;
            Bone bone = skeleton.bones.get(this.boneIndex);
            if (!bone.active) {
                return;
            }
            float[] frames = this.frames;
            if (time < frames[0]) {
                switch (blend) {
                    case setup: {
                        bone.x = bone.data.x;
                        bone.y = bone.data.y;
                        return;
                    }
                    case first: {
                        bone.x += (bone.data.x - bone.x) * alpha;
                        bone.y += (bone.data.y - bone.y) * alpha;
                    }
                }
                return;
            }
            int i = TranslateTimeline.search(frames, time, 3);
            int curveType = (int)this.curves[i / 3];
            switch (curveType) {
                case 0: {
                    float before = frames[i];
                    x = frames[i + 1];
                    y = frames[i + 2];
                    float t2 = (time - before) / (frames[i + 3] - before);
                    x += (frames[i + 3 + 1] - x) * t2;
                    y += (frames[i + 3 + 2] - y) * t2;
                    break;
                }
                case 1: {
                    x = frames[i + 1];
                    y = frames[i + 2];
                    break;
                }
                default: {
                    x = this.getBezierValue(time, i, 1, curveType - 2);
                    y = this.getBezierValue(time, i, 2, curveType + 18 - 2);
                }
            }
            switch (blend) {
                case setup: {
                    bone.x = bone.data.x + x * alpha;
                    bone.y = bone.data.y + y * alpha;
                    break;
                }
                case first: 
                case replace: {
                    bone.x += (bone.data.x + x - bone.x) * alpha;
                    bone.y += (bone.data.y + y - bone.y) * alpha;
                    break;
                }
                case add: {
                    bone.x += x * alpha;
                    bone.y += y * alpha;
                }
            }
        }
    }

    public static class RotateTimeline
    extends CurveTimeline1
    implements BoneTimeline {
        final int boneIndex;

        public RotateTimeline(int frameCount, int bezierCount, int boneIndex) {
            super(frameCount, bezierCount, Property.rotate.ordinal() + "|" + boneIndex);
            this.boneIndex = boneIndex;
        }

        @Override
        public int getBoneIndex() {
            return this.boneIndex;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
            Bone bone = skeleton.bones.get(this.boneIndex);
            if (bone.active) {
                bone.rotation = this.getRelativeValue(time, alpha, blend, bone.rotation, bone.data.rotation);
            }
        }
    }

    public static abstract class CurveTimeline2
    extends CurveTimeline {
        public static final int ENTRIES = 3;
        static final int VALUE1 = 1;
        static final int VALUE2 = 2;

        public CurveTimeline2(int frameCount, int bezierCount, String propertyId1, String propertyId2) {
            super(frameCount, bezierCount, propertyId1, propertyId2);
        }

        @Override
        public int getFrameEntries() {
            return 3;
        }

        public void setFrame(int frame, float time, float value1, float value2) {
            this.frames[frame *= 3] = time;
            this.frames[frame + 1] = value1;
            this.frames[frame + 2] = value2;
        }
    }

    public static abstract class CurveTimeline1
    extends CurveTimeline {
        public static final int ENTRIES = 2;
        static final int VALUE = 1;

        public CurveTimeline1(int frameCount, int bezierCount, String propertyId) {
            super(frameCount, bezierCount, propertyId);
        }

        @Override
        public int getFrameEntries() {
            return 2;
        }

        public void setFrame(int frame, float time, float value) {
            this.frames[frame <<= 1] = time;
            this.frames[frame + 1] = value;
        }

        public float getCurveValue(float time) {
            float[] frames = this.frames;
            int i = frames.length - 2;
            for (int ii = 2; ii <= i; ii += 2) {
                if (!(frames[ii] > time)) continue;
                i = ii - 2;
                break;
            }
            int curveType = (int)this.curves[i >> 1];
            switch (curveType) {
                case 0: {
                    float before = frames[i];
                    float value = frames[i + 1];
                    return value + (time - before) / (frames[i + 2] - before) * (frames[i + 2 + 1] - value);
                }
                case 1: {
                    return frames[i + 1];
                }
            }
            return this.getBezierValue(time, i, 1, curveType - 2);
        }

        public float getRelativeValue(float time, float alpha, MixBlend blend, float current, float setup) {
            if (time < this.frames[0]) {
                switch (blend) {
                    case setup: {
                        return setup;
                    }
                    case first: {
                        return current + (setup - current) * alpha;
                    }
                }
                return current;
            }
            float value = this.getCurveValue(time);
            switch (blend) {
                case setup: {
                    return setup + value * alpha;
                }
                case first: 
                case replace: {
                    value += setup - current;
                }
            }
            return current + value * alpha;
        }

        public float getAbsoluteValue(float time, float alpha, MixBlend blend, float current, float setup) {
            if (time < this.frames[0]) {
                switch (blend) {
                    case setup: {
                        return setup;
                    }
                    case first: {
                        return current + (setup - current) * alpha;
                    }
                }
                return current;
            }
            float value = this.getCurveValue(time);
            if (blend == MixBlend.setup) {
                return setup + (value - setup) * alpha;
            }
            return current + (value - current) * alpha;
        }

        public float getAbsoluteValue(float time, float alpha, MixBlend blend, float current, float setup, float value) {
            if (time < this.frames[0]) {
                switch (blend) {
                    case setup: {
                        return setup;
                    }
                    case first: {
                        return current + (setup - current) * alpha;
                    }
                }
                return current;
            }
            if (blend == MixBlend.setup) {
                return setup + (value - setup) * alpha;
            }
            return current + (value - current) * alpha;
        }

        public float getScaleValue(float time, float alpha, MixBlend blend, MixDirection direction, float current, float setup) {
            float[] frames = this.frames;
            if (time < frames[0]) {
                switch (blend) {
                    case setup: {
                        return setup;
                    }
                    case first: {
                        return current + (setup - current) * alpha;
                    }
                }
                return current;
            }
            float value = this.getCurveValue(time) * setup;
            if (alpha == 1.0f) {
                if (blend == MixBlend.add) {
                    return current + value - setup;
                }
                return value;
            }
            if (direction == MixDirection.out) {
                switch (blend) {
                    case setup: {
                        return setup + (Math.abs(value) * Math.signum(setup) - setup) * alpha;
                    }
                    case first: 
                    case replace: {
                        return current + (Math.abs(value) * Math.signum(current) - current) * alpha;
                    }
                }
            } else {
                switch (blend) {
                    case setup: {
                        float s = Math.abs(setup) * Math.signum(value);
                        return s + (value - s) * alpha;
                    }
                    case first: 
                    case replace: {
                        float s = Math.abs(current) * Math.signum(value);
                        return s + (value - s) * alpha;
                    }
                }
            }
            return current + (value - setup) * alpha;
        }
    }

    public static abstract class CurveTimeline
    extends Timeline {
        public static final int LINEAR = 0;
        public static final int STEPPED = 1;
        public static final int BEZIER = 2;
        public static final int BEZIER_SIZE = 18;
        float[] curves;

        public CurveTimeline(int frameCount, int bezierCount, String ... propertyIds) {
            super(frameCount, propertyIds);
            this.curves = new float[frameCount + bezierCount * 18];
            this.curves[frameCount - 1] = 1.0f;
        }

        public void setLinear(int frame) {
            this.curves[frame] = 0.0f;
        }

        public void setStepped(int frame) {
            this.curves[frame] = 1.0f;
        }

        public int getCurveType(int frame) {
            return (int)this.curves[frame];
        }

        public void shrink(int bezierCount) {
            int size = this.getFrameCount() + bezierCount * 18;
            if (this.curves.length > size) {
                float[] newCurves = new float[size];
                SpineUtils.arraycopy(this.curves, 0, newCurves, 0, size);
                this.curves = newCurves;
            }
        }

        public void setBezier(int bezier, int frame, int value, float time1, float value1, float cx1, float cy1, float cx2, float cy2, float time2, float value2) {
            float[] curves = this.curves;
            int i = this.getFrameCount() + bezier * 18;
            if (value == 0) {
                curves[frame] = 2 + i;
            }
            float tmpx = (time1 - cx1 * 2.0f + cx2) * 0.03f;
            float tmpy = (value1 - cy1 * 2.0f + cy2) * 0.03f;
            float dddx = ((cx1 - cx2) * 3.0f - time1 + time2) * 0.006f;
            float dddy = ((cy1 - cy2) * 3.0f - value1 + value2) * 0.006f;
            float ddx = tmpx * 2.0f + dddx;
            float ddy = tmpy * 2.0f + dddy;
            float dx = (cx1 - time1) * 0.3f + tmpx + dddx * 0.16666667f;
            float dy = (cy1 - value1) * 0.3f + tmpy + dddy * 0.16666667f;
            float x = time1 + dx;
            float y = value1 + dy;
            int n2 = i + 18;
            while (i < n2) {
                curves[i] = x;
                curves[i + 1] = y;
                x += (dx += (ddx += dddx));
                y += (dy += (ddy += dddy));
                i += 2;
            }
        }

        public float getBezierValue(float time, int frameIndex, int valueOffset, int i) {
            float[] curves = this.curves;
            if (curves[i] > time) {
                float x = this.frames[frameIndex];
                float y = this.frames[frameIndex + valueOffset];
                return y + (time - x) / (curves[i] - x) * (curves[i + 1] - y);
            }
            int n2 = i + 18;
            i += 2;
            while (i < n2) {
                if (curves[i] >= time) {
                    float x = curves[i - 2];
                    float y = curves[i - 1];
                    return y + (time - x) / (curves[i] - x) * (curves[i + 1] - y);
                }
                i += 2;
            }
            float x = curves[n2 - 2];
            float y = curves[n2 - 1];
            return y + (time - x) / (this.frames[frameIndex += this.getFrameEntries()] - x) * (this.frames[frameIndex + valueOffset] - y);
        }
    }

    public static interface SlotTimeline {
        public int getSlotIndex();
    }

    public static interface BoneTimeline {
        public int getBoneIndex();
    }

    private static enum Property {
        rotate,
        x,
        y,
        scaleX,
        scaleY,
        shearX,
        shearY,
        inherit,
        rgb,
        alpha,
        rgb2,
        attachment,
        deform,
        event,
        drawOrder,
        ikConstraint,
        transformConstraint,
        pathConstraintPosition,
        pathConstraintSpacing,
        pathConstraintMix,
        physicsConstraintInertia,
        physicsConstraintStrength,
        physicsConstraintDamping,
        physicsConstraintMass,
        physicsConstraintWind,
        physicsConstraintGravity,
        physicsConstraintMix,
        physicsConstraintReset,
        sequence;

    }
}

