/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Null;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Updatable;
import com.esotericsoftware.spine.utils.SpineUtils;

public class Bone
implements Updatable {
    final BoneData data;
    final Skeleton skeleton;
    @Null
    final Bone parent;
    final Array<Bone> children = new Array();
    float x;
    float y;
    float rotation;
    float scaleX;
    float scaleY;
    float shearX;
    float shearY;
    float ax;
    float ay;
    float arotation;
    float ascaleX;
    float ascaleY;
    float ashearX;
    float ashearY;
    float a;
    float b;
    float worldX;
    float c;
    float d;
    float worldY;
    BoneData.Inherit inherit;
    boolean sorted;
    boolean active;

    public Bone(BoneData data, Skeleton skeleton, @Null Bone parent) {
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        this.data = data;
        this.skeleton = skeleton;
        this.parent = parent;
        this.setToSetupPose();
    }

    public Bone(Bone bone, Skeleton skeleton, @Null Bone parent) {
        if (bone == null) {
            throw new IllegalArgumentException("bone cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        this.skeleton = skeleton;
        this.parent = parent;
        this.data = bone.data;
        this.x = bone.x;
        this.y = bone.y;
        this.rotation = bone.rotation;
        this.scaleX = bone.scaleX;
        this.scaleY = bone.scaleY;
        this.shearX = bone.shearX;
        this.shearY = bone.shearY;
        this.inherit = bone.inherit;
    }

    @Override
    public void update(Skeleton.Physics physics) {
        this.updateWorldTransform(this.ax, this.ay, this.arotation, this.ascaleX, this.ascaleY, this.ashearX, this.ashearY);
    }

    public void updateWorldTransform() {
        this.updateWorldTransform(this.x, this.y, this.rotation, this.scaleX, this.scaleY, this.shearX, this.shearY);
    }

    public void updateWorldTransform(float x, float y, float rotation, float scaleX, float scaleY, float shearX, float shearY) {
        this.ax = x;
        this.ay = y;
        this.arotation = rotation;
        this.ascaleX = scaleX;
        this.ascaleY = scaleY;
        this.ashearX = shearX;
        this.ashearY = shearY;
        Bone parent = this.parent;
        if (parent == null) {
            Skeleton skeleton = this.skeleton;
            float sx = skeleton.scaleX;
            float sy = skeleton.scaleY;
            float rx = (rotation + shearX) * ((float)Math.PI / 180);
            float ry = (rotation + 90.0f + shearY) * ((float)Math.PI / 180);
            this.a = SpineUtils.cos(rx) * scaleX * sx;
            this.b = SpineUtils.cos(ry) * scaleY * sx;
            this.c = SpineUtils.sin(rx) * scaleX * sy;
            this.d = SpineUtils.sin(ry) * scaleY * sy;
            this.worldX = x * sx + skeleton.x;
            this.worldY = y * sy + skeleton.y;
            return;
        }
        float pa = parent.a;
        float pb = parent.b;
        float pc = parent.c;
        float pd = parent.d;
        this.worldX = pa * x + pb * y + parent.worldX;
        this.worldY = pc * x + pd * y + parent.worldY;
        switch (this.inherit) {
            case normal: {
                float rx = (rotation + shearX) * ((float)Math.PI / 180);
                float ry = (rotation + 90.0f + shearY) * ((float)Math.PI / 180);
                float la = SpineUtils.cos(rx) * scaleX;
                float lb = SpineUtils.cos(ry) * scaleY;
                float lc = SpineUtils.sin(rx) * scaleX;
                float ld = SpineUtils.sin(ry) * scaleY;
                this.a = pa * la + pb * lc;
                this.b = pa * lb + pb * ld;
                this.c = pc * la + pd * lc;
                this.d = pc * lb + pd * ld;
                return;
            }
            case onlyTranslation: {
                float rx = (rotation + shearX) * ((float)Math.PI / 180);
                float ry = (rotation + 90.0f + shearY) * ((float)Math.PI / 180);
                this.a = SpineUtils.cos(rx) * scaleX;
                this.b = SpineUtils.cos(ry) * scaleY;
                this.c = SpineUtils.sin(rx) * scaleX;
                this.d = SpineUtils.sin(ry) * scaleY;
                break;
            }
            case noRotationOrReflection: {
                float prx;
                float s = pa * pa + pc * pc;
                if (s > 1.0E-4f) {
                    s = Math.abs(pa * pd - pb * pc) / s;
                    pb = (pc /= this.skeleton.scaleY) * s;
                    pd = (pa /= this.skeleton.scaleX) * s;
                    prx = SpineUtils.atan2Deg(pc, pa);
                } else {
                    pa = 0.0f;
                    pc = 0.0f;
                    prx = 90.0f - SpineUtils.atan2Deg(pd, pb);
                }
                float rx = (rotation + shearX - prx) * ((float)Math.PI / 180);
                float ry = (rotation + shearY - prx + 90.0f) * ((float)Math.PI / 180);
                float la = SpineUtils.cos(rx) * scaleX;
                float lb = SpineUtils.cos(ry) * scaleY;
                float lc = SpineUtils.sin(rx) * scaleX;
                float ld = SpineUtils.sin(ry) * scaleY;
                this.a = pa * la - pb * lc;
                this.b = pa * lb - pb * ld;
                this.c = pc * la + pd * lc;
                this.d = pc * lb + pd * ld;
                break;
            }
            case noScale: 
            case noScaleOrReflection: {
                float cos = SpineUtils.cos(rotation *= (float)Math.PI / 180);
                float sin = SpineUtils.sin(rotation);
                float za = (pa * cos + pb * sin) / this.skeleton.scaleX;
                float zc = (pc * cos + pd * sin) / this.skeleton.scaleY;
                float s = (float)Math.sqrt(za * za + zc * zc);
                if (s > 1.0E-5f) {
                    s = 1.0f / s;
                }
                za *= s;
                zc *= s;
                s = (float)Math.sqrt(za * za + zc * zc);
                if (this.inherit == BoneData.Inherit.noScale && pa * pd - pb * pc < 0.0f != (this.skeleton.scaleX < 0.0f != this.skeleton.scaleY < 0.0f)) {
                    s = -s;
                }
                rotation = 1.5707964f + SpineUtils.atan2(zc, za);
                float zb = SpineUtils.cos(rotation) * s;
                float zd = SpineUtils.sin(rotation) * s;
                shearY = (90.0f + shearY) * ((float)Math.PI / 180);
                float la = SpineUtils.cos(shearX *= (float)Math.PI / 180) * scaleX;
                float lb = SpineUtils.cos(shearY) * scaleY;
                float lc = SpineUtils.sin(shearX) * scaleX;
                float ld = SpineUtils.sin(shearY) * scaleY;
                this.a = za * la + zb * lc;
                this.b = za * lb + zb * ld;
                this.c = zc * la + zd * lc;
                this.d = zc * lb + zd * ld;
            }
        }
        this.a *= this.skeleton.scaleX;
        this.b *= this.skeleton.scaleX;
        this.c *= this.skeleton.scaleY;
        this.d *= this.skeleton.scaleY;
    }

    public void setToSetupPose() {
        BoneData data = this.data;
        this.x = data.x;
        this.y = data.y;
        this.rotation = data.rotation;
        this.scaleX = data.scaleX;
        this.scaleY = data.scaleY;
        this.shearX = data.shearX;
        this.shearY = data.shearY;
        this.inherit = data.inherit;
    }

    public BoneData getData() {
        return this.data;
    }

    public Skeleton getSkeleton() {
        return this.skeleton;
    }

    @Null
    public Bone getParent() {
        return this.parent;
    }

    public Array<Bone> getChildren() {
        return this.children;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setPosition(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public void setScaleX(float scaleX) {
        this.scaleX = scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public void setScaleY(float scaleY) {
        this.scaleY = scaleY;
    }

    public void setScale(float scaleX, float scaleY) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
    }

    public void setScale(float scale) {
        this.scaleX = scale;
        this.scaleY = scale;
    }

    public float getShearX() {
        return this.shearX;
    }

    public void setShearX(float shearX) {
        this.shearX = shearX;
    }

    public float getShearY() {
        return this.shearY;
    }

    public void setShearY(float shearY) {
        this.shearY = shearY;
    }

    public BoneData.Inherit getInherit() {
        return this.inherit;
    }

    public void setInherit(BoneData.Inherit inherit) {
        if (inherit == null) {
            throw new IllegalArgumentException("inherit cannot be null.");
        }
        this.inherit = inherit;
    }

    public float getAX() {
        return this.ax;
    }

    public void setAX(float ax) {
        this.ax = ax;
    }

    public float getAY() {
        return this.ay;
    }

    public void setAY(float ay) {
        this.ay = ay;
    }

    public float getARotation() {
        return this.arotation;
    }

    public void setARotation(float arotation) {
        this.arotation = arotation;
    }

    public float getAScaleX() {
        return this.ascaleX;
    }

    public void setAScaleX(float ascaleX) {
        this.ascaleX = ascaleX;
    }

    public float getAScaleY() {
        return this.ascaleY;
    }

    public void setAScaleY(float ascaleY) {
        this.ascaleY = ascaleY;
    }

    public float getAShearX() {
        return this.ashearX;
    }

    public void setAShearX(float ashearX) {
        this.ashearX = ashearX;
    }

    public float getAShearY() {
        return this.ashearY;
    }

    public void setAShearY(float ashearY) {
        this.ashearY = ashearY;
    }

    public void updateAppliedTransform() {
        float rd;
        float rc;
        float rb;
        float ra;
        Bone parent = this.parent;
        if (parent == null) {
            this.ax = this.worldX - this.skeleton.x;
            this.ay = this.worldY - this.skeleton.y;
            float a = this.a;
            float b = this.b;
            float c = this.c;
            float d2 = this.d;
            this.arotation = SpineUtils.atan2Deg(c, a);
            this.ascaleX = (float)Math.sqrt(a * a + c * c);
            this.ascaleY = (float)Math.sqrt(b * b + d2 * d2);
            this.ashearX = 0.0f;
            this.ashearY = SpineUtils.atan2Deg(a * b + c * d2, a * d2 - b * c);
            return;
        }
        float pa = parent.a;
        float pb = parent.b;
        float pc = parent.c;
        float pd = parent.d;
        float pid = 1.0f / (pa * pd - pb * pc);
        float ia = pd * pid;
        float ib = pb * pid;
        float ic = pc * pid;
        float id2 = pa * pid;
        float dx = this.worldX - parent.worldX;
        float dy = this.worldY - parent.worldY;
        this.ax = dx * ia - dy * ib;
        this.ay = dy * id2 - dx * ic;
        if (this.inherit == BoneData.Inherit.onlyTranslation) {
            ra = this.a;
            rb = this.b;
            rc = this.c;
            rd = this.d;
        } else {
            switch (this.inherit) {
                case noRotationOrReflection: {
                    float s = Math.abs(pa * pd - pb * pc) / (pa * pa + pc * pc);
                    float sa = pa / this.skeleton.scaleX;
                    float sc = pc / this.skeleton.scaleY;
                    pb = -sc * s * this.skeleton.scaleX;
                    pd = sa * s * this.skeleton.scaleY;
                    pid = 1.0f / (pa * pd - pb * pc);
                    ia = pd * pid;
                    ib = pb * pid;
                    break;
                }
                case noScale: 
                case noScaleOrReflection: {
                    float r = this.rotation * ((float)Math.PI / 180);
                    float cos = SpineUtils.cos(r);
                    float sin = SpineUtils.sin(r);
                    pa = (pa * cos + pb * sin) / this.skeleton.scaleX;
                    pc = (pc * cos + pd * sin) / this.skeleton.scaleY;
                    float s = (float)Math.sqrt(pa * pa + pc * pc);
                    if (s > 1.0E-5f) {
                        s = 1.0f / s;
                    }
                    pa *= s;
                    pc *= s;
                    s = (float)Math.sqrt(pa * pa + pc * pc);
                    if (this.inherit == BoneData.Inherit.noScale && pid < 0.0f != (this.skeleton.scaleX < 0.0f != this.skeleton.scaleY < 0.0f)) {
                        s = -s;
                    }
                    r = 1.5707964f + SpineUtils.atan2(pc, pa);
                    pb = SpineUtils.cos(r) * s;
                    pd = SpineUtils.sin(r) * s;
                    pid = 1.0f / (pa * pd - pb * pc);
                    ia = pd * pid;
                    ib = pb * pid;
                    ic = pc * pid;
                    id2 = pa * pid;
                }
            }
            ra = ia * this.a - ib * this.c;
            rb = ia * this.b - ib * this.d;
            rc = id2 * this.c - ic * this.a;
            rd = id2 * this.d - ic * this.b;
        }
        this.ashearX = 0.0f;
        this.ascaleX = (float)Math.sqrt(ra * ra + rc * rc);
        if (this.ascaleX > 1.0E-4f) {
            float det = ra * rd - rb * rc;
            this.ascaleY = det / this.ascaleX;
            this.ashearY = -SpineUtils.atan2Deg(ra * rb + rc * rd, det);
            this.arotation = SpineUtils.atan2Deg(rc, ra);
        } else {
            this.ascaleX = 0.0f;
            this.ascaleY = (float)Math.sqrt(rb * rb + rd * rd);
            this.ashearY = 0.0f;
            this.arotation = 90.0f - SpineUtils.atan2Deg(rd, rb);
        }
    }

    public float getA() {
        return this.a;
    }

    public void setA(float a) {
        this.a = a;
    }

    public float getB() {
        return this.b;
    }

    public void setB(float b) {
        this.b = b;
    }

    public float getC() {
        return this.c;
    }

    public void setC(float c) {
        this.c = c;
    }

    public float getD() {
        return this.d;
    }

    public void setD(float d2) {
        this.d = d2;
    }

    public float getWorldX() {
        return this.worldX;
    }

    public void setWorldX(float worldX) {
        this.worldX = worldX;
    }

    public float getWorldY() {
        return this.worldY;
    }

    public void setWorldY(float worldY) {
        this.worldY = worldY;
    }

    public float getWorldRotationX() {
        return SpineUtils.atan2Deg(this.c, this.a);
    }

    public float getWorldRotationY() {
        return SpineUtils.atan2Deg(this.d, this.b);
    }

    public float getWorldScaleX() {
        return (float)Math.sqrt(this.a * this.a + this.c * this.c);
    }

    public float getWorldScaleY() {
        return (float)Math.sqrt(this.b * this.b + this.d * this.d);
    }

    public Matrix3 getWorldTransform(Matrix3 worldTransform) {
        if (worldTransform == null) {
            throw new IllegalArgumentException("worldTransform cannot be null.");
        }
        float[] val = worldTransform.val;
        val[0] = this.a;
        val[3] = this.b;
        val[1] = this.c;
        val[4] = this.d;
        val[6] = this.worldX;
        val[7] = this.worldY;
        val[2] = 0.0f;
        val[5] = 0.0f;
        val[8] = 1.0f;
        return worldTransform;
    }

    public Vector2 worldToLocal(Vector2 world) {
        if (world == null) {
            throw new IllegalArgumentException("world cannot be null.");
        }
        float det = this.a * this.d - this.b * this.c;
        float x = world.x - this.worldX;
        float y = world.y - this.worldY;
        world.x = (x * this.d - y * this.b) / det;
        world.y = (y * this.a - x * this.c) / det;
        return world;
    }

    public Vector2 localToWorld(Vector2 local) {
        if (local == null) {
            throw new IllegalArgumentException("local cannot be null.");
        }
        float x = local.x;
        float y = local.y;
        local.x = x * this.a + y * this.b + this.worldX;
        local.y = x * this.c + y * this.d + this.worldY;
        return local;
    }

    public Vector2 worldToParent(Vector2 world) {
        if (world == null) {
            throw new IllegalArgumentException("world cannot be null.");
        }
        return this.parent == null ? world : this.parent.worldToLocal(world);
    }

    public Vector2 parentToWorld(Vector2 world) {
        if (world == null) {
            throw new IllegalArgumentException("world cannot be null.");
        }
        return this.parent == null ? world : this.parent.localToWorld(world);
    }

    public float worldToLocalRotation(float worldRotation) {
        float sin = SpineUtils.sin(worldRotation *= (float)Math.PI / 180);
        float cos = SpineUtils.cos(worldRotation);
        return SpineUtils.atan2Deg(this.a * sin - this.c * cos, this.d * cos - this.b * sin) + this.rotation - this.shearX;
    }

    public float localToWorldRotation(float localRotation) {
        localRotation = (localRotation - this.rotation - this.shearX) * ((float)Math.PI / 180);
        float sin = SpineUtils.sin(localRotation);
        float cos = SpineUtils.cos(localRotation);
        return SpineUtils.atan2Deg(cos * this.c + sin * this.d, cos * this.a + sin * this.b);
    }

    public void rotateWorld(float degrees) {
        float sin = SpineUtils.sin(degrees *= (float)Math.PI / 180);
        float cos = SpineUtils.cos(degrees);
        float ra = this.a;
        float rb = this.b;
        this.a = cos * ra - sin * this.c;
        this.b = cos * rb - sin * this.d;
        this.c = sin * ra + cos * this.c;
        this.d = sin * rb + cos * this.d;
    }

    public String toString() {
        return this.data.name;
    }
}

