/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.PhysicsConstraintData;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Updatable;
import com.esotericsoftware.spine.utils.SpineUtils;

public class PhysicsConstraint
implements Updatable {
    final PhysicsConstraintData data;
    public Bone bone;
    float inertia;
    float strength;
    float damping;
    float massInverse;
    float wind;
    float gravity;
    float mix;
    boolean reset = true;
    float ux;
    float uy;
    float cx;
    float cy;
    float tx;
    float ty;
    float xOffset;
    float xVelocity;
    float yOffset;
    float yVelocity;
    float rotateOffset;
    float rotateVelocity;
    float scaleOffset;
    float scaleVelocity;
    boolean active;
    final Skeleton skeleton;
    float remaining;
    float lastTime;

    public PhysicsConstraint(PhysicsConstraintData data, Skeleton skeleton) {
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        this.data = data;
        this.skeleton = skeleton;
        this.bone = skeleton.bones.get(data.bone.index);
        this.inertia = data.inertia;
        this.strength = data.strength;
        this.damping = data.damping;
        this.massInverse = data.massInverse;
        this.wind = data.wind;
        this.gravity = data.gravity;
        this.mix = data.mix;
    }

    public PhysicsConstraint(PhysicsConstraint constraint, Skeleton skeleton) {
        this(constraint.data, skeleton);
        this.inertia = constraint.inertia;
        this.strength = constraint.strength;
        this.damping = constraint.damping;
        this.massInverse = constraint.massInverse;
        this.wind = constraint.wind;
        this.gravity = constraint.gravity;
        this.mix = constraint.mix;
    }

    public void reset() {
        this.remaining = 0.0f;
        this.lastTime = this.skeleton.time;
        this.reset = true;
        this.xOffset = 0.0f;
        this.xVelocity = 0.0f;
        this.yOffset = 0.0f;
        this.yVelocity = 0.0f;
        this.rotateOffset = 0.0f;
        this.rotateVelocity = 0.0f;
        this.scaleOffset = 0.0f;
        this.scaleVelocity = 0.0f;
    }

    public void setToSetupPose() {
        PhysicsConstraintData data = this.data;
        this.inertia = data.inertia;
        this.strength = data.strength;
        this.damping = data.damping;
        this.massInverse = data.massInverse;
        this.wind = data.wind;
        this.gravity = data.gravity;
        this.mix = data.mix;
    }

    public void translate(float x, float y) {
        this.ux -= x;
        this.uy -= y;
        this.cx -= x;
        this.cy -= y;
    }

    public void rotate(float x, float y, float degrees) {
        float r = degrees * ((float)Math.PI / 180);
        float cos = SpineUtils.cos(r);
        float sin = SpineUtils.sin(r);
        float dx = this.cx - x;
        float dy = this.cy - y;
        this.translate(dx * cos - dy * sin - dx, dx * sin + dy * cos - dy);
    }

    @Override
    public void update(Skeleton.Physics physics) {
        float mix = this.mix;
        if (mix == 0.0f) {
            return;
        }
        boolean x = this.data.x > 0.0f;
        boolean y = this.data.y > 0.0f;
        boolean rotateOrShearX = this.data.rotate > 0.0f || this.data.shearX > 0.0f;
        boolean scaleX = this.data.scaleX > 0.0f;
        Bone bone = this.bone;
        float l2 = bone.data.length;
        switch (physics) {
            case none: {
                return;
            }
            case reset: {
                this.reset();
            }
            case update: {
                Skeleton skeleton = this.skeleton;
                float delta = Math.max(skeleton.time - this.lastTime, 0.0f);
                this.remaining += delta;
                this.lastTime = skeleton.time;
                float bx = bone.worldX;
                float by = bone.worldY;
                if (this.reset) {
                    this.reset = false;
                    this.ux = bx;
                    this.uy = by;
                } else {
                    float a = this.remaining;
                    float i = this.inertia;
                    float t2 = this.data.step;
                    float f2 = skeleton.data.referenceScale;
                    float d2 = -1.0f;
                    float qx = this.data.limit * delta;
                    float qy = qx * Math.abs(skeleton.scaleY);
                    qx *= Math.abs(skeleton.scaleX);
                    if (x || y) {
                        float u;
                        if (x) {
                            u = (this.ux - bx) * i;
                            this.xOffset += u > qx ? qx : (u < -qx ? -qx : u);
                            this.ux = bx;
                        }
                        if (y) {
                            u = (this.uy - by) * i;
                            this.yOffset += u > qy ? qy : (u < -qy ? -qy : u);
                            this.uy = by;
                        }
                        if (a >= t2) {
                            d2 = (float)Math.pow(this.damping, 60.0f * t2);
                            float m = this.massInverse * t2;
                            float e = this.strength;
                            float w = this.wind * f2;
                            float g = this.gravity * f2;
                            do {
                                if (x) {
                                    this.xVelocity += (w - this.xOffset * e) * m;
                                    this.xOffset += this.xVelocity * t2;
                                    this.xVelocity *= d2;
                                }
                                if (!y) continue;
                                this.yVelocity -= (g + this.yOffset * e) * m;
                                this.yOffset += this.yVelocity * t2;
                                this.yVelocity *= d2;
                            } while ((a -= t2) >= t2);
                        }
                        if (x) {
                            bone.worldX += this.xOffset * mix * this.data.x;
                        }
                        if (y) {
                            bone.worldY += this.yOffset * mix * this.data.y;
                        }
                    }
                    if (rotateOrShearX || scaleX) {
                        float s;
                        float c;
                        float r;
                        float ca = SpineUtils.atan2(bone.c, bone.a);
                        float mr = 0.0f;
                        float dx = this.cx - bone.worldX;
                        float dy = this.cy - bone.worldY;
                        if (dx > qx) {
                            dx = qx;
                        } else if (dx < -qx) {
                            dx = -qx;
                        }
                        if (dy > qy) {
                            dy = qy;
                        } else if (dy < -qy) {
                            dy = -qy;
                        }
                        if (rotateOrShearX) {
                            mr = (this.data.rotate + this.data.shearX) * mix;
                            r = SpineUtils.atan2(dy + this.ty, dx + this.tx) - ca - this.rotateOffset * mr;
                            this.rotateOffset += (r - (float)Math.ceil(r * 0.15915494f - 0.5f) * ((float)Math.PI * 2)) * i;
                            r = this.rotateOffset * mr + ca;
                            c = SpineUtils.cos(r);
                            s = SpineUtils.sin(r);
                            if (scaleX && (r = l2 * bone.getWorldScaleX()) > 0.0f) {
                                this.scaleOffset += (dx * c + dy * s) * i / r;
                            }
                        } else {
                            c = SpineUtils.cos(ca);
                            s = SpineUtils.sin(ca);
                            r = l2 * bone.getWorldScaleX();
                            if (r > 0.0f) {
                                this.scaleOffset += (dx * c + dy * s) * i / r;
                            }
                        }
                        a = this.remaining;
                        if (a >= t2) {
                            if (d2 == -1.0f) {
                                d2 = (float)Math.pow(this.damping, 60.0f * t2);
                            }
                            float m = this.massInverse * t2;
                            float e = this.strength;
                            float w = this.wind;
                            float g = this.gravity;
                            float h2 = l2 / f2;
                            while (true) {
                                a -= t2;
                                if (scaleX) {
                                    this.scaleVelocity += (w * c - g * s - this.scaleOffset * e) * m;
                                    this.scaleOffset += this.scaleVelocity * t2;
                                    this.scaleVelocity *= d2;
                                }
                                if (rotateOrShearX) {
                                    this.rotateVelocity -= ((w * s + g * c) * h2 + this.rotateOffset * e) * m;
                                    this.rotateOffset += this.rotateVelocity * t2;
                                    this.rotateVelocity *= d2;
                                    if (a < t2) break;
                                    float r2 = this.rotateOffset * mr + ca;
                                    c = SpineUtils.cos(r2);
                                    s = SpineUtils.sin(r2);
                                    continue;
                                }
                                if (a < t2) break;
                            }
                        }
                    }
                    this.remaining = a;
                }
                this.cx = bone.worldX;
                this.cy = bone.worldY;
                break;
            }
            case pose: {
                if (x) {
                    bone.worldX += this.xOffset * mix * this.data.x;
                }
                if (!y) break;
                bone.worldY += this.yOffset * mix * this.data.y;
            }
        }
        if (rotateOrShearX) {
            float a;
            float c;
            float s;
            float o = this.rotateOffset * mix;
            if (this.data.shearX > 0.0f) {
                float r = 0.0f;
                if (this.data.rotate > 0.0f) {
                    r = o * this.data.rotate;
                    s = SpineUtils.sin(r);
                    c = SpineUtils.cos(r);
                    a = bone.b;
                    bone.b = c * a - s * bone.d;
                    bone.d = s * a + c * bone.d;
                }
                s = SpineUtils.sin(r += o * this.data.shearX);
                c = SpineUtils.cos(r);
                a = bone.a;
                bone.a = c * a - s * bone.c;
                bone.c = s * a + c * bone.c;
            } else {
                s = SpineUtils.sin(o *= this.data.rotate);
                c = SpineUtils.cos(o);
                a = bone.a;
                bone.a = c * a - s * bone.c;
                bone.c = s * a + c * bone.c;
                a = bone.b;
                bone.b = c * a - s * bone.d;
                bone.d = s * a + c * bone.d;
            }
        }
        if (scaleX) {
            float s = 1.0f + this.scaleOffset * mix * this.data.scaleX;
            bone.a *= s;
            bone.c *= s;
        }
        if (physics != Skeleton.Physics.pose) {
            this.tx = l2 * bone.a;
            this.ty = l2 * bone.c;
        }
        bone.updateAppliedTransform();
    }

    public Bone getBone() {
        return this.bone;
    }

    public void setBone(Bone bone) {
        this.bone = bone;
    }

    public float getInertia() {
        return this.inertia;
    }

    public void setInertia(float inertia) {
        this.inertia = inertia;
    }

    public float getStrength() {
        return this.strength;
    }

    public void setStrength(float strength) {
        this.strength = strength;
    }

    public float getDamping() {
        return this.damping;
    }

    public void setDamping(float damping) {
        this.damping = damping;
    }

    public float getMassInverse() {
        return this.massInverse;
    }

    public void setMassInverse(float massInverse) {
        this.massInverse = massInverse;
    }

    public float getWind() {
        return this.wind;
    }

    public void setWind(float wind) {
        this.wind = wind;
    }

    public float getGravity() {
        return this.gravity;
    }

    public void setGravity(float gravity) {
        this.gravity = gravity;
    }

    public float getMix() {
        return this.mix;
    }

    public void setMix(float mix) {
        this.mix = mix;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public PhysicsConstraintData getData() {
        return this.data;
    }

    public String toString() {
        return this.data.name;
    }
}

