/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.DataInput;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.SerializationException;
import com.esotericsoftware.spine.Animation;
import com.esotericsoftware.spine.BlendMode;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.ConstraintData;
import com.esotericsoftware.spine.Event;
import com.esotericsoftware.spine.EventData;
import com.esotericsoftware.spine.IkConstraintData;
import com.esotericsoftware.spine.PathConstraintData;
import com.esotericsoftware.spine.PhysicsConstraintData;
import com.esotericsoftware.spine.SkeletonData;
import com.esotericsoftware.spine.SkeletonLoader;
import com.esotericsoftware.spine.Skin;
import com.esotericsoftware.spine.SlotData;
import com.esotericsoftware.spine.TransformConstraintData;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.AttachmentLoader;
import com.esotericsoftware.spine.attachments.AttachmentType;
import com.esotericsoftware.spine.attachments.BoundingBoxAttachment;
import com.esotericsoftware.spine.attachments.ClippingAttachment;
import com.esotericsoftware.spine.attachments.MeshAttachment;
import com.esotericsoftware.spine.attachments.PathAttachment;
import com.esotericsoftware.spine.attachments.PointAttachment;
import com.esotericsoftware.spine.attachments.RegionAttachment;
import com.esotericsoftware.spine.attachments.Sequence;
import com.esotericsoftware.spine.attachments.VertexAttachment;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class SkeletonBinary
extends SkeletonLoader {
    public static final int BONE_ROTATE = 0;
    public static final int BONE_TRANSLATE = 1;
    public static final int BONE_TRANSLATEX = 2;
    public static final int BONE_TRANSLATEY = 3;
    public static final int BONE_SCALE = 4;
    public static final int BONE_SCALEX = 5;
    public static final int BONE_SCALEY = 6;
    public static final int BONE_SHEAR = 7;
    public static final int BONE_SHEARX = 8;
    public static final int BONE_SHEARY = 9;
    public static final int BONE_INHERIT = 10;
    public static final int SLOT_ATTACHMENT = 0;
    public static final int SLOT_RGBA = 1;
    public static final int SLOT_RGB = 2;
    public static final int SLOT_RGBA2 = 3;
    public static final int SLOT_RGB2 = 4;
    public static final int SLOT_ALPHA = 5;
    public static final int ATTACHMENT_DEFORM = 0;
    public static final int ATTACHMENT_SEQUENCE = 1;
    public static final int PATH_POSITION = 0;
    public static final int PATH_SPACING = 1;
    public static final int PATH_MIX = 2;
    public static final int PHYSICS_INERTIA = 0;
    public static final int PHYSICS_STRENGTH = 1;
    public static final int PHYSICS_DAMPING = 2;
    public static final int PHYSICS_MASS = 4;
    public static final int PHYSICS_WIND = 5;
    public static final int PHYSICS_GRAVITY = 6;
    public static final int PHYSICS_MIX = 7;
    public static final int PHYSICS_RESET = 8;
    public static final int CURVE_LINEAR = 0;
    public static final int CURVE_STEPPED = 1;
    public static final int CURVE_BEZIER = 2;
    private final Array<LinkedMesh> linkedMeshes = new Array();

    public SkeletonBinary(AttachmentLoader attachmentLoader) {
        super(attachmentLoader);
    }

    public SkeletonBinary(TextureAtlas atlas) {
        super(atlas);
    }

    @Override
    public SkeletonData readSkeletonData(FileHandle file) {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be null.");
        }
        SkeletonData skeletonData = this.readSkeletonData(file.read());
        skeletonData.name = file.nameWithoutExtension();
        return skeletonData;
    }

    @Override
    public SkeletonData readSkeletonData(InputStream dataInput) {
        if (dataInput == null) {
            throw new IllegalArgumentException("dataInput cannot be null.");
        }
        float scale = this.scale;
        SkeletonInput input = new SkeletonInput(dataInput);
        SkeletonData skeletonData = new SkeletonData();
        try {
            int i;
            int i2;
            int flags;
            int ii;
            BoneData[] constraintBones;
            Object data;
            int i3;
            Object data2;
            long hash = input.readLong();
            skeletonData.hash = hash == 0L ? null : Long.toString(hash);
            skeletonData.version = input.readString();
            if (skeletonData.version.isEmpty()) {
                skeletonData.version = null;
            }
            skeletonData.x = input.readFloat();
            skeletonData.y = input.readFloat();
            skeletonData.width = input.readFloat();
            skeletonData.height = input.readFloat();
            skeletonData.referenceScale = input.readFloat() * scale;
            boolean nonessential = input.readBoolean();
            if (nonessential) {
                skeletonData.fps = input.readFloat();
                skeletonData.imagesPath = input.readString();
                if (skeletonData.imagesPath.isEmpty()) {
                    skeletonData.imagesPath = null;
                }
                skeletonData.audioPath = input.readString();
                if (skeletonData.audioPath.isEmpty()) {
                    skeletonData.audioPath = null;
                }
            }
            int n2 = input.readInt(true);
            input.strings = new String[n2];
            Object[] o = input.strings;
            for (int i4 = 0; i4 < n2; ++i4) {
                o[i4] = input.readString();
            }
            n2 = input.readInt(true);
            BoneData[] bones = skeletonData.bones.setSize(n2);
            for (int i5 = 0; i5 < n2; ++i5) {
                String name = input.readString();
                BoneData parent = i5 == 0 ? null : bones[input.readInt(true)];
                data2 = new BoneData(i5, name, parent);
                ((BoneData)data2).rotation = input.readFloat();
                ((BoneData)data2).x = input.readFloat() * scale;
                ((BoneData)data2).y = input.readFloat() * scale;
                ((BoneData)data2).scaleX = input.readFloat();
                ((BoneData)data2).scaleY = input.readFloat();
                ((BoneData)data2).shearX = input.readFloat();
                ((BoneData)data2).shearY = input.readFloat();
                ((BoneData)data2).length = input.readFloat() * scale;
                ((BoneData)data2).inherit = BoneData.Inherit.values[input.readByte()];
                ((BoneData)data2).skinRequired = input.readBoolean();
                if (nonessential) {
                    Color.rgba8888ToColor(((BoneData)data2).color, input.readInt());
                    ((BoneData)data2).icon = input.readString();
                    ((BoneData)data2).visible = input.readBoolean();
                }
                bones[i5] = data2;
            }
            n2 = input.readInt(true);
            SlotData[] slots = skeletonData.slots.setSize(n2);
            for (i3 = 0; i3 < n2; ++i3) {
                String slotName = input.readString();
                BoneData boneData = bones[input.readInt(true)];
                data = new SlotData(i3, slotName, boneData);
                Color.rgba8888ToColor(((SlotData)data).color, input.readInt());
                int darkColor = input.readInt();
                if (darkColor != -1) {
                    ((SlotData)data).darkColor = new Color();
                    Color.rgb888ToColor(((SlotData)data).darkColor, darkColor);
                }
                ((SlotData)data).attachmentName = input.readStringRef();
                ((SlotData)data).blendMode = BlendMode.values[input.readInt(true)];
                if (nonessential) {
                    ((SlotData)data).visible = input.readBoolean();
                }
                slots[i3] = data;
            }
            n2 = input.readInt(true);
            o = skeletonData.ikConstraints.setSize(n2);
            for (i3 = 0; i3 < n2; ++i3) {
                data2 = new IkConstraintData(input.readString());
                ((IkConstraintData)data2).order = input.readInt(true);
                int nn = input.readInt(true);
                constraintBones = ((IkConstraintData)data2).bones.setSize(nn);
                for (ii = 0; ii < nn; ++ii) {
                    constraintBones[ii] = bones[input.readInt(true)];
                }
                ((IkConstraintData)data2).target = bones[input.readInt(true)];
                flags = input.read();
                ((IkConstraintData)data2).skinRequired = (flags & 1) != 0;
                ((IkConstraintData)data2).bendDirection = (flags & 2) != 0 ? 1 : -1;
                ((IkConstraintData)data2).compress = (flags & 4) != 0;
                ((IkConstraintData)data2).stretch = (flags & 8) != 0;
                boolean bl = ((IkConstraintData)data2).uniform = (flags & 0x10) != 0;
                if ((flags & 0x20) != 0) {
                    float f2 = ((IkConstraintData)data2).mix = (flags & 0x40) != 0 ? input.readFloat() : 1.0f;
                }
                if ((flags & 0x80) != 0) {
                    ((IkConstraintData)data2).softness = input.readFloat() * scale;
                }
                o[i3] = data2;
            }
            n2 = input.readInt(true);
            o = skeletonData.transformConstraints.setSize(n2);
            for (i3 = 0; i3 < n2; ++i3) {
                data2 = new TransformConstraintData(input.readString());
                ((TransformConstraintData)data2).order = input.readInt(true);
                int nn = input.readInt(true);
                constraintBones = ((TransformConstraintData)data2).bones.setSize(nn);
                for (ii = 0; ii < nn; ++ii) {
                    constraintBones[ii] = bones[input.readInt(true)];
                }
                ((TransformConstraintData)data2).target = bones[input.readInt(true)];
                flags = input.read();
                ((TransformConstraintData)data2).skinRequired = (flags & 1) != 0;
                ((TransformConstraintData)data2).local = (flags & 2) != 0;
                boolean bl = ((TransformConstraintData)data2).relative = (flags & 4) != 0;
                if ((flags & 8) != 0) {
                    ((TransformConstraintData)data2).offsetRotation = input.readFloat();
                }
                if ((flags & 0x10) != 0) {
                    ((TransformConstraintData)data2).offsetX = input.readFloat() * scale;
                }
                if ((flags & 0x20) != 0) {
                    ((TransformConstraintData)data2).offsetY = input.readFloat() * scale;
                }
                if ((flags & 0x40) != 0) {
                    ((TransformConstraintData)data2).offsetScaleX = input.readFloat();
                }
                if ((flags & 0x80) != 0) {
                    ((TransformConstraintData)data2).offsetScaleY = input.readFloat();
                }
                if (((flags = input.read()) & 1) != 0) {
                    ((TransformConstraintData)data2).offsetShearY = input.readFloat();
                }
                if ((flags & 2) != 0) {
                    ((TransformConstraintData)data2).mixRotate = input.readFloat();
                }
                if ((flags & 4) != 0) {
                    ((TransformConstraintData)data2).mixX = input.readFloat();
                }
                if ((flags & 8) != 0) {
                    ((TransformConstraintData)data2).mixY = input.readFloat();
                }
                if ((flags & 0x10) != 0) {
                    ((TransformConstraintData)data2).mixScaleX = input.readFloat();
                }
                if ((flags & 0x20) != 0) {
                    ((TransformConstraintData)data2).mixScaleY = input.readFloat();
                }
                if ((flags & 0x40) != 0) {
                    ((TransformConstraintData)data2).mixShearY = input.readFloat();
                }
                o[i3] = data2;
            }
            n2 = input.readInt(true);
            o = skeletonData.pathConstraints.setSize(n2);
            for (i3 = 0; i3 < n2; ++i3) {
                data2 = new PathConstraintData(input.readString());
                ((PathConstraintData)data2).order = input.readInt(true);
                ((PathConstraintData)data2).skinRequired = input.readBoolean();
                int nn = input.readInt(true);
                constraintBones = ((PathConstraintData)data2).bones.setSize(nn);
                for (ii = 0; ii < nn; ++ii) {
                    constraintBones[ii] = bones[input.readInt(true)];
                }
                ((PathConstraintData)data2).target = slots[input.readInt(true)];
                flags = input.read();
                ((PathConstraintData)data2).positionMode = PathConstraintData.PositionMode.values[flags & 1];
                ((PathConstraintData)data2).spacingMode = PathConstraintData.SpacingMode.values[flags >> 1 & 3];
                ((PathConstraintData)data2).rotateMode = PathConstraintData.RotateMode.values[flags >> 3 & 3];
                if ((flags & 0x80) != 0) {
                    ((PathConstraintData)data2).offsetRotation = input.readFloat();
                }
                ((PathConstraintData)data2).position = input.readFloat();
                if (((PathConstraintData)data2).positionMode == PathConstraintData.PositionMode.fixed) {
                    ((PathConstraintData)data2).position *= scale;
                }
                ((PathConstraintData)data2).spacing = input.readFloat();
                if (((PathConstraintData)data2).spacingMode == PathConstraintData.SpacingMode.length || ((PathConstraintData)data2).spacingMode == PathConstraintData.SpacingMode.fixed) {
                    ((PathConstraintData)data2).spacing *= scale;
                }
                ((PathConstraintData)data2).mixRotate = input.readFloat();
                ((PathConstraintData)data2).mixX = input.readFloat();
                ((PathConstraintData)data2).mixY = input.readFloat();
                o[i3] = data2;
            }
            n2 = input.readInt(true);
            o = skeletonData.physicsConstraints.setSize(n2);
            for (i3 = 0; i3 < n2; ++i3) {
                PhysicsConstraintData data3 = new PhysicsConstraintData(input.readString());
                data3.order = input.readInt(true);
                data3.bone = bones[input.readInt(true)];
                int flags2 = input.read();
                boolean bl = data3.skinRequired = (flags2 & 1) != 0;
                if ((flags2 & 2) != 0) {
                    data3.x = input.readFloat();
                }
                if ((flags2 & 4) != 0) {
                    data3.y = input.readFloat();
                }
                if ((flags2 & 8) != 0) {
                    data3.rotate = input.readFloat();
                }
                if ((flags2 & 0x10) != 0) {
                    data3.scaleX = input.readFloat();
                }
                if ((flags2 & 0x20) != 0) {
                    data3.shearX = input.readFloat();
                }
                data3.limit = ((flags2 & 0x40) != 0 ? input.readFloat() : 5000.0f) * scale;
                data3.step = 1.0f / (float)input.readUnsignedByte();
                data3.inertia = input.readFloat();
                data3.strength = input.readFloat();
                data3.damping = input.readFloat();
                data3.massInverse = (flags2 & 0x80) != 0 ? input.readFloat() : 1.0f;
                data3.wind = input.readFloat();
                data3.gravity = input.readFloat();
                flags2 = input.read();
                if ((flags2 & 1) != 0) {
                    data3.inertiaGlobal = true;
                }
                if ((flags2 & 2) != 0) {
                    data3.strengthGlobal = true;
                }
                if ((flags2 & 4) != 0) {
                    data3.dampingGlobal = true;
                }
                if ((flags2 & 8) != 0) {
                    data3.massGlobal = true;
                }
                if ((flags2 & 0x10) != 0) {
                    data3.windGlobal = true;
                }
                if ((flags2 & 0x20) != 0) {
                    data3.gravityGlobal = true;
                }
                if ((flags2 & 0x40) != 0) {
                    data3.mixGlobal = true;
                }
                data3.mix = (flags2 & 0x80) != 0 ? input.readFloat() : 1.0f;
                o[i3] = data3;
            }
            Skin defaultSkin = this.readSkin(input, skeletonData, true, nonessential);
            if (defaultSkin != null) {
                skeletonData.defaultSkin = defaultSkin;
                skeletonData.skins.add(defaultSkin);
            }
            n2 = i2 + input.readInt(true);
            o = skeletonData.skins.setSize(n2);
            for (i2 = skeletonData.skins.size; i2 < n2; ++i2) {
                o[i2] = this.readSkin(input, skeletonData, false, nonessential);
            }
            n2 = this.linkedMeshes.size;
            T[] items = this.linkedMeshes.items;
            for (i = 0; i < n2; ++i) {
                LinkedMesh linkedMesh = (LinkedMesh)items[i];
                Skin skin = skeletonData.skins.get(linkedMesh.skinIndex);
                Attachment parent = skin.getAttachment(linkedMesh.slotIndex, linkedMesh.parent);
                if (parent == null) {
                    throw new SerializationException("Parent mesh not found: " + linkedMesh.parent);
                }
                linkedMesh.mesh.setTimelineAttachment(linkedMesh.inheritTimelines ? (VertexAttachment)parent : linkedMesh.mesh);
                linkedMesh.mesh.setParentMesh((MeshAttachment)parent);
                if (linkedMesh.mesh.getSequence() != null) continue;
                linkedMesh.mesh.updateRegion();
            }
            this.linkedMeshes.clear();
            n2 = input.readInt(true);
            o = skeletonData.events.setSize(n2);
            for (i = 0; i < n2; ++i) {
                data = new EventData(input.readString());
                ((EventData)data).intValue = input.readInt(false);
                ((EventData)data).floatValue = input.readFloat();
                ((EventData)data).stringValue = input.readString();
                ((EventData)data).audioPath = input.readString();
                if (((EventData)data).audioPath != null) {
                    ((EventData)data).volume = input.readFloat();
                    ((EventData)data).balance = input.readFloat();
                }
                o[i] = data;
            }
            n2 = input.readInt(true);
            o = skeletonData.animations.setSize(n2);
            for (i = 0; i < n2; ++i) {
                o[i] = this.readAnimation(input, input.readString(), skeletonData);
            }
        }
        catch (IOException ex) {
            throw new SerializationException("Error reading skeleton file.", ex);
        }
        finally {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
        return skeletonData;
    }

    @Null
    private Skin readSkin(SkeletonInput input, SkeletonData skeletonData, boolean defaultSkin, boolean nonessential) throws IOException {
        Skin skin;
        int slotCount;
        if (defaultSkin) {
            slotCount = input.readInt(true);
            if (slotCount == 0) {
                return null;
            }
            skin = new Skin("default");
        } else {
            int i;
            skin = new Skin(input.readString());
            if (nonessential) {
                Color.rgba8888ToColor(skin.color, input.readInt());
            }
            BoneData[] bones = skin.bones.setSize(input.readInt(true));
            T[] items = skeletonData.bones.items;
            int n2 = skin.bones.size;
            for (i = 0; i < n2; ++i) {
                bones[i] = items[input.readInt(true)];
            }
            items = skeletonData.ikConstraints.items;
            n2 = input.readInt(true);
            for (i = 0; i < n2; ++i) {
                skin.constraints.add((ConstraintData)items[input.readInt(true)]);
            }
            items = skeletonData.transformConstraints.items;
            n2 = input.readInt(true);
            for (i = 0; i < n2; ++i) {
                skin.constraints.add((ConstraintData)items[input.readInt(true)]);
            }
            items = skeletonData.pathConstraints.items;
            n2 = input.readInt(true);
            for (i = 0; i < n2; ++i) {
                skin.constraints.add((ConstraintData)items[input.readInt(true)]);
            }
            items = skeletonData.physicsConstraints.items;
            n2 = input.readInt(true);
            for (i = 0; i < n2; ++i) {
                skin.constraints.add((ConstraintData)items[input.readInt(true)]);
            }
            skin.constraints.shrink();
            slotCount = input.readInt(true);
        }
        for (int i = 0; i < slotCount; ++i) {
            int slotIndex = input.readInt(true);
            int nn = input.readInt(true);
            for (int ii = 0; ii < nn; ++ii) {
                String name = input.readStringRef();
                Attachment attachment = this.readAttachment(input, skeletonData, skin, slotIndex, name, nonessential);
                if (attachment == null) continue;
                skin.setAttachment(slotIndex, name, attachment);
            }
        }
        return skin;
    }

    private Attachment readAttachment(SkeletonInput input, SkeletonData skeletonData, Skin skin, int slotIndex, String attachmentName, boolean nonessential) throws IOException {
        float scale = this.scale;
        byte flags = input.readByte();
        String name = (flags & 8) != 0 ? input.readStringRef() : attachmentName;
        switch (AttachmentType.values[flags & 7]) {
            case region: {
                RegionAttachment region;
                String path = (flags & 0x10) != 0 ? input.readStringRef() : null;
                int color = (flags & 0x20) != 0 ? input.readInt() : -1;
                Sequence sequence = (flags & 0x40) != 0 ? this.readSequence(input) : null;
                float rotation = (flags & 0x80) != 0 ? input.readFloat() : 0.0f;
                float x = input.readFloat();
                float y = input.readFloat();
                float scaleX = input.readFloat();
                float scaleY = input.readFloat();
                float width = input.readFloat();
                float height = input.readFloat();
                if (path == null) {
                    path = name;
                }
                if ((region = this.attachmentLoader.newRegionAttachment(skin, name, path, sequence)) == null) {
                    return null;
                }
                region.setPath(path);
                region.setX(x * scale);
                region.setY(y * scale);
                region.setScaleX(scaleX);
                region.setScaleY(scaleY);
                region.setRotation(rotation);
                region.setWidth(width * scale);
                region.setHeight(height * scale);
                Color.rgba8888ToColor(region.getColor(), color);
                region.setSequence(sequence);
                if (sequence == null) {
                    region.updateRegion();
                }
                return region;
            }
            case boundingbox: {
                Vertices vertices = this.readVertices(input, (flags & 0x10) != 0);
                int color = nonessential ? input.readInt() : 0;
                BoundingBoxAttachment box = this.attachmentLoader.newBoundingBoxAttachment(skin, name);
                if (box == null) {
                    return null;
                }
                box.setWorldVerticesLength(vertices.length);
                box.setVertices(vertices.vertices);
                box.setBones(vertices.bones);
                if (nonessential) {
                    Color.rgba8888ToColor(box.getColor(), color);
                }
                return box;
            }
            case mesh: {
                MeshAttachment mesh;
                String path = (flags & 0x10) != 0 ? input.readStringRef() : name;
                int color = (flags & 0x20) != 0 ? input.readInt() : -1;
                Sequence sequence = (flags & 0x40) != 0 ? this.readSequence(input) : null;
                int hullLength = input.readInt(true);
                Vertices vertices = this.readVertices(input, (flags & 0x80) != 0);
                float[] uvs = this.readFloatArray(input, vertices.length, 1.0f);
                short[] triangles = this.readShortArray(input, (vertices.length - hullLength - 2) * 3);
                short[] edges = null;
                float width = 0.0f;
                float height = 0.0f;
                if (nonessential) {
                    edges = this.readShortArray(input, input.readInt(true));
                    width = input.readFloat();
                    height = input.readFloat();
                }
                if ((mesh = this.attachmentLoader.newMeshAttachment(skin, name, path, sequence)) == null) {
                    return null;
                }
                mesh.setPath(path);
                Color.rgba8888ToColor(mesh.getColor(), color);
                mesh.setBones(vertices.bones);
                mesh.setVertices(vertices.vertices);
                mesh.setWorldVerticesLength(vertices.length);
                mesh.setTriangles(triangles);
                mesh.setRegionUVs(uvs);
                if (sequence == null) {
                    mesh.updateRegion();
                }
                mesh.setHullLength(hullLength << 1);
                mesh.setSequence(sequence);
                if (nonessential) {
                    mesh.setEdges(edges);
                    mesh.setWidth(width * scale);
                    mesh.setHeight(height * scale);
                }
                return mesh;
            }
            case linkedmesh: {
                MeshAttachment mesh;
                String path = (flags & 0x10) != 0 ? input.readStringRef() : name;
                int color = (flags & 0x20) != 0 ? input.readInt() : -1;
                Sequence sequence = (flags & 0x40) != 0 ? this.readSequence(input) : null;
                boolean inheritTimelines = (flags & 0x80) != 0;
                int skinIndex = input.readInt(true);
                String parent = input.readStringRef();
                float width = 0.0f;
                float height = 0.0f;
                if (nonessential) {
                    width = input.readFloat();
                    height = input.readFloat();
                }
                if ((mesh = this.attachmentLoader.newMeshAttachment(skin, name, path, sequence)) == null) {
                    return null;
                }
                mesh.setPath(path);
                Color.rgba8888ToColor(mesh.getColor(), color);
                mesh.setSequence(sequence);
                if (nonessential) {
                    mesh.setWidth(width * scale);
                    mesh.setHeight(height * scale);
                }
                this.linkedMeshes.add(new LinkedMesh(mesh, skinIndex, slotIndex, parent, inheritTimelines));
                return mesh;
            }
            case path: {
                boolean closed = (flags & 0x10) != 0;
                boolean constantSpeed = (flags & 0x20) != 0;
                Vertices vertices = this.readVertices(input, (flags & 0x40) != 0);
                float[] lengths = new float[vertices.length / 6];
                int n2 = lengths.length;
                for (int i = 0; i < n2; ++i) {
                    lengths[i] = input.readFloat() * scale;
                }
                int color = nonessential ? input.readInt() : 0;
                PathAttachment path = this.attachmentLoader.newPathAttachment(skin, name);
                if (path == null) {
                    return null;
                }
                path.setClosed(closed);
                path.setConstantSpeed(constantSpeed);
                path.setWorldVerticesLength(vertices.length);
                path.setVertices(vertices.vertices);
                path.setBones(vertices.bones);
                path.setLengths(lengths);
                if (nonessential) {
                    Color.rgba8888ToColor(path.getColor(), color);
                }
                return path;
            }
            case point: {
                float rotation = input.readFloat();
                float x = input.readFloat();
                float y = input.readFloat();
                int color = nonessential ? input.readInt() : 0;
                PointAttachment point = this.attachmentLoader.newPointAttachment(skin, name);
                if (point == null) {
                    return null;
                }
                point.setX(x * scale);
                point.setY(y * scale);
                point.setRotation(rotation);
                if (nonessential) {
                    Color.rgba8888ToColor(point.getColor(), color);
                }
                return point;
            }
            case clipping: {
                int endSlotIndex = input.readInt(true);
                Vertices vertices = this.readVertices(input, (flags & 0x10) != 0);
                int color = nonessential ? input.readInt() : 0;
                ClippingAttachment clip = this.attachmentLoader.newClippingAttachment(skin, name);
                if (clip == null) {
                    return null;
                }
                clip.setEndSlot(skeletonData.slots.get(endSlotIndex));
                clip.setWorldVerticesLength(vertices.length);
                clip.setVertices(vertices.vertices);
                clip.setBones(vertices.bones);
                if (nonessential) {
                    Color.rgba8888ToColor(clip.getColor(), color);
                }
                return clip;
            }
        }
        return null;
    }

    private Sequence readSequence(SkeletonInput input) throws IOException {
        Sequence sequence = new Sequence(input.readInt(true));
        sequence.setStart(input.readInt(true));
        sequence.setDigits(input.readInt(true));
        sequence.setSetupIndex(input.readInt(true));
        return sequence;
    }

    private Vertices readVertices(SkeletonInput input, boolean weighted) throws IOException {
        float scale = this.scale;
        int vertexCount = input.readInt(true);
        Vertices vertices = new Vertices();
        vertices.length = vertexCount << 1;
        if (!weighted) {
            vertices.vertices = this.readFloatArray(input, vertices.length, scale);
            return vertices;
        }
        FloatArray weights = new FloatArray(vertices.length * 3 * 3);
        IntArray bonesArray = new IntArray(vertices.length * 3);
        for (int i = 0; i < vertexCount; ++i) {
            int boneCount = input.readInt(true);
            bonesArray.add(boneCount);
            for (int ii = 0; ii < boneCount; ++ii) {
                bonesArray.add(input.readInt(true));
                weights.add(input.readFloat() * scale);
                weights.add(input.readFloat() * scale);
                weights.add(input.readFloat());
            }
        }
        vertices.vertices = weights.toArray();
        vertices.bones = bonesArray.toArray();
        return vertices;
    }

    private float[] readFloatArray(SkeletonInput input, int n2, float scale) throws IOException {
        float[] array = new float[n2];
        if (scale == 1.0f) {
            for (int i = 0; i < n2; ++i) {
                array[i] = input.readFloat();
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                array[i] = input.readFloat() * scale;
            }
        }
        return array;
    }

    private short[] readShortArray(SkeletonInput input, int n2) throws IOException {
        short[] array = new short[n2];
        for (int i = 0; i < n2; ++i) {
            array[i] = (short)input.readInt(true);
        }
        return array;
    }

    private Animation readAnimation(SkeletonInput input, String name, SkeletonData skeletonData) throws IOException {
        int eventCount;
        int frameLast;
        int frameCount;
        int index;
        int frameCount2;
        int ii;
        int nn;
        int i;
        Array<Animation.Timeline> timelines = new Array<Animation.Timeline>(input.readInt(true));
        float scale = this.scale;
        int n2 = input.readInt(true);
        for (i = 0; i < n2; ++i) {
            int slotIndex = input.readInt(true);
            nn = input.readInt(true);
            block71: for (ii = 0; ii < nn; ++ii) {
                byte timelineType = input.readByte();
                frameCount2 = input.readInt(true);
                int frameLast2 = frameCount2 - 1;
                switch (timelineType) {
                    case 0: {
                        Animation.Timeline timeline = new Animation.AttachmentTimeline(frameCount2, slotIndex);
                        for (int frame = 0; frame < frameCount2; ++frame) {
                            ((Animation.AttachmentTimeline)timeline).setFrame(frame, input.readFloat(), input.readStringRef());
                        }
                        timelines.add(timeline);
                        continue block71;
                    }
                    case 1: {
                        Animation.Timeline timeline = new Animation.RGBATimeline(frameCount2, input.readInt(true), slotIndex);
                        float time = input.readFloat();
                        float r = (float)input.read() / 255.0f;
                        float g = (float)input.read() / 255.0f;
                        float b = (float)input.read() / 255.0f;
                        float a = (float)input.read() / 255.0f;
                        int frame = 0;
                        int bezier = 0;
                        while (true) {
                            ((Animation.RGBATimeline)timeline).setFrame(frame, time, r, g, b, a);
                            if (frame == frameLast2) break;
                            float time2 = input.readFloat();
                            float r2 = (float)input.read() / 255.0f;
                            float g2 = (float)input.read() / 255.0f;
                            float b2 = (float)input.read() / 255.0f;
                            float a2 = (float)input.read() / 255.0f;
                            switch (input.readByte()) {
                                case 1: {
                                    ((Animation.CurveTimeline)timeline).setStepped(frame);
                                    break;
                                }
                                case 2: {
                                    this.setBezier(input, (Animation.CurveTimeline)timeline, bezier++, frame, 0, time, time2, r, r2, 1.0f);
                                    this.setBezier(input, (Animation.CurveTimeline)timeline, bezier++, frame, 1, time, time2, g, g2, 1.0f);
                                    this.setBezier(input, (Animation.CurveTimeline)timeline, bezier++, frame, 2, time, time2, b, b2, 1.0f);
                                    this.setBezier(input, (Animation.CurveTimeline)timeline, bezier++, frame, 3, time, time2, a, a2, 1.0f);
                                }
                            }
                            time = time2;
                            r = r2;
                            g = g2;
                            b = b2;
                            a = a2;
                            ++frame;
                        }
                        timelines.add(timeline);
                        continue block71;
                    }
                    case 2: {
                        Animation.Timeline timeline = new Animation.RGBTimeline(frameCount2, input.readInt(true), slotIndex);
                        float time = input.readFloat();
                        float r = (float)input.read() / 255.0f;
                        float g = (float)input.read() / 255.0f;
                        float b = (float)input.read() / 255.0f;
                        int frame = 0;
                        int bezier = 0;
                        while (true) {
                            ((Animation.RGBTimeline)timeline).setFrame(frame, time, r, g, b);
                            if (frame == frameLast2) break;
                            float time2 = input.readFloat();
                            float r2 = (float)input.read() / 255.0f;
                            float g2 = (float)input.read() / 255.0f;
                            float b2 = (float)input.read() / 255.0f;
                            switch (input.readByte()) {
                                case 1: {
                                    ((Animation.CurveTimeline)timeline).setStepped(frame);
                                    break;
                                }
                                case 2: {
                                    this.setBezier(input, (Animation.CurveTimeline)timeline, bezier++, frame, 0, time, time2, r, r2, 1.0f);
                                    this.setBezier(input, (Animation.CurveTimeline)timeline, bezier++, frame, 1, time, time2, g, g2, 1.0f);
                                    this.setBezier(input, (Animation.CurveTimeline)timeline, bezier++, frame, 2, time, time2, b, b2, 1.0f);
                                }
                            }
                            time = time2;
                            r = r2;
                            g = g2;
                            b = b2;
                            ++frame;
                        }
                        timelines.add(timeline);
                        continue block71;
                    }
                    case 3: {
                        Animation.Timeline timeline = new Animation.RGBA2Timeline(frameCount2, input.readInt(true), slotIndex);
                        float time = input.readFloat();
                        float r = (float)input.read() / 255.0f;
                        float g = (float)input.read() / 255.0f;
                        float b = (float)input.read() / 255.0f;
                        float a = (float)input.read() / 255.0f;
                        float r2 = (float)input.read() / 255.0f;
                        float g2 = (float)input.read() / 255.0f;
                        float b2 = (float)input.read() / 255.0f;
                        int frame = 0;
                        int bezier = 0;
                        while (true) {
                            ((Animation.RGBA2Timeline)timeline).setFrame(frame, time, r, g, b, a, r2, g2, b2);
                            if (frame == frameLast2) break;
                            float time2 = input.readFloat();
                            float nr = (float)input.read() / 255.0f;
                            float ng = (float)input.read() / 255.0f;
                            float nb = (float)input.read() / 255.0f;
                            float na = (float)input.read() / 255.0f;
                            float nr2 = (float)input.read() / 255.0f;
                            float ng2 = (float)input.read() / 255.0f;
                            float nb2 = (float)input.read() / 255.0f;
                            switch (input.readByte()) {
                                case 1: {
                                    ((Animation.CurveTimeline)timeline).setStepped(frame);
                                    break;
                                }
                                case 2: {
                                    this.setBezier(input, (Animation.CurveTimeline)timeline, bezier++, frame, 0, time, time2, r, nr, 1.0f);
                                    this.setBezier(input, (Animation.CurveTimeline)timeline, bezier++, frame, 1, time, time2, g, ng, 1.0f);
                                    this.setBezier(input, (Animation.CurveTimeline)timeline, bezier++, frame, 2, time, time2, b, nb, 1.0f);
                                    this.setBezier(input, (Animation.CurveTimeline)timeline, bezier++, frame, 3, time, time2, a, na, 1.0f);
                                    this.setBezier(input, (Animation.CurveTimeline)timeline, bezier++, frame, 4, time, time2, r2, nr2, 1.0f);
                                    this.setBezier(input, (Animation.CurveTimeline)timeline, bezier++, frame, 5, time, time2, g2, ng2, 1.0f);
                                    this.setBezier(input, (Animation.CurveTimeline)timeline, bezier++, frame, 6, time, time2, b2, nb2, 1.0f);
                                }
                            }
                            time = time2;
                            r = nr;
                            g = ng;
                            b = nb;
                            a = na;
                            r2 = nr2;
                            g2 = ng2;
                            b2 = nb2;
                            ++frame;
                        }
                        timelines.add(timeline);
                        continue block71;
                    }
                    case 4: {
                        Animation.Timeline timeline = new Animation.RGB2Timeline(frameCount2, input.readInt(true), slotIndex);
                        float time = input.readFloat();
                        float r = (float)input.read() / 255.0f;
                        float g = (float)input.read() / 255.0f;
                        float b = (float)input.read() / 255.0f;
                        float r2 = (float)input.read() / 255.0f;
                        float g2 = (float)input.read() / 255.0f;
                        float b2 = (float)input.read() / 255.0f;
                        int frame = 0;
                        int bezier = 0;
                        while (true) {
                            ((Animation.RGB2Timeline)timeline).setFrame(frame, time, r, g, b, r2, g2, b2);
                            if (frame == frameLast2) break;
                            float time2 = input.readFloat();
                            float nr = (float)input.read() / 255.0f;
                            float ng = (float)input.read() / 255.0f;
                            float nb = (float)input.read() / 255.0f;
                            float nr2 = (float)input.read() / 255.0f;
                            float ng2 = (float)input.read() / 255.0f;
                            float nb2 = (float)input.read() / 255.0f;
                            switch (input.readByte()) {
                                case 1: {
                                    ((Animation.CurveTimeline)timeline).setStepped(frame);
                                    break;
                                }
                                case 2: {
                                    this.setBezier(input, (Animation.CurveTimeline)timeline, bezier++, frame, 0, time, time2, r, nr, 1.0f);
                                    this.setBezier(input, (Animation.CurveTimeline)timeline, bezier++, frame, 1, time, time2, g, ng, 1.0f);
                                    this.setBezier(input, (Animation.CurveTimeline)timeline, bezier++, frame, 2, time, time2, b, nb, 1.0f);
                                    this.setBezier(input, (Animation.CurveTimeline)timeline, bezier++, frame, 3, time, time2, r2, nr2, 1.0f);
                                    this.setBezier(input, (Animation.CurveTimeline)timeline, bezier++, frame, 4, time, time2, g2, ng2, 1.0f);
                                    this.setBezier(input, (Animation.CurveTimeline)timeline, bezier++, frame, 5, time, time2, b2, nb2, 1.0f);
                                }
                            }
                            time = time2;
                            r = nr;
                            g = ng;
                            b = nb;
                            r2 = nr2;
                            g2 = ng2;
                            b2 = nb2;
                            ++frame;
                        }
                        timelines.add(timeline);
                        continue block71;
                    }
                    case 5: {
                        Animation.Timeline timeline = new Animation.AlphaTimeline(frameCount2, input.readInt(true), slotIndex);
                        float time = input.readFloat();
                        float a = (float)input.read() / 255.0f;
                        int frame = 0;
                        int bezier = 0;
                        while (true) {
                            ((Animation.CurveTimeline1)timeline).setFrame(frame, time, a);
                            if (frame == frameLast2) break;
                            float time2 = input.readFloat();
                            float a2 = (float)input.read() / 255.0f;
                            switch (input.readByte()) {
                                case 1: {
                                    ((Animation.CurveTimeline)timeline).setStepped(frame);
                                    break;
                                }
                                case 2: {
                                    this.setBezier(input, (Animation.CurveTimeline)timeline, bezier++, frame, 0, time, time2, a, a2, 1.0f);
                                }
                            }
                            time = time2;
                            a = a2;
                            ++frame;
                        }
                        timelines.add(timeline);
                    }
                }
            }
        }
        n2 = input.readInt(true);
        for (i = 0; i < n2; ++i) {
            int boneIndex = input.readInt(true);
            nn = input.readInt(true);
            block79: for (ii = 0; ii < nn; ++ii) {
                byte type = input.readByte();
                frameCount2 = input.readInt(true);
                if (type == 10) {
                    Animation.InheritTimeline timeline = new Animation.InheritTimeline(frameCount2, boneIndex);
                    for (int frame = 0; frame < frameCount2; ++frame) {
                        timeline.setFrame(frame, input.readFloat(), BoneData.Inherit.values[input.readByte()]);
                    }
                    timelines.add(timeline);
                    continue;
                }
                int bezierCount = input.readInt(true);
                switch (type) {
                    case 0: {
                        this.readTimeline(input, timelines, new Animation.RotateTimeline(frameCount2, bezierCount, boneIndex), 1.0f);
                        continue block79;
                    }
                    case 1: {
                        this.readTimeline(input, timelines, new Animation.TranslateTimeline(frameCount2, bezierCount, boneIndex), scale);
                        continue block79;
                    }
                    case 2: {
                        this.readTimeline(input, timelines, new Animation.TranslateXTimeline(frameCount2, bezierCount, boneIndex), scale);
                        continue block79;
                    }
                    case 3: {
                        this.readTimeline(input, timelines, new Animation.TranslateYTimeline(frameCount2, bezierCount, boneIndex), scale);
                        continue block79;
                    }
                    case 4: {
                        this.readTimeline(input, timelines, new Animation.ScaleTimeline(frameCount2, bezierCount, boneIndex), 1.0f);
                        continue block79;
                    }
                    case 5: {
                        this.readTimeline(input, timelines, new Animation.ScaleXTimeline(frameCount2, bezierCount, boneIndex), 1.0f);
                        continue block79;
                    }
                    case 6: {
                        this.readTimeline(input, timelines, new Animation.ScaleYTimeline(frameCount2, bezierCount, boneIndex), 1.0f);
                        continue block79;
                    }
                    case 7: {
                        this.readTimeline(input, timelines, new Animation.ShearTimeline(frameCount2, bezierCount, boneIndex), 1.0f);
                        continue block79;
                    }
                    case 8: {
                        this.readTimeline(input, timelines, new Animation.ShearXTimeline(frameCount2, bezierCount, boneIndex), 1.0f);
                        continue block79;
                    }
                    case 9: {
                        this.readTimeline(input, timelines, new Animation.ShearYTimeline(frameCount2, bezierCount, boneIndex), 1.0f);
                    }
                }
            }
        }
        n2 = input.readInt(true);
        for (i = 0; i < n2; ++i) {
            index = input.readInt(true);
            frameCount = input.readInt(true);
            frameLast = frameCount - 1;
            Animation.IkConstraintTimeline timeline = new Animation.IkConstraintTimeline(frameCount, input.readInt(true), index);
            int flags = input.read();
            float time = input.readFloat();
            float mix = (flags & 1) != 0 ? ((flags & 2) != 0 ? input.readFloat() : 1.0f) : 0.0f;
            float softness = (flags & 4) != 0 ? input.readFloat() * scale : 0.0f;
            int frame = 0;
            int bezier = 0;
            while (true) {
                float softness2;
                timeline.setFrame(frame, time, mix, softness, (flags & 8) != 0 ? 1 : -1, (flags & 0x10) != 0, (flags & 0x20) != 0);
                if (frame == frameLast) break;
                flags = input.read();
                float time2 = input.readFloat();
                float mix2 = (flags & 1) != 0 ? ((flags & 2) != 0 ? input.readFloat() : 1.0f) : 0.0f;
                float f2 = softness2 = (flags & 4) != 0 ? input.readFloat() * scale : 0.0f;
                if ((flags & 0x40) != 0) {
                    timeline.setStepped(frame);
                } else if ((flags & 0x80) != 0) {
                    this.setBezier(input, timeline, bezier++, frame, 0, time, time2, mix, mix2, 1.0f);
                    this.setBezier(input, timeline, bezier++, frame, 1, time, time2, softness, softness2, scale);
                }
                time = time2;
                mix = mix2;
                softness = softness2;
                ++frame;
            }
            timelines.add(timeline);
        }
        n2 = input.readInt(true);
        for (i = 0; i < n2; ++i) {
            index = input.readInt(true);
            frameCount = input.readInt(true);
            frameLast = frameCount - 1;
            Animation.TransformConstraintTimeline timeline = new Animation.TransformConstraintTimeline(frameCount, input.readInt(true), index);
            float time = input.readFloat();
            float mixRotate = input.readFloat();
            float mixX = input.readFloat();
            float mixY = input.readFloat();
            float mixScaleX = input.readFloat();
            float mixScaleY = input.readFloat();
            float mixShearY = input.readFloat();
            int frame = 0;
            int bezier = 0;
            while (true) {
                timeline.setFrame(frame, time, mixRotate, mixX, mixY, mixScaleX, mixScaleY, mixShearY);
                if (frame == frameLast) break;
                float time2 = input.readFloat();
                float mixRotate2 = input.readFloat();
                float mixX2 = input.readFloat();
                float mixY2 = input.readFloat();
                float mixScaleX2 = input.readFloat();
                float mixScaleY2 = input.readFloat();
                float mixShearY2 = input.readFloat();
                switch (input.readByte()) {
                    case 1: {
                        timeline.setStepped(frame);
                        break;
                    }
                    case 2: {
                        this.setBezier(input, timeline, bezier++, frame, 0, time, time2, mixRotate, mixRotate2, 1.0f);
                        this.setBezier(input, timeline, bezier++, frame, 1, time, time2, mixX, mixX2, 1.0f);
                        this.setBezier(input, timeline, bezier++, frame, 2, time, time2, mixY, mixY2, 1.0f);
                        this.setBezier(input, timeline, bezier++, frame, 3, time, time2, mixScaleX, mixScaleX2, 1.0f);
                        this.setBezier(input, timeline, bezier++, frame, 4, time, time2, mixScaleY, mixScaleY2, 1.0f);
                        this.setBezier(input, timeline, bezier++, frame, 5, time, time2, mixShearY, mixShearY2, 1.0f);
                    }
                }
                time = time2;
                mixRotate = mixRotate2;
                mixX = mixX2;
                mixY = mixY2;
                mixScaleX = mixScaleX2;
                mixScaleY = mixScaleY2;
                mixShearY = mixShearY2;
                ++frame;
            }
            timelines.add(timeline);
        }
        n2 = input.readInt(true);
        for (i = 0; i < n2; ++i) {
            index = input.readInt(true);
            PathConstraintData data = skeletonData.pathConstraints.get(index);
            int nn2 = input.readInt(true);
            block86: for (int ii2 = 0; ii2 < nn2; ++ii2) {
                byte type = input.readByte();
                int frameCount3 = input.readInt(true);
                int bezierCount = input.readInt(true);
                switch (type) {
                    case 0: {
                        this.readTimeline(input, timelines, new Animation.PathConstraintPositionTimeline(frameCount3, bezierCount, index), data.positionMode == PathConstraintData.PositionMode.fixed ? scale : 1.0f);
                        continue block86;
                    }
                    case 1: {
                        this.readTimeline(input, timelines, new Animation.PathConstraintSpacingTimeline(frameCount3, bezierCount, index), data.spacingMode == PathConstraintData.SpacingMode.length || data.spacingMode == PathConstraintData.SpacingMode.fixed ? scale : 1.0f);
                        continue block86;
                    }
                    case 2: {
                        Animation.PathConstraintMixTimeline timeline = new Animation.PathConstraintMixTimeline(frameCount3, bezierCount, index);
                        float time = input.readFloat();
                        float mixRotate = input.readFloat();
                        float mixX = input.readFloat();
                        float mixY = input.readFloat();
                        int frame = 0;
                        int bezier = 0;
                        int frameLast3 = timeline.getFrameCount() - 1;
                        while (true) {
                            timeline.setFrame(frame, time, mixRotate, mixX, mixY);
                            if (frame == frameLast3) break;
                            float time2 = input.readFloat();
                            float mixRotate2 = input.readFloat();
                            float mixX2 = input.readFloat();
                            float mixY2 = input.readFloat();
                            switch (input.readByte()) {
                                case 1: {
                                    timeline.setStepped(frame);
                                    break;
                                }
                                case 2: {
                                    this.setBezier(input, timeline, bezier++, frame, 0, time, time2, mixRotate, mixRotate2, 1.0f);
                                    this.setBezier(input, timeline, bezier++, frame, 1, time, time2, mixX, mixX2, 1.0f);
                                    this.setBezier(input, timeline, bezier++, frame, 2, time, time2, mixY, mixY2, 1.0f);
                                }
                            }
                            time = time2;
                            mixRotate = mixRotate2;
                            mixX = mixX2;
                            mixY = mixY2;
                            ++frame;
                        }
                        timelines.add(timeline);
                    }
                }
            }
        }
        n2 = input.readInt(true);
        for (i = 0; i < n2; ++i) {
            index = input.readInt(true) - 1;
            nn = input.readInt(true);
            block89: for (int ii3 = 0; ii3 < nn; ++ii3) {
                byte type = input.readByte();
                int frameCount4 = input.readInt(true);
                if (type == 8) {
                    Animation.PhysicsConstraintResetTimeline timeline = new Animation.PhysicsConstraintResetTimeline(frameCount4, index);
                    for (int frame = 0; frame < frameCount4; ++frame) {
                        timeline.setFrame(frame, input.readFloat());
                    }
                    timelines.add(timeline);
                    continue;
                }
                int bezierCount = input.readInt(true);
                switch (type) {
                    case 0: {
                        this.readTimeline(input, timelines, new Animation.PhysicsConstraintInertiaTimeline(frameCount4, bezierCount, index), 1.0f);
                        continue block89;
                    }
                    case 1: {
                        this.readTimeline(input, timelines, new Animation.PhysicsConstraintStrengthTimeline(frameCount4, bezierCount, index), 1.0f);
                        continue block89;
                    }
                    case 2: {
                        this.readTimeline(input, timelines, new Animation.PhysicsConstraintDampingTimeline(frameCount4, bezierCount, index), 1.0f);
                        continue block89;
                    }
                    case 4: {
                        this.readTimeline(input, timelines, new Animation.PhysicsConstraintMassTimeline(frameCount4, bezierCount, index), 1.0f);
                        continue block89;
                    }
                    case 5: {
                        this.readTimeline(input, timelines, new Animation.PhysicsConstraintWindTimeline(frameCount4, bezierCount, index), 1.0f);
                        continue block89;
                    }
                    case 6: {
                        this.readTimeline(input, timelines, new Animation.PhysicsConstraintGravityTimeline(frameCount4, bezierCount, index), 1.0f);
                        continue block89;
                    }
                    case 7: {
                        this.readTimeline(input, timelines, new Animation.PhysicsConstraintMixTimeline(frameCount4, bezierCount, index), 1.0f);
                    }
                }
            }
        }
        n2 = input.readInt(true);
        for (i = 0; i < n2; ++i) {
            Skin skin = skeletonData.skins.get(input.readInt(true));
            nn = input.readInt(true);
            for (int ii4 = 0; ii4 < nn; ++ii4) {
                int slotIndex = input.readInt(true);
                int nnn = input.readInt(true);
                block93: for (int iii = 0; iii < nnn; ++iii) {
                    String attachmentName = input.readStringRef();
                    Attachment attachment = skin.getAttachment(slotIndex, attachmentName);
                    if (attachment == null) {
                        throw new SerializationException("Timeline attachment not found: " + attachmentName);
                    }
                    byte timelineType = input.readByte();
                    int frameCount5 = input.readInt(true);
                    int frameLast4 = frameCount5 - 1;
                    switch (timelineType) {
                        case 0: {
                            VertexAttachment vertexAttachment = (VertexAttachment)attachment;
                            boolean weighted = vertexAttachment.getBones() != null;
                            float[] vertices = vertexAttachment.getVertices();
                            int deformLength = weighted ? vertices.length / 3 << 1 : vertices.length;
                            Animation.DeformTimeline timeline = new Animation.DeformTimeline(frameCount5, input.readInt(true), slotIndex, vertexAttachment);
                            float time = input.readFloat();
                            int frame = 0;
                            int bezier = 0;
                            while (true) {
                                float[] deform;
                                int end;
                                if ((end = input.readInt(true)) == 0) {
                                    deform = weighted ? new float[deformLength] : vertices;
                                } else {
                                    int v;
                                    deform = new float[deformLength];
                                    int start = input.readInt(true);
                                    end += start;
                                    if (scale == 1.0f) {
                                        for (v = start; v < end; ++v) {
                                            deform[v] = input.readFloat();
                                        }
                                    } else {
                                        for (v = start; v < end; ++v) {
                                            deform[v] = input.readFloat() * scale;
                                        }
                                    }
                                    if (!weighted) {
                                        int vn = deform.length;
                                        for (v = 0; v < vn; ++v) {
                                            int n3 = v;
                                            deform[n3] = deform[n3] + vertices[v];
                                        }
                                    }
                                }
                                timeline.setFrame(frame, time, deform);
                                if (frame == frameLast4) break;
                                float time2 = input.readFloat();
                                switch (input.readByte()) {
                                    case 1: {
                                        timeline.setStepped(frame);
                                        break;
                                    }
                                    case 2: {
                                        this.setBezier(input, timeline, bezier++, frame, 0, time, time2, 0.0f, 1.0f, 1.0f);
                                    }
                                }
                                time = time2;
                                ++frame;
                            }
                            timelines.add(timeline);
                            continue block93;
                        }
                        case 1: {
                            Animation.SequenceTimeline timeline = new Animation.SequenceTimeline(frameCount5, slotIndex, attachment);
                            for (int frame = 0; frame < frameCount5; ++frame) {
                                float time = input.readFloat();
                                int modeAndIndex = input.readInt();
                                timeline.setFrame(frame, time, Sequence.SequenceMode.values[modeAndIndex & 0xF], modeAndIndex >> 4, input.readFloat());
                            }
                            timelines.add(timeline);
                        }
                    }
                }
            }
        }
        int drawOrderCount = input.readInt(true);
        if (drawOrderCount > 0) {
            Animation.DrawOrderTimeline timeline = new Animation.DrawOrderTimeline(drawOrderCount);
            int slotCount = skeletonData.slots.size;
            for (int i2 = 0; i2 < drawOrderCount; ++i2) {
                int ii5;
                float time = input.readFloat();
                int offsetCount = input.readInt(true);
                int[] drawOrder = new int[slotCount];
                for (int ii6 = slotCount - 1; ii6 >= 0; --ii6) {
                    drawOrder[ii6] = -1;
                }
                int[] unchanged = new int[slotCount - offsetCount];
                int originalIndex = 0;
                int unchangedIndex = 0;
                for (ii5 = 0; ii5 < offsetCount; ++ii5) {
                    int slotIndex = input.readInt(true);
                    while (originalIndex != slotIndex) {
                        unchanged[unchangedIndex++] = originalIndex++;
                    }
                    drawOrder[originalIndex + input.readInt((boolean)true)] = originalIndex++;
                }
                while (originalIndex < slotCount) {
                    unchanged[unchangedIndex++] = originalIndex++;
                }
                for (ii5 = slotCount - 1; ii5 >= 0; --ii5) {
                    if (drawOrder[ii5] != -1) continue;
                    drawOrder[ii5] = unchanged[--unchangedIndex];
                }
                timeline.setFrame(i2, time, drawOrder);
            }
            timelines.add(timeline);
        }
        if ((eventCount = input.readInt(true)) > 0) {
            Animation.EventTimeline timeline = new Animation.EventTimeline(eventCount);
            for (int i3 = 0; i3 < eventCount; ++i3) {
                float time = input.readFloat();
                EventData eventData = skeletonData.events.get(input.readInt(true));
                Event event = new Event(time, eventData);
                event.intValue = input.readInt(false);
                event.floatValue = input.readFloat();
                event.stringValue = input.readString();
                if (event.stringValue == null) {
                    event.stringValue = eventData.stringValue;
                }
                if (event.getData().audioPath != null) {
                    event.volume = input.readFloat();
                    event.balance = input.readFloat();
                }
                timeline.setFrame(i3, event);
            }
            timelines.add(timeline);
        }
        float duration = 0.0f;
        T[] items = timelines.items;
        int n4 = timelines.size;
        for (int i4 = 0; i4 < n4; ++i4) {
            duration = Math.max(duration, ((Animation.Timeline)items[i4]).getDuration());
        }
        return new Animation(name, timelines, duration);
    }

    private void readTimeline(SkeletonInput input, Array<Animation.Timeline> timelines, Animation.CurveTimeline1 timeline, float scale) throws IOException {
        float time = input.readFloat();
        float value = input.readFloat() * scale;
        int frame = 0;
        int bezier = 0;
        int frameLast = timeline.getFrameCount() - 1;
        while (true) {
            timeline.setFrame(frame, time, value);
            if (frame == frameLast) break;
            float time2 = input.readFloat();
            float value2 = input.readFloat() * scale;
            switch (input.readByte()) {
                case 1: {
                    timeline.setStepped(frame);
                    break;
                }
                case 2: {
                    this.setBezier(input, timeline, bezier++, frame, 0, time, time2, value, value2, scale);
                }
            }
            time = time2;
            value = value2;
            ++frame;
        }
        timelines.add(timeline);
    }

    private void readTimeline(SkeletonInput input, Array<Animation.Timeline> timelines, Animation.CurveTimeline2 timeline, float scale) throws IOException {
        float time = input.readFloat();
        float value1 = input.readFloat() * scale;
        float value2 = input.readFloat() * scale;
        int frame = 0;
        int bezier = 0;
        int frameLast = timeline.getFrameCount() - 1;
        while (true) {
            timeline.setFrame(frame, time, value1, value2);
            if (frame == frameLast) break;
            float time2 = input.readFloat();
            float nvalue1 = input.readFloat() * scale;
            float nvalue2 = input.readFloat() * scale;
            switch (input.readByte()) {
                case 1: {
                    timeline.setStepped(frame);
                    break;
                }
                case 2: {
                    this.setBezier(input, timeline, bezier++, frame, 0, time, time2, value1, nvalue1, scale);
                    this.setBezier(input, timeline, bezier++, frame, 1, time, time2, value2, nvalue2, scale);
                }
            }
            time = time2;
            value1 = nvalue1;
            value2 = nvalue2;
            ++frame;
        }
        timelines.add(timeline);
    }

    void setBezier(SkeletonInput input, Animation.CurveTimeline timeline, int bezier, int frame, int value, float time1, float time2, float value1, float value2, float scale) throws IOException {
        timeline.setBezier(bezier, frame, value, time1, value1, input.readFloat(), input.readFloat() * scale, input.readFloat(), input.readFloat() * scale, time2, value2);
    }

    static class SkeletonInput
    extends DataInput {
        private char[] chars = new char[32];
        String[] strings;

        public SkeletonInput(InputStream input) {
            super(input);
        }

        public SkeletonInput(FileHandle file) {
            super(file.read(512));
        }

        @Null
        public String readStringRef() throws IOException {
            int index = this.readInt(true);
            return index == 0 ? null : this.strings[index - 1];
        }

        @Override
        public String readString() throws IOException {
            int byteCount = this.readInt(true);
            switch (byteCount) {
                case 0: {
                    return null;
                }
                case 1: {
                    return "";
                }
            }
            if (this.chars.length < --byteCount) {
                this.chars = new char[byteCount];
            }
            char[] chars = this.chars;
            int charCount = 0;
            int i = 0;
            block9: while (i < byteCount) {
                int b = this.read();
                switch (b >> 4) {
                    case -1: {
                        throw new EOFException();
                    }
                    case 12: 
                    case 13: {
                        chars[charCount++] = (char)((b & 0x1F) << 6 | this.read() & 0x3F);
                        i += 2;
                        continue block9;
                    }
                    case 14: {
                        chars[charCount++] = (char)((b & 0xF) << 12 | (this.read() & 0x3F) << 6 | this.read() & 0x3F);
                        i += 3;
                        continue block9;
                    }
                }
                chars[charCount++] = (char)b;
                ++i;
            }
            return new String(chars, 0, charCount);
        }
    }

    static class LinkedMesh {
        String parent;
        int skinIndex;
        int slotIndex;
        MeshAttachment mesh;
        boolean inheritTimelines;

        public LinkedMesh(MeshAttachment mesh, int skinIndex, int slotIndex, String parent, boolean inheritTimelines) {
            this.mesh = mesh;
            this.skinIndex = skinIndex;
            this.slotIndex = slotIndex;
            this.parent = parent;
            this.inheritTimelines = inheritTimelines;
        }
    }

    static class Vertices {
        int length;
        int[] bones;
        float[] vertices;

        Vertices() {
        }
    }
}

