/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.SerializationException;
import com.esotericsoftware.spine.Animation;
import com.esotericsoftware.spine.BlendMode;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.ConstraintData;
import com.esotericsoftware.spine.Event;
import com.esotericsoftware.spine.EventData;
import com.esotericsoftware.spine.IkConstraintData;
import com.esotericsoftware.spine.PathConstraintData;
import com.esotericsoftware.spine.PhysicsConstraintData;
import com.esotericsoftware.spine.SkeletonData;
import com.esotericsoftware.spine.SkeletonLoader;
import com.esotericsoftware.spine.Skin;
import com.esotericsoftware.spine.SlotData;
import com.esotericsoftware.spine.TransformConstraintData;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.AttachmentLoader;
import com.esotericsoftware.spine.attachments.AttachmentType;
import com.esotericsoftware.spine.attachments.BoundingBoxAttachment;
import com.esotericsoftware.spine.attachments.ClippingAttachment;
import com.esotericsoftware.spine.attachments.MeshAttachment;
import com.esotericsoftware.spine.attachments.PathAttachment;
import com.esotericsoftware.spine.attachments.PointAttachment;
import com.esotericsoftware.spine.attachments.RegionAttachment;
import com.esotericsoftware.spine.attachments.Sequence;
import com.esotericsoftware.spine.attachments.VertexAttachment;
import com.esotericsoftware.spine.utils.SpineUtils;
import java.io.InputStream;

public class SkeletonJson
extends SkeletonLoader {
    private final Array<LinkedMesh> linkedMeshes = new Array();

    public SkeletonJson(AttachmentLoader attachmentLoader) {
        super(attachmentLoader);
    }

    public SkeletonJson(TextureAtlas atlas) {
        super(atlas);
    }

    @Override
    public SkeletonData readSkeletonData(FileHandle file) {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be null.");
        }
        SkeletonData skeletonData = this.readSkeletonData(new JsonReader().parse(file));
        skeletonData.name = file.nameWithoutExtension();
        return skeletonData;
    }

    @Override
    public SkeletonData readSkeletonData(InputStream input) {
        if (input == null) {
            throw new IllegalArgumentException("dataInput cannot be null.");
        }
        return this.readSkeletonData(new JsonReader().parse(input));
    }

    public SkeletonData readSkeletonData(JsonValue root) {
        String targetName;
        BoneData bone;
        JsonValue entry;
        ConstraintData data;
        String boneName;
        if (root == null) {
            throw new IllegalArgumentException("root cannot be null.");
        }
        float scale = this.scale;
        SkeletonData skeletonData = new SkeletonData();
        JsonValue skeletonMap = root.get("skeleton");
        if (skeletonMap != null) {
            skeletonData.hash = skeletonMap.getString("hash", null);
            skeletonData.version = skeletonMap.getString("spine", null);
            skeletonData.x = skeletonMap.getFloat("x", 0.0f);
            skeletonData.y = skeletonMap.getFloat("y", 0.0f);
            skeletonData.width = skeletonMap.getFloat("width", 0.0f);
            skeletonData.height = skeletonMap.getFloat("height", 0.0f);
            skeletonData.referenceScale = skeletonMap.getFloat("referenceScale", 100.0f) * scale;
            skeletonData.fps = skeletonMap.getFloat("fps", 30.0f);
            skeletonData.imagesPath = skeletonMap.getString("images", null);
            skeletonData.audioPath = skeletonMap.getString("audio", null);
        }
        JsonValue boneMap = root.getChild("bones");
        while (boneMap != null) {
            BoneData parent = null;
            String parentName = boneMap.getString("parent", null);
            if (parentName != null && (parent = skeletonData.findBone(parentName)) == null) {
                throw new SerializationException("Parent bone not found: " + parentName);
            }
            BoneData data2 = new BoneData(skeletonData.bones.size, boneMap.getString("name"), parent);
            data2.length = boneMap.getFloat("length", 0.0f) * scale;
            data2.x = boneMap.getFloat("x", 0.0f) * scale;
            data2.y = boneMap.getFloat("y", 0.0f) * scale;
            data2.rotation = boneMap.getFloat("rotation", 0.0f);
            data2.scaleX = boneMap.getFloat("scaleX", 1.0f);
            data2.scaleY = boneMap.getFloat("scaleY", 1.0f);
            data2.shearX = boneMap.getFloat("shearX", 0.0f);
            data2.shearY = boneMap.getFloat("shearY", 0.0f);
            data2.inherit = BoneData.Inherit.valueOf(boneMap.getString("inherit", BoneData.Inherit.normal.name()));
            data2.skinRequired = boneMap.getBoolean("skin", false);
            String color = boneMap.getString("color", null);
            if (color != null) {
                Color.valueOf(color, data2.getColor());
            }
            data2.icon = boneMap.getString("icon", null);
            data2.visible = boneMap.getBoolean("visible", true);
            skeletonData.bones.add(data2);
            boneMap = boneMap.next;
        }
        JsonValue slotMap = root.getChild("slots");
        while (slotMap != null) {
            String dark;
            String slotName = slotMap.getString("name");
            boneName = slotMap.getString("bone");
            BoneData boneData = skeletonData.findBone(boneName);
            if (boneData == null) {
                throw new SerializationException("Slot bone not found: " + boneName);
            }
            SlotData data3 = new SlotData(skeletonData.slots.size, slotName, boneData);
            String color = slotMap.getString("color", null);
            if (color != null) {
                Color.valueOf(color, data3.getColor());
            }
            if ((dark = slotMap.getString("dark", null)) != null) {
                data3.setDarkColor(Color.valueOf(dark));
            }
            data3.attachmentName = slotMap.getString("attachment", null);
            data3.blendMode = BlendMode.valueOf(slotMap.getString("blend", BlendMode.normal.name()));
            data3.visible = slotMap.getBoolean("visible", true);
            skeletonData.slots.add(data3);
            slotMap = slotMap.next;
        }
        JsonValue constraintMap = root.getChild("ik");
        while (constraintMap != null) {
            data = new IkConstraintData(constraintMap.getString("name"));
            data.order = constraintMap.getInt("order", 0);
            data.skinRequired = constraintMap.getBoolean("skin", false);
            entry = constraintMap.getChild("bones");
            while (entry != null) {
                bone = skeletonData.findBone(entry.asString());
                if (bone == null) {
                    throw new SerializationException("IK bone not found: " + entry);
                }
                data.bones.add(bone);
                entry = entry.next;
            }
            targetName = constraintMap.getString("target");
            data.target = skeletonData.findBone(targetName);
            if (data.target == null) {
                throw new SerializationException("IK target bone not found: " + targetName);
            }
            data.mix = constraintMap.getFloat("mix", 1.0f);
            data.softness = constraintMap.getFloat("softness", 0.0f) * scale;
            data.bendDirection = constraintMap.getBoolean("bendPositive", true) ? 1 : -1;
            data.compress = constraintMap.getBoolean("compress", false);
            data.stretch = constraintMap.getBoolean("stretch", false);
            data.uniform = constraintMap.getBoolean("uniform", false);
            skeletonData.ikConstraints.add((IkConstraintData)data);
            constraintMap = constraintMap.next;
        }
        constraintMap = root.getChild("transform");
        while (constraintMap != null) {
            data = new TransformConstraintData(constraintMap.getString("name"));
            ((TransformConstraintData)data).order = constraintMap.getInt("order", 0);
            ((TransformConstraintData)data).skinRequired = constraintMap.getBoolean("skin", false);
            entry = constraintMap.getChild("bones");
            while (entry != null) {
                bone = skeletonData.findBone(entry.asString());
                if (bone == null) {
                    throw new SerializationException("Transform constraint bone not found: " + entry);
                }
                ((TransformConstraintData)data).bones.add(bone);
                entry = entry.next;
            }
            targetName = constraintMap.getString("target");
            ((TransformConstraintData)data).target = skeletonData.findBone(targetName);
            if (((TransformConstraintData)data).target == null) {
                throw new SerializationException("Transform constraint target bone not found: " + targetName);
            }
            ((TransformConstraintData)data).local = constraintMap.getBoolean("local", false);
            ((TransformConstraintData)data).relative = constraintMap.getBoolean("relative", false);
            ((TransformConstraintData)data).offsetRotation = constraintMap.getFloat("rotation", 0.0f);
            ((TransformConstraintData)data).offsetX = constraintMap.getFloat("x", 0.0f) * scale;
            ((TransformConstraintData)data).offsetY = constraintMap.getFloat("y", 0.0f) * scale;
            ((TransformConstraintData)data).offsetScaleX = constraintMap.getFloat("scaleX", 0.0f);
            ((TransformConstraintData)data).offsetScaleY = constraintMap.getFloat("scaleY", 0.0f);
            ((TransformConstraintData)data).offsetShearY = constraintMap.getFloat("shearY", 0.0f);
            ((TransformConstraintData)data).mixRotate = constraintMap.getFloat("mixRotate", 1.0f);
            ((TransformConstraintData)data).mixX = constraintMap.getFloat("mixX", 1.0f);
            ((TransformConstraintData)data).mixY = constraintMap.getFloat("mixY", ((TransformConstraintData)data).mixX);
            ((TransformConstraintData)data).mixScaleX = constraintMap.getFloat("mixScaleX", 1.0f);
            ((TransformConstraintData)data).mixScaleY = constraintMap.getFloat("mixScaleY", ((TransformConstraintData)data).mixScaleX);
            ((TransformConstraintData)data).mixShearY = constraintMap.getFloat("mixShearY", 1.0f);
            skeletonData.transformConstraints.add((TransformConstraintData)data);
            constraintMap = constraintMap.next;
        }
        constraintMap = root.getChild("path");
        while (constraintMap != null) {
            data = new PathConstraintData(constraintMap.getString("name"));
            ((PathConstraintData)data).order = constraintMap.getInt("order", 0);
            ((PathConstraintData)data).skinRequired = constraintMap.getBoolean("skin", false);
            entry = constraintMap.getChild("bones");
            while (entry != null) {
                bone = skeletonData.findBone(entry.asString());
                if (bone == null) {
                    throw new SerializationException("Path bone not found: " + entry);
                }
                ((PathConstraintData)data).bones.add(bone);
                entry = entry.next;
            }
            targetName = constraintMap.getString("target");
            ((PathConstraintData)data).target = skeletonData.findSlot(targetName);
            if (((PathConstraintData)data).target == null) {
                throw new SerializationException("Path target slot not found: " + targetName);
            }
            ((PathConstraintData)data).positionMode = PathConstraintData.PositionMode.valueOf(constraintMap.getString("positionMode", "percent"));
            ((PathConstraintData)data).spacingMode = PathConstraintData.SpacingMode.valueOf(constraintMap.getString("spacingMode", "length"));
            ((PathConstraintData)data).rotateMode = PathConstraintData.RotateMode.valueOf(constraintMap.getString("rotateMode", "tangent"));
            ((PathConstraintData)data).offsetRotation = constraintMap.getFloat("rotation", 0.0f);
            ((PathConstraintData)data).position = constraintMap.getFloat("position", 0.0f);
            if (((PathConstraintData)data).positionMode == PathConstraintData.PositionMode.fixed) {
                ((PathConstraintData)data).position *= scale;
            }
            ((PathConstraintData)data).spacing = constraintMap.getFloat("spacing", 0.0f);
            if (((PathConstraintData)data).spacingMode == PathConstraintData.SpacingMode.length || ((PathConstraintData)data).spacingMode == PathConstraintData.SpacingMode.fixed) {
                ((PathConstraintData)data).spacing *= scale;
            }
            ((PathConstraintData)data).mixRotate = constraintMap.getFloat("mixRotate", 1.0f);
            ((PathConstraintData)data).mixX = constraintMap.getFloat("mixX", 1.0f);
            ((PathConstraintData)data).mixY = constraintMap.getFloat("mixY", 1.0f);
            skeletonData.pathConstraints.add((PathConstraintData)data);
            constraintMap = constraintMap.next;
        }
        constraintMap = root.getChild("physics");
        while (constraintMap != null) {
            data = new PhysicsConstraintData(constraintMap.getString("name"));
            ((PhysicsConstraintData)data).order = constraintMap.getInt("order", 0);
            ((PhysicsConstraintData)data).skinRequired = constraintMap.getBoolean("skin", false);
            boneName = constraintMap.getString("bone");
            ((PhysicsConstraintData)data).bone = skeletonData.findBone(boneName);
            if (((PhysicsConstraintData)data).bone == null) {
                throw new SerializationException("Physics bone not found: " + boneName);
            }
            ((PhysicsConstraintData)data).x = constraintMap.getFloat("x", 0.0f);
            ((PhysicsConstraintData)data).y = constraintMap.getFloat("y", 0.0f);
            ((PhysicsConstraintData)data).rotate = constraintMap.getFloat("rotate", 0.0f);
            ((PhysicsConstraintData)data).scaleX = constraintMap.getFloat("scaleX", 0.0f);
            ((PhysicsConstraintData)data).shearX = constraintMap.getFloat("shearX", 0.0f);
            ((PhysicsConstraintData)data).limit = constraintMap.getFloat("limit", 5000.0f) * scale;
            ((PhysicsConstraintData)data).step = 1.0f / (float)constraintMap.getInt("fps", 60);
            ((PhysicsConstraintData)data).inertia = constraintMap.getFloat("inertia", 1.0f);
            ((PhysicsConstraintData)data).strength = constraintMap.getFloat("strength", 100.0f);
            ((PhysicsConstraintData)data).damping = constraintMap.getFloat("damping", 1.0f);
            ((PhysicsConstraintData)data).massInverse = 1.0f / constraintMap.getFloat("mass", 1.0f);
            ((PhysicsConstraintData)data).wind = constraintMap.getFloat("wind", 0.0f);
            ((PhysicsConstraintData)data).gravity = constraintMap.getFloat("gravity", 0.0f);
            ((PhysicsConstraintData)data).mix = constraintMap.getFloat("mix", 1.0f);
            ((PhysicsConstraintData)data).inertiaGlobal = constraintMap.getBoolean("inertiaGlobal", false);
            ((PhysicsConstraintData)data).strengthGlobal = constraintMap.getBoolean("strengthGlobal", false);
            ((PhysicsConstraintData)data).dampingGlobal = constraintMap.getBoolean("dampingGlobal", false);
            ((PhysicsConstraintData)data).massGlobal = constraintMap.getBoolean("massGlobal", false);
            ((PhysicsConstraintData)data).windGlobal = constraintMap.getBoolean("windGlobal", false);
            ((PhysicsConstraintData)data).gravityGlobal = constraintMap.getBoolean("gravityGlobal", false);
            ((PhysicsConstraintData)data).mixGlobal = constraintMap.getBoolean("mixGlobal", false);
            skeletonData.physicsConstraints.add((PhysicsConstraintData)data);
            constraintMap = constraintMap.next;
        }
        JsonValue skinMap = root.getChild("skins");
        while (skinMap != null) {
            ConstraintData constraint;
            Skin skin = new Skin(skinMap.getString("name"));
            entry = skinMap.getChild("bones");
            while (entry != null) {
                bone = skeletonData.findBone(entry.asString());
                if (bone == null) {
                    throw new SerializationException("Skin bone not found: " + entry);
                }
                skin.bones.add(bone);
                entry = entry.next;
            }
            skin.bones.shrink();
            entry = skinMap.getChild("ik");
            while (entry != null) {
                constraint = skeletonData.findIkConstraint(entry.asString());
                if (constraint == null) {
                    throw new SerializationException("Skin IK constraint not found: " + entry);
                }
                skin.constraints.add(constraint);
                entry = entry.next;
            }
            entry = skinMap.getChild("transform");
            while (entry != null) {
                constraint = skeletonData.findTransformConstraint(entry.asString());
                if (constraint == null) {
                    throw new SerializationException("Skin transform constraint not found: " + entry);
                }
                skin.constraints.add(constraint);
                entry = entry.next;
            }
            entry = skinMap.getChild("path");
            while (entry != null) {
                constraint = skeletonData.findPathConstraint(entry.asString());
                if (constraint == null) {
                    throw new SerializationException("Skin path constraint not found: " + entry);
                }
                skin.constraints.add(constraint);
                entry = entry.next;
            }
            entry = skinMap.getChild("physics");
            while (entry != null) {
                constraint = skeletonData.findPhysicsConstraint(entry.asString());
                if (constraint == null) {
                    throw new SerializationException("Skin physics constraint not found: " + entry);
                }
                skin.constraints.add(constraint);
                entry = entry.next;
            }
            skin.constraints.shrink();
            JsonValue slotEntry = skinMap.getChild("attachments");
            while (slotEntry != null) {
                SlotData slot = skeletonData.findSlot(slotEntry.name);
                if (slot == null) {
                    throw new SerializationException("Slot not found: " + slotEntry.name);
                }
                JsonValue entry2 = slotEntry.child;
                while (entry2 != null) {
                    try {
                        Attachment attachment = this.readAttachment(entry2, skin, slot.index, entry2.name, skeletonData);
                        if (attachment != null) {
                            skin.setAttachment(slot.index, entry2.name, attachment);
                        }
                    }
                    catch (Throwable ex) {
                        throw new SerializationException("Error reading attachment: " + entry2.name + ", skin: " + skin, ex);
                    }
                    entry2 = entry2.next;
                }
                slotEntry = slotEntry.next;
            }
            String color = skinMap.getString("color", null);
            if (color != null) {
                Color.valueOf(color, skin.getColor());
            }
            skeletonData.skins.add(skin);
            if (skin.name.equals("default")) {
                skeletonData.defaultSkin = skin;
            }
            skinMap = skinMap.next;
        }
        T[] items = this.linkedMeshes.items;
        int n2 = this.linkedMeshes.size;
        for (int i = 0; i < n2; ++i) {
            Skin skin;
            LinkedMesh linkedMesh = (LinkedMesh)items[i];
            Skin skin2 = skin = linkedMesh.skin == null ? skeletonData.getDefaultSkin() : skeletonData.findSkin(linkedMesh.skin);
            if (skin == null) {
                throw new SerializationException("Skin not found: " + linkedMesh.skin);
            }
            Attachment parent = skin.getAttachment(linkedMesh.slotIndex, linkedMesh.parent);
            if (parent == null) {
                throw new SerializationException("Parent mesh not found: " + linkedMesh.parent);
            }
            linkedMesh.mesh.setTimelineAttachment(linkedMesh.inheritTimelines ? (VertexAttachment)parent : linkedMesh.mesh);
            linkedMesh.mesh.setParentMesh((MeshAttachment)parent);
            if (linkedMesh.mesh.getRegion() == null) continue;
            linkedMesh.mesh.updateRegion();
        }
        this.linkedMeshes.clear();
        JsonValue eventMap = root.getChild("events");
        while (eventMap != null) {
            EventData data4 = new EventData(eventMap.name);
            data4.intValue = eventMap.getInt("int", 0);
            data4.floatValue = eventMap.getFloat("float", 0.0f);
            data4.stringValue = eventMap.getString("string", "");
            data4.audioPath = eventMap.getString("audio", null);
            if (data4.audioPath != null) {
                data4.volume = eventMap.getFloat("volume", 1.0f);
                data4.balance = eventMap.getFloat("balance", 0.0f);
            }
            skeletonData.events.add(data4);
            eventMap = eventMap.next;
        }
        JsonValue animationMap = root.getChild("animations");
        while (animationMap != null) {
            try {
                this.readAnimation(animationMap, animationMap.name, skeletonData);
            }
            catch (Throwable ex) {
                throw new SerializationException("Error reading animation: " + animationMap.name, ex);
            }
            animationMap = animationMap.next;
        }
        skeletonData.bones.shrink();
        skeletonData.slots.shrink();
        skeletonData.skins.shrink();
        skeletonData.events.shrink();
        skeletonData.animations.shrink();
        skeletonData.ikConstraints.shrink();
        return skeletonData;
    }

    private Attachment readAttachment(JsonValue map, Skin skin, int slotIndex, String name, SkeletonData skeletonData) {
        float scale = this.scale;
        name = map.getString("name", name);
        switch (AttachmentType.valueOf(map.getString("type", AttachmentType.region.name()))) {
            case region: {
                String path = map.getString("path", name);
                Sequence sequence = this.readSequence(map.get("sequence"));
                RegionAttachment region = this.attachmentLoader.newRegionAttachment(skin, name, path, sequence);
                if (region == null) {
                    return null;
                }
                region.setPath(path);
                region.setX(map.getFloat("x", 0.0f) * scale);
                region.setY(map.getFloat("y", 0.0f) * scale);
                region.setScaleX(map.getFloat("scaleX", 1.0f));
                region.setScaleY(map.getFloat("scaleY", 1.0f));
                region.setRotation(map.getFloat("rotation", 0.0f));
                region.setWidth(map.getFloat("width") * scale);
                region.setHeight(map.getFloat("height") * scale);
                region.setSequence(sequence);
                String color = map.getString("color", null);
                if (color != null) {
                    Color.valueOf(color, region.getColor());
                }
                if (region.getRegion() != null) {
                    region.updateRegion();
                }
                return region;
            }
            case boundingbox: {
                BoundingBoxAttachment box = this.attachmentLoader.newBoundingBoxAttachment(skin, name);
                if (box == null) {
                    return null;
                }
                this.readVertices(map, box, map.getInt("vertexCount") << 1);
                String color = map.getString("color", null);
                if (color != null) {
                    Color.valueOf(color, box.getColor());
                }
                return box;
            }
            case mesh: 
            case linkedmesh: {
                String path = map.getString("path", name);
                Sequence sequence = this.readSequence(map.get("sequence"));
                MeshAttachment mesh = this.attachmentLoader.newMeshAttachment(skin, name, path, sequence);
                if (mesh == null) {
                    return null;
                }
                mesh.setPath(path);
                String color = map.getString("color", null);
                if (color != null) {
                    Color.valueOf(color, mesh.getColor());
                }
                mesh.setWidth(map.getFloat("width", 0.0f) * scale);
                mesh.setHeight(map.getFloat("height", 0.0f) * scale);
                mesh.setSequence(sequence);
                String parent = map.getString("parent", null);
                if (parent != null) {
                    this.linkedMeshes.add(new LinkedMesh(mesh, map.getString("skin", null), slotIndex, parent, map.getBoolean("timelines", true)));
                    return mesh;
                }
                float[] uvs = map.require("uvs").asFloatArray();
                this.readVertices(map, mesh, uvs.length);
                mesh.setTriangles(map.require("triangles").asShortArray());
                mesh.setRegionUVs(uvs);
                if (mesh.getRegion() != null) {
                    mesh.updateRegion();
                }
                if (map.has("hull")) {
                    mesh.setHullLength(map.require("hull").asInt() << 1);
                }
                if (map.has("edges")) {
                    mesh.setEdges(map.require("edges").asShortArray());
                }
                return mesh;
            }
            case path: {
                PathAttachment path = this.attachmentLoader.newPathAttachment(skin, name);
                if (path == null) {
                    return null;
                }
                path.setClosed(map.getBoolean("closed", false));
                path.setConstantSpeed(map.getBoolean("constantSpeed", true));
                int vertexCount = map.getInt("vertexCount");
                this.readVertices(map, path, vertexCount << 1);
                float[] lengths = new float[vertexCount / 3];
                int i = 0;
                JsonValue curves = map.require((String)"lengths").child;
                while (curves != null) {
                    lengths[i++] = curves.asFloat() * scale;
                    curves = curves.next;
                }
                path.setLengths(lengths);
                String color = map.getString("color", null);
                if (color != null) {
                    Color.valueOf(color, path.getColor());
                }
                return path;
            }
            case point: {
                PointAttachment point = this.attachmentLoader.newPointAttachment(skin, name);
                if (point == null) {
                    return null;
                }
                point.setX(map.getFloat("x", 0.0f) * scale);
                point.setY(map.getFloat("y", 0.0f) * scale);
                point.setRotation(map.getFloat("rotation", 0.0f));
                String color = map.getString("color", null);
                if (color != null) {
                    Color.valueOf(color, point.getColor());
                }
                return point;
            }
            case clipping: {
                ClippingAttachment clip = this.attachmentLoader.newClippingAttachment(skin, name);
                if (clip == null) {
                    return null;
                }
                String end = map.getString("end", null);
                if (end != null) {
                    SlotData slot = skeletonData.findSlot(end);
                    if (slot == null) {
                        throw new SerializationException("Clipping end slot not found: " + end);
                    }
                    clip.setEndSlot(slot);
                }
                this.readVertices(map, clip, map.getInt("vertexCount") << 1);
                String color = map.getString("color", null);
                if (color != null) {
                    Color.valueOf(color, clip.getColor());
                }
                return clip;
            }
        }
        return null;
    }

    private Sequence readSequence(@Null JsonValue map) {
        if (map == null) {
            return null;
        }
        Sequence sequence = new Sequence(map.getInt("count"));
        sequence.setStart(map.getInt("start", 1));
        sequence.setDigits(map.getInt("digits", 0));
        sequence.setSetupIndex(map.getInt("setup", 0));
        return sequence;
    }

    private void readVertices(JsonValue map, VertexAttachment attachment, int verticesLength) {
        attachment.setWorldVerticesLength(verticesLength);
        float[] vertices = map.require("vertices").asFloatArray();
        if (verticesLength == vertices.length) {
            if (this.scale != 1.0f) {
                int i = 0;
                int n2 = vertices.length;
                while (i < n2) {
                    int n3 = i++;
                    vertices[n3] = vertices[n3] * this.scale;
                }
            }
            attachment.setVertices(vertices);
            return;
        }
        FloatArray weights = new FloatArray(verticesLength * 3 * 3);
        IntArray bones = new IntArray(verticesLength * 3);
        int i = 0;
        int n4 = vertices.length;
        while (i < n4) {
            int boneCount = (int)vertices[i++];
            bones.add(boneCount);
            int nn = i + (boneCount << 2);
            while (i < nn) {
                bones.add((int)vertices[i]);
                weights.add(vertices[i + 1] * this.scale);
                weights.add(vertices[i + 2] * this.scale);
                weights.add(vertices[i + 3]);
                i += 4;
            }
        }
        attachment.setBones(bones.toArray());
        attachment.setVertices(weights.toArray());
    }

    private void readAnimation(JsonValue map, String name, SkeletonData skeletonData) {
        JsonValue eventsMap;
        Animation.CurveTimeline timeline;
        ConstraintData constraint;
        JsonValue keyMap;
        JsonValue curve;
        int frame;
        Animation.Timeline timeline2;
        String timelineName;
        int frames;
        JsonValue keyMap2;
        JsonValue timelineMap;
        float scale = this.scale;
        Array<Animation.Timeline> timelines = new Array<Animation.Timeline>();
        JsonValue slotMap = map.getChild("slots");
        while (slotMap != null) {
            SlotData slot = skeletonData.findSlot(slotMap.name);
            if (slot == null) {
                throw new SerializationException("Slot not found: " + slotMap.name);
            }
            timelineMap = slotMap.child;
            while (timelineMap != null) {
                keyMap2 = timelineMap.child;
                if (keyMap2 != null) {
                    float a;
                    float b;
                    float g;
                    float r;
                    String color;
                    frames = timelineMap.size;
                    timelineName = timelineMap.name;
                    if (timelineName.equals("attachment")) {
                        timeline2 = new Animation.AttachmentTimeline(frames, slot.index);
                        frame = 0;
                        while (keyMap2 != null) {
                            ((Animation.AttachmentTimeline)timeline2).setFrame(frame, keyMap2.getFloat("time", 0.0f), keyMap2.getString("name", null));
                            keyMap2 = keyMap2.next;
                            ++frame;
                        }
                        timelines.add(timeline2);
                    } else if (timelineName.equals("rgba")) {
                        timeline2 = new Animation.RGBATimeline(frames, frames << 2, slot.index);
                        float time = keyMap2.getFloat("time", 0.0f);
                        color = keyMap2.getString("color");
                        r = (float)Integer.parseInt(color.substring(0, 2), 16) / 255.0f;
                        g = (float)Integer.parseInt(color.substring(2, 4), 16) / 255.0f;
                        b = (float)Integer.parseInt(color.substring(4, 6), 16) / 255.0f;
                        a = (float)Integer.parseInt(color.substring(6, 8), 16) / 255.0f;
                        int frame2 = 0;
                        int bezier = 0;
                        while (true) {
                            ((Animation.RGBATimeline)timeline2).setFrame(frame2, time, r, g, b, a);
                            JsonValue nextMap = keyMap2.next;
                            if (nextMap == null) break;
                            float time2 = nextMap.getFloat("time", 0.0f);
                            color = nextMap.getString("color");
                            float nr = (float)Integer.parseInt(color.substring(0, 2), 16) / 255.0f;
                            float ng = (float)Integer.parseInt(color.substring(2, 4), 16) / 255.0f;
                            float nb = (float)Integer.parseInt(color.substring(4, 6), 16) / 255.0f;
                            float na = (float)Integer.parseInt(color.substring(6, 8), 16) / 255.0f;
                            curve = keyMap2.get("curve");
                            if (curve != null) {
                                bezier = this.readCurve(curve, (Animation.CurveTimeline)timeline2, bezier, frame2, 0, time, time2, r, nr, 1.0f);
                                bezier = this.readCurve(curve, (Animation.CurveTimeline)timeline2, bezier, frame2, 1, time, time2, g, ng, 1.0f);
                                bezier = this.readCurve(curve, (Animation.CurveTimeline)timeline2, bezier, frame2, 2, time, time2, b, nb, 1.0f);
                                bezier = this.readCurve(curve, (Animation.CurveTimeline)timeline2, bezier, frame2, 3, time, time2, a, na, 1.0f);
                            }
                            time = time2;
                            r = nr;
                            g = ng;
                            b = nb;
                            a = na;
                            keyMap2 = nextMap;
                            ++frame2;
                        }
                        ((Animation.CurveTimeline)timeline2).shrink(bezier);
                        timelines.add(timeline2);
                    } else if (timelineName.equals("rgb")) {
                        timeline2 = new Animation.RGBTimeline(frames, frames * 3, slot.index);
                        float time = keyMap2.getFloat("time", 0.0f);
                        color = keyMap2.getString("color");
                        r = (float)Integer.parseInt(color.substring(0, 2), 16) / 255.0f;
                        g = (float)Integer.parseInt(color.substring(2, 4), 16) / 255.0f;
                        b = (float)Integer.parseInt(color.substring(4, 6), 16) / 255.0f;
                        int frame3 = 0;
                        int bezier = 0;
                        while (true) {
                            ((Animation.RGBTimeline)timeline2).setFrame(frame3, time, r, g, b);
                            JsonValue nextMap = keyMap2.next;
                            if (nextMap == null) break;
                            float time2 = nextMap.getFloat("time", 0.0f);
                            color = nextMap.getString("color");
                            float nr = (float)Integer.parseInt(color.substring(0, 2), 16) / 255.0f;
                            float ng = (float)Integer.parseInt(color.substring(2, 4), 16) / 255.0f;
                            float nb = (float)Integer.parseInt(color.substring(4, 6), 16) / 255.0f;
                            JsonValue curve2 = keyMap2.get("curve");
                            if (curve2 != null) {
                                bezier = this.readCurve(curve2, (Animation.CurveTimeline)timeline2, bezier, frame3, 0, time, time2, r, nr, 1.0f);
                                bezier = this.readCurve(curve2, (Animation.CurveTimeline)timeline2, bezier, frame3, 1, time, time2, g, ng, 1.0f);
                                bezier = this.readCurve(curve2, (Animation.CurveTimeline)timeline2, bezier, frame3, 2, time, time2, b, nb, 1.0f);
                            }
                            time = time2;
                            r = nr;
                            g = ng;
                            b = nb;
                            keyMap2 = nextMap;
                            ++frame3;
                        }
                        ((Animation.CurveTimeline)timeline2).shrink(bezier);
                        timelines.add(timeline2);
                    } else if (timelineName.equals("alpha")) {
                        timelines.add(this.readTimeline(keyMap2, new Animation.AlphaTimeline(frames, frames, slot.index), 0.0f, 1.0f));
                    } else if (timelineName.equals("rgba2")) {
                        timeline2 = new Animation.RGBA2Timeline(frames, frames * 7, slot.index);
                        float time = keyMap2.getFloat("time", 0.0f);
                        color = keyMap2.getString("light");
                        r = (float)Integer.parseInt(color.substring(0, 2), 16) / 255.0f;
                        g = (float)Integer.parseInt(color.substring(2, 4), 16) / 255.0f;
                        b = (float)Integer.parseInt(color.substring(4, 6), 16) / 255.0f;
                        a = (float)Integer.parseInt(color.substring(6, 8), 16) / 255.0f;
                        color = keyMap2.getString("dark");
                        float r2 = (float)Integer.parseInt(color.substring(0, 2), 16) / 255.0f;
                        float g2 = (float)Integer.parseInt(color.substring(2, 4), 16) / 255.0f;
                        float b2 = (float)Integer.parseInt(color.substring(4, 6), 16) / 255.0f;
                        int frame4 = 0;
                        int bezier = 0;
                        while (true) {
                            ((Animation.RGBA2Timeline)timeline2).setFrame(frame4, time, r, g, b, a, r2, g2, b2);
                            JsonValue nextMap = keyMap2.next;
                            if (nextMap == null) break;
                            float time2 = nextMap.getFloat("time", 0.0f);
                            color = nextMap.getString("light");
                            float nr = (float)Integer.parseInt(color.substring(0, 2), 16) / 255.0f;
                            float ng = (float)Integer.parseInt(color.substring(2, 4), 16) / 255.0f;
                            float nb = (float)Integer.parseInt(color.substring(4, 6), 16) / 255.0f;
                            float na = (float)Integer.parseInt(color.substring(6, 8), 16) / 255.0f;
                            color = nextMap.getString("dark");
                            float nr2 = (float)Integer.parseInt(color.substring(0, 2), 16) / 255.0f;
                            float ng2 = (float)Integer.parseInt(color.substring(2, 4), 16) / 255.0f;
                            float nb2 = (float)Integer.parseInt(color.substring(4, 6), 16) / 255.0f;
                            JsonValue curve3 = keyMap2.get("curve");
                            if (curve3 != null) {
                                bezier = this.readCurve(curve3, (Animation.CurveTimeline)timeline2, bezier, frame4, 0, time, time2, r, nr, 1.0f);
                                bezier = this.readCurve(curve3, (Animation.CurveTimeline)timeline2, bezier, frame4, 1, time, time2, g, ng, 1.0f);
                                bezier = this.readCurve(curve3, (Animation.CurveTimeline)timeline2, bezier, frame4, 2, time, time2, b, nb, 1.0f);
                                bezier = this.readCurve(curve3, (Animation.CurveTimeline)timeline2, bezier, frame4, 3, time, time2, a, na, 1.0f);
                                bezier = this.readCurve(curve3, (Animation.CurveTimeline)timeline2, bezier, frame4, 4, time, time2, r2, nr2, 1.0f);
                                bezier = this.readCurve(curve3, (Animation.CurveTimeline)timeline2, bezier, frame4, 5, time, time2, g2, ng2, 1.0f);
                                bezier = this.readCurve(curve3, (Animation.CurveTimeline)timeline2, bezier, frame4, 6, time, time2, b2, nb2, 1.0f);
                            }
                            time = time2;
                            r = nr;
                            g = ng;
                            b = nb;
                            a = na;
                            r2 = nr2;
                            g2 = ng2;
                            b2 = nb2;
                            keyMap2 = nextMap;
                            ++frame4;
                        }
                        ((Animation.CurveTimeline)timeline2).shrink(bezier);
                        timelines.add(timeline2);
                    } else if (timelineName.equals("rgb2")) {
                        timeline2 = new Animation.RGB2Timeline(frames, frames * 6, slot.index);
                        float time = keyMap2.getFloat("time", 0.0f);
                        color = keyMap2.getString("light");
                        r = (float)Integer.parseInt(color.substring(0, 2), 16) / 255.0f;
                        g = (float)Integer.parseInt(color.substring(2, 4), 16) / 255.0f;
                        b = (float)Integer.parseInt(color.substring(4, 6), 16) / 255.0f;
                        color = keyMap2.getString("dark");
                        float r2 = (float)Integer.parseInt(color.substring(0, 2), 16) / 255.0f;
                        float g2 = (float)Integer.parseInt(color.substring(2, 4), 16) / 255.0f;
                        float b2 = (float)Integer.parseInt(color.substring(4, 6), 16) / 255.0f;
                        int frame5 = 0;
                        int bezier = 0;
                        while (true) {
                            ((Animation.RGB2Timeline)timeline2).setFrame(frame5, time, r, g, b, r2, g2, b2);
                            JsonValue nextMap = keyMap2.next;
                            if (nextMap == null) break;
                            float time2 = nextMap.getFloat("time", 0.0f);
                            color = nextMap.getString("light");
                            float nr = (float)Integer.parseInt(color.substring(0, 2), 16) / 255.0f;
                            float ng = (float)Integer.parseInt(color.substring(2, 4), 16) / 255.0f;
                            float nb = (float)Integer.parseInt(color.substring(4, 6), 16) / 255.0f;
                            color = nextMap.getString("dark");
                            float nr2 = (float)Integer.parseInt(color.substring(0, 2), 16) / 255.0f;
                            float ng2 = (float)Integer.parseInt(color.substring(2, 4), 16) / 255.0f;
                            float nb2 = (float)Integer.parseInt(color.substring(4, 6), 16) / 255.0f;
                            JsonValue curve4 = keyMap2.get("curve");
                            if (curve4 != null) {
                                bezier = this.readCurve(curve4, (Animation.CurveTimeline)timeline2, bezier, frame5, 0, time, time2, r, nr, 1.0f);
                                bezier = this.readCurve(curve4, (Animation.CurveTimeline)timeline2, bezier, frame5, 1, time, time2, g, ng, 1.0f);
                                bezier = this.readCurve(curve4, (Animation.CurveTimeline)timeline2, bezier, frame5, 2, time, time2, b, nb, 1.0f);
                                bezier = this.readCurve(curve4, (Animation.CurveTimeline)timeline2, bezier, frame5, 3, time, time2, r2, nr2, 1.0f);
                                bezier = this.readCurve(curve4, (Animation.CurveTimeline)timeline2, bezier, frame5, 4, time, time2, g2, ng2, 1.0f);
                                bezier = this.readCurve(curve4, (Animation.CurveTimeline)timeline2, bezier, frame5, 5, time, time2, b2, nb2, 1.0f);
                            }
                            time = time2;
                            r = nr;
                            g = ng;
                            b = nb;
                            r2 = nr2;
                            g2 = ng2;
                            b2 = nb2;
                            keyMap2 = nextMap;
                            ++frame5;
                        }
                        ((Animation.CurveTimeline)timeline2).shrink(bezier);
                        timelines.add(timeline2);
                    } else {
                        throw new RuntimeException("Invalid timeline type for a slot: " + timelineName + " (" + slotMap.name + ")");
                    }
                }
                timelineMap = timelineMap.next;
            }
            slotMap = slotMap.next;
        }
        JsonValue boneMap = map.getChild("bones");
        while (boneMap != null) {
            BoneData bone = skeletonData.findBone(boneMap.name);
            if (bone == null) {
                throw new SerializationException("Bone not found: " + boneMap.name);
            }
            timelineMap = boneMap.child;
            while (timelineMap != null) {
                keyMap2 = timelineMap.child;
                if (keyMap2 != null) {
                    frames = timelineMap.size;
                    timelineName = timelineMap.name;
                    if (timelineName.equals("rotate")) {
                        timelines.add(this.readTimeline(keyMap2, new Animation.RotateTimeline(frames, frames, bone.index), 0.0f, 1.0f));
                    } else if (timelineName.equals("translate")) {
                        timeline2 = new Animation.TranslateTimeline(frames, frames << 1, bone.index);
                        timelines.add(this.readTimeline(keyMap2, (Animation.CurveTimeline2)timeline2, "x", "y", 0.0f, scale));
                    } else if (timelineName.equals("translatex")) {
                        timelines.add(this.readTimeline(keyMap2, new Animation.TranslateXTimeline(frames, frames, bone.index), 0.0f, scale));
                    } else if (timelineName.equals("translatey")) {
                        timelines.add(this.readTimeline(keyMap2, new Animation.TranslateYTimeline(frames, frames, bone.index), 0.0f, scale));
                    } else if (timelineName.equals("scale")) {
                        timeline2 = new Animation.ScaleTimeline(frames, frames << 1, bone.index);
                        timelines.add(this.readTimeline(keyMap2, (Animation.CurveTimeline2)timeline2, "x", "y", 1.0f, 1.0f));
                    } else if (timelineName.equals("scalex")) {
                        timelines.add(this.readTimeline(keyMap2, new Animation.ScaleXTimeline(frames, frames, bone.index), 1.0f, 1.0f));
                    } else if (timelineName.equals("scaley")) {
                        timelines.add(this.readTimeline(keyMap2, new Animation.ScaleYTimeline(frames, frames, bone.index), 1.0f, 1.0f));
                    } else if (timelineName.equals("shear")) {
                        timeline2 = new Animation.ShearTimeline(frames, frames << 1, bone.index);
                        timelines.add(this.readTimeline(keyMap2, (Animation.CurveTimeline2)timeline2, "x", "y", 0.0f, 1.0f));
                    } else if (timelineName.equals("shearx")) {
                        timelines.add(this.readTimeline(keyMap2, new Animation.ShearXTimeline(frames, frames, bone.index), 0.0f, 1.0f));
                    } else if (timelineName.equals("sheary")) {
                        timelines.add(this.readTimeline(keyMap2, new Animation.ShearYTimeline(frames, frames, bone.index), 0.0f, 1.0f));
                    } else if (timelineName.equals("inherit")) {
                        timeline2 = new Animation.InheritTimeline(frames, bone.index);
                        frame = 0;
                        while (keyMap2 != null) {
                            float time = keyMap2.getFloat("time", 0.0f);
                            ((Animation.InheritTimeline)timeline2).setFrame(frame, time, BoneData.Inherit.valueOf(keyMap2.getString("inherit", BoneData.Inherit.normal.name())));
                            keyMap2 = keyMap2.next;
                            ++frame;
                        }
                        timelines.add(timeline2);
                    } else {
                        throw new RuntimeException("Invalid timeline type for a bone: " + timelineName + " (" + boneMap.name + ")");
                    }
                }
                timelineMap = timelineMap.next;
            }
            boneMap = boneMap.next;
        }
        JsonValue timelineMap2 = map.getChild("ik");
        while (timelineMap2 != null) {
            keyMap = timelineMap2.child;
            if (keyMap != null) {
                constraint = skeletonData.findIkConstraint(timelineMap2.name);
                timeline = new Animation.IkConstraintTimeline(timelineMap2.size, timelineMap2.size << 1, skeletonData.getIkConstraints().indexOf((IkConstraintData)constraint, true));
                float time = keyMap.getFloat("time", 0.0f);
                float mix = keyMap.getFloat("mix", 1.0f);
                float softness = keyMap.getFloat("softness", 0.0f) * scale;
                frame = 0;
                int bezier = 0;
                while (true) {
                    ((Animation.IkConstraintTimeline)timeline).setFrame(frame, time, mix, softness, keyMap.getBoolean("bendPositive", true) ? 1 : -1, keyMap.getBoolean("compress", false), keyMap.getBoolean("stretch", false));
                    JsonValue nextMap = keyMap.next;
                    if (nextMap == null) break;
                    float time2 = nextMap.getFloat("time", 0.0f);
                    float mix2 = nextMap.getFloat("mix", 1.0f);
                    float softness2 = nextMap.getFloat("softness", 0.0f) * scale;
                    JsonValue curve5 = keyMap.get("curve");
                    if (curve5 != null) {
                        bezier = this.readCurve(curve5, timeline, bezier, frame, 0, time, time2, mix, mix2, 1.0f);
                        bezier = this.readCurve(curve5, timeline, bezier, frame, 1, time, time2, softness, softness2, scale);
                    }
                    time = time2;
                    mix = mix2;
                    softness = softness2;
                    keyMap = nextMap;
                    ++frame;
                }
                timeline.shrink(bezier);
                timelines.add(timeline);
            }
            timelineMap2 = timelineMap2.next;
        }
        timelineMap2 = map.getChild("transform");
        while (timelineMap2 != null) {
            keyMap = timelineMap2.child;
            if (keyMap != null) {
                constraint = skeletonData.findTransformConstraint(timelineMap2.name);
                timeline = new Animation.TransformConstraintTimeline(timelineMap2.size, timelineMap2.size * 6, skeletonData.getTransformConstraints().indexOf((TransformConstraintData)constraint, true));
                float time = keyMap.getFloat("time", 0.0f);
                float mixRotate = keyMap.getFloat("mixRotate", 1.0f);
                float mixX = keyMap.getFloat("mixX", 1.0f);
                float mixY = keyMap.getFloat("mixY", mixX);
                float mixScaleX = keyMap.getFloat("mixScaleX", 1.0f);
                float mixScaleY = keyMap.getFloat("mixScaleY", mixScaleX);
                float mixShearY = keyMap.getFloat("mixShearY", 1.0f);
                int frame6 = 0;
                int bezier = 0;
                while (true) {
                    ((Animation.TransformConstraintTimeline)timeline).setFrame(frame6, time, mixRotate, mixX, mixY, mixScaleX, mixScaleY, mixShearY);
                    JsonValue nextMap = keyMap.next;
                    if (nextMap == null) break;
                    float time2 = nextMap.getFloat("time", 0.0f);
                    float mixRotate2 = nextMap.getFloat("mixRotate", 1.0f);
                    float mixX2 = nextMap.getFloat("mixX", 1.0f);
                    float mixY2 = nextMap.getFloat("mixY", mixX2);
                    float mixScaleX2 = nextMap.getFloat("mixScaleX", 1.0f);
                    float mixScaleY2 = nextMap.getFloat("mixScaleY", mixScaleX2);
                    float mixShearY2 = nextMap.getFloat("mixShearY", 1.0f);
                    curve = keyMap.get("curve");
                    if (curve != null) {
                        bezier = this.readCurve(curve, timeline, bezier, frame6, 0, time, time2, mixRotate, mixRotate2, 1.0f);
                        bezier = this.readCurve(curve, timeline, bezier, frame6, 1, time, time2, mixX, mixX2, 1.0f);
                        bezier = this.readCurve(curve, timeline, bezier, frame6, 2, time, time2, mixY, mixY2, 1.0f);
                        bezier = this.readCurve(curve, timeline, bezier, frame6, 3, time, time2, mixScaleX, mixScaleX2, 1.0f);
                        bezier = this.readCurve(curve, timeline, bezier, frame6, 4, time, time2, mixScaleY, mixScaleY2, 1.0f);
                        bezier = this.readCurve(curve, timeline, bezier, frame6, 5, time, time2, mixShearY, mixShearY2, 1.0f);
                    }
                    time = time2;
                    mixRotate = mixRotate2;
                    mixX = mixX2;
                    mixY = mixY2;
                    mixScaleX = mixScaleX2;
                    mixScaleY = mixScaleY2;
                    mixShearY = mixShearY2;
                    keyMap = nextMap;
                    ++frame6;
                }
                timeline.shrink(bezier);
                timelines.add(timeline);
            }
            timelineMap2 = timelineMap2.next;
        }
        JsonValue constraintMap = map.getChild("path");
        while (constraintMap != null) {
            PathConstraintData constraint2 = skeletonData.findPathConstraint(constraintMap.name);
            if (constraint2 == null) {
                throw new SerializationException("Path constraint not found: " + constraintMap.name);
            }
            int index = skeletonData.pathConstraints.indexOf(constraint2, true);
            JsonValue timelineMap3 = constraintMap.child;
            while (timelineMap3 != null) {
                JsonValue keyMap3 = timelineMap3.child;
                if (keyMap3 != null) {
                    Animation.CurveTimeline timeline3;
                    int frames2 = timelineMap3.size;
                    String timelineName2 = timelineMap3.name;
                    if (timelineName2.equals("position")) {
                        timeline3 = new Animation.PathConstraintPositionTimeline(frames2, frames2, index);
                        timelines.add(this.readTimeline(keyMap3, (Animation.CurveTimeline1)timeline3, 0.0f, constraint2.positionMode == PathConstraintData.PositionMode.fixed ? scale : 1.0f));
                    } else if (timelineName2.equals("spacing")) {
                        timeline3 = new Animation.PathConstraintSpacingTimeline(frames2, frames2, index);
                        timelines.add(this.readTimeline(keyMap3, (Animation.CurveTimeline1)timeline3, 0.0f, constraint2.spacingMode == PathConstraintData.SpacingMode.length || constraint2.spacingMode == PathConstraintData.SpacingMode.fixed ? scale : 1.0f));
                    } else if (timelineName2.equals("mix")) {
                        timeline3 = new Animation.PathConstraintMixTimeline(frames2, frames2 * 3, index);
                        float time = keyMap3.getFloat("time", 0.0f);
                        float mixRotate = keyMap3.getFloat("mixRotate", 1.0f);
                        float mixX = keyMap3.getFloat("mixX", 1.0f);
                        float mixY = keyMap3.getFloat("mixY", mixX);
                        int frame7 = 0;
                        int bezier = 0;
                        while (true) {
                            ((Animation.PathConstraintMixTimeline)timeline3).setFrame(frame7, time, mixRotate, mixX, mixY);
                            JsonValue nextMap = keyMap3.next;
                            if (nextMap == null) break;
                            float time2 = nextMap.getFloat("time", 0.0f);
                            float mixRotate2 = nextMap.getFloat("mixRotate", 1.0f);
                            float mixX2 = nextMap.getFloat("mixX", 1.0f);
                            float mixY2 = nextMap.getFloat("mixY", mixX2);
                            JsonValue curve6 = keyMap3.get("curve");
                            if (curve6 != null) {
                                bezier = this.readCurve(curve6, timeline3, bezier, frame7, 0, time, time2, mixRotate, mixRotate2, 1.0f);
                                bezier = this.readCurve(curve6, timeline3, bezier, frame7, 1, time, time2, mixX, mixX2, 1.0f);
                                bezier = this.readCurve(curve6, timeline3, bezier, frame7, 2, time, time2, mixY, mixY2, 1.0f);
                            }
                            time = time2;
                            mixRotate = mixRotate2;
                            mixX = mixX2;
                            mixY = mixY2;
                            keyMap3 = nextMap;
                            ++frame7;
                        }
                        timeline3.shrink(bezier);
                        timelines.add(timeline3);
                    }
                }
                timelineMap3 = timelineMap3.next;
            }
            constraintMap = constraintMap.next;
        }
        constraintMap = map.getChild("physics");
        while (constraintMap != null) {
            int index = -1;
            if (!constraintMap.name.isEmpty()) {
                PhysicsConstraintData constraint3 = skeletonData.findPhysicsConstraint(constraintMap.name);
                if (constraint3 == null) {
                    throw new SerializationException("Physics constraint not found: " + constraintMap.name);
                }
                index = skeletonData.physicsConstraints.indexOf(constraint3, true);
            }
            JsonValue timelineMap4 = constraintMap.child;
            while (timelineMap4 != null) {
                block112: {
                    Animation.Timeline timeline4;
                    block115: {
                        String timelineName3;
                        int frames3;
                        block120: {
                            block119: {
                                block118: {
                                    block117: {
                                        block116: {
                                            block114: {
                                                block113: {
                                                    keyMap2 = timelineMap4.child;
                                                    if (keyMap2 == null) break block112;
                                                    frames3 = timelineMap4.size;
                                                    timelineName3 = timelineMap4.name;
                                                    if (!timelineName3.equals("reset")) break block113;
                                                    timeline4 = new Animation.PhysicsConstraintResetTimeline(frames3, index);
                                                    int frame8 = 0;
                                                    while (keyMap2 != null) {
                                                        timeline4.setFrame(frame8, keyMap2.getFloat("time", 0.0f));
                                                        keyMap2 = keyMap2.next;
                                                        ++frame8;
                                                    }
                                                    timelines.add(timeline4);
                                                    break block112;
                                                }
                                                if (!timelineName3.equals("inertia")) break block114;
                                                timeline4 = new Animation.PhysicsConstraintInertiaTimeline(frames3, frames3, index);
                                                break block115;
                                            }
                                            if (!timelineName3.equals("strength")) break block116;
                                            timeline4 = new Animation.PhysicsConstraintStrengthTimeline(frames3, frames3, index);
                                            break block115;
                                        }
                                        if (!timelineName3.equals("damping")) break block117;
                                        timeline4 = new Animation.PhysicsConstraintDampingTimeline(frames3, frames3, index);
                                        break block115;
                                    }
                                    if (!timelineName3.equals("mass")) break block118;
                                    timeline4 = new Animation.PhysicsConstraintMassTimeline(frames3, frames3, index);
                                    break block115;
                                }
                                if (!timelineName3.equals("wind")) break block119;
                                timeline4 = new Animation.PhysicsConstraintWindTimeline(frames3, frames3, index);
                                break block115;
                            }
                            if (!timelineName3.equals("gravity")) break block120;
                            timeline4 = new Animation.PhysicsConstraintGravityTimeline(frames3, frames3, index);
                            break block115;
                        }
                        if (!timelineName3.equals("mix")) break block112;
                        timeline4 = new Animation.PhysicsConstraintMixTimeline(frames3, frames3, index);
                    }
                    timelines.add(this.readTimeline(keyMap2, (Animation.CurveTimeline1)timeline4, 0.0f, 1.0f));
                }
                timelineMap4 = timelineMap4.next;
            }
            constraintMap = constraintMap.next;
        }
        JsonValue attachmentsMap = map.getChild("attachments");
        while (attachmentsMap != null) {
            Skin skin = skeletonData.findSkin(attachmentsMap.name);
            if (skin == null) {
                throw new SerializationException("Skin not found: " + attachmentsMap.name);
            }
            JsonValue slotMap2 = attachmentsMap.child;
            while (slotMap2 != null) {
                SlotData slot = skeletonData.findSlot(slotMap2.name);
                if (slot == null) {
                    throw new SerializationException("Slot not found: " + slotMap2.name);
                }
                JsonValue attachmentMap = slotMap2.child;
                while (attachmentMap != null) {
                    Attachment attachment = skin.getAttachment(slot.index, attachmentMap.name);
                    if (attachment == null) {
                        throw new SerializationException("Timeline attachment not found: " + attachmentMap.name);
                    }
                    JsonValue timelineMap5 = attachmentMap.child;
                    while (timelineMap5 != null) {
                        JsonValue keyMap4 = timelineMap5.child;
                        int frames4 = timelineMap5.size;
                        String timelineName4 = timelineMap5.name;
                        if (timelineName4.equals("deform")) {
                            VertexAttachment vertexAttachment = (VertexAttachment)attachment;
                            boolean weighted = vertexAttachment.getBones() != null;
                            float[] vertices = vertexAttachment.getVertices();
                            int deformLength = weighted ? vertices.length / 3 << 1 : vertices.length;
                            Animation.DeformTimeline timeline5 = new Animation.DeformTimeline(frames4, frames4, slot.index, vertexAttachment);
                            float time = keyMap4.getFloat("time", 0.0f);
                            int frame9 = 0;
                            int bezier = 0;
                            while (true) {
                                float[] deform;
                                JsonValue verticesValue;
                                if ((verticesValue = keyMap4.get("vertices")) == null) {
                                    deform = weighted ? new float[deformLength] : vertices;
                                } else {
                                    deform = new float[deformLength];
                                    int start = keyMap4.getInt("offset", 0);
                                    SpineUtils.arraycopy(verticesValue.asFloatArray(), 0, deform, start, verticesValue.size);
                                    if (scale != 1.0f) {
                                        int i = start;
                                        int n2 = i + verticesValue.size;
                                        while (i < n2) {
                                            int n3 = i++;
                                            deform[n3] = deform[n3] * scale;
                                        }
                                    }
                                    if (!weighted) {
                                        for (int i = 0; i < deformLength; ++i) {
                                            int n4 = i;
                                            deform[n4] = deform[n4] + vertices[i];
                                        }
                                    }
                                }
                                timeline5.setFrame(frame9, time, deform);
                                JsonValue nextMap = keyMap4.next;
                                if (nextMap == null) break;
                                float time2 = nextMap.getFloat("time", 0.0f);
                                JsonValue curve7 = keyMap4.get("curve");
                                if (curve7 != null) {
                                    bezier = this.readCurve(curve7, timeline5, bezier, frame9, 0, time, time2, 0.0f, 1.0f, 1.0f);
                                }
                                time = time2;
                                keyMap4 = nextMap;
                                ++frame9;
                            }
                            timeline5.shrink(bezier);
                            timelines.add(timeline5);
                        } else if (timelineName4.equals("sequence")) {
                            Animation.SequenceTimeline timeline6 = new Animation.SequenceTimeline(frames4, slot.index, attachment);
                            float lastDelay = 0.0f;
                            int frame10 = 0;
                            while (keyMap4 != null) {
                                float delay = keyMap4.getFloat("delay", lastDelay);
                                timeline6.setFrame(frame10, keyMap4.getFloat("time", 0.0f), Sequence.SequenceMode.valueOf(keyMap4.getString("mode", "hold")), keyMap4.getInt("index", 0), delay);
                                lastDelay = delay;
                                keyMap4 = keyMap4.next;
                                ++frame10;
                            }
                            timelines.add(timeline6);
                        }
                        timelineMap5 = timelineMap5.next;
                    }
                    attachmentMap = attachmentMap.next;
                }
                slotMap2 = slotMap2.next;
            }
            attachmentsMap = attachmentsMap.next;
        }
        JsonValue drawOrderMap = map.get("drawOrder");
        if (drawOrderMap != null) {
            Animation.DrawOrderTimeline timeline7 = new Animation.DrawOrderTimeline(drawOrderMap.size);
            int slotCount = skeletonData.slots.size;
            int frame11 = 0;
            JsonValue keyMap5 = drawOrderMap.child;
            while (keyMap5 != null) {
                int[] drawOrder = null;
                JsonValue offsets = keyMap5.get("offsets");
                if (offsets != null) {
                    drawOrder = new int[slotCount];
                    for (int i = slotCount - 1; i >= 0; --i) {
                        drawOrder[i] = -1;
                    }
                    int[] unchanged = new int[slotCount - offsets.size];
                    int originalIndex = 0;
                    int unchangedIndex = 0;
                    JsonValue offsetMap = offsets.child;
                    while (offsetMap != null) {
                        SlotData slot = skeletonData.findSlot(offsetMap.getString("slot"));
                        if (slot == null) {
                            throw new SerializationException("Slot not found: " + offsetMap.getString("slot"));
                        }
                        while (originalIndex != slot.index) {
                            unchanged[unchangedIndex++] = originalIndex++;
                        }
                        drawOrder[originalIndex + offsetMap.getInt((String)"offset")] = originalIndex++;
                        offsetMap = offsetMap.next;
                    }
                    while (originalIndex < slotCount) {
                        unchanged[unchangedIndex++] = originalIndex++;
                    }
                    for (int i = slotCount - 1; i >= 0; --i) {
                        if (drawOrder[i] != -1) continue;
                        drawOrder[i] = unchanged[--unchangedIndex];
                    }
                }
                timeline7.setFrame(frame11, keyMap5.getFloat("time", 0.0f), drawOrder);
                keyMap5 = keyMap5.next;
                ++frame11;
            }
            timelines.add(timeline7);
        }
        if ((eventsMap = map.get("events")) != null) {
            Animation.EventTimeline timeline8 = new Animation.EventTimeline(eventsMap.size);
            int frame12 = 0;
            JsonValue keyMap6 = eventsMap.child;
            while (keyMap6 != null) {
                EventData eventData = skeletonData.findEvent(keyMap6.getString("name"));
                if (eventData == null) {
                    throw new SerializationException("Event not found: " + keyMap6.getString("name"));
                }
                Event event = new Event(keyMap6.getFloat("time", 0.0f), eventData);
                event.intValue = keyMap6.getInt("int", eventData.intValue);
                event.floatValue = keyMap6.getFloat("float", eventData.floatValue);
                event.stringValue = keyMap6.getString("string", eventData.stringValue);
                if (event.getData().audioPath != null) {
                    event.volume = keyMap6.getFloat("volume", eventData.volume);
                    event.balance = keyMap6.getFloat("balance", eventData.balance);
                }
                timeline8.setFrame(frame12, event);
                keyMap6 = keyMap6.next;
                ++frame12;
            }
            timelines.add(timeline8);
        }
        timelines.shrink();
        float duration = 0.0f;
        T[] items = timelines.items;
        int n5 = timelines.size;
        for (int i = 0; i < n5; ++i) {
            duration = Math.max(duration, ((Animation.Timeline)items[i]).getDuration());
        }
        skeletonData.animations.add(new Animation(name, timelines, duration));
    }

    private Animation.Timeline readTimeline(JsonValue keyMap, Animation.CurveTimeline1 timeline, float defaultValue, float scale) {
        float time = keyMap.getFloat("time", 0.0f);
        float value = keyMap.getFloat("value", defaultValue) * scale;
        int frame = 0;
        int bezier = 0;
        while (true) {
            timeline.setFrame(frame, time, value);
            JsonValue nextMap = keyMap.next;
            if (nextMap == null) {
                timeline.shrink(bezier);
                return timeline;
            }
            float time2 = nextMap.getFloat("time", 0.0f);
            float value2 = nextMap.getFloat("value", defaultValue) * scale;
            JsonValue curve = keyMap.get("curve");
            if (curve != null) {
                bezier = this.readCurve(curve, timeline, bezier, frame, 0, time, time2, value, value2, scale);
            }
            time = time2;
            value = value2;
            keyMap = nextMap;
            ++frame;
        }
    }

    private Animation.Timeline readTimeline(JsonValue keyMap, Animation.CurveTimeline2 timeline, String name1, String name2, float defaultValue, float scale) {
        float time = keyMap.getFloat("time", 0.0f);
        float value1 = keyMap.getFloat(name1, defaultValue) * scale;
        float value2 = keyMap.getFloat(name2, defaultValue) * scale;
        int frame = 0;
        int bezier = 0;
        while (true) {
            timeline.setFrame(frame, time, value1, value2);
            JsonValue nextMap = keyMap.next;
            if (nextMap == null) {
                timeline.shrink(bezier);
                return timeline;
            }
            float time2 = nextMap.getFloat("time", 0.0f);
            float nvalue1 = nextMap.getFloat(name1, defaultValue) * scale;
            float nvalue2 = nextMap.getFloat(name2, defaultValue) * scale;
            JsonValue curve = keyMap.get("curve");
            if (curve != null) {
                bezier = this.readCurve(curve, timeline, bezier, frame, 0, time, time2, value1, nvalue1, scale);
                bezier = this.readCurve(curve, timeline, bezier, frame, 1, time, time2, value2, nvalue2, scale);
            }
            time = time2;
            value1 = nvalue1;
            value2 = nvalue2;
            keyMap = nextMap;
            ++frame;
        }
    }

    int readCurve(JsonValue curve, Animation.CurveTimeline timeline, int bezier, int frame, int value, float time1, float time2, float value1, float value2, float scale) {
        if (curve.isString()) {
            if (curve.asString().equals("stepped")) {
                timeline.setStepped(frame);
            }
            return bezier;
        }
        curve = curve.get(value << 2);
        float cx1 = curve.asFloat();
        curve = curve.next;
        float cy1 = curve.asFloat() * scale;
        curve = curve.next;
        float cx2 = curve.asFloat();
        curve = curve.next;
        float cy2 = curve.asFloat() * scale;
        SkeletonJson.setBezier(timeline, frame, value, bezier, time1, value1, cx1, cy1, cx2, cy2, time2, value2);
        return bezier + 1;
    }

    static void setBezier(Animation.CurveTimeline timeline, int frame, int value, int bezier, float time1, float value1, float cx1, float cy1, float cx2, float cy2, float time2, float value2) {
        timeline.setBezier(bezier, frame, value, time1, value1, cx1, cy1, cx2, cy2, time2, value2);
    }

    static class LinkedMesh {
        String parent;
        String skin;
        int slotIndex;
        MeshAttachment mesh;
        boolean inheritTimelines;

        public LinkedMesh(MeshAttachment mesh, String skin, int slotIndex, String parent, boolean inheritTimelines) {
            this.mesh = mesh;
            this.skin = skin;
            this.slotIndex = slotIndex;
            this.parent = parent;
            this.inheritTimelines = inheritTimelines;
        }
    }
}

