/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.PolygonSpriteBatch;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.NumberUtils;
import com.badlogic.gdx.utils.ShortArray;
import com.esotericsoftware.spine.BlendMode;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.ClippingAttachment;
import com.esotericsoftware.spine.attachments.MeshAttachment;
import com.esotericsoftware.spine.attachments.RegionAttachment;
import com.esotericsoftware.spine.attachments.SkeletonAttachment;
import com.esotericsoftware.spine.utils.SkeletonClipping;
import com.esotericsoftware.spine.utils.TwoColorPolygonBatch;

public class SkeletonRenderer {
    private static final short[] quadTriangles = new short[]{0, 1, 2, 2, 3, 0};
    private boolean pmaColors;
    private boolean pmaBlendModes;
    private final FloatArray vertices = new FloatArray(32);
    private final SkeletonClipping clipper = new SkeletonClipping();

    public void draw(Batch batch, Skeleton skeleton) {
        if (batch instanceof TwoColorPolygonBatch) {
            this.draw((TwoColorPolygonBatch)batch, skeleton);
            return;
        }
        if (batch instanceof PolygonSpriteBatch) {
            this.draw((PolygonSpriteBatch)batch, skeleton);
            return;
        }
        if (batch == null) {
            throw new IllegalArgumentException("batch cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        boolean pmaColors = this.pmaColors;
        boolean pmaBlendModes = this.pmaBlendModes;
        BlendMode blendMode = null;
        float[] vertices = this.vertices.items;
        Color skeletonColor = skeleton.color;
        float r = skeletonColor.r;
        float g = skeletonColor.g;
        float b = skeletonColor.b;
        float a = skeletonColor.a;
        T[] drawOrder = skeleton.drawOrder.items;
        int n2 = skeleton.drawOrder.size;
        for (int i = 0; i < n2; ++i) {
            Skeleton attachmentSkeleton;
            Slot slot = (Slot)drawOrder[i];
            if (!slot.bone.active) continue;
            Attachment attachment = slot.attachment;
            if (attachment instanceof RegionAttachment) {
                RegionAttachment region = (RegionAttachment)attachment;
                region.computeWorldVertices(slot, vertices, 0, 5);
                Color color = region.getColor();
                Color slotColor = slot.getColor();
                float alpha = a * slotColor.a * color.a * 255.0f;
                float multiplier = pmaColors ? alpha : 255.0f;
                BlendMode slotBlendMode = slot.data.getBlendMode();
                if (slotBlendMode != blendMode) {
                    if (slotBlendMode == BlendMode.additive && pmaColors) {
                        slotBlendMode = BlendMode.normal;
                        alpha = 0.0f;
                    }
                    blendMode = slotBlendMode;
                    blendMode.apply(batch, pmaBlendModes);
                }
                float c = NumberUtils.intToFloatColor((int)alpha << 24 | (int)(b * slotColor.b * color.b * multiplier) << 16 | (int)(g * slotColor.g * color.g * multiplier) << 8 | (int)(r * slotColor.r * color.r * multiplier));
                float[] uvs = region.getUVs();
                int u = 0;
                int v = 2;
                while (u < 8) {
                    vertices[v] = c;
                    vertices[v + 1] = uvs[u];
                    vertices[v + 2] = uvs[u + 1];
                    u += 2;
                    v += 5;
                }
                batch.draw(region.getRegion().getTexture(), vertices, 0, 20);
                continue;
            }
            if (attachment instanceof ClippingAttachment) {
                throw new RuntimeException(batch.getClass().getSimpleName() + " cannot perform clipping, PolygonSpriteBatch or TwoColorPolygonBatch is required.");
            }
            if (attachment instanceof MeshAttachment) {
                throw new RuntimeException(batch.getClass().getSimpleName() + " cannot render meshes, PolygonSpriteBatch or TwoColorPolygonBatch is required.");
            }
            if (!(attachment instanceof SkeletonAttachment) || (attachmentSkeleton = ((SkeletonAttachment)attachment).getSkeleton()) == null) continue;
            this.draw(batch, attachmentSkeleton);
        }
    }

    public void draw(PolygonSpriteBatch batch, Skeleton skeleton) {
        if (batch == null) {
            throw new IllegalArgumentException("batch cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        boolean pmaColors = this.pmaColors;
        boolean pmaBlendModes = this.pmaBlendModes;
        BlendMode blendMode = null;
        int verticesLength = 0;
        float[] vertices = null;
        float[] uvs = null;
        short[] triangles = null;
        Color color = null;
        Color skeletonColor = skeleton.color;
        float r = skeletonColor.r;
        float g = skeletonColor.g;
        float b = skeletonColor.b;
        float a = skeletonColor.a;
        T[] drawOrder = skeleton.drawOrder.items;
        int n2 = skeleton.drawOrder.size;
        for (int i = 0; i < n2; ++i) {
            Slot slot = (Slot)drawOrder[i];
            if (!slot.bone.active) {
                this.clipper.clipEnd(slot);
                continue;
            }
            Texture texture = null;
            int vertexSize = this.clipper.isClipping() ? 2 : 5;
            Attachment attachment = slot.attachment;
            if (attachment instanceof RegionAttachment) {
                RegionAttachment region = (RegionAttachment)attachment;
                verticesLength = vertexSize << 2;
                vertices = this.vertices.items;
                region.computeWorldVertices(slot, vertices, 0, vertexSize);
                triangles = quadTriangles;
                texture = region.getRegion().getTexture();
                uvs = region.getUVs();
                color = region.getColor();
            } else if (attachment instanceof MeshAttachment) {
                MeshAttachment mesh = (MeshAttachment)attachment;
                int count = mesh.getWorldVerticesLength();
                verticesLength = (count >> 1) * vertexSize;
                vertices = this.vertices.setSize(verticesLength);
                mesh.computeWorldVertices(slot, 0, count, vertices, 0, vertexSize);
                triangles = mesh.getTriangles();
                texture = mesh.getRegion().getTexture();
                uvs = mesh.getUVs();
                color = mesh.getColor();
            } else {
                Skeleton attachmentSkeleton;
                if (attachment instanceof ClippingAttachment) {
                    ClippingAttachment clip = (ClippingAttachment)attachment;
                    this.clipper.clipStart(slot, clip);
                    continue;
                }
                if (attachment instanceof SkeletonAttachment && (attachmentSkeleton = ((SkeletonAttachment)attachment).getSkeleton()) != null) {
                    this.draw(batch, attachmentSkeleton);
                }
            }
            if (texture != null) {
                Color slotColor = slot.getColor();
                float alpha = a * slotColor.a * color.a * 255.0f;
                float multiplier = pmaColors ? alpha : 255.0f;
                BlendMode slotBlendMode = slot.data.getBlendMode();
                if (slotBlendMode != blendMode) {
                    if (slotBlendMode == BlendMode.additive && pmaColors) {
                        slotBlendMode = BlendMode.normal;
                        alpha = 0.0f;
                    }
                    blendMode = slotBlendMode;
                    blendMode.apply(batch, pmaBlendModes);
                }
                float c = NumberUtils.intToFloatColor((int)alpha << 24 | (int)(b * slotColor.b * color.b * multiplier) << 16 | (int)(g * slotColor.g * color.g * multiplier) << 8 | (int)(r * slotColor.r * color.r * multiplier));
                if (this.clipper.isClipping()) {
                    this.clipper.clipTriangles(vertices, triangles, triangles.length, uvs, c, 0.0f, false);
                    FloatArray clippedVertices = this.clipper.getClippedVertices();
                    ShortArray clippedTriangles = this.clipper.getClippedTriangles();
                    batch.draw(texture, clippedVertices.items, 0, clippedVertices.size, clippedTriangles.items, 0, clippedTriangles.size);
                } else {
                    int v = 2;
                    int u = 0;
                    while (v < verticesLength) {
                        vertices[v] = c;
                        vertices[v + 1] = uvs[u];
                        vertices[v + 2] = uvs[u + 1];
                        v += 5;
                        u += 2;
                    }
                    batch.draw(texture, vertices, 0, verticesLength, triangles, 0, triangles.length);
                }
            }
            this.clipper.clipEnd(slot);
        }
        this.clipper.clipEnd();
    }

    public void draw(TwoColorPolygonBatch batch, Skeleton skeleton) {
        if (batch == null) {
            throw new IllegalArgumentException("batch cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        boolean pmaColors = this.pmaColors;
        boolean pmaBlendModes = this.pmaBlendModes;
        batch.setPremultipliedAlpha(pmaColors);
        BlendMode blendMode = null;
        int verticesLength = 0;
        float[] vertices = null;
        float[] uvs = null;
        short[] triangles = null;
        Color color = null;
        Color skeletonColor = skeleton.color;
        float r = skeletonColor.r;
        float g = skeletonColor.g;
        float b = skeletonColor.b;
        float a = skeletonColor.a;
        T[] drawOrder = skeleton.drawOrder.items;
        int n2 = skeleton.drawOrder.size;
        for (int i = 0; i < n2; ++i) {
            Slot slot = (Slot)drawOrder[i];
            if (!slot.bone.active) {
                this.clipper.clipEnd(slot);
                continue;
            }
            Texture texture = null;
            int vertexSize = this.clipper.isClipping() ? 2 : 6;
            Attachment attachment = slot.attachment;
            if (attachment instanceof RegionAttachment) {
                RegionAttachment region = (RegionAttachment)attachment;
                verticesLength = vertexSize << 2;
                vertices = this.vertices.items;
                region.computeWorldVertices(slot, vertices, 0, vertexSize);
                triangles = quadTriangles;
                texture = region.getRegion().getTexture();
                uvs = region.getUVs();
                color = region.getColor();
            } else if (attachment instanceof MeshAttachment) {
                MeshAttachment mesh = (MeshAttachment)attachment;
                int count = mesh.getWorldVerticesLength();
                verticesLength = (count >> 1) * vertexSize;
                vertices = this.vertices.setSize(verticesLength);
                mesh.computeWorldVertices(slot, 0, count, vertices, 0, vertexSize);
                triangles = mesh.getTriangles();
                texture = mesh.getRegion().getTexture();
                uvs = mesh.getUVs();
                color = mesh.getColor();
            } else {
                Skeleton attachmentSkeleton;
                if (attachment instanceof ClippingAttachment) {
                    ClippingAttachment clip = (ClippingAttachment)attachment;
                    this.clipper.clipStart(slot, clip);
                    continue;
                }
                if (attachment instanceof SkeletonAttachment && (attachmentSkeleton = ((SkeletonAttachment)attachment).getSkeleton()) != null) {
                    this.draw(batch, attachmentSkeleton);
                }
            }
            if (texture != null) {
                float dark;
                Color lightColor = slot.getColor();
                float alpha = a * lightColor.a * color.a * 255.0f;
                float multiplier = pmaColors ? alpha : 255.0f;
                BlendMode slotBlendMode = slot.data.getBlendMode();
                if (slotBlendMode != blendMode) {
                    if (slotBlendMode == BlendMode.additive && pmaColors) {
                        slotBlendMode = BlendMode.normal;
                        alpha = 0.0f;
                    }
                    blendMode = slotBlendMode;
                    blendMode.apply(batch, pmaBlendModes);
                }
                float red = r * color.r * multiplier;
                float green = g * color.g * multiplier;
                float blue = b * color.b * multiplier;
                float light = NumberUtils.intToFloatColor((int)alpha << 24 | (int)(blue * lightColor.b) << 16 | (int)(green * lightColor.g) << 8 | (int)(red * lightColor.r));
                Color darkColor = slot.getDarkColor();
                float f2 = dark = darkColor == null ? 0.0f : NumberUtils.intToFloatColor((int)(blue * darkColor.b) << 16 | (int)(green * darkColor.g) << 8 | (int)(red * darkColor.r));
                if (this.clipper.isClipping()) {
                    this.clipper.clipTriangles(vertices, triangles, triangles.length, uvs, light, dark, true);
                    FloatArray clippedVertices = this.clipper.getClippedVertices();
                    ShortArray clippedTriangles = this.clipper.getClippedTriangles();
                    batch.drawTwoColor(texture, clippedVertices.items, 0, clippedVertices.size, clippedTriangles.items, 0, clippedTriangles.size);
                } else {
                    int v = 2;
                    int u = 0;
                    while (v < verticesLength) {
                        vertices[v] = light;
                        vertices[v + 1] = dark;
                        vertices[v + 2] = uvs[u];
                        vertices[v + 3] = uvs[u + 1];
                        v += 6;
                        u += 2;
                    }
                    batch.drawTwoColor(texture, vertices, 0, verticesLength, triangles, 0, triangles.length);
                }
            }
            this.clipper.clipEnd(slot);
        }
        this.clipper.clipEnd();
    }

    public boolean getPremultipliedAlphaColors() {
        return this.pmaColors;
    }

    public void setPremultipliedAlphaColors(boolean pmaColors) {
        this.pmaColors = pmaColors;
    }

    public boolean getPremultipliedAlphaBlendModes() {
        return this.pmaBlendModes;
    }

    public void setPremultipliedAlphaBlendModes(boolean pmaBlendModes) {
        this.pmaBlendModes = pmaBlendModes;
    }

    public void setPremultipliedAlpha(boolean pmaColorsAndBlendModes) {
        this.pmaColors = pmaColorsAndBlendModes;
        this.pmaBlendModes = pmaColorsAndBlendModes;
    }

    public SkeletonClipping getSkeletonClipping() {
        return this.clipper;
    }
}

