/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.TransformConstraintData;
import com.esotericsoftware.spine.Updatable;
import com.esotericsoftware.spine.utils.SpineUtils;

public class TransformConstraint
implements Updatable {
    final TransformConstraintData data;
    final Array<Bone> bones;
    Bone target;
    float mixRotate;
    float mixX;
    float mixY;
    float mixScaleX;
    float mixScaleY;
    float mixShearY;
    boolean active;
    final Vector2 temp = new Vector2();

    public TransformConstraint(TransformConstraintData data, Skeleton skeleton) {
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        this.data = data;
        this.bones = new Array(data.bones.size);
        for (BoneData boneData : data.bones) {
            this.bones.add(skeleton.bones.get(boneData.index));
        }
        this.target = skeleton.bones.get(data.target.index);
        this.mixRotate = data.mixRotate;
        this.mixX = data.mixX;
        this.mixY = data.mixY;
        this.mixScaleX = data.mixScaleX;
        this.mixScaleY = data.mixScaleY;
        this.mixShearY = data.mixShearY;
    }

    public TransformConstraint(TransformConstraint constraint, Skeleton skeleton) {
        this(constraint.data, skeleton);
        this.mixRotate = constraint.mixRotate;
        this.mixX = constraint.mixX;
        this.mixY = constraint.mixY;
        this.mixScaleX = constraint.mixScaleX;
        this.mixScaleY = constraint.mixScaleY;
        this.mixShearY = constraint.mixShearY;
    }

    public void setToSetupPose() {
        TransformConstraintData data = this.data;
        this.mixRotate = data.mixRotate;
        this.mixX = data.mixX;
        this.mixY = data.mixY;
        this.mixScaleX = data.mixScaleX;
        this.mixScaleY = data.mixScaleY;
        this.mixShearY = data.mixShearY;
    }

    @Override
    public void update(Skeleton.Physics physics) {
        if (this.mixRotate == 0.0f && this.mixX == 0.0f && this.mixY == 0.0f && this.mixScaleX == 0.0f && this.mixScaleY == 0.0f && this.mixShearY == 0.0f) {
            return;
        }
        if (this.data.local) {
            if (this.data.relative) {
                this.applyRelativeLocal();
            } else {
                this.applyAbsoluteLocal();
            }
        } else if (this.data.relative) {
            this.applyRelativeWorld();
        } else {
            this.applyAbsoluteWorld();
        }
    }

    private void applyAbsoluteWorld() {
        float mixRotate = this.mixRotate;
        float mixX = this.mixX;
        float mixY = this.mixY;
        float mixScaleX = this.mixScaleX;
        float mixScaleY = this.mixScaleY;
        float mixShearY = this.mixShearY;
        boolean translate = mixX != 0.0f || mixY != 0.0f;
        Bone target = this.target;
        float ta = target.a;
        float tb = target.b;
        float tc = target.c;
        float td = target.d;
        float degRadReflect = ta * td - tb * tc > 0.0f ? (float)Math.PI / 180 : (float)(-Math.PI) / 180;
        float offsetRotation = this.data.offsetRotation * degRadReflect;
        float offsetShearY = this.data.offsetShearY * degRadReflect;
        T[] bones = this.bones.items;
        int n2 = this.bones.size;
        for (int i = 0; i < n2; ++i) {
            float s;
            Bone bone = (Bone)bones[i];
            if (mixRotate != 0.0f) {
                float a = bone.a;
                float b = bone.b;
                float c = bone.c;
                float d2 = bone.d;
                float r = SpineUtils.atan2(tc, ta) - SpineUtils.atan2(c, a) + offsetRotation;
                if (r > (float)Math.PI) {
                    r -= (float)Math.PI * 2;
                } else if (r < (float)(-Math.PI)) {
                    r += (float)Math.PI * 2;
                }
                float cos = SpineUtils.cos(r *= mixRotate);
                float sin = SpineUtils.sin(r);
                bone.a = cos * a - sin * c;
                bone.b = cos * b - sin * d2;
                bone.c = sin * a + cos * c;
                bone.d = sin * b + cos * d2;
            }
            if (translate) {
                Vector2 temp = this.temp;
                target.localToWorld(temp.set(this.data.offsetX, this.data.offsetY));
                bone.worldX += (temp.x - bone.worldX) * mixX;
                bone.worldY += (temp.y - bone.worldY) * mixY;
            }
            if (mixScaleX != 0.0f) {
                s = (float)Math.sqrt(bone.a * bone.a + bone.c * bone.c);
                if (s != 0.0f) {
                    s = (s + ((float)Math.sqrt(ta * ta + tc * tc) - s + this.data.offsetScaleX) * mixScaleX) / s;
                }
                bone.a *= s;
                bone.c *= s;
            }
            if (mixScaleY != 0.0f) {
                s = (float)Math.sqrt(bone.b * bone.b + bone.d * bone.d);
                if (s != 0.0f) {
                    s = (s + ((float)Math.sqrt(tb * tb + td * td) - s + this.data.offsetScaleY) * mixScaleY) / s;
                }
                bone.b *= s;
                bone.d *= s;
            }
            if (mixShearY > 0.0f) {
                float b = bone.b;
                float d3 = bone.d;
                float by = SpineUtils.atan2(d3, b);
                float r = SpineUtils.atan2(td, tb) - SpineUtils.atan2(tc, ta) - (by - SpineUtils.atan2(bone.c, bone.a));
                if (r > (float)Math.PI) {
                    r -= (float)Math.PI * 2;
                } else if (r < (float)(-Math.PI)) {
                    r += (float)Math.PI * 2;
                }
                r = by + (r + offsetShearY) * mixShearY;
                float s2 = (float)Math.sqrt(b * b + d3 * d3);
                bone.b = SpineUtils.cos(r) * s2;
                bone.d = SpineUtils.sin(r) * s2;
            }
            bone.updateAppliedTransform();
        }
    }

    private void applyRelativeWorld() {
        float mixRotate = this.mixRotate;
        float mixX = this.mixX;
        float mixY = this.mixY;
        float mixScaleX = this.mixScaleX;
        float mixScaleY = this.mixScaleY;
        float mixShearY = this.mixShearY;
        boolean translate = mixX != 0.0f || mixY != 0.0f;
        Bone target = this.target;
        float ta = target.a;
        float tb = target.b;
        float tc = target.c;
        float td = target.d;
        float degRadReflect = ta * td - tb * tc > 0.0f ? (float)Math.PI / 180 : (float)(-Math.PI) / 180;
        float offsetRotation = this.data.offsetRotation * degRadReflect;
        float offsetShearY = this.data.offsetShearY * degRadReflect;
        T[] bones = this.bones.items;
        int n2 = this.bones.size;
        for (int i = 0; i < n2; ++i) {
            float s;
            float b;
            Bone bone = (Bone)bones[i];
            if (mixRotate != 0.0f) {
                float a = bone.a;
                b = bone.b;
                float c = bone.c;
                float d2 = bone.d;
                float r = SpineUtils.atan2(tc, ta) + offsetRotation;
                if (r > (float)Math.PI) {
                    r -= (float)Math.PI * 2;
                } else if (r < (float)(-Math.PI)) {
                    r += (float)Math.PI * 2;
                }
                float cos = SpineUtils.cos(r *= mixRotate);
                float sin = SpineUtils.sin(r);
                bone.a = cos * a - sin * c;
                bone.b = cos * b - sin * d2;
                bone.c = sin * a + cos * c;
                bone.d = sin * b + cos * d2;
            }
            if (translate) {
                Vector2 temp = this.temp;
                target.localToWorld(temp.set(this.data.offsetX, this.data.offsetY));
                bone.worldX += temp.x * mixX;
                bone.worldY += temp.y * mixY;
            }
            if (mixScaleX != 0.0f) {
                s = ((float)Math.sqrt(ta * ta + tc * tc) - 1.0f + this.data.offsetScaleX) * mixScaleX + 1.0f;
                bone.a *= s;
                bone.c *= s;
            }
            if (mixScaleY != 0.0f) {
                s = ((float)Math.sqrt(tb * tb + td * td) - 1.0f + this.data.offsetScaleY) * mixScaleY + 1.0f;
                bone.b *= s;
                bone.d *= s;
            }
            if (mixShearY > 0.0f) {
                float r = SpineUtils.atan2(td, tb) - SpineUtils.atan2(tc, ta);
                if (r > (float)Math.PI) {
                    r -= (float)Math.PI * 2;
                } else if (r < (float)(-Math.PI)) {
                    r += (float)Math.PI * 2;
                }
                b = bone.b;
                float d3 = bone.d;
                r = SpineUtils.atan2(d3, b) + (r - 1.5707964f + offsetShearY) * mixShearY;
                float s2 = (float)Math.sqrt(b * b + d3 * d3);
                bone.b = SpineUtils.cos(r) * s2;
                bone.d = SpineUtils.sin(r) * s2;
            }
            bone.updateAppliedTransform();
        }
    }

    private void applyAbsoluteLocal() {
        float mixRotate = this.mixRotate;
        float mixX = this.mixX;
        float mixY = this.mixY;
        float mixScaleX = this.mixScaleX;
        float mixScaleY = this.mixScaleY;
        float mixShearY = this.mixShearY;
        Bone target = this.target;
        T[] bones = this.bones.items;
        int n2 = this.bones.size;
        for (int i = 0; i < n2; ++i) {
            Bone bone = (Bone)bones[i];
            float rotation = bone.arotation;
            if (mixRotate != 0.0f) {
                rotation += (target.arotation - rotation + this.data.offsetRotation) * mixRotate;
            }
            float x = bone.ax;
            float y = bone.ay;
            x += (target.ax - x + this.data.offsetX) * mixX;
            y += (target.ay - y + this.data.offsetY) * mixY;
            float scaleX = bone.ascaleX;
            float scaleY = bone.ascaleY;
            if (mixScaleX != 0.0f && scaleX != 0.0f) {
                scaleX = (scaleX + (target.ascaleX - scaleX + this.data.offsetScaleX) * mixScaleX) / scaleX;
            }
            if (mixScaleY != 0.0f && scaleY != 0.0f) {
                scaleY = (scaleY + (target.ascaleY - scaleY + this.data.offsetScaleY) * mixScaleY) / scaleY;
            }
            float shearY = bone.ashearY;
            if (mixShearY != 0.0f) {
                shearY += (target.ashearY - shearY + this.data.offsetShearY) * mixShearY;
            }
            bone.updateWorldTransform(x, y, rotation, scaleX, scaleY, bone.ashearX, shearY);
        }
    }

    private void applyRelativeLocal() {
        float mixRotate = this.mixRotate;
        float mixX = this.mixX;
        float mixY = this.mixY;
        float mixScaleX = this.mixScaleX;
        float mixScaleY = this.mixScaleY;
        float mixShearY = this.mixShearY;
        Bone target = this.target;
        T[] bones = this.bones.items;
        int n2 = this.bones.size;
        for (int i = 0; i < n2; ++i) {
            Bone bone = (Bone)bones[i];
            float rotation = bone.arotation + (target.arotation + this.data.offsetRotation) * mixRotate;
            float x = bone.ax + (target.ax + this.data.offsetX) * mixX;
            float y = bone.ay + (target.ay + this.data.offsetY) * mixY;
            float scaleX = bone.ascaleX * ((target.ascaleX - 1.0f + this.data.offsetScaleX) * mixScaleX + 1.0f);
            float scaleY = bone.ascaleY * ((target.ascaleY - 1.0f + this.data.offsetScaleY) * mixScaleY + 1.0f);
            float shearY = bone.ashearY + (target.ashearY + this.data.offsetShearY) * mixShearY;
            bone.updateWorldTransform(x, y, rotation, scaleX, scaleY, bone.ashearX, shearY);
        }
    }

    public Array<Bone> getBones() {
        return this.bones;
    }

    public Bone getTarget() {
        return this.target;
    }

    public void setTarget(Bone target) {
        if (target == null) {
            throw new IllegalArgumentException("target cannot be null.");
        }
        this.target = target;
    }

    public float getMixRotate() {
        return this.mixRotate;
    }

    public void setMixRotate(float mixRotate) {
        this.mixRotate = mixRotate;
    }

    public float getMixX() {
        return this.mixX;
    }

    public void setMixX(float mixX) {
        this.mixX = mixX;
    }

    public float getMixY() {
        return this.mixY;
    }

    public void setMixY(float mixY) {
        this.mixY = mixY;
    }

    public float getMixScaleX() {
        return this.mixScaleX;
    }

    public void setMixScaleX(float mixScaleX) {
        this.mixScaleX = mixScaleX;
    }

    public float getMixScaleY() {
        return this.mixScaleY;
    }

    public void setMixScaleY(float mixScaleY) {
        this.mixScaleY = mixScaleY;
    }

    public float getMixShearY() {
        return this.mixShearY;
    }

    public void setMixShearY(float mixShearY) {
        this.mixShearY = mixShearY;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public TransformConstraintData getData() {
        return this.data;
    }

    public String toString() {
        return this.data.name;
    }
}

