/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine.attachments;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.utils.SpineUtils;

public class PointAttachment
extends Attachment {
    float x;
    float y;
    float rotation;
    final Color color = new Color(0.9451f, 0.9451f, 0.0f, 1.0f);

    public PointAttachment(String name) {
        super(name);
    }

    protected PointAttachment(PointAttachment other) {
        super(other);
        this.x = other.x;
        this.y = other.y;
        this.rotation = other.rotation;
        this.color.set(other.color);
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    public Color getColor() {
        return this.color;
    }

    public Vector2 computeWorldPosition(Bone bone, Vector2 point) {
        point.x = this.x * bone.getA() + this.y * bone.getB() + bone.getWorldX();
        point.y = this.x * bone.getC() + this.y * bone.getD() + bone.getWorldY();
        return point;
    }

    public float computeWorldRotation(Bone bone) {
        float r = this.rotation * ((float)Math.PI / 180);
        float cos = SpineUtils.cos(r);
        float sin = SpineUtils.sin(r);
        float x = cos * bone.getA() + sin * bone.getB();
        float y = cos * bone.getC() + sin * bone.getD();
        return SpineUtils.atan2Deg(y, x);
    }

    @Override
    public PointAttachment copy() {
        return new PointAttachment(this);
    }
}

