/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.ansi;

import java.util.Locale;
import net.kyori.ansi.JAnsiColorLevel;
import org.jetbrains.annotations.NotNull;

public enum ColorLevel {
    NONE{

        @Override
        @NotNull
        public String determineEscape(int rgb) {
            return "";
        }
    }
    ,
    TRUE_COLOR{

        @Override
        @NotNull
        public String determineEscape(int rgb) {
            return "38;2;" + (rgb >> 16 & 0xFF) + ';' + (rgb >> 8 & 0xFF) + ';' + (rgb & 0xFF);
        }
    }
    ,
    INDEXED_256{

        @Override
        @NotNull
        public String determineEscape(int rgbColor) {
            if (indexed256ColorTable == null) {
                ColorLevel.access$102(new int[256]);
                for (int i = 0; i < indexed256ColorTable.length; ++i) {
                    int blue;
                    int green;
                    int red;
                    if (i < 16) {
                        indexed256ColorTable[i] = StandardColor.values()[i].color;
                        continue;
                    }
                    if (i < 232) {
                        int j = i - 16;
                        int r = j / 36;
                        int g = j / 6 % 6;
                        int b = j % 6;
                        red = r == 0 ? 0 : r * 40 + 55;
                        green = g == 0 ? 0 : g * 40 + 55;
                        blue = b == 0 ? 0 : b * 40 + 55;
                    } else {
                        int grayscale;
                        red = grayscale = 8 + (i - 232) * 10;
                        green = grayscale;
                        blue = grayscale;
                    }
                    indexed256ColorTable[i] = red << 16 | green << 8 | blue;
                }
            }
            int idx = -1;
            int bestDistance = Integer.MAX_VALUE;
            int r1 = rgbColor >> 16 & 0xFF;
            int g1 = rgbColor >> 8 & 0xFF;
            int b1 = rgbColor & 0xFF;
            for (int i = 0; i < indexed256ColorTable.length; ++i) {
                int r2 = indexed256ColorTable[i] >> 16 & 0xFF;
                int g2 = indexed256ColorTable[i] >> 8 & 0xFF;
                int b2 = indexed256ColorTable[i] & 0xFF;
                int distance = Math.abs(r1 - r2) + Math.abs(g1 - g2) + Math.abs(b1 - b2);
                if (distance < bestDistance) {
                    bestDistance = distance;
                    idx = i;
                }
                if (distance == 0) break;
            }
            return "38;5;" + idx;
        }
    }
    ,
    INDEXED_16{

        @Override
        @NotNull
        public String determineEscape(int rgbColor) {
            return ColorLevel.findClosestColorEscape(rgbColor, StandardColor.VALUES_INDEXED16);
        }
    }
    ,
    INDEXED_8{

        @Override
        @NotNull
        public String determineEscape(int rgbColor) {
            return ColorLevel.findClosestColorEscape(rgbColor, StandardColor.VALUES_INDEXED8);
        }
    };

    public static final String COLOR_LEVEL_PROPERTY = "net.kyori.ansi.colorLevel";
    public static final String TERMINAL_ANSI_OVERRIDE_PROPERTY = "terminal.ansi";
    private static final String COLORTERM;
    private static final String TERM;
    private static final String WT_SESSION;
    private static int[] indexed256ColorTable;

    @NotNull
    public static ColorLevel compute() {
        String terminalAnsiPropertyValue;
        String colorLevelPropertyValue = System.getProperty(COLOR_LEVEL_PROPERTY);
        if (colorLevelPropertyValue != null) {
            switch (colorLevelPropertyValue.toLowerCase(Locale.ROOT)) {
                case "none": {
                    return NONE;
                }
                case "truecolor": {
                    return TRUE_COLOR;
                }
                case "indexed256": {
                    return INDEXED_256;
                }
                case "indexed16": {
                    return INDEXED_16;
                }
                case "indexed8": {
                    return INDEXED_8;
                }
            }
        }
        if ((terminalAnsiPropertyValue = System.getProperty(TERMINAL_ANSI_OVERRIDE_PROPERTY)) != null && terminalAnsiPropertyValue.equals("false")) {
            return NONE;
        }
        if (COLORTERM != null && (COLORTERM.equals("truecolor") || COLORTERM.equals("24bit"))) {
            return TRUE_COLOR;
        }
        if (TERM != null && TERM.contains("truecolor")) {
            return TRUE_COLOR;
        }
        if (TERM != null && TERM.contains("256color")) {
            return INDEXED_256;
        }
        if (TERM == null) {
            if (WT_SESSION != null) {
                return TRUE_COLOR;
            }
            if (System.console() != null && JAnsiColorLevel.isAvailable()) {
                return JAnsiColorLevel.computeFromJAnsi();
            }
            return NONE;
        }
        return INDEXED_16;
    }

    @NotNull
    public abstract String determineEscape(int var1);

    private static String findClosestColorEscape(int rgbColor, StandardColor[] potentialColors) {
        float matchedDistance = Float.MAX_VALUE;
        StandardColor match = StandardColor.BLACK;
        for (StandardColor potential : potentialColors) {
            float distance = HSV.fromRGB(rgbColor).distance(HSV.fromRGB(potential.color));
            if (distance < matchedDistance) {
                match = potential;
                matchedDistance = distance;
            }
            if (distance == 0.0f) break;
        }
        return match.index;
    }

    static /* synthetic */ int[] access$102(int[] x0) {
        indexed256ColorTable = x0;
        return x0;
    }

    static {
        COLORTERM = System.getenv("COLORTERM");
        TERM = System.getenv("TERM");
        WT_SESSION = System.getenv("WT_SESSION");
        indexed256ColorTable = null;
    }

    private static class HSV {
        float h;
        float s;
        float v;

        HSV(float h2, float s, float v) {
            this.h = h2;
            this.s = s;
            this.v = v;
        }

        private float distance(@NotNull HSV other) {
            float hueDistance = 3.0f * Math.min(Math.abs(this.h - other.h), 1.0f - Math.abs(this.h - other.h));
            float saturationDiff = this.s - other.s;
            float valueDiff = this.v - other.v;
            return hueDistance * hueDistance + saturationDiff * saturationDiff + valueDiff * valueDiff;
        }

        private static HSV fromRGB(int rgb) {
            float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
            float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
            float b = (float)(rgb & 0xFF) / 255.0f;
            float min = Math.min(r, Math.min(g, b));
            float max = Math.max(r, Math.max(g, b));
            float delta = max - min;
            float s = max != 0.0f ? delta / max : 0.0f;
            if (s == 0.0f) {
                return new HSV(0.0f, s, max);
            }
            float h2 = r == max ? (g - b) / delta : (g == max ? 2.0f + (b - r) / delta : 4.0f + (r - g) / delta);
            if ((h2 *= 60.0f) < 0.0f) {
                h2 += 360.0f;
            }
            return new HSV(h2 / 360.0f, s, max);
        }
    }

    private static enum StandardColor {
        BLACK(0, "30"),
        DARK_RED(0xAA0000, "31"),
        DARK_GREEN(43520, "32"),
        GOLD(0xFFAA00, "33"),
        DARK_BLUE(170, "34"),
        DARK_PURPLE(0xAA00AA, "35"),
        DARK_AQUA(43690, "36"),
        GRAY(0xAAAAAA, "37"),
        DARK_GRAY(0x555555, "90"),
        RED(0xFF5555, "91"),
        GREEN(0x55FF55, "92"),
        YELLOW(0xFFFF55, "93"),
        BLUE(0x5555FF, "94"),
        LIGHT_PURPLE(0xFF55FF, "95"),
        AQUA(0x55FFFF, "96"),
        WHITE(0xFFFFFF, "97");

        static final StandardColor[] VALUES_INDEXED16;
        static final StandardColor[] VALUES_INDEXED8;
        final int color;
        final String index;

        private StandardColor(int color, String index) {
            this.color = color;
            this.index = index;
        }

        static {
            VALUES_INDEXED16 = StandardColor.values();
            StandardColor[] indexed8 = new StandardColor[8];
            System.arraycopy(StandardColor.values(), 0, indexed8, 0, 8);
            VALUES_INDEXED8 = indexed8;
        }
    }
}

