/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.chat;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.ComponentStyle;
import net.md_5.bungee.api.chat.ComponentStyleBuilder;

public class ComponentStyleSerializer
implements JsonSerializer<ComponentStyle>,
JsonDeserializer<ComponentStyle> {
    private static boolean getAsBoolean(JsonElement el) {
        if (el.isJsonPrimitive()) {
            Number number;
            JsonPrimitive primitive = (JsonPrimitive)el;
            if (primitive.isBoolean()) {
                return primitive.getAsBoolean();
            }
            if (primitive.isNumber() && (number = primitive.getAsNumber()) instanceof Byte) {
                return number.byteValue() != 0;
            }
        }
        return false;
    }

    static void serializeTo(ComponentStyle style2, JsonObject object) {
        if (style2.isBoldRaw() != null) {
            object.addProperty("bold", style2.isBoldRaw());
        }
        if (style2.isItalicRaw() != null) {
            object.addProperty("italic", style2.isItalicRaw());
        }
        if (style2.isUnderlinedRaw() != null) {
            object.addProperty("underlined", style2.isUnderlinedRaw());
        }
        if (style2.isStrikethroughRaw() != null) {
            object.addProperty("strikethrough", style2.isStrikethroughRaw());
        }
        if (style2.isObfuscatedRaw() != null) {
            object.addProperty("obfuscated", style2.isObfuscatedRaw());
        }
        if (style2.hasColor()) {
            object.addProperty("color", style2.getColor().getName());
        }
        if (style2.hasFont()) {
            object.addProperty("font", style2.getFont());
        }
    }

    public ComponentStyle deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        ComponentStyleBuilder builder = ComponentStyle.builder();
        JsonObject object = json.getAsJsonObject();
        if (object.has("bold")) {
            builder.bold(ComponentStyleSerializer.getAsBoolean(object.get("bold")));
        }
        if (object.has("italic")) {
            builder.italic(ComponentStyleSerializer.getAsBoolean(object.get("italic")));
        }
        if (object.has("underlined")) {
            builder.underlined(ComponentStyleSerializer.getAsBoolean(object.get("underlined")));
        }
        if (object.has("strikethrough")) {
            builder.strikethrough(ComponentStyleSerializer.getAsBoolean(object.get("strikethrough")));
        }
        if (object.has("obfuscated")) {
            builder.obfuscated(ComponentStyleSerializer.getAsBoolean(object.get("obfuscated")));
        }
        if (object.has("color")) {
            builder.color(ChatColor.of(object.get("color").getAsString()));
        }
        if (object.has("font")) {
            builder.font(object.get("font").getAsString());
        }
        return builder.build();
    }

    public JsonElement serialize(ComponentStyle src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        ComponentStyleSerializer.serializeTo(src, object);
        return object;
    }
}

