/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.nashorn.internal;

public class IntDeque {
    private int[] deque = new int[16];
    private int nextFree = 0;

    public void push(int value) {
        if (this.nextFree == this.deque.length) {
            int[] newDeque = new int[this.nextFree * 2];
            System.arraycopy(this.deque, 0, newDeque, 0, this.nextFree);
            this.deque = newDeque;
        }
        this.deque[this.nextFree++] = value;
    }

    public int pop() {
        return this.deque[--this.nextFree];
    }

    public int peek() {
        return this.deque[this.nextFree - 1];
    }

    public int getAndIncrement() {
        int n2 = this.nextFree - 1;
        int n3 = this.deque[n2];
        this.deque[n2] = n3 + 1;
        return n3;
    }

    public int decrementAndGet() {
        int n2 = this.nextFree - 1;
        int n3 = this.deque[n2] - 1;
        this.deque[n2] = n3;
        return n3;
    }

    public boolean isEmpty() {
        return this.nextFree == 0;
    }
}

