/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.media.callback;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.IOException;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_close_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_open_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_read_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_seek_cb;
import uk.co.caprica.vlcj.binding.support.types.size_t;
import uk.co.caprica.vlcj.media.callback.CallbackMedia;

public abstract class AbstractCallbackMedia
implements CallbackMedia {
    private static final int SUCCESS = 0;
    private static final int ERROR = -1;
    private static final int END_OF_STREAM = 0;
    private final boolean seekable;
    private final Open open;
    private final Read read;
    private final Seek seek;
    private final Close close;
    private final Pointer opaque;

    public AbstractCallbackMedia(boolean seekable) {
        this.seekable = seekable;
        this.open = new Open();
        this.read = new Read();
        this.seek = seekable ? new Seek() : null;
        this.close = new Close();
        this.opaque = null;
    }

    public final boolean isSeekable() {
        return this.seekable;
    }

    protected abstract long onGetSize();

    protected abstract boolean onOpen();

    protected abstract int onRead(Pointer var1, int var2) throws IOException;

    protected abstract boolean onSeek(long var1);

    protected abstract void onClose();

    @Override
    public final libvlc_media_open_cb getOpen() {
        return this.open;
    }

    @Override
    public final libvlc_media_read_cb getRead() {
        return this.read;
    }

    @Override
    public final libvlc_media_seek_cb getSeek() {
        return this.seek;
    }

    @Override
    public final libvlc_media_close_cb getClose() {
        return this.close;
    }

    @Override
    public final Pointer getOpaque() {
        return this.opaque;
    }

    private class Close
    implements libvlc_media_close_cb {
        private Close() {
        }

        @Override
        public void close(Pointer opaque) {
            AbstractCallbackMedia.this.onClose();
        }
    }

    private class Seek
    implements libvlc_media_seek_cb {
        private Seek() {
        }

        @Override
        public int seek(Pointer opaque, long offset) {
            return AbstractCallbackMedia.this.onSeek(offset) ? 0 : -1;
        }
    }

    private class Read
    implements libvlc_media_read_cb {
        private Read() {
        }

        @Override
        public size_t read(Pointer opaque, Pointer buf, size_t len) {
            int result;
            try {
                int bytesRead = AbstractCallbackMedia.this.onRead(buf, len.intValue());
                result = bytesRead >= 0 ? bytesRead : 0;
            }
            catch (IOException e) {
                result = -1;
            }
            return new size_t(result);
        }
    }

    private class Open
    implements libvlc_media_open_cb {
        private Open() {
        }

        @Override
        public int open(Pointer opaque, PointerByReference datap, LongByReference sizep) {
            sizep.setValue(AbstractCallbackMedia.this.onGetSize());
            return AbstractCallbackMedia.this.onOpen() ? 0 : -1;
        }
    }
}

