/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.component;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import javax.swing.JComponent;
import javax.swing.JPanel;
import uk.co.caprica.vlcj.binding.support.runtime.RuntimeUtil;
import uk.co.caprica.vlcj.factory.MediaPlayerFactory;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.component.EmbeddedMediaPlayerComponentBase;
import uk.co.caprica.vlcj.player.component.InputEvents;
import uk.co.caprica.vlcj.player.component.MediaPlayerComponent;
import uk.co.caprica.vlcj.player.component.MediaPlayerComponentDefaults;
import uk.co.caprica.vlcj.player.component.MediaPlayerSpecs;
import uk.co.caprica.vlcj.player.component.callback.CallbackImagePainter;
import uk.co.caprica.vlcj.player.component.callback.ScaledCallbackImagePainter;
import uk.co.caprica.vlcj.player.embedded.EmbeddedMediaPlayer;
import uk.co.caprica.vlcj.player.embedded.fullscreen.FullScreenStrategy;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.BufferFormat;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.BufferFormatCallback;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.BufferFormatCallbackAdapter;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.RenderCallback;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.RenderCallbackAdapter;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.format.RV32BufferFormat;

public class CallbackMediaPlayerComponent
extends EmbeddedMediaPlayerComponentBase
implements MediaPlayerComponent {
    static final String[] DEFAULT_FACTORY_ARGUMENTS = MediaPlayerComponentDefaults.EMBEDDED_MEDIA_PLAYER_ARGS;
    private boolean ownFactory;
    protected final MediaPlayerFactory mediaPlayerFactory;
    private final DefaultRenderCallback defaultRenderCallback;
    private CallbackImagePainter imagePainter;
    private final JComponent videoSurfaceComponent;
    private final EmbeddedMediaPlayer mediaPlayer;
    private BufferedImage image;

    public CallbackMediaPlayerComponent(MediaPlayerFactory mediaPlayerFactory, FullScreenStrategy fullScreenStrategy, InputEvents inputEvents, boolean lockBuffers, CallbackImagePainter imagePainter, RenderCallback renderCallback, BufferFormatCallback bufferFormatCallback, JComponent videoSurfaceComponent) {
        this.ownFactory = mediaPlayerFactory == null;
        this.mediaPlayerFactory = this.initMediaPlayerFactory(mediaPlayerFactory);
        this.validateArguments(imagePainter, renderCallback, bufferFormatCallback, videoSurfaceComponent);
        if (renderCallback == null) {
            this.defaultRenderCallback = new DefaultRenderCallback();
            this.imagePainter = imagePainter == null ? new ScaledCallbackImagePainter() : imagePainter;
            this.videoSurfaceComponent = new DefaultVideoSurfaceComponent();
            bufferFormatCallback = new DefaultBufferFormatCallback();
            renderCallback = this.defaultRenderCallback;
        } else {
            this.defaultRenderCallback = null;
            this.imagePainter = null;
            this.videoSurfaceComponent = videoSurfaceComponent;
        }
        this.mediaPlayer = this.mediaPlayerFactory.mediaPlayers().newEmbeddedMediaPlayer();
        this.mediaPlayer.fullScreen().strategy(fullScreenStrategy);
        this.mediaPlayer.events().addMediaPlayerEventListener(this);
        this.mediaPlayer.events().addMediaEventListener(this);
        this.mediaPlayer.videoSurface().set(this.mediaPlayerFactory.videoSurfaces().newVideoSurface(bufferFormatCallback, renderCallback, lockBuffers));
        this.setBackground(Color.black);
        this.setLayout(new BorderLayout());
        if (this.videoSurfaceComponent != null) {
            this.add((Component)this.videoSurfaceComponent, "Center");
        }
        this.initInputEvents(inputEvents);
        this.onAfterConstruct();
    }

    public CallbackMediaPlayerComponent(MediaPlayerFactory mediaPlayerFactory, FullScreenStrategy fullScreenStrategy, InputEvents inputEvents, boolean lockBuffers, CallbackImagePainter imagePainter) {
        this(mediaPlayerFactory, fullScreenStrategy, inputEvents, lockBuffers, imagePainter, null, null, null);
    }

    public CallbackMediaPlayerComponent(MediaPlayerFactory mediaPlayerFactory, FullScreenStrategy fullScreenStrategy, InputEvents inputEvents, boolean lockBuffers, RenderCallback renderCallback, BufferFormatCallback bufferFormatCallback, JComponent videoSurfaceComponent) {
        this(mediaPlayerFactory, fullScreenStrategy, inputEvents, lockBuffers, null, renderCallback, bufferFormatCallback, videoSurfaceComponent);
    }

    public CallbackMediaPlayerComponent(MediaPlayerSpecs.CallbackMediaPlayerSpec spec) {
        this(spec.factory, spec.fullScreenStrategy, spec.inputEvents, spec.lockedBuffers, spec.imagePainter, spec.renderCallback, spec.bufferFormatCallback, spec.videoSurfaceComponent);
    }

    public CallbackMediaPlayerComponent(String ... libvlcArgs) {
        this(new MediaPlayerFactory(libvlcArgs), null, null, true, null, null, null, null);
    }

    public CallbackMediaPlayerComponent() {
        this(null, null, null, true, null, null, null, null);
    }

    private void validateArguments(CallbackImagePainter imagePainter, RenderCallback renderCallback, BufferFormatCallback bufferFormatCallback, JComponent videoSurfaceComponent) {
        if (renderCallback == null) {
            if (bufferFormatCallback != null) {
                throw new IllegalArgumentException("Do not specify bufferFormatCallback without a renderCallback");
            }
            if (videoSurfaceComponent != null) {
                throw new IllegalArgumentException("Do not specify videoSurfaceComponent without a renderCallback");
            }
        } else {
            if (imagePainter != null) {
                throw new IllegalArgumentException("Do not specify imagePainter with a renderCallback");
            }
            if (bufferFormatCallback == null) {
                throw new IllegalArgumentException("bufferFormatCallback is required with a renderCallback");
            }
        }
    }

    private MediaPlayerFactory initMediaPlayerFactory(MediaPlayerFactory mediaPlayerFactory) {
        if (mediaPlayerFactory == null) {
            mediaPlayerFactory = new MediaPlayerFactory(DEFAULT_FACTORY_ARGUMENTS);
        }
        return mediaPlayerFactory;
    }

    private void initInputEvents(InputEvents inputEvents) {
        if (inputEvents == null) {
            inputEvents = RuntimeUtil.isNix() || RuntimeUtil.isMac() ? InputEvents.DEFAULT : InputEvents.DISABLE_NATIVE;
        }
        switch (inputEvents) {
            case NONE: {
                break;
            }
            case DISABLE_NATIVE: {
                this.mediaPlayer.input().enableKeyInputHandling(false);
                this.mediaPlayer.input().enableMouseInputHandling(false);
            }
            case DEFAULT: {
                if (this.videoSurfaceComponent == null) break;
                this.videoSurfaceComponent.addMouseListener(this);
                this.videoSurfaceComponent.addMouseMotionListener(this);
                this.videoSurfaceComponent.addMouseWheelListener(this);
                this.videoSurfaceComponent.addKeyListener(this);
            }
        }
    }

    public final void setImagePainter(CallbackImagePainter imagePainter) {
        this.imagePainter = imagePainter;
    }

    public final EmbeddedMediaPlayer mediaPlayer() {
        return this.mediaPlayer;
    }

    public final JComponent videoSurfaceComponent() {
        return this.videoSurfaceComponent;
    }

    public final void release() {
        this.onBeforeRelease();
        if (this.videoSurfaceComponent != null) {
            this.videoSurfaceComponent.removeMouseListener(this);
            this.videoSurfaceComponent.removeMouseMotionListener(this);
            this.videoSurfaceComponent.removeMouseWheelListener(this);
            this.videoSurfaceComponent.removeKeyListener(this);
        }
        this.mediaPlayer.release();
        if (this.ownFactory) {
            this.mediaPlayerFactory.release();
        }
        this.onAfterRelease();
    }

    @Override
    public final MediaPlayerFactory mediaPlayerFactory() {
        return this.mediaPlayerFactory;
    }

    private void newVideoBuffer(int width, int height) {
        this.image = new BufferedImage(width, height, 1);
        this.defaultRenderCallback.setImageBuffer(this.image);
        if (this.videoSurfaceComponent != null) {
            this.videoSurfaceComponent.setPreferredSize(new Dimension(width, height));
        }
    }

    protected void onPaintOverlay(Graphics2D g2) {
    }

    private class DefaultRenderCallback
    extends RenderCallbackAdapter {
        private DefaultRenderCallback() {
        }

        private void setImageBuffer(BufferedImage image) {
            this.setBuffer(((DataBufferInt)image.getRaster().getDataBuffer()).getData());
        }

        @Override
        protected void onDisplay(MediaPlayer mediaPlayer, int[] buffer) {
            CallbackMediaPlayerComponent.this.videoSurfaceComponent.repaint();
        }
    }

    private class DefaultBufferFormatCallback
    extends BufferFormatCallbackAdapter {
        private DefaultBufferFormatCallback() {
        }

        @Override
        public BufferFormat getBufferFormat(int sourceWidth, int sourceHeight) {
            CallbackMediaPlayerComponent.this.newVideoBuffer(sourceWidth, sourceHeight);
            return new RV32BufferFormat(sourceWidth, sourceHeight);
        }
    }

    private class DefaultVideoSurfaceComponent
    extends JPanel {
        private DefaultVideoSurfaceComponent() {
            this.setBackground(Color.black);
            this.setIgnoreRepaint(true);
            this.setPreferredSize(new Dimension(640, 360));
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            CallbackMediaPlayerComponent.this.imagePainter.prepare(g2, this);
            CallbackMediaPlayerComponent.this.imagePainter.paint(g2, this, CallbackMediaPlayerComponent.this.image);
            CallbackMediaPlayerComponent.this.onPaintOverlay(g2);
        }
    }
}

