/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.bbm.converter.wrapped;

import dev.jnic.gPScUN.JNICLoader;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import yslelf.cloudpick.bbm.converter.wrapped.WrappedOutliner;
import yslelf.cloudpick.bbm.loader.element.BlockBenchElement;
import yslelf.cloudpick.bbm.loader.model.BlockBenchModel;
import yslelf.cloudpick.bbm.loader.outliner.Outliner;
import yslelf.cloudpick.bbm.loader.texture.BlockBenchTexture;

public class WrappedBBModel {
    private final BlockBenchModel handler;
    private final List<WrappedOutliner> outliners = new ArrayList<WrappedOutliner>();
    private BufferedImage texture;
    private int textureFrameTime;
    private BufferedImage glowTexture;
    private int glowTextureFrameTime;

    public WrappedBBModel(BlockBenchModel model) {
        this.handler = model;
        HashMap<UUID, BlockBenchElement> elementDict = new HashMap<UUID, BlockBenchElement>();
        for (BlockBenchElement element : model.elements()) {
            if (!element.type().equalsIgnoreCase("cube")) continue;
            elementDict.put(element.uniqueId(), element);
        }
        ArrayList<Outliner> noOutlinerElements = new ArrayList<Outliner>();
        for (Outliner outliner : model.outliner()) {
            if (outliner.name() == null) {
                noOutlinerElements.add(outliner);
                continue;
            }
            this.outliners.add(new WrappedOutliner(outliner, elementDict, null));
        }
        this.outliners.add(new WrappedOutliner(Outliner.create(noOutlinerElements), elementDict, null));
        for (BlockBenchTexture blockBenchTexture : this.handler.textures()) {
            if (blockBenchTexture.name().endsWith("glow")) {
                this.glowTexture = blockBenchTexture.image();
                this.glowTextureFrameTime = blockBenchTexture.frameTime();
                continue;
            }
            this.texture = blockBenchTexture.image();
            this.textureFrameTime = blockBenchTexture.frameTime();
        }
    }

    public native BlockBenchModel getHandler();

    public native List<WrappedOutliner> getOutliners();

    public native BufferedImage getTexture();

    public native int getTextureFrameTime();

    public native BufferedImage getGlowTexture();

    public native int getGlowTextureFrameTime();

    public static native /* synthetic */ void $jnicLoader();

    static {
        JNICLoader.init();
        WrappedBBModel.$jnicLoader();
    }
}

