/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.config;

import dev.jnic.gPScUN.JNICLoader;
import java.util.List;
import java.util.UUID;
import yslelf.cloudpick.configuration.ConfigurationSection;
import yslelf.cloudpick.graphics.graphics.drawable.Drawable;
import yslelf.cloudpick.model.ui.ViewKey;

public class FontConfig {
    protected ConfigurationSection configurationSection;
    protected String text;
    protected String path;
    protected Drawable drawable;
    protected ViewKey viewKey;
    protected String alignment;
    protected String texture;
    protected float width = 9.0f;
    protected float height = 9.0f;
    protected float fontWidth;
    protected float offsetX = 0.0f;
    protected float offsetY = 0.0f;
    protected boolean single = false;
    protected boolean color = false;
    protected List<String> permissions;
    protected boolean permissionContains = true;
    private Object glyphInfo;
    private Object bakedGlyph;
    protected String alias;

    public FontConfig(ConfigurationSection configurationSection) {
        this.configurationSection = configurationSection;
        this.text = configurationSection.getName();
        this.texture = configurationSection.getString("texture", configurationSection.getString("path", "unknown.png"));
        this.width = (float)configurationSection.getDouble("width", this.width);
        this.height = (float)configurationSection.getDouble("height", this.height);
        this.fontWidth = (float)configurationSection.getDouble("fontWidth", this.width);
        this.offsetX = (float)configurationSection.getDouble("offsetX", configurationSection.getDouble("xOffset", this.offsetX));
        this.offsetY = (float)configurationSection.getDouble("offsetY", configurationSection.getDouble("yOffset", this.offsetY));
        this.single = configurationSection.getBoolean("single", this.single);
        this.color = configurationSection.getBoolean("color", this.color);
        this.alignment = configurationSection.getString("alignment");
        this.permissions = configurationSection.getStringList("permissions");
        this.permissionContains = configurationSection.getBoolean("permissionContains", this.permissionContains);
        if (this.texture.startsWith("http://") || this.texture.startsWith("https://")) {
            this.alias = UUID.randomUUID().toString();
        }
    }

    public native ConfigurationSection getConfigurationSection();

    public native String getText();

    public native String getPath();

    public native Drawable getDrawable();

    public native ViewKey getViewKey();

    public native String getAlignment();

    public native String getTexture();

    public native float getWidth();

    public native float getHeight();

    public native float getFontWidth();

    public native float getOffsetX();

    public native float getOffsetY();

    public native boolean isSingle();

    public native boolean isColor();

    public native List<String> getPermissions();

    public native boolean isPermissionContains();

    public native Object getGlyphInfo();

    public native Object getBakedGlyph();

    public native String getAlias();

    public native void setConfigurationSection(ConfigurationSection var1);

    public native void setText(String var1);

    public native void setPath(String var1);

    public native void setDrawable(Drawable var1);

    public native void setViewKey(ViewKey var1);

    public native void setAlignment(String var1);

    public native void setTexture(String var1);

    public native void setWidth(float var1);

    public native void setHeight(float var1);

    public native void setFontWidth(float var1);

    public native void setOffsetX(float var1);

    public native void setOffsetY(float var1);

    public native void setSingle(boolean var1);

    public native void setColor(boolean var1);

    public native void setPermissions(List<String> var1);

    public native void setPermissionContains(boolean var1);

    public native void setGlyphInfo(Object var1);

    public native void setBakedGlyph(Object var1);

    public native void setAlias(String var1);

    public static native /* synthetic */ void $jnicLoader();

    static {
        JNICLoader.init();
        FontConfig.$jnicLoader();
    }
}

