/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.config;

import dev.jnic.gPScUN.JNICLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import yslelf.cloudpick.config.animation.Animation;
import yslelf.cloudpick.configuration.ConfigurationSection;

public class HolographyConfig {
    protected ConfigurationSection configurationSection;
    protected Object itemStack;
    protected String world = "";
    protected double translateX = 0.0;
    protected double translateY = 0.0;
    protected double translateZ = 0.0;
    protected float rotateY = 0.0f;
    protected float rotateX = 0.0f;
    protected float rotateZ = 0.0f;
    protected boolean through = false;
    protected boolean renderOnFirst = false;
    protected float distance = 64.0f;
    protected String path = "unknown.png";
    protected float width = 1.0f;
    protected float height = 1.0f;
    protected float alpha = 1.0f;
    protected boolean glow = false;
    protected boolean followPlayerEyes = false;
    protected UUID entity = null;
    protected boolean followEntityDirection = false;
    protected double translateEntityFront = 0.0;
    protected double translateEntityRight = 0.0;
    protected List<Animation> animationList = new ArrayList<Animation>();

    public HolographyConfig(ConfigurationSection configurationSection) {
        this.configurationSection = configurationSection;
        this.world = configurationSection.getString("world");
        this.translateX = configurationSection.getDouble("translateX", configurationSection.getDouble("x"));
        this.translateY = configurationSection.getDouble("translateY", configurationSection.getDouble("y"));
        this.translateZ = configurationSection.getDouble("translateZ", configurationSection.getDouble("z"));
        this.rotateX = (float)configurationSection.getDouble("rotateX");
        this.rotateY = (float)configurationSection.getDouble("rotateY");
        this.rotateZ = (float)configurationSection.getDouble("rotateZ");
        this.through = configurationSection.getBoolean("through", this.through);
        this.renderOnFirst = configurationSection.getBoolean("renderOnFirst", this.renderOnFirst);
        this.distance = (float)configurationSection.getDouble("distance", this.distance);
        this.path = configurationSection.getString("path");
        this.width = (float)configurationSection.getDouble("width");
        this.height = (float)configurationSection.getDouble("height");
        this.alpha = (float)configurationSection.getDouble("alpha");
        this.glow = configurationSection.getBoolean("glow");
        this.followPlayerEyes = configurationSection.getBoolean("followPlayerEyes");
        try {
            this.entity = UUID.fromString(configurationSection.getString("entity"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.followEntityDirection = configurationSection.getBoolean("followEntityDirection");
        this.translateEntityFront = configurationSection.getDouble("translateEntityFront");
        this.translateEntityRight = configurationSection.getDouble("translateEntityRight");
    }

    public native ConfigurationSection getConfigurationSection();

    public native Object getItemStack();

    public native String getWorld();

    public native double getTranslateX();

    public native double getTranslateY();

    public native double getTranslateZ();

    public native float getRotateY();

    public native float getRotateX();

    public native float getRotateZ();

    public native boolean isThrough();

    public native boolean isRenderOnFirst();

    public native float getDistance();

    public native String getPath();

    public native float getWidth();

    public native float getHeight();

    public native float getAlpha();

    public native boolean isGlow();

    public native boolean isFollowPlayerEyes();

    public native UUID getEntity();

    public native boolean isFollowEntityDirection();

    public native double getTranslateEntityFront();

    public native double getTranslateEntityRight();

    public native List<Animation> getAnimationList();

    public native void setConfigurationSection(ConfigurationSection var1);

    public native void setItemStack(Object var1);

    public native void setWorld(String var1);

    public native void setTranslateX(double var1);

    public native void setTranslateY(double var1);

    public native void setTranslateZ(double var1);

    public native void setRotateY(float var1);

    public native void setRotateX(float var1);

    public native void setRotateZ(float var1);

    public native void setThrough(boolean var1);

    public native void setRenderOnFirst(boolean var1);

    public native void setDistance(float var1);

    public native void setPath(String var1);

    public native void setWidth(float var1);

    public native void setHeight(float var1);

    public native void setAlpha(float var1);

    public native void setGlow(boolean var1);

    public native void setFollowPlayerEyes(boolean var1);

    public native void setEntity(UUID var1);

    public native void setFollowEntityDirection(boolean var1);

    public native void setTranslateEntityFront(double var1);

    public native void setTranslateEntityRight(double var1);

    public native void setAnimationList(List<Animation> var1);

    public static native /* synthetic */ void $jnicLoader();

    static {
        JNICLoader.init();
        HolographyConfig.$jnicLoader();
    }
}

