/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.external.particlesmasher.particle;

import dev.jnic.gPScUN.JNICLoader;
import java.util.Random;
import yslelf.cloudpick.external.particlesmasher.particle.Particle;
import yslelf.cloudpick.graphics.graphics.Point;
import yslelf.cloudpick.graphics.graphics.Rect;

public class FloatParticle
extends Particle {
    private float top;
    private float left;
    public static final int ORIENTATION_LEFT = 1;
    public static final int ORIENTATION_RIGHT = 2;
    public static final int ORIENTATION_TOP = 3;
    public static final int ORIENTATION_BOTTOM = 4;
    private int orientation = 3;

    public FloatParticle(int orientation, Point point, int color, int radius, Rect rect, float endValue, Random random, float horizontalMultiple, float verticalMultiple) {
        this.color = color;
        this.alpha = 1.0f;
        float nextFloat = random.nextFloat();
        this.radius = this.baseRadius = FloatParticle.getBaseRadius(radius, random, nextFloat);
        this.horizontalElement = FloatParticle.getHorizontalElement(rect, random, nextFloat, horizontalMultiple);
        this.verticalElement = FloatParticle.getVerticalElement(rect, random, nextFloat, verticalMultiple);
        this.baseCx = point.x;
        this.baseCy = point.y;
        this.cx = this.baseCx;
        this.cy = this.baseCy;
        this.font = endValue / 10.0f * random.nextFloat();
        this.later = 0.4f * random.nextFloat();
        this.left = (this.baseCx - (float)rect.left) / (float)rect.width();
        this.top = (this.baseCy - (float)rect.top) / (float)rect.height();
        this.orientation = orientation;
    }

    private static native float getBaseRadius(float var0, Random var1, float var2);

    private static native float getHorizontalElement(Rect var0, Random var1, float var2, float var3);

    private static native float getVerticalElement(Rect var0, Random var1, float var2, float var3);

    @Override
    public native void advance(float var1, float var2);

    public static native /* synthetic */ void $jnicLoader();

    static {
        JNICLoader.init();
        FloatParticle.$jnicLoader();
    }
}

