/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.external.spine;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Null;
import dev.jnic.gPScUN.JNICLoader;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import yslelf.cloudpick.external.spine.CpTexture;
import yslelf.cloudpick.graphics.graphics.Bitmap;

public class CpTextureAtlas {
    private final Array<CpTexture> textures = new Array();
    private final Array<TextureAtlas.AtlasRegion> regions = new Array();

    public CpTextureAtlas(TextureAtlas.TextureAtlasData data, BitmapLoader bitmapLoader) {
        for (TextureAtlas.TextureAtlasData.Page page : data.getPages()) {
            page.texture = new CpTexture(bitmapLoader.load(page.textureFile.path()));
            this.textures.add((CpTexture)page.texture);
        }
        for (TextureAtlas.TextureAtlasData.Region region : data.getRegions()) {
            TextureAtlas.AtlasRegion atlasRegion = new TextureAtlas.AtlasRegion(region.page.texture, region.left, region.top, region.rotate ? region.height : region.width, region.rotate ? region.width : region.height);
            atlasRegion.index = region.index;
            atlasRegion.name = region.name;
            atlasRegion.offsetX = region.offsetX;
            atlasRegion.offsetY = region.offsetY;
            atlasRegion.originalHeight = region.originalHeight;
            atlasRegion.originalWidth = region.originalWidth;
            atlasRegion.rotate = region.rotate;
            atlasRegion.degrees = region.degrees;
            atlasRegion.names = region.names;
            atlasRegion.values = region.values;
            if (region.flip) {
                atlasRegion.flip(false, true);
            }
            this.regions.add(atlasRegion);
        }
    }

    @Null
    public native TextureAtlas.AtlasRegion findRegion(String var1);

    public native Array<CpTexture> getTextures();

    public native Array<TextureAtlas.AtlasRegion> getRegions();

    public static native CpTextureAtlas fromFile(File var0);

    public static native CpTextureAtlas fromHttp(URL var0, File var1);

    private static native InputStream inputStream(File var0) throws Exception;

    private static native TextureAtlas.TextureAtlasData loadTextureAtlasData(File var0);

    private static native /* synthetic */ Bitmap lambda$fromHttp$1(URL var0, File var1, String var2);

    private static native /* synthetic */ Bitmap lambda$fromFile$0(String var0);

    public static native /* synthetic */ void $jnicLoader();

    static {
        JNICLoader.init();
        CpTextureAtlas.$jnicLoader();
    }

    public static interface BitmapLoader {
        public Bitmap load(String var1);
    }
}

