/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.function.LongConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.TestOnly;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.glfw.GLFWMonitorCallback;
import org.lwjgl.glfw.GLFWWindowCloseCallback;
import org.lwjgl.glfw.GLFWWindowCloseCallbackI;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL33C;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.Platform;
import yslelf.cloudpick.graphics.R;
import yslelf.cloudpick.graphics.annotation.MainThread;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.annotation.RenderThread;
import yslelf.cloudpick.graphics.annotation.UiThread;
import yslelf.cloudpick.graphics.app.Activity;
import yslelf.cloudpick.graphics.core.ActivityWindow;
import yslelf.cloudpick.graphics.core.Core;
import yslelf.cloudpick.graphics.core.Handler;
import yslelf.cloudpick.graphics.core.Looper;
import yslelf.cloudpick.graphics.core.Monitor;
import yslelf.cloudpick.graphics.core.VideoMode;
import yslelf.cloudpick.graphics.fragment.Fragment;
import yslelf.cloudpick.graphics.fragment.FragmentContainerView;
import yslelf.cloudpick.graphics.fragment.FragmentController;
import yslelf.cloudpick.graphics.fragment.FragmentHostCallback;
import yslelf.cloudpick.graphics.fragment.OnBackPressedDispatcher;
import yslelf.cloudpick.graphics.fragment.OnBackPressedDispatcherOwner;
import yslelf.cloudpick.graphics.graphics.ArcCanvas;
import yslelf.cloudpick.graphics.graphics.Bitmap;
import yslelf.cloudpick.graphics.graphics.BitmapFactory;
import yslelf.cloudpick.graphics.graphics.Canvas;
import yslelf.cloudpick.graphics.graphics.Image;
import yslelf.cloudpick.graphics.graphics.Rect;
import yslelf.cloudpick.graphics.graphics.drawable.ColorDrawable;
import yslelf.cloudpick.graphics.graphics.text.FontFamily;
import yslelf.cloudpick.graphics.lifecycle.Lifecycle;
import yslelf.cloudpick.graphics.lifecycle.LifecycleOwner;
import yslelf.cloudpick.graphics.lifecycle.LifecycleRegistry;
import yslelf.cloudpick.graphics.lifecycle.ViewModelStore;
import yslelf.cloudpick.graphics.lifecycle.ViewModelStoreOwner;
import yslelf.cloudpick.graphics.resources.Resources;
import yslelf.cloudpick.graphics.resources.ResourcesBuilder;
import yslelf.cloudpick.graphics.resources.SystemTheme;
import yslelf.cloudpick.graphics.resources.TypedValue;
import yslelf.cloudpick.graphics.text.Typeface;
import yslelf.cloudpick.graphics.util.DisplayMetrics;
import yslelf.cloudpick.graphics.view.KeyEvent;
import yslelf.cloudpick.graphics.view.MotionEvent;
import yslelf.cloudpick.graphics.view.PointerIcon;
import yslelf.cloudpick.graphics.view.View;
import yslelf.cloudpick.graphics.view.ViewRoot;
import yslelf.cloudpick.graphics.view.WindowGroup;
import yslelf.cloudpick.graphics.view.WindowManager;
import yslelf.cloudpick.graphics.view.menu.ContextMenuBuilder;
import yslelf.cloudpick.graphics.view.menu.MenuHelper;
import yslelf.cloudpick.graphics.view.menu.MenuPopupHelper;
import yslelf.cloudpick.graphics.widget.TextView;
import yslelf.cloudpick.render.core.ColorSpace;
import yslelf.cloudpick.render.core.ImageInfo;
import yslelf.cloudpick.render.core.RefCnt;
import yslelf.cloudpick.render.core.Surface;
import yslelf.cloudpick.render.engine.ImmediateContext;
import yslelf.cloudpick.render.granite.GraniteSurface;
import yslelf.cloudpick.render.granite.RootTask;

public class CloudPick
extends Activity
implements AutoCloseable,
LifecycleOwner {
    public static final String ID = "modernui";
    public static final String NAME_CPT = "ModernUI";
    public static final Logger LOGGER = LogManager.getLogger((String)"ModernUI");
    public static final Marker MARKER = MarkerManager.getMarker((String)"Core");
    public static final Properties props = new Properties();
    private static volatile CloudPick sInstance;
    private static final int fragment_container = 16908295;
    private volatile ActivityWindow mWindow;
    private ViewRootImpl mRoot;
    private WindowGroup mDecor;
    private FragmentContainerView mFragmentContainerView;
    private LifecycleRegistry mLifecycleRegistry;
    private OnBackPressedDispatcher mOnBackPressedDispatcher;
    private ViewModelStore mViewModelStore;
    private FragmentController mFragmentController;
    private volatile Typeface mDefaultTypeface;
    private volatile Thread mRenderThread;
    private volatile Looper mRenderLooper;
    private volatile Handler mRenderHandler;
    private final Object mThemeLock = new Object();
    private Resources mResources;
    private Resources.Theme mTheme;
    private Image mBackgroundImage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloudPick() {
        Class<CloudPick> clazz = CloudPick.class;
        synchronized (CloudPick.class) {
            if (sInstance != null) {
                throw new RuntimeException("Multiple instances");
            }
            sInstance = this;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            ResourcesBuilder rb = new ResourcesBuilder();
            SystemTheme.addToResources(rb);
            this.mResources = rb.build();
            return;
        }
    }

    public static CloudPick getInstance() {
        return sInstance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void findHighestGLVersion() {
        GLFWErrorCallback callback = GLFW.glfwSetErrorCallback(null);
        int[][] versions = new int[][]{{4, 6}, {4, 5}, {4, 4}, {4, 3}, {4, 2}, {4, 1}, {4, 0}, {3, 3}};
        long window = 0L;
        try {
            int[][] nArrayArray = versions;
            int n2 = nArrayArray.length;
            int n3 = 0;
            while (n3 < n2) {
                int[] version = nArrayArray[n3];
                GLFW.glfwWindowHint((int)139266, (int)version[0]);
                GLFW.glfwWindowHint((int)139267, (int)version[1]);
                LOGGER.debug(MARKER, "Trying OpenGL {}.{}", (Object)version[0], (Object)version[1]);
                window = GLFW.glfwCreateWindow((int)640, (int)480, (CharSequence)"System Testing", (long)0L, (long)0L);
                if (window != 0L) {
                    LOGGER.info(MARKER, "Will use OpenGL {}.{} Core Profile", (Object)version[0], (Object)version[1]);
                    return;
                }
                ++n3;
            }
            throw new RuntimeException("OpenGL 3.3 or OpenGL ES 3.0 is required");
        }
        catch (Exception e) {
            throw new RuntimeException("OpenGL 3.3 or OpenGL ES 3.0 is required");
        }
        finally {
            if (window != 0L) {
                GLFW.glfwDestroyWindow((long)window);
            }
            GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)callback);
        }
    }

    @MainThread
    public void run(@NonNull Fragment fragment) {
        this.run(fragment, null);
    }

    @TestOnly
    @MainThread
    public void run(@NonNull Fragment fragment, LongConsumer windowCallback) {
        Thread.currentThread().setName("Main-Thread");
        Core.initialize();
        LOGGER.debug(MARKER, "Preparing main thread");
        Looper.prepareMainLooper();
        CompletableFuture<Void> loadTypeface = CompletableFuture.runAsync(this::loadDefaultTypeface);
        LOGGER.debug(MARKER, "Initializing window system");
        Monitor monitor = Monitor.getPrimary();
        String name = (String)Configuration.OPENGL_LIBRARY_NAME.get();
        if (name != null) {
            LOGGER.debug(MARKER, "OpenGL library: {}", (Object)name);
            Objects.requireNonNull(GL.getFunctionProvider(), "Implicit OpenGL loading is required");
        }
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint((int)139265, (int)196609);
        GLFW.glfwWindowHint((int)139275, (int)221185);
        GLFW.glfwWindowHint((int)139272, (int)204801);
        GLFW.glfwWindowHint((int)139270, (int)1);
        GLFW.glfwWindowHint((int)135173, (int)0);
        GLFW.glfwWindowHint((int)135174, (int)0);
        GLFW.glfwWindowHintString((int)147457, (CharSequence)NAME_CPT);
        GLFW.glfwWindowHintString((int)147458, (CharSequence)NAME_CPT);
        GLFW.glfwWindowHint((int)131076, (int)0);
        if (Platform.get() == Platform.MACOSX) {
            GLFW.glfwWindowHint((int)139266, (int)4);
            GLFW.glfwWindowHint((int)139267, (int)1);
        } else {
            this.findHighestGLVersion();
        }
        if (monitor == null) {
            LOGGER.info(MARKER, "No monitor connected");
            this.mWindow = ActivityWindow.createMainWindow("Modern UI", 1280, 720);
        } else {
            VideoMode mode = monitor.getCurrentMode();
            this.mWindow = ActivityWindow.createMainWindow("Modern UI", (int)((double)mode.getWidth() * 0.75), (int)((double)mode.getHeight() * 0.75));
        }
        CountDownLatch latch = new CountDownLatch(1);
        LOGGER.debug(MARKER, "Preparing render thread");
        this.mRenderThread = new Thread(() -> this.runRender(latch), "Render-Thread");
        this.mRenderThread.start();
        if (windowCallback != null) {
            windowCallback.accept(this.mWindow.getHandle());
        }
        CompletableFuture.supplyAsync(() -> {
            try {
                Bitmap i16 = BitmapFactory.decodeStream(this.getResourceStream(ID, "AppLogo16x.png"));
                Bitmap i32 = BitmapFactory.decodeStream(this.getResourceStream(ID, "AppLogo32x.png"));
                Bitmap i48 = BitmapFactory.decodeStream(this.getResourceStream(ID, "AppLogo48x.png"));
                return new Bitmap[]{i16, i32, i48};
            }
            catch (Throwable e) {
                LOGGER.info(MARKER, "Failed to load window icons", e);
                return null;
            }
        }).thenAcceptAsync(icons -> this.mWindow.setIcon((Bitmap)icons), Core.getMainThreadExecutor());
        if (monitor != null) {
            this.mWindow.center(monitor);
            int[] physw = new int[]{0};
            int[] physh = new int[]{0};
            GLFW.glfwGetMonitorPhysicalSize((long)monitor.getHandle(), (int[])physw, (int[])physh);
            float[] xscale = new float[]{0.0f};
            float[] yscale = new float[]{0.0f};
            GLFW.glfwGetMonitorContentScale((long)monitor.getHandle(), (float[])xscale, (float[])yscale);
            DisplayMetrics metrics = new DisplayMetrics();
            metrics.setToDefaults();
            metrics.widthPixels = this.mWindow.getWidth();
            metrics.heightPixels = this.mWindow.getHeight();
            VideoMode mode = monitor.getCurrentMode();
            metrics.xdpi = 25.4f * (float)mode.getWidth() / (float)physw[0];
            metrics.ydpi = 25.4f * (float)mode.getHeight() / (float)physh[0];
            LOGGER.info(MARKER, "Primary monitor physical size: {}x{} mm, xScale: {}, yScale: {}", (Object)physw[0], (Object)physh[0], (Object)Float.valueOf(xscale[0]), (Object)Float.valueOf(yscale[0]));
            int density = Math.round(72.0f * xscale[0] / 12.0f) * 12;
            metrics.density = (float)density * 0.013888889f;
            metrics.densityDpi = density;
            metrics.scaledDensity = metrics.density;
            LOGGER.info(MARKER, "Display metrics: {}", (Object)metrics);
            this.mResources.updateMetrics(metrics);
        }
        GLFW.glfwSetWindowCloseCallback((long)this.mWindow.getHandle(), (GLFWWindowCloseCallbackI)new GLFWWindowCloseCallback(){

            public void invoke(long window) {
                LOGGER.debug(MARKER, "Window closed from callback");
                CloudPick.this.stop();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        LOGGER.debug(MARKER, "Initializing UI system");
        Core.initUiThread();
        this.mRoot = new ViewRootImpl();
        this.mRoot.loadSystemProperties(() -> Boolean.getBoolean("icyllis.modernui.display.debug.layout"));
        this.mDecor = new WindowGroup(this);
        this.mDecor.setWillNotDraw(true);
        this.mDecor.setId(0x1020002);
        TypedValue value = new TypedValue();
        this.getTheme().resolveAttribute(ID, "colorSurfaceContainerLowest", value, true);
        int colorSurfaceContainerLowest = value.data;
        this.mDecor.setBackground(new ColorDrawable(colorSurfaceContainerLowest));
        this.mFragmentContainerView = new FragmentContainerView(this);
        this.mFragmentContainerView.setLayoutParams(new WindowManager.LayoutParams());
        this.mFragmentContainerView.setWillNotDraw(true);
        this.mFragmentContainerView.setId(16908295);
        this.mDecor.addView(this.mFragmentContainerView);
        this.mDecor.setLayoutDirection(3);
        this.mDecor.setIsRootNamespace(true);
        this.mRoot.setView(this.mDecor);
        LOGGER.debug(MARKER, "Installing view protocol");
        this.mWindow.install(this.mRoot);
        this.mLifecycleRegistry = new LifecycleRegistry(this);
        this.mOnBackPressedDispatcher = new OnBackPressedDispatcher(() -> {
            this.mWindow.setShouldClose(true);
            this.stop();
        });
        this.mViewModelStore = new ViewModelStore();
        this.mFragmentController = FragmentController.createController(new HostCallbacks());
        this.mFragmentController.attachHost(null);
        this.mLifecycleRegistry.handleLifecycleEvent(Lifecycle.Event.ON_CREATE);
        this.mFragmentController.dispatchCreate();
        this.mFragmentController.dispatchActivityCreated();
        this.mFragmentController.execPendingActions();
        this.mLifecycleRegistry.handleLifecycleEvent(Lifecycle.Event.ON_START);
        this.mFragmentController.dispatchStart();
        this.mLifecycleRegistry.handleLifecycleEvent(Lifecycle.Event.ON_RESUME);
        this.mFragmentController.dispatchResume();
        this.mFragmentController.getFragmentManager().beginTransaction().add(16908295, fragment, "main").setTransition(4097).addToBackStack("main").commit();
        this.mWindow.show();
        loadTypeface.join();
        LOGGER.info(MARKER, "Looping main thread");
        Looper.loop();
        this.mRoot.mSurface = RefCnt.move(this.mRoot.mSurface);
        Core.requireUiRecordingContext().unref();
        LOGGER.info(MARKER, "Quited main thread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RenderThread
    private void runRender(CountDownLatch latch) {
        ActivityWindow window = this.mWindow;
        window.makeCurrent();
        try {
            if (!Core.initOpenGL()) {
                Core.glShowCapsErrorDialog();
                throw new IllegalStateException("Failed to initialize OpenGL");
            }
            this.mRenderLooper = Looper.prepare();
            this.mRenderHandler = new Handler(this.mRenderLooper);
            Core.glSetupDebugCallback();
        }
        finally {
            latch.countDown();
        }
        window.swapInterval(1);
        LOGGER.info(MARKER, "Looping render thread");
        Looper.loop();
        Class<Core> clazz = Core.class;
        synchronized (Core.class) {
            if (this.mBackgroundImage != null) {
                this.mBackgroundImage.close();
                this.mBackgroundImage = null;
            }
            // ** MonitorExit[var3_4] (shouldn't be in output)
            Core.requireImmediateContext().unref();
            LOGGER.info(MARKER, "Quited render thread");
            return;
        }
    }

    public ActivityWindow getWindow() {
        return this.mWindow;
    }

    private void loadDefaultTypeface() {
        LinkedHashSet<FontFamily> set = new LinkedHashSet<FontFamily>();
        for (String name : new String[]{"Microsoft YaHei UI", "Calibri", "STHeiti", "Segoe UI", "SimHei"}) {
            FontFamily family = FontFamily.getSystemFontWithAlias(name);
            if (family == null) continue;
            set.add(family);
        }
        this.mDefaultTypeface = Typeface.createTypeface(set.toArray(new FontFamily[0]));
    }

    private void stop() {
        this.mDecor.setBackground(null);
        this.mFragmentController.dispatchStop();
        this.mLifecycleRegistry.handleLifecycleEvent(Lifecycle.Event.ON_STOP);
        this.mFragmentController.dispatchDestroy();
        this.mLifecycleRegistry.handleLifecycleEvent(Lifecycle.Event.ON_DESTROY);
        Looper.getMainLooper().quitSafely();
    }

    @Override
    @NonNull
    public Lifecycle getLifecycle() {
        return this.mLifecycleRegistry;
    }

    @Override
    public Resources getResources() {
        return this.mResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resources.Theme getTheme() {
        Object object = this.mThemeLock;
        synchronized (object) {
            if (this.mTheme != null) {
                return this.mTheme;
            }
            this.mTheme = this.mResources.newTheme();
            this.mTheme.applyStyle(R.style.Theme_Material3_Dark, true);
            return this.mTheme;
        }
    }

    protected Locale onGetSelectedLocale() {
        return Locale.getDefault();
    }

    @NonNull
    public static Locale getSelectedLocale() {
        return sInstance == null ? Locale.getDefault() : sInstance.onGetSelectedLocale();
    }

    @NonNull
    protected Typeface onGetSelectedTypeface() {
        return Objects.requireNonNullElse(this.mDefaultTypeface, Typeface.SANS_SERIF);
    }

    @NonNull
    public static Typeface getSelectedTypeface() {
        return sInstance == null ? Typeface.SANS_SERIF : sInstance.onGetSelectedTypeface();
    }

    @ApiStatus.Experimental
    public boolean hasRtlSupport() {
        return true;
    }

    @ApiStatus.Experimental
    @NonNull
    public InputStream getResourceStream(@NonNull String namespace, @NonNull String path) throws IOException {
        InputStream stream = CloudPick.class.getResourceAsStream("/assets/" + namespace + "/" + path);
        if (stream == null) {
            throw new FileNotFoundException();
        }
        return stream;
    }

    @ApiStatus.Experimental
    @NonNull
    public ReadableByteChannel getResourceChannel(@NonNull String namespace, @NonNull String path) throws IOException {
        return Channels.newChannel(this.getResourceStream(namespace, path));
    }

    @Override
    @ApiStatus.Internal
    public WindowManager getWindowManager() {
        return this.mDecor;
    }

    @Override
    public void close() {
        try {
            GLFWMonitorCallback cb;
            this.mRenderLooper.quit();
            if (this.mRenderThread != null && this.mRenderThread.isAlive()) {
                try {
                    this.mRenderThread.join(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.mWindow != null) {
                this.mWindow.close();
                LOGGER.debug(MARKER, "Closed main window");
            }
            if ((cb = GLFW.glfwSetMonitorCallback(null)) != null) {
                cb.free();
            }
        }
        finally {
            Core.terminate();
        }
    }

    static {
        if (Runtime.version().feature() < 17) {
            throw new RuntimeException("JRE 17 or above is required");
        }
    }

    @UiThread
    class ViewRootImpl
    extends ViewRoot {
        private final Rect mGlobalRect = new Rect();
        Surface mSurface;
        RootTask mLastFrameTask;
        ContextMenuBuilder mContextMenu;
        MenuHelper mContextMenuHelper;

        ViewRootImpl() {
        }

        @Override
        protected boolean dispatchTouchEvent(MotionEvent event) {
            TextView tv;
            View v;
            if (event.getAction() == 0 && (v = this.mView.findFocus()) instanceof TextView && (tv = (TextView)v).getMovementMethod() != null) {
                v.getGlobalVisibleRect(this.mGlobalRect);
                if (!this.mGlobalRect.contains((int)event.getRawX(), (int)event.getRawY())) {
                    v.clearFocus();
                }
            }
            return super.dispatchTouchEvent(event);
        }

        @Override
        protected void onKeyEvent(KeyEvent event) {
            if (event.getAction() == 0 && event.getKeyCode() == 256) {
                TextView tv;
                View v = this.mView.findFocus();
                if (v instanceof TextView && (tv = (TextView)v).getMovementMethod() != null) {
                    this.mView.requestFocus();
                } else {
                    CloudPick.this.mOnBackPressedDispatcher.onBackPressed();
                }
            }
        }

        @Override
        public void setFrame(int width, int height) {
            super.setFrame(width, height);
            if ((this.mSurface == null || this.mSurface.getWidth() != width || this.mSurface.getHeight() != height) && width > 0 && height > 0) {
                this.mSurface = RefCnt.move(this.mSurface, GraniteSurface.makeRenderTarget(Core.requireUiRecordingContext(), ImageInfo.make(width, height, 6, 2, ColorSpace.get(ColorSpace.Named.SRGB)), false, 1, null));
            }
        }

        @Override
        protected Canvas beginDrawLocked(int width, int height) {
            if (this.mSurface != null && width > 0 && height > 0) {
                return new ArcCanvas(this.mSurface.getCanvas());
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void endDrawLocked(@NonNull Canvas canvas) {
            RootTask task = Core.requireUiRecordingContext().snap();
            Object object = this.mRenderLock;
            synchronized (object) {
                this.mLastFrameTask = RefCnt.move(this.mLastFrameTask, task);
                CloudPick.this.mRenderHandler.post(this::render);
                try {
                    this.mRenderLock.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                this.mLastFrameTask = RefCnt.move(this.mLastFrameTask);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @RenderThread
        private void render() {
            RootTask task;
            int height;
            int width;
            ImmediateContext context = Core.requireImmediateContext();
            Object object = this.mRenderLock;
            synchronized (object) {
                width = this.mSurface.getWidth();
                height = this.mSurface.getHeight();
                task = this.mLastFrameTask;
                this.mLastFrameTask = null;
                this.mRenderLock.notifyAll();
            }
            if (task == null) {
                return;
            }
            boolean added = context.addTask(task);
            RefCnt.move(task);
            if (added) {
                GL33C.glBindFramebuffer((int)36009, (int)0);
                GL33C.glBlitFramebuffer((int)0, (int)0, (int)width, (int)height, (int)0, (int)0, (int)width, (int)height, (int)16384, (int)9728);
                context.submit();
                CloudPick.this.mWindow.swapBuffers();
            } else {
                LOGGER.error("Failed to add draw commands");
            }
        }

        @Override
        public void playSoundEffect(int effectId) {
        }

        @Override
        public boolean performHapticFeedback(int effectId, boolean always) {
            return false;
        }

        @Override
        protected void applyPointerIcon(int pointerType) {
            Core.executeOnMainThread(() -> GLFW.glfwSetCursor((long)CloudPick.this.mWindow.getHandle(), (long)PointerIcon.getSystemIcon(pointerType).getHandle()));
        }

        @Override
        public boolean showContextMenuForChild(View originalView, float x, float y) {
            if (this.mContextMenuHelper != null) {
                this.mContextMenuHelper.dismiss();
                this.mContextMenuHelper = null;
            }
            if (this.mContextMenu == null) {
                this.mContextMenu = new ContextMenuBuilder(CloudPick.this);
            } else {
                this.mContextMenu.clearAll();
            }
            boolean isPopup = !Float.isNaN(x) && !Float.isNaN(y);
            MenuPopupHelper helper = isPopup ? this.mContextMenu.showPopup(CloudPick.this, originalView, x, y) : this.mContextMenu.showPopup(CloudPick.this, originalView, 0.0f, 0.0f);
            if (helper != null) {
                // empty if block
            }
            this.mContextMenuHelper = helper;
            return helper != null;
        }
    }

    @UiThread
    class HostCallbacks
    extends FragmentHostCallback<Object>
    implements ViewModelStoreOwner,
    OnBackPressedDispatcherOwner {
        HostCallbacks() {
            super(CloudPick.this, new Handler(Looper.myLooper()));
            assert (Core.isOnUiThread());
        }

        @Override
        @Nullable
        public Object onGetHost() {
            return null;
        }

        @Override
        @Nullable
        public View onFindViewById(int id2) {
            return CloudPick.this.mDecor.findViewById(id2);
        }

        @Override
        @NonNull
        public ViewModelStore getViewModelStore() {
            return CloudPick.this.mViewModelStore;
        }

        @Override
        @NonNull
        public OnBackPressedDispatcher getOnBackPressedDispatcher() {
            return CloudPick.this.mOnBackPressedDispatcher;
        }

        @Override
        @NonNull
        public Lifecycle getLifecycle() {
            return CloudPick.this.mLifecycleRegistry;
        }
    }
}

