/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import yslelf.cloudpick.graphics.CloudPick;
import yslelf.cloudpick.graphics.R;
import yslelf.cloudpick.graphics.animation.Animator;
import yslelf.cloudpick.graphics.animation.AnimatorListener;
import yslelf.cloudpick.graphics.animation.LayoutTransition;
import yslelf.cloudpick.graphics.animation.ObjectAnimator;
import yslelf.cloudpick.graphics.animation.PropertyValuesHolder;
import yslelf.cloudpick.graphics.animation.TimeInterpolator;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.audio.AudioManager;
import yslelf.cloudpick.graphics.audio.FFT;
import yslelf.cloudpick.graphics.audio.Track;
import yslelf.cloudpick.graphics.core.Context;
import yslelf.cloudpick.graphics.core.Core;
import yslelf.cloudpick.graphics.fragment.Fragment;
import yslelf.cloudpick.graphics.graphics.AngularGradient;
import yslelf.cloudpick.graphics.graphics.Canvas;
import yslelf.cloudpick.graphics.graphics.Color;
import yslelf.cloudpick.graphics.graphics.GradientShader;
import yslelf.cloudpick.graphics.graphics.ImageShader;
import yslelf.cloudpick.graphics.graphics.LinearGradient;
import yslelf.cloudpick.graphics.graphics.MathUtil;
import yslelf.cloudpick.graphics.graphics.Paint;
import yslelf.cloudpick.graphics.graphics.Shader;
import yslelf.cloudpick.graphics.graphics.drawable.ColorDrawable;
import yslelf.cloudpick.graphics.graphics.drawable.ShapeDrawable;
import yslelf.cloudpick.graphics.graphics.text.FontFamily;
import yslelf.cloudpick.graphics.graphics.text.ShapedText;
import yslelf.cloudpick.graphics.material.MaterialCheckBox;
import yslelf.cloudpick.graphics.resources.TypedValue;
import yslelf.cloudpick.graphics.text.SpannableString;
import yslelf.cloudpick.graphics.text.TextDirectionHeuristics;
import yslelf.cloudpick.graphics.text.TextPaint;
import yslelf.cloudpick.graphics.text.TextShaper;
import yslelf.cloudpick.graphics.text.style.ForegroundColorSpan;
import yslelf.cloudpick.graphics.text.style.RelativeSizeSpan;
import yslelf.cloudpick.graphics.text.style.StrikethroughSpan;
import yslelf.cloudpick.graphics.text.style.StyleSpan;
import yslelf.cloudpick.graphics.text.style.SuperscriptSpan;
import yslelf.cloudpick.graphics.text.style.URLSpan;
import yslelf.cloudpick.graphics.text.style.UnderlineSpan;
import yslelf.cloudpick.graphics.util.DataSet;
import yslelf.cloudpick.graphics.util.FloatProperty;
import yslelf.cloudpick.graphics.view.KeyEvent;
import yslelf.cloudpick.graphics.view.LayoutInflater;
import yslelf.cloudpick.graphics.view.MenuItem;
import yslelf.cloudpick.graphics.view.SubMenu;
import yslelf.cloudpick.graphics.view.View;
import yslelf.cloudpick.graphics.view.ViewGroup;
import yslelf.cloudpick.graphics.widget.ArrayAdapter;
import yslelf.cloudpick.graphics.widget.Button;
import yslelf.cloudpick.graphics.widget.EditText;
import yslelf.cloudpick.graphics.widget.FrameLayout;
import yslelf.cloudpick.graphics.widget.LinearLayout;
import yslelf.cloudpick.graphics.widget.PopupWindow;
import yslelf.cloudpick.graphics.widget.ProgressBar;
import yslelf.cloudpick.graphics.widget.RadioButton;
import yslelf.cloudpick.graphics.widget.RadioGroup;
import yslelf.cloudpick.graphics.widget.ScrollView;
import yslelf.cloudpick.graphics.widget.SeekBar;
import yslelf.cloudpick.graphics.widget.Spinner;
import yslelf.cloudpick.graphics.widget.Switch;
import yslelf.cloudpick.graphics.widget.TextView;

public class TestFragment
extends Fragment {
    public static void main(String[] args) {
        System.setProperty("java.awt.headless", "true");
        Configurator.setRootLevel((Level)Level.DEBUG);
        try (CloudPick app = new CloudPick();){
            app.getTheme().applyStyle(R.style.Theme_Material3_Light, true);
            app.getTheme().applyStyle(R.style.ThemeOverlay_Material3_Light_Rust, true);
            app.run(new TestFragment());
        }
        AudioManager.getInstance().close();
        System.gc();
    }

    @Override
    public void onAttach(@NonNull Context context) {
        super.onAttach(context);
        this.getParentFragmentManager().beginTransaction().setPrimaryNavigationFragment(this).commit();
    }

    @Override
    public void onCreate(@Nullable DataSet savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getChildFragmentManager().beginTransaction().replace(660, new FragmentA(), null).commit();
        AudioManager.getInstance().initialize();
    }

    @Override
    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable DataSet savedInstanceState) {
        ScrollView base = new ScrollView(this.getContext());
        base.setId(660);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(base.dp(960.0f), base.dp(540.0f));
        params.gravity = 17;
        base.setLayoutParams(params);
        TypedValue value = new TypedValue();
        this.requireContext().getTheme().resolveAttribute("modernui", "colorSurface", value, true);
        int colorSurface = value.data;
        base.setBackground(new ColorDrawable(colorSurface));
        return base;
    }

    public static class FragmentA
    extends Fragment {
        @Override
        @Nullable
        public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable DataSet savedInstanceState) {
            TestLinearLayout content = new TestLinearLayout(this.getContext());
            content.setLayoutParams(new FrameLayout.LayoutParams(-1, -2));
            content.setOnKeyListener((v, keyCode, event) -> keyCode == 69 && event.getAction() == 1);
            CloudPick.LOGGER.info("{} onCreateView(), id={}", (Object)this.getClass().getSimpleName(), (Object)this.getId());
            return content;
        }

        @Override
        public void onDestroy() {
            super.onDestroy();
            CloudPick.LOGGER.info("{} onDestroy()", (Object)this.getClass().getSimpleName());
        }
    }

    public static class SpectrumGraph {
        private final boolean mCircular;
        private final float[] mAmplitudes = new float[60];
        private final FFT mFFT;
        private final int mHeight;
        private boolean mUpdated;

        public SpectrumGraph(Track track, View view, boolean circular, int height) {
            this.mFFT = FFT.create(1024, track.getSampleRate());
            this.mFFT.setLogAverages(250, 14);
            this.mFFT.setWindowFunc(3);
            track.setAnalyzer(this.mFFT, f2 -> {
                this.updateAmplitudes();
                view.postInvalidate();
            });
            this.mCircular = circular;
            this.mHeight = height;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateAmplitudes() {
            int len = Math.min(this.mFFT.getAverageSize() - 5, this.mAmplitudes.length);
            long time = Core.timeMillis();
            int iOff = this.mCircular ? (int)(time / 200L) : 0;
            float[] fArray = this.mAmplitudes;
            synchronized (this.mAmplitudes) {
                for (int i = 0; i < len; ++i) {
                    float va = this.mFFT.getAverage((i + iOff) % len + 5) / (float)this.mFFT.getBandSize();
                    this.mAmplitudes[i] = Math.max(this.mAmplitudes[i], va);
                }
                this.mUpdated = true;
                // ** MonitorExit[var5_4] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean update(long delta) {
            int len = Math.min(this.mFFT.getAverageSize() - 5, this.mAmplitudes.length);
            float[] fArray = this.mAmplitudes;
            synchronized (this.mAmplitudes) {
                for (int i = 0; i < len; ++i) {
                    this.mAmplitudes[i] = Math.max(0.0f, this.mAmplitudes[i] - (float)delta * 2.5E-5f * 198.0f * (this.mAmplitudes[i] + 0.03f));
                }
                boolean updated = this.mUpdated;
                this.mUpdated = false;
                if (!updated) {
                    for (int i = 0; i < len; ++i) {
                        if (!(this.mAmplitudes[i] > 0.0f)) continue;
                        // ** MonitorExit[var4_3] (shouldn't be in output)
                        return true;
                    }
                }
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return updated;
            }
        }

        public void draw(@Nonnull Canvas canvas, float cx, float cy) {
            Paint paint = Paint.obtain();
            if (this.mCircular) {
                long time = Core.timeMillis();
                float b = 1.5f + MathUtil.sin((float)time / 600.0f) / 2.0f;
                paint.setRGBA(160, 155, 230, (int)(64.0f * b));
                paint.setStrokeWidth(200.0f);
                paint.setStyle(1);
                canvas.drawCircle(cx, cy, 130.0f, paint);
                paint.reset();
                for (int i = 0; i < this.mAmplitudes.length; ++i) {
                    float f2 = Math.abs((float)((i + (int)(time / 100L)) % this.mAmplitudes.length) - (float)(this.mAmplitudes.length - 1) / 2.0f) / (float)(this.mAmplitudes.length - 1) * b;
                    paint.setRGBA(100 + (int)(f2 * 120.0f), 220 - (int)(f2 * 130.0f), 240 - (int)(f2 * 20.0f), 255);
                    canvas.rotate(-360.0f / (float)this.mAmplitudes.length, cx, cy);
                    canvas.drawRect(cx - 6.0f, cy - 120.0f - this.mAmplitudes[i] * (float)this.mHeight, cx + 6.0f, cy - 120.0f, paint);
                }
            } else {
                for (int i = 0; i < this.mAmplitudes.length; ++i) {
                    paint.setRGBA(100 + i * 2, 220 - i * 2, 240 - i * 4, 255);
                    canvas.drawRect(cx - 479.0f + (float)(i * 16), cy - this.mAmplitudes[i] * (float)this.mHeight, cx - 465.0f + (float)(i * 16), cy, paint);
                }
            }
            paint.recycle();
        }
    }

    public static class TestLinearLayout
    extends LinearLayout {
        private float c = 10.0f;
        private float f = 0.0f;
        private static final FloatBuffer sLinePoints = FloatBuffer.allocate(16);
        private static final IntBuffer sLineColors = IntBuffer.allocate(sLinePoints.capacity() / 2);
        private static final FloatBuffer sTrianglePoints = FloatBuffer.allocate(12);
        private static final IntBuffer sTriangleColors = IntBuffer.allocate(sTrianglePoints.capacity() / 2);
        private final Animator mRoundRectLenAnim;
        private float circleAcc1;
        private float circleAcc2;
        private float circleAcc3;
        private float circleAcc4;
        private float iconRadius = 40.0f;
        private float arcStart = 0.0f;
        private float arcEnd = 0.0f;
        private float mRoundRectLen = 0.0f;
        private float roundRectAlpha = 0.0f;
        private float mSmoothRadius = 0.0f;
        private boolean b;
        private int colorPrimary;
        private int colorSecondaryContainer;
        private int ticks;
        private final TextView mTextView;
        ProgressBar mProgressBar1;
        ProgressBar mProgressBar2;
        PopupWindow mPopupWindow = new PopupWindow();
        ObjectAnimator mGoodAnim;
        ImageShader mTestImageShader;
        LinearGradient mTestLinearGrad;
        AngularGradient mTestAngularGrad;
        private static final FloatProperty<TestLinearLayout> sRoundRectLengthProp;
        private static final FloatProperty<TestLinearLayout> sSmoothRadiusProp;

        public TestLinearLayout(Context context) {
            super(context);
            this.setOrientation(1);
            this.setGravity(17);
            ShapeDrawable divider = new ShapeDrawable();
            divider.setShape(3);
            divider.setSize(-1, this.dp(1.0f));
            TypedValue value = new TypedValue();
            context.getTheme().resolveAttribute("modernui", "colorOutlineVariant", value, true);
            divider.setColor(value.data);
            this.setDividerDrawable(divider);
            this.setShowDividers(6);
            this.getContext().getTheme().resolveAttribute("modernui", "colorPrimary", value, true);
            this.colorPrimary = value.data;
            this.getContext().getTheme().resolveAttribute("modernui", "colorSecondaryContainer", value, true);
            this.colorSecondaryContainer = value.data;
            this.setPadding(this.dp(12.0f), this.dp(12.0f), this.dp(12.0f), this.dp(12.0f));
            this.setDividerPadding(this.dp(8.0f));
            this.setClickable(true);
            this.setFocusable(true);
            this.setFocusableInTouchMode(true);
            Object text = "\t\t\u0639\u0646\u062f\u0645\u0627 \u064a\u0631\u064a\u062f \u0627\u0644\u0639\u0627\u0644\u0645 \u0623\u0646 \u202a\u064a\u062a\u0643\u0644\u0651\u0645 \u202c \u060c \u0641\u0647\u0648 \u064a\u062a\u062d\u062f\u0651\u062b \u0628\u0644\u063a\u0629 \u064a\u0648\u0646\u064a\u0643\u0648\u062f. \u062a\u0633\u062c\u0651\u0644 \u0627\u0644\u0622\u0646 \u0644\u062d\u0636\u0648\u0631 \u0627\u0644\u0645\u0624\u062a\u0645\u0631 \u0627\u0644\u062f\u0648\u0644\u064a \u0627\u0644\u0639\u0627\u0634\u0631 \u0644\u064a\u0648\u0646\u064a\u0643\u0648\u062f (Unicode Conference)\n";
            int firstPara = ((String)text).length();
            text = (String)text + "\t\t\u7ea2 \u65e5\uff08\u8feb\u771f\uff09\n";
            int secondsPara = ((String)text).length();
            text = (String)text + "\t\tMy name is Van, I'm 30 years old, and I'm from Japan. I'm an artist, I'm a performance artist. I'm hired for people to fulfill their fantasies, their deep dark fantasies.\n\t\t\u4f60\u770b\u8fd9\u4e2a\u5f6c\u5f6c \u624d\u559d\u51e0\u7f50 \u5c31\u9189\u4e86...\u771f\u7684\u592a\u900a\u529b\uff1b\u54e6\uff0c\u542c\u4f60\u90a3\u4e48\u8bf4 \u4f60\u5f88\u52c7\u54e6\uff1b\u5f00\u73a9\u7b11\uff0c\u6211\u8d85\u52c7\u7684\u597d\u4e0d\u597d \u6211\u8d85\u4f1a\u559d\u7684\u5566\n";
            text = (String)text + "Oops, your ";
            int emojiSt = ((String)text).length();
            text = (String)text + "\ud83d\udc34 died\n";
            text = (String)text + "\t\t\u09b9\u09cd\u09af\u09be\u09b2\u09cb \u0645\u0631\u062d\u0628\u0627 \ud808\udd99\ud808\udd99";
            TextView tv = new TextView(this.getContext());
            tv.setLayoutParams(new LinearLayout.LayoutParams(tv.dp(640.0f), -2));
            tv.setLineBreakWordStyle(3);
            SpannableString spannable = new SpannableString((CharSequence)text);
            spannable.setSpan(new ForegroundColorSpan(-616012), ((String)text).length() - 54, ((String)text).length(), 33);
            spannable.setSpan(new RelativeSizeSpan(1.15f), ((String)text).length() - 99, ((String)text).length() - 30, 33);
            spannable.setSpan(new StyleSpan(1), ((String)text).length() - 50, ((String)text).length() - 40, 33);
            spannable.setSpan(new URLSpan("https://www.bilibili.com/video/BV1qm411Q7LX"), firstPara, secondsPara - 1, 33);
            spannable.setSpan(new SuperscriptSpan(), firstPara + 4, firstPara + 5, 33);
            spannable.setSpan(new UnderlineSpan(), ((String)text).length() / 2, ((String)text).length() / 4 * 3, 33);
            spannable.setSpan(new StrikethroughSpan(), ((String)text).length() / 4 * 3, ((String)text).length(), 34);
            tv.setText(spannable, TextView.BufferType.SPANNABLE);
            tv.setLinksClickable(true);
            tv.setTextIsSelectable(true);
            tv.setTextAlignment(1);
            this.mTextView = tv;
            PropertyValuesHolder pvh1 = PropertyValuesHolder.ofFloat(ROTATION, 0.0f, 2880.0f);
            PropertyValuesHolder pvh2 = PropertyValuesHolder.ofFloat(ROTATION_Y, 0.0f, 720.0f);
            PropertyValuesHolder pvh3 = PropertyValuesHolder.ofFloat(ROTATION_X, 0.0f, 1440.0f);
            ObjectAnimator anim = ObjectAnimator.ofPropertyValuesHolder(this, pvh1, pvh2, pvh3);
            anim.setDuration(12000L);
            anim.setInterpolator(TimeInterpolator.ACCELERATE_DECELERATE);
            anim.addListener(new AnimatorListener(){

                @Override
                public void onAnimationEnd(@NonNull Animator animation) {
                    this.setRotation(0.0f);
                    this.setRotationX(0.0f);
                    this.setRotationY(0.0f);
                }
            });
            this.mGoodAnim = anim;
            this.mTestLinearGrad = new LinearGradient(0.0f, 0.0f, 128.0f, 0.0f, Color.argb(255, 45, 212, 191), Color.argb(255, 14, 165, 233), Shader.TileMode.MIRROR, null);
            this.mTestAngularGrad = new AngularGradient.Builder(0.0f, 0.0f, 0.0f, 360.0f, Shader.TileMode.CLAMP, null, 5).addColor(0.2f, 0.85f, 0.95f, 1.0f).addColor(0.85f, 0.5f, 0.75f, 1.0f).addColor(0.95f, 0.5f, 0.05f, 1.0f).addColor(0.75f, 0.95f, 0.7f, 1.0f).addColor(0.6f, 0.25f, 0.65f, 1.0f).setInterpolationColorSpace(GradientShader.InterpolationColorSpace.SRGB_LINEAR).build();
            long start = System.nanoTime();
            for (int i = 0; i < 14; ++i) {
                LinearLayout.LayoutParams p2;
                View v;
                if (i == 1) {
                    button = new Button(this.getContext(), null, null, R.style.Widget_Material3_Button_OutlinedButton);
                    button.setText("Play A Music!");
                    button.setOnClickListener(__ -> {
                        if (this.mGoodAnim != null) {
                            this.mGoodAnim.start();
                        }
                    });
                    v = button;
                    p2 = new LinearLayout.LayoutParams(-2, -2);
                    p2.setMargins(0, this.dp(4.0f), 0, this.dp(4.0f));
                } else if (i == 0) {
                    Switch switchButton;
                    v = switchButton = new Switch(this.getContext());
                    switchButton.setText("Show text block");
                    switchButton.setPadding(this.dp(12.0f), 0, this.dp(12.0f), 0);
                    switchButton.setOnCheckedChangeListener((button, checked) -> {
                        if (checked) {
                            button.post(() -> this.addView((View)this.mTextView, 2));
                        } else {
                            button.post(() -> this.removeView(this.mTextView));
                        }
                    });
                    p2 = new LinearLayout.LayoutParams(this.dp(300.0f), this.dp(40.0f));
                } else {
                    if (i == 2) continue;
                    if (i == 3) {
                        EditText textField = new EditText(this.getContext());
                        textField.setTextAppearance(R.style.TextAppearance_Material3_LabelLarge);
                        v = textField;
                        p2 = new LinearLayout.LayoutParams(-1, -2);
                        textField.setHint("Your Name");
                        textField.setTextSize(16.0f);
                        textField.setTextAlignment(5);
                        textField.setPadding(this.dp(12.0f), 0, this.dp(12.0f), 0);
                    } else if (i == 10) {
                        LinearLayout layout = new LinearLayout(this.getContext());
                        layout.setOrientation(0);
                        layout.setHorizontalGravity(0x800003);
                        int dp3 = this.dp(3.0f);
                        int dp6 = this.dp(6.0f);
                        TextView title = new TextView(this.getContext());
                        title.setText("Title");
                        title.setTextSize(14.0f);
                        title.setTextAlignment(5);
                        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2, 1.0f);
                        params.gravity = 0x800003;
                        layout.addView((View)title, params);
                        EditText input = new EditText(this.getContext());
                        input.setId(16908297);
                        input.setTextAlignment(6);
                        input.setTextSize(14.0f);
                        input.setPadding(dp3, 0, dp3, 0);
                        input.setText("Value");
                        params = new LinearLayout.LayoutParams(-2, -2);
                        params.gravity = 16;
                        layout.addView((View)input, params);
                        LinearLayout.LayoutParams params2 = new LinearLayout.LayoutParams(-1, -2);
                        params2.gravity = 17;
                        params2.setMargins(dp6, 0, dp6, 0);
                        v = layout;
                        p2 = params2;
                    } else if (i == 5) {
                        RadioGroup group = new RadioGroup(this.getContext());
                        v = group;
                        for (int j = 0; j < 3; ++j) {
                            RadioButton button2 = new RadioButton(this.getContext(), null);
                            button2.setText(switch (j) {
                                case 0 -> "English";
                                case 1 -> "Chinese";
                                default -> "Spanish";
                            });
                            button2.setId(9 + j);
                            group.addView(button2);
                        }
                        p2 = new LinearLayout.LayoutParams(-2, -2);
                    } else if (i == 6) {
                        MaterialCheckBox checkBox = new MaterialCheckBox(this.getContext());
                        v = checkBox;
                        checkBox.setText("Checkbox 0");
                        checkBox.setTextSize(16.0f);
                        checkBox.setGravity(0x800005);
                        checkBox.setTooltipText("Hello, this is a tooltip.");
                        p2 = new LinearLayout.LayoutParams(-2, -2);
                    } else if (i == 7) {
                        Spinner spinner = new Spinner(this.getContext());
                        v = spinner;
                        ArrayAdapter<Object> adapter = new ArrayAdapter<Object>(this.getContext(), FontFamily.getSystemFontMap().keySet().toArray());
                        adapter.sort(null);
                        spinner.setAdapter(adapter);
                        p2 = new LinearLayout.LayoutParams(-2, -2);
                        spinner.setMinimumWidth(this.dp(240.0f));
                    } else if (i == 11) {
                        SeekBar seekbar = new SeekBar(this.getContext(), null, null, R.style.Widget_Material3_SeekBar_Discrete);
                        seekbar.setMax(10);
                        v = seekbar;
                        p2 = new LinearLayout.LayoutParams(this.dp(200.0f), -2);
                    } else if (i == 12) {
                        progressBar = new ProgressBar(context, null, null, R.style.Widget_Material3_ProgressBar_Horizontal);
                        progressBar.setIndeterminate(true);
                        v = progressBar;
                        p2 = new LinearLayout.LayoutParams(-2, -2);
                        this.mProgressBar1 = progressBar;
                    } else if (i == 13) {
                        progressBar = new ProgressBar(context);
                        progressBar.setIndeterminate(true);
                        v = progressBar;
                        p2 = new LinearLayout.LayoutParams(-2, -2);
                        this.mProgressBar2 = progressBar;
                    } else {
                        if (i < 6) {
                            button = new Button(this.getContext(), null, null, R.style.Widget_Material3_Button_TonalButton);
                            button.setText("Tonal button " + i);
                            button.setOnClickListener(__ -> {
                                int newVisibility = this.mProgressBar1.getVisibility() == 0 ? 8 : 0;
                                boolean newIndeterminate = !this.mProgressBar1.isIndeterminate();
                                this.mProgressBar1.setIndeterminate(newIndeterminate);
                                this.mProgressBar2.setIndeterminate(newIndeterminate);
                                this.mProgressBar1.setProgress(6000);
                                this.mProgressBar2.setProgress(6000);
                            });
                        } else {
                            button = new Button(this.getContext(), null);
                            button.setText("Filled button " + i);
                        }
                        if ((i & 1) == 1) {
                            button.setEnabled(false);
                            button.setTooltipText("Disabled by intentional UI design");
                        }
                        v = button;
                        p2 = new LinearLayout.LayoutParams(-2, -2);
                        p2.setMargins(0, this.dp(4.0f), 0, this.dp(4.0f));
                    }
                }
                if (i == 8) {
                    v.setOnCreateContextMenuListener((menu, v1, menuInfo) -> {
                        menu.setQwertyMode(true);
                        menu.setGroupDividerEnabled(true);
                        MenuItem item = menu.add(2, 0, 0, "Align start");
                        item.setAlphabeticShortcut('s', KeyEvent.META_CTRL_ON);
                        item.setChecked(true);
                        item = menu.add(2, 0, 0, "Align center");
                        item.setAlphabeticShortcut('d', KeyEvent.META_CTRL_ON);
                        item = menu.add(2, 0, 0, "Align end");
                        item.setAlphabeticShortcut('f', KeyEvent.META_CTRL_ON);
                        menu.setGroupCheckable(2, true, true);
                        SubMenu subMenu = menu.addSubMenu("New");
                        subMenu.add("Document");
                        subMenu.add("Image");
                        menu.add(1, 0, 0, "Delete");
                    });
                }
                v.setClickable(true);
                p2.gravity = 17;
                this.addView(v, p2);
            }
            CloudPick.LOGGER.info((Object)((double)(System.nanoTime() - start) / 1000000.0));
            this.addView((View)new DView(this.getContext()), new LinearLayout.LayoutParams(this.dp(120.0f), this.dp(40.0f)));
            anim = ObjectAnimator.ofFloat(this, sRoundRectLengthProp, 0.0f, 80.0f);
            anim.setDuration(400L);
            anim.setInterpolator(TimeInterpolator.OVERSHOOT);
            anim.addUpdateListener(a -> this.invalidate());
            this.mRoundRectLenAnim = anim;
            this.setLayoutTransition(new LayoutTransition());
        }

        private void changeRadioButtons(int id2, int count) {
            int nextCount;
            int nextId;
            for (int i = 0; i < this.getChildCount(); ++i) {
                View view;
                if (i != count || !((view = this.getChildAt(i)) instanceof LinearLayout)) continue;
                LinearLayout layout = (LinearLayout)view;
                for (int j = 0; j < layout.getChildCount(); ++j) {
                    View view2 = layout.getChildAt(j);
                    if (!(view2 instanceof RadioGroup)) continue;
                    RadioGroup group = (RadioGroup)view2;
                    group.check(id2);
                }
            }
            if (count >= 12) {
                nextId = id2 >= 11 ? 9 : id2 + 1;
                nextCount = 0;
            } else {
                nextId = id2;
                nextCount = count + 1;
            }
            this.postDelayed(() -> this.changeRadioButtons(nextId, nextCount), 50L);
        }

        @Override
        protected void onDetachedFromWindow() {
            super.onDetachedFromWindow();
        }

        @Override
        protected void onDraw(@Nonnull Canvas canvas) {
            super.onDraw(canvas);
        }

        static {
            sLinePoints.put(100.0f).put(100.0f).put(110.0f).put(200.0f).put(120.0f).put(100.0f).put(130.0f).put(300.0f).put(140.0f).put(100.0f).put(150.0f).put(400.0f).put(160.0f).put(100.0f).put(170.0f).put(500.0f).flip();
            sLineColors.put(-1426128896).put(-65281).put(-1442840321).put(-16711936).put(-1442775041).put(-16711936).put(-1426063616).put(-1).flip();
            sTrianglePoints.put(420.0f).put(20.0f).put(420.0f).put(100.0f).put(490.0f).put(60.0f).put(300.0f).put(130.0f).put(250.0f).put(180.0f).put(350.0f).put(180.0f).flip();
            sTriangleColors.put(-1426128896).put(-65281).put(-1442840321).put(-1442775041).put(-16711936).put(-1426063616).flip();
            sRoundRectLengthProp = new FloatProperty<TestLinearLayout>("roundRectLen"){

                @Override
                public void setValue(@Nonnull TestLinearLayout object, float value) {
                    object.mRoundRectLen = value;
                }

                @Override
                public Float get(@Nonnull TestLinearLayout object) {
                    return Float.valueOf(object.mRoundRectLen);
                }
            };
            sSmoothRadiusProp = new FloatProperty<TestLinearLayout>("smoothRadius"){

                @Override
                public void setValue(@Nonnull TestLinearLayout object, float value) {
                    object.mSmoothRadius = value;
                }

                @Override
                public Float get(@Nonnull TestLinearLayout object) {
                    return Float.valueOf(object.mSmoothRadius);
                }
            };
        }

        private static class DView
        extends View {
            private float offsetY;
            private final TextPaint mTextPaint = new TextPaint();
            private final ShapedText mText;
            private final ObjectAnimator mAnimator;
            private final int mColorBackground;

            public DView(Context context) {
                super(context);
                TypedValue value = new TypedValue();
                context.getTheme().resolveAttribute("modernui", "colorOnPrimaryContainer", value, true);
                this.mTextPaint.setColor(value.data);
                this.mTextPaint.setTextSize(13.0f);
                this.mText = TextShaper.shapeText("18:52 modernui", 0, 14, TextDirectionHeuristics.FIRSTSTRONG_LTR, this.mTextPaint);
                context.getTheme().resolveAttribute("modernui", "colorPrimaryContainer", value, true);
                this.mColorBackground = value.data;
                PropertyValuesHolder pvh1 = PropertyValuesHolder.ofFloat(ROTATION, 0.0f, 360.0f);
                PropertyValuesHolder pvh2 = PropertyValuesHolder.ofFloat(SCALE_X, 1.0f, 0.2f);
                PropertyValuesHolder pvh3 = PropertyValuesHolder.ofFloat(SCALE_Y, 1.0f, 0.2f);
                PropertyValuesHolder pvh4 = PropertyValuesHolder.ofFloat(TRANSLATION_X, 0.0f, 60.0f);
                PropertyValuesHolder pvh5 = PropertyValuesHolder.ofFloat(TRANSLATION_Y, 0.0f, -180.0f);
                PropertyValuesHolder pvh6 = PropertyValuesHolder.ofFloat(ALPHA, 1.0f, 0.0f);
                this.mAnimator = ObjectAnimator.ofPropertyValuesHolder(this, pvh1, pvh2, pvh3, pvh4, pvh5, pvh6);
                this.mAnimator.setRepeatCount(1);
                this.mAnimator.setRepeatMode(2);
                this.mAnimator.setDuration(3000L);
                this.setClickable(true);
            }

            @Override
            protected void onDraw(@Nonnull Canvas canvas) {
                Paint paint = Paint.obtain();
                paint.setColor(this.mColorBackground);
                canvas.drawRoundRect(0.0f, 1.0f, (float)this.getWidth(), (float)(this.getHeight() - 2), 4.0f, paint);
                int x = this.getWidth() / 2 - 20;
                canvas.drawShapedText(this.mText, x, this.offsetY + 24.0f, this.mTextPaint);
                paint.recycle();
            }

            @Override
            public boolean performClick() {
                this.mAnimator.start();
                return super.performClick();
            }
        }
    }

    public static class FragmentB
    extends Fragment {
        @Override
        @Nullable
        public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable DataSet savedInstanceState) {
            TextView tv = new TextView(this.getContext());
            tv.setText("My name is Van, I'm an arist, a performance artist.");
            return tv;
        }

        @Override
        public void onDestroy() {
            super.onDestroy();
            CloudPick.LOGGER.info("FragmentB onDestroy()");
        }
    }
}

