/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.animation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.graphics.CloudPick;
import yslelf.cloudpick.graphics.animation.AnimationHandler;
import yslelf.cloudpick.graphics.animation.Animator;
import yslelf.cloudpick.graphics.animation.AnimatorListener;
import yslelf.cloudpick.graphics.animation.ObjectAnimator;
import yslelf.cloudpick.graphics.animation.TimeInterpolator;
import yslelf.cloudpick.graphics.animation.ValueAnimator;
import yslelf.cloudpick.graphics.core.Looper;
import yslelf.cloudpick.graphics.util.ArrayMap;

public final class AnimatorSet
extends Animator
implements AnimationHandler.FrameCallback {
    private ArrayList<Node> mPlayingSet = new ArrayList();
    private ArrayMap<Animator, Node> mNodeMap = new ArrayMap();
    private ArrayList<AnimationEvent> mEvents = new ArrayList();
    private ArrayList<Node> mNodes = new ArrayList();
    private boolean mDependencyDirty = false;
    private boolean mStarted = false;
    private long mStartDelay = 0L;
    private ValueAnimator mDelayAnim = ValueAnimator.ofFloat(0.0f, 1.0f).setDuration(0L);
    private Node mRootNode = new Node(this.mDelayAnim);
    private long mDuration = -1L;
    private TimeInterpolator mInterpolator = null;
    private long mTotalDuration = 0L;
    private final boolean mShouldIgnoreEndWithoutStart;
    private final boolean mShouldResetValuesAtStart;
    private final boolean mEndCanBeCalled;
    private long mLastFrameTime = -1L;
    private long mFirstFrame = -1L;
    private int mLastEventId = -1;
    private boolean mReversing = false;
    private boolean mSelfPulse = true;
    private SeekState mSeekState = new SeekState();
    private boolean mChildrenInitialized = false;
    private long mPauseTime = -1L;
    private AnimatorListener mAnimationEndListener = new AnimatorListener(){

        @Override
        public void onAnimationEnd(@Nonnull Animator animation) {
            if (AnimatorSet.this.mNodeMap.get(animation) == null) {
                throw new RuntimeException("Error: animation ended is not in the node map");
            }
            AnimatorSet.this.mNodeMap.get((Object)animation).mEnded = true;
        }
    };

    public AnimatorSet() {
        this.mNodeMap.put(this.mDelayAnim, this.mRootNode);
        this.mNodes.add(this.mRootNode);
        this.mShouldIgnoreEndWithoutStart = false;
        this.mShouldResetValuesAtStart = true;
        this.mEndCanBeCalled = true;
    }

    public void playTogether(Animator ... items) {
        if (items != null) {
            Builder builder = this.play(items[0]);
            for (int i = 1; i < items.length; ++i) {
                builder.with(items[i]);
            }
        }
    }

    public void playTogether(Collection<Animator> items) {
        if (items != null && items.size() > 0) {
            Builder builder = null;
            for (Animator anim : items) {
                if (builder == null) {
                    builder = this.play(anim);
                    continue;
                }
                builder.with(anim);
            }
        }
    }

    public void playSequentially(Animator ... items) {
        if (items != null) {
            if (items.length == 1) {
                this.play(items[0]);
            } else {
                for (int i = 0; i < items.length - 1; ++i) {
                    this.play(items[i]).before(items[i + 1]);
                }
            }
        }
    }

    public void playSequentially(List<Animator> items) {
        if (items != null && items.size() > 0) {
            if (items.size() == 1) {
                this.play(items.get(0));
            } else {
                for (int i = 0; i < items.size() - 1; ++i) {
                    this.play(items.get(i)).before(items.get(i + 1));
                }
            }
        }
    }

    @Nonnull
    public ArrayList<Animator> getChildAnimations() {
        ArrayList<Animator> childList = new ArrayList<Animator>();
        for (Node node : this.mNodes) {
            if (node == this.mRootNode) continue;
            childList.add(node.mAnimation);
        }
        return childList;
    }

    @Override
    public void setTarget(@Nullable Object target) {
        for (Node node : this.mNodes) {
            Animator animation = node.mAnimation;
            if (animation instanceof AnimatorSet) {
                animation.setTarget(target);
                continue;
            }
            if (!(animation instanceof ObjectAnimator)) continue;
            animation.setTarget(target);
        }
    }

    @Override
    public void setInterpolator(@Nullable TimeInterpolator interpolator) {
        this.mInterpolator = interpolator;
    }

    @Override
    @Nullable
    public TimeInterpolator getInterpolator() {
        return this.mInterpolator;
    }

    public Builder play(Animator anim) {
        if (anim != null) {
            return new Builder(anim);
        }
        return null;
    }

    @Override
    public void cancel() {
        if (Looper.myLooper() == null) {
            throw new RuntimeException("Animators may only be run on Looper threads");
        }
        if (this.isStarted()) {
            if (this.mListeners != null) {
                for (AnimatorListener l2 : this.mListeners) {
                    l2.onAnimationCancel(this);
                }
            }
            ArrayList<Node> playingSet = new ArrayList<Node>(this.mPlayingSet);
            for (Node node : playingSet) {
                node.mAnimation.cancel();
            }
            this.mPlayingSet.clear();
            this.endAnimation();
        }
    }

    private void forceToEnd() {
        if (this.mEndCanBeCalled) {
            this.end();
            return;
        }
        if (this.mReversing) {
            this.handleAnimationEvents(this.mLastEventId, 0, this.getTotalDuration());
        } else {
            long zeroScalePlayTime = this.getTotalDuration();
            if (zeroScalePlayTime == -1L) {
                zeroScalePlayTime = Integer.MAX_VALUE;
            }
            this.handleAnimationEvents(this.mLastEventId, this.mEvents.size() - 1, zeroScalePlayTime);
        }
        this.mPlayingSet.clear();
        this.endAnimation();
    }

    @Override
    public void end() {
        if (Looper.myLooper() == null) {
            throw new RuntimeException("Animators may only be run on Looper threads");
        }
        if (this.mShouldIgnoreEndWithoutStart && !this.isStarted()) {
            return;
        }
        if (this.isStarted()) {
            if (this.mReversing) {
                int n2 = this.mLastEventId = this.mLastEventId == -1 ? this.mEvents.size() : this.mLastEventId;
                while (this.mLastEventId > 0) {
                    --this.mLastEventId;
                    AnimationEvent event = this.mEvents.get(this.mLastEventId);
                    Animator anim = event.mNode.mAnimation;
                    if (this.mNodeMap.get((Object)anim).mEnded) continue;
                    if (event.mEvent == 2) {
                        anim.reverse();
                        continue;
                    }
                    if (event.mEvent != 1 || !anim.isStarted()) continue;
                    anim.end();
                }
            } else {
                while (this.mLastEventId < this.mEvents.size() - 1) {
                    ++this.mLastEventId;
                    AnimationEvent event = this.mEvents.get(this.mLastEventId);
                    Animator anim = event.mNode.mAnimation;
                    if (this.mNodeMap.get((Object)anim).mEnded) continue;
                    if (event.mEvent == 0) {
                        anim.start();
                        continue;
                    }
                    if (event.mEvent != 2 || !anim.isStarted()) continue;
                    anim.end();
                }
            }
            this.mPlayingSet.clear();
        }
        this.endAnimation();
    }

    @Override
    public boolean isRunning() {
        if (this.mStartDelay == 0L) {
            return this.mStarted;
        }
        return this.mLastFrameTime > 0L;
    }

    @Override
    public boolean isStarted() {
        return this.mStarted;
    }

    @Override
    public long getStartDelay() {
        return this.mStartDelay;
    }

    @Override
    public void setStartDelay(long startDelay) {
        long delta;
        if (startDelay < 0L) {
            CloudPick.LOGGER.warn(MARKER, "Start delay should always be non-negative");
            startDelay = 0L;
        }
        if ((delta = startDelay - this.mStartDelay) == 0L) {
            return;
        }
        this.mStartDelay = startDelay;
        if (!this.mDependencyDirty) {
            for (Node node : this.mNodes) {
                if (node == this.mRootNode) {
                    node.mEndTime = this.mStartDelay;
                    continue;
                }
                node.mStartTime = node.mStartTime == -1L ? -1L : node.mStartTime + delta;
                node.mEndTime = node.mEndTime == -1L ? -1L : node.mEndTime + delta;
            }
            if (this.mTotalDuration != -1L) {
                this.mTotalDuration += delta;
            }
        }
    }

    @Override
    public long getDuration() {
        return this.mDuration;
    }

    @Override
    public AnimatorSet setDuration(long duration) {
        if (duration < 0L) {
            throw new IllegalArgumentException("duration must be a value of zero or greater");
        }
        this.mDependencyDirty = true;
        this.mDuration = duration;
        return this;
    }

    @Override
    public void setupStartValues() {
        for (Node node : this.mNodes) {
            if (node == this.mRootNode) continue;
            node.mAnimation.setupStartValues();
        }
    }

    @Override
    public void setupEndValues() {
        for (Node node : this.mNodes) {
            if (node == this.mRootNode) continue;
            node.mAnimation.setupEndValues();
        }
    }

    @Override
    public void pause() {
        if (Looper.myLooper() == null) {
            throw new RuntimeException("Animators may only be run on Looper threads");
        }
        boolean previouslyPaused = this.mPaused;
        super.pause();
        if (!previouslyPaused && this.mPaused) {
            this.mPauseTime = -1L;
        }
    }

    @Override
    public void resume() {
        if (Looper.myLooper() == null) {
            throw new RuntimeException("Animators may only be run on Looper threads");
        }
        boolean previouslyPaused = this.mPaused;
        super.resume();
        if (previouslyPaused && !this.mPaused && this.mPauseTime >= 0L) {
            this.addAnimationCallback();
        }
    }

    @Override
    public void start() {
        this.start(false, true);
    }

    @Override
    void startWithoutPulsing(boolean inReverse) {
        this.start(inReverse, false);
    }

    private void initAnimation() {
        if (this.mInterpolator != null) {
            for (Node node : this.mNodes) {
                node.mAnimation.setInterpolator(this.mInterpolator);
            }
        }
        this.updateAnimatorsDuration();
        this.createDependencyGraph();
    }

    private void start(boolean inReverse, boolean selfPulse) {
        if (Looper.myLooper() == null) {
            throw new RuntimeException("Animators may only be run on Looper threads");
        }
        this.mStarted = true;
        this.mSelfPulse = selfPulse;
        this.mPaused = false;
        this.mPauseTime = -1L;
        for (Node node : this.mNodes) {
            node.mEnded = false;
        }
        this.initAnimation();
        if (inReverse && !this.canReverse()) {
            throw new UnsupportedOperationException("Cannot reverse infinite AnimatorSet");
        }
        this.mReversing = inReverse;
        boolean isEmptySet = AnimatorSet.isEmptySet(this);
        if (!isEmptySet) {
            this.startAnimation();
        }
        if (this.mListeners != null) {
            for (AnimatorListener l2 : this.mListeners) {
                l2.onAnimationStart(this, inReverse);
            }
        }
        if (isEmptySet) {
            this.end();
        }
    }

    private static boolean isEmptySet(@Nonnull AnimatorSet set) {
        if (set.getStartDelay() > 0L) {
            return false;
        }
        for (int i = 0; i < set.getChildAnimations().size(); ++i) {
            Animator anim = set.getChildAnimations().get(i);
            if (!(anim instanceof AnimatorSet)) {
                return false;
            }
            if (AnimatorSet.isEmptySet((AnimatorSet)anim)) continue;
            return false;
        }
        return true;
    }

    private void updateAnimatorsDuration() {
        if (this.mDuration >= 0L) {
            for (Node node : this.mNodes) {
                node.mAnimation.setDuration(this.mDuration);
            }
        }
        this.mDelayAnim.setDuration(this.mStartDelay);
    }

    @Override
    void skipToEndValue(boolean inReverse) {
        if (!this.isInitialized()) {
            throw new UnsupportedOperationException("Children must be initialized.");
        }
        this.initAnimation();
        if (inReverse) {
            for (int i = this.mEvents.size() - 1; i >= 0; --i) {
                if (this.mEvents.get((int)i).mEvent != 1) continue;
                this.mEvents.get((int)i).mNode.mAnimation.skipToEndValue(true);
            }
        } else {
            for (AnimationEvent event : this.mEvents) {
                if (event.mEvent != 2) continue;
                event.mNode.mAnimation.skipToEndValue(false);
            }
        }
    }

    @Override
    void animateBasedOnPlayTime(long currentPlayTime, long lastPlayTime, boolean inReverse) {
        if (currentPlayTime < 0L || lastPlayTime < 0L) {
            throw new UnsupportedOperationException("Error: Play time should never be negative.");
        }
        if (inReverse) {
            if (this.getTotalDuration() == -1L) {
                throw new UnsupportedOperationException("Cannot reverse AnimatorSet with infinite duration");
            }
            long duration = this.getTotalDuration() - this.mStartDelay;
            currentPlayTime = Math.min(currentPlayTime, duration);
            currentPlayTime = duration - currentPlayTime;
            lastPlayTime = duration - lastPlayTime;
        }
        ArrayList<Node> unfinishedNodes = new ArrayList<Node>();
        for (AnimationEvent event : this.mEvents) {
            if (event.getTime() > currentPlayTime || event.getTime() == -1L) break;
            if (event.mEvent == 1 && (event.mNode.mEndTime == -1L || event.mNode.mEndTime > currentPlayTime)) {
                unfinishedNodes.add(event.mNode);
            }
            if (event.mEvent != 2) continue;
            event.mNode.mAnimation.skipToEndValue(false);
        }
        for (Node node : unfinishedNodes) {
            long playTime = this.getPlayTimeForNode(currentPlayTime, node, false);
            node.mAnimation.animateBasedOnPlayTime(playTime -= node.mAnimation.getStartDelay(), lastPlayTime, false);
        }
        for (AnimationEvent event : this.mEvents) {
            if (event.getTime() <= currentPlayTime || event.mEvent != 1) continue;
            event.mNode.mAnimation.skipToEndValue(true);
        }
    }

    @Override
    boolean isInitialized() {
        if (this.mChildrenInitialized) {
            return true;
        }
        boolean allInitialized = true;
        for (Node node : this.mNodes) {
            if (node.mAnimation.isInitialized()) continue;
            allInitialized = false;
            break;
        }
        this.mChildrenInitialized = allInitialized;
        return this.mChildrenInitialized;
    }

    private void skipToStartValue(boolean inReverse) {
        this.skipToEndValue(!inReverse);
    }

    public void setCurrentPlayTime(long playTime) {
        if (this.mReversing && this.getTotalDuration() == -1L) {
            throw new UnsupportedOperationException("Error: Cannot seek in reverse in an infinite AnimatorSet");
        }
        if (this.getTotalDuration() != -1L && playTime > this.getTotalDuration() - this.mStartDelay || playTime < 0L) {
            throw new UnsupportedOperationException("Error: Play time should always be in between0 and duration.");
        }
        this.initAnimation();
        if (!this.isStarted() || this.isPaused()) {
            if (this.mReversing) {
                throw new UnsupportedOperationException("Error: Something went wrong. mReversing should not be set when AnimatorSet is not started.");
            }
            if (!this.mSeekState.isActive()) {
                this.findLatestEventIdForTime(0L);
                this.initChildren();
                this.mSeekState.setPlayTime(0L, this.mReversing);
            }
            this.animateBasedOnPlayTime(playTime, 0L, this.mReversing);
            this.mSeekState.setPlayTime(playTime, this.mReversing);
        } else {
            this.mSeekState.setPlayTime(playTime, this.mReversing);
        }
    }

    public long getCurrentPlayTime() {
        if (this.mSeekState.isActive()) {
            return this.mSeekState.getPlayTime();
        }
        if (this.mLastFrameTime == -1L) {
            return 0L;
        }
        float durationScale = ValueAnimator.sDurationScale;
        float f2 = durationScale = durationScale == 0.0f ? 1.0f : durationScale;
        if (this.mReversing) {
            return (long)((float)(this.mLastFrameTime - this.mFirstFrame) / durationScale);
        }
        return (long)((float)(this.mLastFrameTime - this.mFirstFrame - this.mStartDelay) / durationScale);
    }

    private void initChildren() {
        if (!this.isInitialized()) {
            this.mChildrenInitialized = true;
            this.skipToEndValue(false);
        }
    }

    @Override
    @ApiStatus.Internal
    public boolean doAnimationFrame(long frameTime) {
        float durationScale = ValueAnimator.sDurationScale;
        if (durationScale == 0.0f) {
            this.forceToEnd();
            return true;
        }
        if (this.mFirstFrame < 0L) {
            this.mFirstFrame = frameTime;
        }
        if (this.mPaused) {
            this.mPauseTime = frameTime;
            this.removeAnimationCallback();
            return false;
        }
        if (this.mPauseTime > 0L) {
            this.mFirstFrame += frameTime - this.mPauseTime;
            this.mPauseTime = -1L;
        }
        if (this.mSeekState.isActive()) {
            this.mSeekState.updateSeekDirection(this.mReversing);
            this.mFirstFrame = this.mReversing ? (long)((float)frameTime - (float)this.mSeekState.getPlayTime() * durationScale) : (long)((float)frameTime - (float)(this.mSeekState.getPlayTime() + this.mStartDelay) * durationScale);
            this.mSeekState.reset();
        }
        if (!this.mReversing && (float)frameTime < (float)this.mFirstFrame + (float)this.mStartDelay * durationScale) {
            return false;
        }
        long unscaledPlayTime = (long)((float)(frameTime - this.mFirstFrame) / durationScale);
        this.mLastFrameTime = frameTime;
        int latestId = this.findLatestEventIdForTime(unscaledPlayTime);
        int startId = this.mLastEventId;
        this.handleAnimationEvents(startId, latestId, unscaledPlayTime);
        this.mLastEventId = latestId;
        for (Node node : this.mPlayingSet) {
            if (node.mEnded) continue;
            this.pulseFrame(node, this.getPlayTimeForNode(unscaledPlayTime, node));
        }
        for (int i = this.mPlayingSet.size() - 1; i >= 0; --i) {
            if (!this.mPlayingSet.get((int)i).mEnded) continue;
            this.mPlayingSet.remove(i);
        }
        boolean finished = false;
        if (this.mReversing) {
            if (this.mPlayingSet.size() == 1 && this.mPlayingSet.get(0) == this.mRootNode) {
                finished = true;
            } else if (this.mPlayingSet.isEmpty() && this.mLastEventId < 3) {
                finished = true;
            }
        } else {
            boolean bl = finished = this.mPlayingSet.isEmpty() && this.mLastEventId == this.mEvents.size() - 1;
        }
        if (finished) {
            this.endAnimation();
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public void commitAnimationFrame(long frameTime) {
    }

    @Override
    boolean pulseAnimationFrame(long frameTime) {
        return this.doAnimationFrame(frameTime);
    }

    private void handleAnimationEvents(int startId, int latestId, long playTime) {
        if (this.mReversing) {
            startId = startId == -1 ? this.mEvents.size() : startId;
            for (int i = startId - 1; i >= latestId; --i) {
                AnimationEvent event = this.mEvents.get(i);
                Node node = event.mNode;
                if (event.mEvent == 2) {
                    if (node.mAnimation.isStarted()) {
                        node.mAnimation.cancel();
                    }
                    node.mEnded = false;
                    this.mPlayingSet.add(event.mNode);
                    node.mAnimation.startWithoutPulsing(true);
                    this.pulseFrame(node, 0L);
                    continue;
                }
                if (event.mEvent != 1 || node.mEnded) continue;
                this.pulseFrame(node, this.getPlayTimeForNode(playTime, node));
            }
        } else {
            for (int i = startId + 1; i <= latestId; ++i) {
                AnimationEvent event = this.mEvents.get(i);
                Node node = event.mNode;
                if (event.mEvent == 0) {
                    this.mPlayingSet.add(event.mNode);
                    if (node.mAnimation.isStarted()) {
                        node.mAnimation.cancel();
                    }
                    node.mEnded = false;
                    node.mAnimation.startWithoutPulsing(false);
                    this.pulseFrame(node, 0L);
                    continue;
                }
                if (event.mEvent != 2 || node.mEnded) continue;
                this.pulseFrame(node, this.getPlayTimeForNode(playTime, node));
            }
        }
    }

    private void pulseFrame(@Nonnull Node node, long animPlayTime) {
        if (!node.mEnded) {
            float durationScale = ValueAnimator.sDurationScale;
            durationScale = durationScale == 0.0f ? 1.0f : durationScale;
            node.mEnded = node.mAnimation.pulseAnimationFrame((long)((float)animPlayTime * durationScale));
        }
    }

    private long getPlayTimeForNode(long overallPlayTime, Node node) {
        return this.getPlayTimeForNode(overallPlayTime, node, this.mReversing);
    }

    private long getPlayTimeForNode(long overallPlayTime, Node node, boolean inReverse) {
        if (inReverse) {
            overallPlayTime = this.getTotalDuration() - overallPlayTime;
            return node.mEndTime - overallPlayTime;
        }
        return overallPlayTime - node.mStartTime;
    }

    private void startAnimation() {
        this.addAnimationEndListener();
        this.addAnimationCallback();
        if (this.mSeekState.getPlayTimeNormalized() == 0L && this.mReversing) {
            this.mSeekState.reset();
        }
        if (this.mShouldResetValuesAtStart) {
            if (this.isInitialized()) {
                this.skipToEndValue(!this.mReversing);
            } else if (this.mReversing) {
                this.initChildren();
                this.skipToEndValue(!this.mReversing);
            } else {
                for (int i = this.mEvents.size() - 1; i >= 0; --i) {
                    Animator anim;
                    if (this.mEvents.get((int)i).mEvent != 1 || !(anim = this.mEvents.get((int)i).mNode.mAnimation).isInitialized()) continue;
                    anim.skipToEndValue(true);
                }
            }
        }
        if (this.mReversing || this.mStartDelay == 0L || this.mSeekState.isActive()) {
            long playTime;
            if (this.mSeekState.isActive()) {
                this.mSeekState.updateSeekDirection(this.mReversing);
                playTime = this.mSeekState.getPlayTime();
            } else {
                playTime = 0L;
            }
            int toId = this.findLatestEventIdForTime(playTime);
            this.handleAnimationEvents(-1, toId, playTime);
            for (int i = this.mPlayingSet.size() - 1; i >= 0; --i) {
                if (!this.mPlayingSet.get((int)i).mEnded) continue;
                this.mPlayingSet.remove(i);
            }
            this.mLastEventId = toId;
        }
    }

    private void addAnimationEndListener() {
        for (int i = 1; i < this.mNodes.size(); ++i) {
            this.mNodes.get((int)i).mAnimation.addListener(this.mAnimationEndListener);
        }
    }

    private void removeAnimationEndListener() {
        for (int i = 1; i < this.mNodes.size(); ++i) {
            this.mNodes.get((int)i).mAnimation.removeListener(this.mAnimationEndListener);
        }
    }

    private int findLatestEventIdForTime(long currentPlayTime) {
        int size = this.mEvents.size();
        int latestId = this.mLastEventId;
        if (this.mReversing) {
            currentPlayTime = this.getTotalDuration() - currentPlayTime;
            this.mLastEventId = this.mLastEventId == -1 ? size : this.mLastEventId;
            for (int j = this.mLastEventId - 1; j >= 0; --j) {
                AnimationEvent event = this.mEvents.get(j);
                if (event.getTime() < currentPlayTime) continue;
                latestId = j;
            }
        } else {
            for (int i = this.mLastEventId + 1; i < size; ++i) {
                AnimationEvent event = this.mEvents.get(i);
                if (event.getTime() == -1L || event.getTime() > currentPlayTime) continue;
                latestId = i;
            }
        }
        return latestId;
    }

    private void endAnimation() {
        this.mStarted = false;
        this.mLastFrameTime = -1L;
        this.mFirstFrame = -1L;
        this.mLastEventId = -1;
        this.mPaused = false;
        this.mPauseTime = -1L;
        this.mSeekState.reset();
        this.mPlayingSet.clear();
        this.removeAnimationCallback();
        if (this.mListeners != null) {
            for (AnimatorListener l2 : this.mListeners) {
                l2.onAnimationEnd(this, this.mReversing);
            }
        }
        this.removeAnimationEndListener();
        this.mSelfPulse = true;
        this.mReversing = false;
    }

    private void removeAnimationCallback() {
        if (!this.mSelfPulse) {
            return;
        }
        AnimationHandler handler = AnimationHandler.getInstance();
        handler.removeCallback(this);
    }

    private void addAnimationCallback() {
        if (!this.mSelfPulse) {
            return;
        }
        AnimationHandler handler = AnimationHandler.getInstance();
        handler.addFrameCallback(this, 0L);
    }

    @Override
    @Nonnull
    public AnimatorSet clone() {
        Node nodeClone;
        final AnimatorSet anim = (AnimatorSet)super.clone();
        int nodeCount = this.mNodes.size();
        anim.mStarted = false;
        anim.mLastFrameTime = -1L;
        anim.mFirstFrame = -1L;
        anim.mLastEventId = -1;
        anim.mPaused = false;
        anim.mPauseTime = -1L;
        anim.mSeekState = new SeekState();
        anim.mSelfPulse = true;
        anim.mPlayingSet = new ArrayList();
        anim.mNodeMap = new ArrayMap();
        anim.mNodes = new ArrayList(nodeCount);
        anim.mEvents = new ArrayList();
        anim.mAnimationEndListener = new AnimatorListener(){

            @Override
            public void onAnimationEnd(@Nonnull Animator animation) {
                Node node = anim.mNodeMap.get(animation);
                if (node == null) {
                    throw new RuntimeException("Error: animation ended is not in the node map");
                }
                node.mEnded = true;
            }
        };
        anim.mReversing = false;
        anim.mDependencyDirty = true;
        HashMap<Node, Node> clonesMap = new HashMap<Node, Node>(nodeCount);
        for (Node node : this.mNodes) {
            nodeClone = node.clone();
            nodeClone.mAnimation.removeListener(this.mAnimationEndListener);
            clonesMap.put(node, nodeClone);
            anim.mNodes.add(nodeClone);
            anim.mNodeMap.put(nodeClone.mAnimation, nodeClone);
        }
        anim.mRootNode = (Node)clonesMap.get(this.mRootNode);
        anim.mDelayAnim = (ValueAnimator)anim.mRootNode.mAnimation;
        for (Node node : this.mNodes) {
            int j;
            nodeClone = (Node)clonesMap.get(node);
            nodeClone.mLatestParent = node.mLatestParent == null ? null : (Node)clonesMap.get(node.mLatestParent);
            int size = node.mChildNodes == null ? 0 : node.mChildNodes.size();
            for (j = 0; j < size; ++j) {
                nodeClone.mChildNodes.set(j, (Node)clonesMap.get(node.mChildNodes.get(j)));
            }
            size = node.mSiblings == null ? 0 : node.mSiblings.size();
            for (j = 0; j < size; ++j) {
                nodeClone.mSiblings.set(j, (Node)clonesMap.get(node.mSiblings.get(j)));
            }
            size = node.mParents == null ? 0 : node.mParents.size();
            for (j = 0; j < size; ++j) {
                nodeClone.mParents.set(j, (Node)clonesMap.get(node.mParents.get(j)));
            }
        }
        return anim;
    }

    @Override
    @ApiStatus.Internal
    public boolean canReverse() {
        return this.getTotalDuration() != -1L;
    }

    @Override
    public void reverse() {
        this.start(true, true);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder("AnimatorSet@" + Integer.toHexString(this.hashCode()) + "{");
        int size = this.mNodes.size();
        for (int i = 0; i < size; ++i) {
            Node node = this.mNodes.get(i);
            sb.append("\n    ").append(node.mAnimation.toString());
        }
        return sb.append("\n}").toString();
    }

    private void printChildCount() {
        ArrayList<Node> list = new ArrayList<Node>(this.mNodes.size());
        list.add(this.mRootNode);
        CloudPick.LOGGER.debug(MARKER, "Current tree: ");
        int index = 0;
        while (index < list.size()) {
            int listSize = list.size();
            StringBuilder builder = new StringBuilder();
            while (index < listSize) {
                Node node = (Node)list.get(index);
                int num = 0;
                if (node.mChildNodes != null) {
                    for (int i = 0; i < node.mChildNodes.size(); ++i) {
                        Node child = node.mChildNodes.get(i);
                        if (child.mLatestParent != node) continue;
                        ++num;
                        list.add(child);
                    }
                }
                builder.append(" ");
                builder.append(num);
                ++index;
            }
            CloudPick.LOGGER.debug(MARKER, builder.toString());
        }
    }

    private void createDependencyGraph() {
        if (!this.mDependencyDirty) {
            boolean durationChanged = false;
            for (Node node : this.mNodes) {
                Animator anim = node.mAnimation;
                if (node.mTotalDuration == anim.getTotalDuration()) continue;
                durationChanged = true;
                break;
            }
            if (!durationChanged) {
                return;
            }
        }
        this.mDependencyDirty = false;
        for (Node value : this.mNodes) {
            value.mParentsAdded = false;
        }
        for (Node node : this.mNodes) {
            int j;
            if (node.mParentsAdded) continue;
            node.mParentsAdded = true;
            if (node.mSiblings == null) continue;
            this.findSiblings(node, node.mSiblings);
            node.mSiblings.remove(node);
            int siblingSize = node.mSiblings.size();
            for (j = 0; j < siblingSize; ++j) {
                node.addParents(node.mSiblings.get((int)j).mParents);
            }
            for (j = 0; j < siblingSize; ++j) {
                Node sibling = node.mSiblings.get(j);
                sibling.addParents(node.mParents);
                sibling.mParentsAdded = true;
            }
        }
        for (Node node : this.mNodes) {
            if (node == this.mRootNode || node.mParents != null) continue;
            node.addParent(this.mRootNode);
        }
        ArrayList<Node> visited = new ArrayList<Node>(this.mNodes.size());
        this.mRootNode.mStartTime = 0L;
        this.mRootNode.mEndTime = this.mDelayAnim.getDuration();
        this.updatePlayTime(this.mRootNode, visited);
        this.sortAnimationEvents();
        this.mTotalDuration = this.mEvents.get(this.mEvents.size() - 1).getTime();
    }

    private void sortAnimationEvents() {
        this.mEvents.clear();
        for (int i = 1; i < this.mNodes.size(); ++i) {
            Node node = this.mNodes.get(i);
            this.mEvents.add(new AnimationEvent(node, 0));
            this.mEvents.add(new AnimationEvent(node, 1));
            this.mEvents.add(new AnimationEvent(node, 2));
        }
        this.mEvents.sort((e1, e2) -> {
            long t2;
            long t1 = e1.getTime();
            if (t1 == (t2 = e2.getTime())) {
                if (e2.mEvent + e1.mEvent == 1) {
                    return e1.mEvent - e2.mEvent;
                }
                return e2.mEvent - e1.mEvent;
            }
            if (t2 == -1L) {
                return -1;
            }
            if (t1 == -1L) {
                return 1;
            }
            return (int)(t1 - t2);
        });
        int eventSize = this.mEvents.size();
        int i = 0;
        while (i < eventSize) {
            AnimationEvent event = this.mEvents.get(i);
            if (event.mEvent == 2) {
                boolean needToSwapStart;
                if (event.mNode.mStartTime == event.mNode.mEndTime) {
                    needToSwapStart = true;
                } else if (event.mNode.mEndTime == event.mNode.mStartTime + event.mNode.mAnimation.getStartDelay()) {
                    needToSwapStart = false;
                } else {
                    ++i;
                    continue;
                }
                int startEventId = eventSize;
                int startDelayEndId = eventSize;
                for (int j = i + 1; j < eventSize && (startEventId >= eventSize || startDelayEndId >= eventSize); ++j) {
                    if (this.mEvents.get((int)j).mNode != event.mNode) continue;
                    if (this.mEvents.get((int)j).mEvent == 0) {
                        startEventId = j;
                        continue;
                    }
                    if (this.mEvents.get((int)j).mEvent != 1) continue;
                    startDelayEndId = j;
                }
                if (needToSwapStart && startEventId == this.mEvents.size()) {
                    throw new UnsupportedOperationException("Something went wrong, no start isfound after stop for an animation that has the same start and endtime.");
                }
                if (startDelayEndId == this.mEvents.size()) {
                    throw new UnsupportedOperationException("Something went wrong, no startdelay end is found after stop for an animation");
                }
                if (needToSwapStart) {
                    AnimationEvent startEvent = this.mEvents.remove(startEventId);
                    this.mEvents.add(i, startEvent);
                    ++i;
                }
                AnimationEvent startDelayEndEvent = this.mEvents.remove(startDelayEndId);
                this.mEvents.add(i, startDelayEndEvent);
                i += 2;
                continue;
            }
            ++i;
        }
        if (!this.mEvents.isEmpty() && this.mEvents.get((int)0).mEvent != 0) {
            throw new UnsupportedOperationException("Sorting went bad, the start event should always be at index 0");
        }
        this.mEvents.add(0, new AnimationEvent(this.mRootNode, 0));
        this.mEvents.add(1, new AnimationEvent(this.mRootNode, 1));
        this.mEvents.add(2, new AnimationEvent(this.mRootNode, 2));
        if (this.mEvents.get((int)(this.mEvents.size() - 1)).mEvent == 0 || this.mEvents.get((int)(this.mEvents.size() - 1)).mEvent == 1) {
            throw new UnsupportedOperationException("Something went wrong, the last event is not an end event");
        }
    }

    private void updatePlayTime(@Nonnull Node parent, @Nonnull ArrayList<Node> visited) {
        if (parent.mChildNodes == null) {
            if (parent == this.mRootNode) {
                for (Node node : this.mNodes) {
                    if (node == this.mRootNode) continue;
                    node.mStartTime = -1L;
                    node.mEndTime = -1L;
                }
            }
            return;
        }
        visited.add(parent);
        int childrenSize = parent.mChildNodes.size();
        for (int i = 0; i < childrenSize; ++i) {
            Node child = parent.mChildNodes.get(i);
            child.mTotalDuration = child.mAnimation.getTotalDuration();
            int index = visited.indexOf(child);
            if (index >= 0) {
                for (int j = index; j < visited.size(); ++j) {
                    visited.get((int)j).mLatestParent = null;
                    visited.get((int)j).mStartTime = -1L;
                    visited.get((int)j).mEndTime = -1L;
                }
                child.mStartTime = -1L;
                child.mEndTime = -1L;
                child.mLatestParent = null;
                CloudPick.LOGGER.warn(MARKER, "Cycle found in AnimatorSet: " + this);
                continue;
            }
            if (child.mStartTime != -1L) {
                if (parent.mEndTime == -1L) {
                    child.mLatestParent = parent;
                    child.mStartTime = -1L;
                    child.mEndTime = -1L;
                } else {
                    if (parent.mEndTime >= child.mStartTime) {
                        child.mLatestParent = parent;
                        child.mStartTime = parent.mEndTime;
                    }
                    child.mEndTime = child.mTotalDuration == -1L ? -1L : child.mStartTime + child.mTotalDuration;
                }
            }
            this.updatePlayTime(child, visited);
        }
        visited.remove(parent);
    }

    private void findSiblings(Node node, @Nonnull ArrayList<Node> siblings) {
        if (!siblings.contains(node)) {
            siblings.add(node);
            if (node.mSiblings == null) {
                return;
            }
            for (int i = 0; i < node.mSiblings.size(); ++i) {
                this.findSiblings(node.mSiblings.get(i), siblings);
            }
        }
    }

    public boolean shouldPlayTogether() {
        this.updateAnimatorsDuration();
        this.createDependencyGraph();
        return this.mRootNode.mChildNodes == null || this.mRootNode.mChildNodes.size() == this.mNodes.size() - 1;
    }

    @Override
    public long getTotalDuration() {
        this.updateAnimatorsDuration();
        this.createDependencyGraph();
        return this.mTotalDuration;
    }

    @Nonnull
    private Node getNodeForAnimation(@Nonnull Animator anim) {
        Node node = this.mNodeMap.get(anim);
        if (node == null) {
            node = new Node(anim);
            this.mNodeMap.put(anim, node);
            this.mNodes.add(node);
        }
        return node;
    }

    private static class Node
    implements Cloneable {
        Animator mAnimation;
        ArrayList<Node> mChildNodes = null;
        boolean mEnded = false;
        ArrayList<Node> mSiblings;
        ArrayList<Node> mParents;
        Node mLatestParent = null;
        boolean mParentsAdded = false;
        long mStartTime = 0L;
        long mEndTime = 0L;
        long mTotalDuration = 0L;

        public Node(Animator animation) {
            this.mAnimation = animation;
        }

        @Nonnull
        public Node clone() {
            try {
                Node node = (Node)super.clone();
                node.mAnimation = this.mAnimation.clone();
                if (this.mChildNodes != null) {
                    node.mChildNodes = new ArrayList<Node>(this.mChildNodes);
                }
                if (this.mSiblings != null) {
                    node.mSiblings = new ArrayList<Node>(this.mSiblings);
                }
                if (this.mParents != null) {
                    node.mParents = new ArrayList<Node>(this.mParents);
                }
                node.mEnded = false;
                return node;
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError();
            }
        }

        void addChild(Node node) {
            if (this.mChildNodes == null) {
                this.mChildNodes = new ArrayList();
            }
            if (!this.mChildNodes.contains(node)) {
                this.mChildNodes.add(node);
                node.addParent(this);
            }
        }

        public void addSibling(Node node) {
            if (this.mSiblings == null) {
                this.mSiblings = new ArrayList();
            }
            if (!this.mSiblings.contains(node)) {
                this.mSiblings.add(node);
                node.addSibling(this);
            }
        }

        public void addParent(Node node) {
            if (this.mParents == null) {
                this.mParents = new ArrayList();
            }
            if (!this.mParents.contains(node)) {
                this.mParents.add(node);
                node.addChild(this);
            }
        }

        public void addParents(ArrayList<Node> parents) {
            if (parents == null) {
                return;
            }
            for (Node parent : parents) {
                this.addParent(parent);
            }
        }
    }

    private class SeekState {
        private long mPlayTime = -1L;
        private boolean mSeekingInReverse = false;

        private SeekState() {
        }

        void reset() {
            this.mPlayTime = -1L;
            this.mSeekingInReverse = false;
        }

        void setPlayTime(long playTime, boolean inReverse) {
            if (AnimatorSet.this.getTotalDuration() != -1L) {
                this.mPlayTime = Math.min(playTime, AnimatorSet.this.getTotalDuration() - AnimatorSet.this.mStartDelay);
            }
            this.mPlayTime = Math.max(0L, this.mPlayTime);
            this.mSeekingInReverse = inReverse;
        }

        void updateSeekDirection(boolean inReverse) {
            if (inReverse && AnimatorSet.this.getTotalDuration() == -1L) {
                throw new UnsupportedOperationException("Error: Cannot reverse infinite animator set");
            }
            if (this.mPlayTime >= 0L && inReverse != this.mSeekingInReverse) {
                this.mPlayTime = AnimatorSet.this.getTotalDuration() - AnimatorSet.this.mStartDelay - this.mPlayTime;
                this.mSeekingInReverse = inReverse;
            }
        }

        long getPlayTime() {
            return this.mPlayTime;
        }

        long getPlayTimeNormalized() {
            if (AnimatorSet.this.mReversing) {
                return AnimatorSet.this.getTotalDuration() - AnimatorSet.this.mStartDelay - this.mPlayTime;
            }
            return this.mPlayTime;
        }

        boolean isActive() {
            return this.mPlayTime != -1L;
        }
    }

    public class Builder {
        private final Node mCurrentNode;

        Builder(Animator anim) {
            AnimatorSet.this.mDependencyDirty = true;
            this.mCurrentNode = AnimatorSet.this.getNodeForAnimation(anim);
        }

        public Builder with(@Nonnull Animator anim) {
            Node node = AnimatorSet.this.getNodeForAnimation(anim);
            this.mCurrentNode.addSibling(node);
            return this;
        }

        public Builder before(@Nonnull Animator anim) {
            Node node = AnimatorSet.this.getNodeForAnimation(anim);
            this.mCurrentNode.addChild(node);
            return this;
        }

        public Builder after(@Nonnull Animator anim) {
            Node node = AnimatorSet.this.getNodeForAnimation(anim);
            this.mCurrentNode.addParent(node);
            return this;
        }

        public Builder after(long delay) {
            ValueAnimator anim = ValueAnimator.ofFloat(0.0f, 1.0f);
            anim.setDuration(delay);
            this.after(anim);
            return this;
        }
    }

    private static class AnimationEvent {
        static final int ANIMATION_START = 0;
        static final int ANIMATION_DELAY_ENDED = 1;
        static final int ANIMATION_END = 2;
        final Node mNode;
        final int mEvent;

        AnimationEvent(Node node, int event) {
            this.mNode = node;
            this.mEvent = event;
        }

        long getTime() {
            if (this.mEvent == 0) {
                return this.mNode.mStartTime;
            }
            if (this.mEvent == 1) {
                return this.mNode.mStartTime == -1L ? -1L : this.mNode.mStartTime + this.mNode.mAnimation.getStartDelay();
            }
            return this.mNode.mEndTime;
        }

        public String toString() {
            String eventStr = this.mEvent == 0 ? "start" : (this.mEvent == 1 ? "delay ended" : "end");
            return eventStr + " " + this.mNode.mAnimation.toString();
        }
    }
}

