/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.animation;

import yslelf.cloudpick.graphics.animation.TimeInterpolator;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.graphics.MathUtil;
import yslelf.cloudpick.render.engine.PathUtils;

public class BezierInterpolator
implements TimeInterpolator {
    private static final float PRECISION = 0.002f;
    private final float[] mXs;
    private final float[] mYs;

    public BezierInterpolator(float controlX, float controlY) {
        int numPoints = PathUtils.countQuadraticPoints(0.0f, 0.0f, controlX, controlY, 1.0f, 1.0f, 0.002f);
        float[] coords = new float[numPoints << 1];
        int numCoords = PathUtils.generateQuadraticPoints(0.0f, 0.0f, controlX, controlY, 1.0f, 1.0f, 4.0000004E-6f, coords, 0, coords.length);
        float[] xs = new float[1 + (numCoords >> 1)];
        float[] ys = new float[1 + (numCoords >> 1)];
        int i = 0;
        int p2 = 1;
        while (i < numCoords) {
            xs[p2] = coords[i];
            ys[p2] = coords[i + 1];
            i += 2;
            ++p2;
        }
        this.mXs = xs;
        this.mYs = ys;
    }

    public BezierInterpolator(float controlX1, float controlY1, float controlX2, float controlY2) {
        int numPoints = PathUtils.countCubicPoints(0.0f, 0.0f, controlX1, controlY1, controlX2, controlY2, 1.0f, 1.0f, 0.002f);
        float[] coords = new float[numPoints << 1];
        int numCoords = PathUtils.generateCubicPoints(0.0f, 0.0f, controlX1, controlY1, controlX2, controlY2, 1.0f, 1.0f, 4.0000004E-6f, coords, 0, coords.length);
        float[] xs = new float[1 + (numCoords >> 1)];
        float[] ys = new float[1 + (numCoords >> 1)];
        int i = 0;
        int p2 = 1;
        while (i < numCoords) {
            xs[p2] = coords[i];
            ys[p2] = coords[i + 1];
            i += 2;
            ++p2;
        }
        this.mXs = xs;
        this.mYs = ys;
    }

    private BezierInterpolator(float[] xs, float[] ys) {
        this.mXs = xs;
        this.mYs = ys;
    }

    @NonNull
    public static BezierInterpolator createTwoCubic(float controlX1, float controlY1, float controlX2, float controlY2, float controlX3, float controlY3, float controlX4, float controlY4, float controlX5, float controlY5) {
        int numPoints1 = PathUtils.countCubicPoints(0.0f, 0.0f, controlX1, controlY1, controlX2, controlY2, controlX3, controlY3, 0.002f);
        int numPoints2 = PathUtils.countCubicPoints(controlX3, controlY3, controlX4, controlY4, controlX5, controlY5, 1.0f, 1.0f, 0.002f);
        float[] coords = new float[(numPoints1 << 1) + (numPoints2 << 1)];
        int numCoords1 = PathUtils.generateCubicPoints(0.0f, 0.0f, controlX1, controlY1, controlX2, controlY2, controlX3, controlY3, 4.0000004E-6f, coords, 0, numPoints1 << 1);
        int numCoords2 = PathUtils.generateCubicPoints(controlX3, controlY3, controlX4, controlY4, controlX5, controlY5, 1.0f, 1.0f, 4.0000004E-6f, coords, numCoords1, numPoints2 << 1);
        float[] xs = new float[1 + (numCoords1 >> 1) + (numCoords2 >> 1)];
        float[] ys = new float[1 + (numCoords1 >> 1) + (numCoords2 >> 1)];
        int i = 0;
        int p2 = 1;
        while (i < numCoords1 + numCoords2) {
            xs[p2] = coords[i];
            ys[p2] = coords[i + 1];
            i += 2;
            ++p2;
        }
        return new BezierInterpolator(xs, ys);
    }

    @Override
    public float getInterpolation(float t2) {
        if (t2 <= 0.0f) {
            return 0.0f;
        }
        if (t2 >= 1.0f) {
            return 1.0f;
        }
        int low = 0;
        int high = this.mXs.length - 1;
        while (high - low > 1) {
            int mid = low + high >>> 1;
            if (t2 < this.mXs[mid]) {
                high = mid;
                continue;
            }
            low = mid;
        }
        float xRange = this.mXs[high] - this.mXs[low];
        if (xRange == 0.0f) {
            return this.mYs[low];
        }
        float tInRange = t2 - this.mXs[low];
        float fraction = tInRange / xRange;
        return MathUtil.lerp(this.mYs[low], this.mYs[high], fraction);
    }
}

