/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.animation;

import yslelf.cloudpick.graphics.animation.Keyframe;
import yslelf.cloudpick.graphics.animation.KeyframeSet;
import yslelf.cloudpick.graphics.animation.Keyframes;
import yslelf.cloudpick.graphics.animation.TimeInterpolator;

class FloatKeyframeSet
extends KeyframeSet
implements Keyframes.FloatKeyframes {
    FloatKeyframeSet(Keyframe ... keyframes) {
        super(keyframes);
    }

    @Override
    public FloatKeyframeSet copy() {
        int numKeyframes = this.mKeyframes.length;
        Keyframe[] newKeyframes = new Keyframe.FloatKeyframe[numKeyframes];
        for (int i = 0; i < numKeyframes; ++i) {
            newKeyframes[i] = (Keyframe.FloatKeyframe)this.mKeyframes[i].copy();
        }
        return new FloatKeyframeSet(newKeyframes);
    }

    @Override
    public Float getValue(float fraction) {
        return Float.valueOf(this.getFloatValue(fraction));
    }

    @Override
    public float getFloatValue(float fraction) {
        Keyframe[] keyframes = this.mKeyframes;
        int length = keyframes.length;
        if (fraction <= 0.0f) {
            Keyframe.FloatKeyframe prevKeyframe = (Keyframe.FloatKeyframe)keyframes[0];
            Keyframe.FloatKeyframe nextKeyframe = (Keyframe.FloatKeyframe)keyframes[1];
            float prevValue = prevKeyframe.getFloatValue();
            float nextValue = nextKeyframe.getFloatValue();
            TimeInterpolator interpolator = nextKeyframe.getInterpolator();
            if (interpolator != null) {
                fraction = interpolator.getInterpolation(fraction);
            }
            float prevFraction = prevKeyframe.getFraction();
            float intervalFraction = (fraction - prevFraction) / (nextKeyframe.getFraction() - prevFraction);
            return this.mEvaluator == null ? prevValue + intervalFraction * (nextValue - prevValue) : this.mEvaluator.evaluate(intervalFraction, Float.valueOf(prevValue), Float.valueOf(nextValue)).floatValue();
        }
        if (fraction >= 1.0f) {
            Keyframe.FloatKeyframe prevKeyframe = (Keyframe.FloatKeyframe)keyframes[length - 2];
            Keyframe.FloatKeyframe nextKeyframe = (Keyframe.FloatKeyframe)keyframes[length - 1];
            float prevValue = prevKeyframe.getFloatValue();
            float nextValue = nextKeyframe.getFloatValue();
            TimeInterpolator interpolator = nextKeyframe.getInterpolator();
            if (interpolator != null) {
                fraction = interpolator.getInterpolation(fraction);
            }
            float prevFraction = prevKeyframe.getFraction();
            float intervalFraction = (fraction - prevFraction) / (nextKeyframe.getFraction() - prevFraction);
            return this.mEvaluator == null ? prevValue + intervalFraction * (nextValue - prevValue) : this.mEvaluator.evaluate(intervalFraction, Float.valueOf(prevValue), Float.valueOf(nextValue)).floatValue();
        }
        Keyframe.FloatKeyframe prevKeyframe = (Keyframe.FloatKeyframe)keyframes[0];
        for (int i = 1; i < length; ++i) {
            Keyframe.FloatKeyframe nextKeyframe = (Keyframe.FloatKeyframe)keyframes[i];
            if (fraction < nextKeyframe.getFraction()) {
                TimeInterpolator interpolator = nextKeyframe.getInterpolator();
                float prevFraction = prevKeyframe.getFraction();
                float intervalFraction = (fraction - prevFraction) / (nextKeyframe.getFraction() - prevFraction);
                float prevValue = prevKeyframe.getFloatValue();
                float nextValue = nextKeyframe.getFloatValue();
                if (interpolator != null) {
                    intervalFraction = interpolator.getInterpolation(intervalFraction);
                }
                return this.mEvaluator == null ? prevValue + intervalFraction * (nextValue - prevValue) : this.mEvaluator.evaluate(intervalFraction, Float.valueOf(prevValue), Float.valueOf(nextValue)).floatValue();
            }
            prevKeyframe = nextKeyframe;
        }
        return prevKeyframe.getFloatValue();
    }
}

