/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.animation;

import yslelf.cloudpick.graphics.animation.AnticipateOvershootInterpolator;
import yslelf.cloudpick.graphics.animation.BezierInterpolator;
import yslelf.cloudpick.graphics.animation.BounceInterpolator;
import yslelf.cloudpick.graphics.animation.ViscousFluidInterpolator;
import yslelf.cloudpick.graphics.annotation.NonNull;

@FunctionalInterface
public interface TimeInterpolator {
    @NonNull
    public static final TimeInterpolator LINEAR = t2 -> t2;
    @NonNull
    public static final TimeInterpolator ACCELERATE = t2 -> t2 * t2;
    @NonNull
    public static final TimeInterpolator DECELERATE = t2 -> 1.0f - (1.0f - t2) * (1.0f - t2);
    @NonNull
    public static final TimeInterpolator DECELERATE_CUBIC = t2 -> (t2 -= 1.0f) * t2 * t2 + 1.0f;
    @NonNull
    public static final TimeInterpolator DECELERATE_QUINTIC = t2 -> (t2 -= 1.0f) * t2 * t2 * t2 * t2 + 1.0f;
    @NonNull
    public static final TimeInterpolator ACCELERATE_DECELERATE = t2 -> (float)Math.cos(((double)t2 + 1.0) * Math.PI) * 0.5f + 0.5f;
    @NonNull
    public static final TimeInterpolator SINE = t2 -> (float)Math.sin(1.5707963267948966 * (double)t2);
    @NonNull
    public static final TimeInterpolator ANTICIPATE = t2 -> t2 * t2 * (3.0f * t2 - 2.0f);
    @NonNull
    public static final TimeInterpolator OVERSHOOT = t2 -> (t2 -= 1.0f) * t2 * (3.0f * t2 + 2.0f) + 1.0f;
    @NonNull
    public static final TimeInterpolator ANTICIPATE_OVERSHOOT = new AnticipateOvershootInterpolator();
    @NonNull
    public static final TimeInterpolator BOUNCE = new BounceInterpolator();
    @NonNull
    public static final TimeInterpolator VISCOUS_FLUID = new ViscousFluidInterpolator();
    @NonNull
    public static final TimeInterpolator FAST_OUT_SLOW_IN = new BezierInterpolator(0.4f, 0.0f, 0.2f, 1.0f);
    @NonNull
    public static final TimeInterpolator FAST_OUT_LINEAR_IN = new BezierInterpolator(0.4f, 0.0f, 1.0f, 1.0f);
    @NonNull
    public static final TimeInterpolator LINEAR_OUT_SLOW_IN = new BezierInterpolator(0.0f, 0.0f, 0.2f, 1.0f);
    @NonNull
    public static final TimeInterpolator MOTION_EASING_STANDARD = new BezierInterpolator(0.2f, 0.0f, 0.0f, 1.0f);
    @NonNull
    public static final TimeInterpolator MOTION_EASING_EMPHASIZED = BezierInterpolator.createTwoCubic(0.05f, 0.0f, 0.133333f, 0.06f, 0.166666f, 0.4f, 0.208333f, 0.82f, 0.25f, 1.0f);

    public float getInterpolation(float var1);

    @NonNull
    public static TimeInterpolator linear() {
        return LINEAR;
    }

    @NonNull
    public static TimeInterpolator accelerate() {
        return ACCELERATE;
    }

    @NonNull
    public static TimeInterpolator accelerate(float factor) {
        if (factor == 1.0f) {
            return ACCELERATE;
        }
        double f2 = (double)factor * 2.0;
        return t2 -> (float)Math.pow(t2, f2);
    }

    @NonNull
    public static TimeInterpolator decelerate() {
        return DECELERATE;
    }

    @NonNull
    public static TimeInterpolator decelerate(float factor) {
        if (factor == 1.0f) {
            return DECELERATE;
        }
        if (factor == 1.5f) {
            return DECELERATE_CUBIC;
        }
        if (factor == 2.5f) {
            return DECELERATE_QUINTIC;
        }
        double f2 = (double)factor * 2.0;
        return t2 -> (float)(1.0 - Math.pow(1.0 - (double)t2, f2));
    }

    @NonNull
    public static TimeInterpolator cycle(float cycle) {
        if (cycle == 0.25f) {
            return SINE;
        }
        double f2 = Math.PI * 2 * (double)cycle;
        return t2 -> (float)Math.sin(f2 * (double)t2);
    }

    @NonNull
    public static TimeInterpolator anticipate() {
        return ANTICIPATE;
    }

    @NonNull
    public static TimeInterpolator anticipate(float tension) {
        if (tension == 2.0f) {
            return ANTICIPATE;
        }
        return t2 -> t2 * t2 * ((tension + 1.0f) * t2 - tension);
    }

    @NonNull
    public static TimeInterpolator overshoot() {
        return OVERSHOOT;
    }

    @NonNull
    public static TimeInterpolator overshoot(float tension) {
        if (tension == 2.0f) {
            return OVERSHOOT;
        }
        return t2 -> (t2 -= 1.0f) * t2 * ((tension + 1.0f) * t2 + tension) + 1.0f;
    }

    @NonNull
    public static TimeInterpolator bounce() {
        return BOUNCE;
    }
}

