/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.animation;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.graphics.animation.AnimationHandler;
import yslelf.cloudpick.graphics.animation.AnimationUtils;
import yslelf.cloudpick.graphics.animation.Animator;
import yslelf.cloudpick.graphics.animation.AnimatorListener;
import yslelf.cloudpick.graphics.animation.ColorEvaluator;
import yslelf.cloudpick.graphics.animation.PropertyValuesHolder;
import yslelf.cloudpick.graphics.animation.TimeInterpolator;
import yslelf.cloudpick.graphics.animation.TypeEvaluator;
import yslelf.cloudpick.graphics.annotation.CallSuper;
import yslelf.cloudpick.graphics.core.Looper;

public class ValueAnimator
extends Animator
implements AnimationHandler.FrameCallback {
    @ApiStatus.Internal
    public static volatile float sDurationScale = 1.0f;
    public static final int RESTART = 1;
    public static final int REVERSE = 2;
    public static final int INFINITE = -1;
    private boolean mRunning = false;
    private boolean mStarted = false;
    private boolean mResumed = false;
    private boolean mReversing;
    private boolean mStartListenersCalled = false;
    boolean mInitialized = false;
    private boolean mAnimationEndRequested = false;
    boolean mStartTimeCommitted;
    long mStartTime = -1L;
    private long mPauseTime;
    float mSeekFraction = -1.0f;
    private long mDuration = 300L;
    private long mStartDelay = 0L;
    private int mRepeatCount = 0;
    private int mRepeatMode = 1;
    private boolean mSelfPulse = true;
    private boolean mSuppressSelfPulseRequested = false;
    private float mOverallFraction = 0.0f;
    private float mCurrentFraction = 0.0f;
    private long mLastFrameTime = -1L;
    @Nonnull
    private TimeInterpolator mInterpolator = TimeInterpolator.ACCELERATE_DECELERATE;
    @Nullable
    ArrayList<AnimatorUpdateListener> mUpdateListeners;
    PropertyValuesHolder[] mValues;

    public static boolean areAnimatorsEnabled() {
        return sDurationScale != 0.0f;
    }

    @Nonnull
    public static ValueAnimator ofInt(int ... values) {
        ValueAnimator anim = new ValueAnimator();
        anim.setValues(PropertyValuesHolder.ofInt(values));
        return anim;
    }

    @Nonnull
    public static ValueAnimator ofArgb(int ... values) {
        ValueAnimator anim = new ValueAnimator();
        anim.setValues(PropertyValuesHolder.ofInt(values));
        anim.setEvaluator(ColorEvaluator.getInstance());
        return anim;
    }

    @Nonnull
    public static ValueAnimator ofFloat(float ... values) {
        ValueAnimator anim = new ValueAnimator();
        anim.setValues(PropertyValuesHolder.ofFloat(values));
        return anim;
    }

    @Nonnull
    @SafeVarargs
    public static <V> ValueAnimator ofObject(@Nonnull TypeEvaluator<V> evaluator, V ... values) {
        ValueAnimator anim = new ValueAnimator();
        anim.setValues(PropertyValuesHolder.ofObject(evaluator, values));
        return anim;
    }

    public void setValues(PropertyValuesHolder ... values) {
        this.mValues = values;
        this.mInitialized = false;
    }

    @Nonnull
    public PropertyValuesHolder[] getValues() {
        return this.mValues;
    }

    void initAnimation() {
        if (!this.mInitialized) {
            if (this.mValues != null) {
                for (PropertyValuesHolder value : this.mValues) {
                    value.init();
                }
            }
            this.mInitialized = true;
        }
    }

    @Override
    public ValueAnimator setDuration(long duration) {
        if (duration < 0L) {
            duration = 0L;
        }
        this.mDuration = duration;
        return this;
    }

    private long getScaledDuration() {
        return (long)((float)this.mDuration * sDurationScale);
    }

    @Override
    public long getDuration() {
        return this.mDuration;
    }

    @Override
    public long getTotalDuration() {
        if (this.mRepeatCount == -1) {
            return -1L;
        }
        return this.mStartDelay + this.mDuration * (long)(this.mRepeatCount + 1);
    }

    public void setCurrentPlayTime(long playTime) {
        float fraction = this.mDuration > 0L ? (float)playTime / (float)this.mDuration : 1.0f;
        this.setCurrentFraction(fraction);
    }

    public void setCurrentFraction(float fraction) {
        this.initAnimation();
        fraction = this.clampFraction(fraction);
        this.mStartTimeCommitted = true;
        if (this.isPulsingInternal()) {
            long seekTime = (long)((float)this.getScaledDuration() * fraction);
            long currentTime = AnimationUtils.currentAnimationTimeMillis();
            this.mStartTime = currentTime - seekTime;
        } else {
            this.mSeekFraction = fraction;
        }
        this.mOverallFraction = fraction;
        float currentIterationFraction = this.getCurrentIterationFraction(fraction, this.mReversing);
        this.animateValue(currentIterationFraction);
    }

    private int getCurrentIteration(float fraction) {
        double iteration;
        if ((double)(fraction = this.clampFraction(fraction)) == (iteration = Math.floor(fraction)) && fraction > 0.0f) {
            iteration -= 1.0;
        }
        return (int)iteration;
    }

    private float getCurrentIterationFraction(float fraction, boolean inReverse) {
        fraction = this.clampFraction(fraction);
        int iteration = this.getCurrentIteration(fraction);
        float currentFraction = fraction - (float)iteration;
        return this.shouldPlayBackward(iteration, inReverse) ? 1.0f - currentFraction : currentFraction;
    }

    private float clampFraction(float fraction) {
        if (fraction < 0.0f) {
            fraction = 0.0f;
        } else if (this.mRepeatCount != -1) {
            fraction = Math.min(fraction, (float)(this.mRepeatCount + 1));
        }
        return fraction;
    }

    private boolean shouldPlayBackward(int iteration, boolean inReverse) {
        if (iteration > 0 && this.mRepeatMode == 2 && (iteration < this.mRepeatCount + 1 || this.mRepeatCount == -1)) {
            if (inReverse) {
                return iteration % 2 == 0;
            }
            return iteration % 2 != 0;
        }
        return inReverse;
    }

    public long getCurrentPlayTime() {
        if (!this.mInitialized || !this.mStarted && this.mSeekFraction < 0.0f) {
            return 0L;
        }
        if (this.mSeekFraction >= 0.0f) {
            return (long)((float)this.mDuration * this.mSeekFraction);
        }
        float durationScale = sDurationScale;
        if (durationScale == 0.0f) {
            durationScale = 1.0f;
        }
        return (long)((float)(AnimationUtils.currentAnimationTimeMillis() - this.mStartTime) / durationScale);
    }

    @Override
    public void setStartDelay(long startDelay) {
        if (startDelay < 0L) {
            startDelay = 0L;
        }
        this.mStartDelay = startDelay;
    }

    @Override
    public long getStartDelay() {
        return this.mStartDelay;
    }

    public Object getAnimatedValue() {
        if (this.mValues != null && this.mValues.length > 0) {
            return this.mValues[0].getAnimatedValue();
        }
        return null;
    }

    public void setRepeatCount(int value) {
        this.mRepeatCount = value;
    }

    public int getRepeatCount() {
        return this.mRepeatCount;
    }

    public void setRepeatMode(int value) {
        this.mRepeatMode = value;
    }

    public int getRepeatMode() {
        return this.mRepeatMode;
    }

    public void addUpdateListener(@Nonnull AnimatorUpdateListener listener) {
        if (this.mUpdateListeners == null) {
            this.mUpdateListeners = new ArrayList();
        }
        this.mUpdateListeners.add(listener);
    }

    public void removeAllUpdateListeners() {
        if (this.mUpdateListeners != null) {
            this.mUpdateListeners.clear();
            this.mUpdateListeners = null;
        }
    }

    public void removeUpdateListener(@Nonnull AnimatorUpdateListener listener) {
        if (this.mUpdateListeners == null) {
            return;
        }
        this.mUpdateListeners.remove(listener);
        if (this.mUpdateListeners.isEmpty()) {
            this.mUpdateListeners = null;
        }
    }

    @Override
    public void setInterpolator(@Nullable TimeInterpolator value) {
        this.mInterpolator = Objects.requireNonNullElse(value, TimeInterpolator.LINEAR);
    }

    @Override
    @Nonnull
    public TimeInterpolator getInterpolator() {
        return this.mInterpolator;
    }

    public void setEvaluator(TypeEvaluator<?> value) {
        if (value != null && this.mValues != null && this.mValues.length > 0) {
            this.mValues[0].setEvaluator(value);
        }
    }

    private void notifyStartListeners() {
        if (this.mListeners != null && !this.mStartListenersCalled) {
            for (AnimatorListener l2 : this.mListeners) {
                l2.onAnimationStart(this, this.mReversing);
            }
        }
        this.mStartListenersCalled = true;
    }

    private void start(boolean playBackwards) {
        if (Looper.myLooper() == null) {
            throw new RuntimeException("Animators may only be run on Looper threads");
        }
        this.mReversing = playBackwards;
        boolean bl = this.mSelfPulse = !this.mSuppressSelfPulseRequested;
        if (playBackwards && this.mSeekFraction != -1.0f && this.mSeekFraction != 0.0f) {
            if (this.mRepeatCount == -1) {
                float fraction = (float)((double)this.mSeekFraction - Math.floor(this.mSeekFraction));
                this.mSeekFraction = 1.0f - fraction;
            } else {
                this.mSeekFraction = (float)(1 + this.mRepeatCount) - this.mSeekFraction;
            }
        }
        this.mStarted = true;
        this.mPaused = false;
        this.mRunning = false;
        this.mAnimationEndRequested = false;
        this.mLastFrameTime = -1L;
        this.mStartTime = -1L;
        this.addAnimationCallback();
        if (this.mStartDelay == 0L || this.mSeekFraction >= 0.0f || this.mReversing) {
            this.startAnimation();
            if (this.mSeekFraction == -1.0f) {
                this.setCurrentPlayTime(0L);
            } else {
                this.setCurrentFraction(this.mSeekFraction);
            }
        }
    }

    @Override
    void startWithoutPulsing(boolean inReverse) {
        this.mSuppressSelfPulseRequested = true;
        if (inReverse) {
            this.reverse();
        } else {
            this.start();
        }
        this.mSuppressSelfPulseRequested = false;
    }

    @Override
    public void start() {
        this.start(false);
    }

    @Override
    public void cancel() {
        if (Looper.myLooper() == null) {
            throw new RuntimeException("Animators may only be run on Looper threads");
        }
        if (this.mAnimationEndRequested) {
            return;
        }
        if ((this.mStarted || this.mRunning) && this.mListeners != null) {
            if (!this.mRunning) {
                this.notifyStartListeners();
            }
            for (AnimatorListener l2 : this.mListeners) {
                l2.onAnimationCancel(this);
            }
        }
        this.endAnimation();
    }

    @Override
    public void end() {
        if (Looper.myLooper() == null) {
            throw new RuntimeException("Animators may only be run on Looper threads");
        }
        if (!this.mRunning) {
            this.startAnimation();
            this.mStarted = true;
        } else if (!this.mInitialized) {
            this.initAnimation();
        }
        this.animateValue(this.shouldPlayBackward(this.mRepeatCount, this.mReversing) ? 0.0f : 1.0f);
        this.endAnimation();
    }

    @Override
    public void resume() {
        if (Looper.myLooper() == null) {
            throw new RuntimeException("Animators may only be resumed from the same thread that the animator was started on");
        }
        if (this.mPaused && !this.mResumed) {
            this.mResumed = true;
            if (this.mPauseTime > 0L) {
                this.addAnimationCallback();
            }
        }
        super.resume();
    }

    @Override
    public void pause() {
        boolean previouslyPaused = this.mPaused;
        super.pause();
        if (!previouslyPaused && this.mPaused) {
            this.mPauseTime = -1L;
            this.mResumed = false;
        }
    }

    @Override
    public boolean isRunning() {
        return this.mRunning;
    }

    @Override
    public boolean isStarted() {
        return this.mStarted;
    }

    @Override
    public void reverse() {
        if (this.isPulsingInternal()) {
            long currentTime = AnimationUtils.currentAnimationTimeMillis();
            long currentPlayTime = currentTime - this.mStartTime;
            long timeLeft = this.getScaledDuration() - currentPlayTime;
            this.mStartTime = currentTime - timeLeft;
            this.mStartTimeCommitted = true;
            this.mReversing = !this.mReversing;
        } else if (this.mStarted) {
            this.mReversing = !this.mReversing;
            this.end();
        } else {
            this.start(true);
        }
    }

    @Override
    public boolean canReverse() {
        return true;
    }

    private void endAnimation() {
        boolean notify;
        if (this.mAnimationEndRequested) {
            return;
        }
        this.removeAnimationCallback();
        this.mAnimationEndRequested = true;
        this.mPaused = false;
        boolean bl = notify = (this.mStarted || this.mRunning) && this.mListeners != null;
        if (notify && !this.mRunning) {
            this.notifyStartListeners();
        }
        this.mRunning = false;
        this.mStarted = false;
        this.mStartListenersCalled = false;
        this.mLastFrameTime = -1L;
        this.mStartTime = -1L;
        if (notify && this.mListeners != null) {
            for (AnimatorListener l2 : this.mListeners) {
                l2.onAnimationEnd(this, this.mReversing);
            }
        }
        this.mReversing = false;
    }

    private void startAnimation() {
        this.mAnimationEndRequested = false;
        this.initAnimation();
        this.mRunning = true;
        this.mOverallFraction = this.mSeekFraction >= 0.0f ? this.mSeekFraction : 0.0f;
        if (this.mListeners != null) {
            this.notifyStartListeners();
        }
    }

    private boolean isPulsingInternal() {
        return this.mLastFrameTime >= 0L;
    }

    public void commitAnimationFrame(long frameTime) {
        if (!this.mStartTimeCommitted) {
            this.mStartTimeCommitted = true;
            long adjustment = frameTime - this.mLastFrameTime;
            if (adjustment > 0L) {
                this.mStartTime += adjustment;
            }
        }
    }

    boolean animateBasedOnTime(long currentTime) {
        boolean done = false;
        if (this.mRunning) {
            boolean lastIterationFinished;
            long scaledDuration = this.getScaledDuration();
            float fraction = scaledDuration > 0L ? (float)(currentTime - this.mStartTime) / (float)scaledDuration : 1.0f;
            float lastFraction = this.mOverallFraction;
            boolean newIteration = (int)fraction > (int)lastFraction;
            boolean bl = lastIterationFinished = fraction >= (float)(this.mRepeatCount + 1) && this.mRepeatCount != -1;
            if (scaledDuration == 0L) {
                done = true;
            } else if (newIteration && !lastIterationFinished) {
                if (this.mListeners != null) {
                    for (AnimatorListener listener : this.mListeners) {
                        listener.onAnimationRepeat(this);
                    }
                }
            } else if (lastIterationFinished) {
                done = true;
            }
            this.mOverallFraction = this.clampFraction(fraction);
            float currentIterationFraction = this.getCurrentIterationFraction(this.mOverallFraction, this.mReversing);
            this.animateValue(currentIterationFraction);
        }
        return done;
    }

    @Override
    void animateBasedOnPlayTime(long currentPlayTime, long lastPlayTime, boolean inReverse) {
        if (currentPlayTime < 0L || lastPlayTime < 0L) {
            throw new UnsupportedOperationException("Error: Play time should never be negative.");
        }
        this.initAnimation();
        if (this.mRepeatCount > 0) {
            int iteration = (int)(currentPlayTime / this.mDuration);
            int lastIteration = (int)(lastPlayTime / this.mDuration);
            if ((iteration = Math.min(iteration, this.mRepeatCount)) != (lastIteration = Math.min(lastIteration, this.mRepeatCount)) && this.mListeners != null) {
                for (AnimatorListener listener : this.mListeners) {
                    listener.onAnimationRepeat(this);
                }
            }
        }
        if (this.mRepeatCount != -1 && currentPlayTime >= (long)(this.mRepeatCount + 1) * this.mDuration) {
            this.skipToEndValue(inReverse);
        } else {
            float fraction = (float)currentPlayTime / (float)this.mDuration;
            fraction = this.getCurrentIterationFraction(fraction, inReverse);
            this.animateValue(fraction);
        }
    }

    @Override
    void skipToEndValue(boolean inReverse) {
        float endFraction;
        this.initAnimation();
        float f2 = endFraction = inReverse ? 0.0f : 1.0f;
        if (this.mRepeatCount % 2 == 1 && this.mRepeatMode == 2) {
            endFraction = 0.0f;
        }
        this.animateValue(endFraction);
    }

    @Override
    boolean isInitialized() {
        return this.mInitialized;
    }

    @Override
    public final boolean doAnimationFrame(long frameTime) {
        if (this.mStartTime < 0L) {
            long l2 = this.mStartTime = this.mReversing ? frameTime : frameTime + (long)((float)this.mStartDelay * sDurationScale);
        }
        if (this.mPaused) {
            this.mPauseTime = frameTime;
            this.removeAnimationCallback();
            return false;
        }
        if (this.mResumed) {
            this.mResumed = false;
            if (this.mPauseTime > 0L) {
                this.mStartTime += frameTime - this.mPauseTime;
            }
        }
        if (!this.mRunning) {
            if (this.mStartTime > frameTime && this.mSeekFraction == -1.0f) {
                return false;
            }
            this.mRunning = true;
            this.startAnimation();
        }
        if (this.mLastFrameTime < 0L) {
            if (this.mSeekFraction >= 0.0f) {
                long seekTime = (long)((float)this.getScaledDuration() * this.mSeekFraction);
                this.mStartTime = frameTime - seekTime;
                this.mSeekFraction = -1.0f;
            }
            this.mStartTimeCommitted = false;
        }
        this.mLastFrameTime = frameTime;
        long currentTime = Math.max(frameTime, this.mStartTime);
        boolean finished = this.animateBasedOnTime(currentTime);
        if (finished) {
            this.endAnimation();
        }
        return finished;
    }

    @Override
    boolean pulseAnimationFrame(long frameTime) {
        if (this.mSelfPulse) {
            return false;
        }
        return this.doAnimationFrame(frameTime);
    }

    private void removeAnimationCallback() {
        if (this.mSelfPulse) {
            AnimationHandler.getInstance().removeCallback(this);
        }
    }

    private void addAnimationCallback() {
        if (this.mSelfPulse) {
            AnimationHandler.getInstance().addFrameCallback(this, 0L);
        }
    }

    public float getAnimatedFraction() {
        return this.mCurrentFraction;
    }

    @CallSuper
    void animateValue(float fraction) {
        this.mCurrentFraction = fraction = this.mInterpolator.getInterpolation(fraction);
        if (this.mValues != null) {
            for (PropertyValuesHolder value : this.mValues) {
                value.calculateValue(fraction);
            }
        }
        if (this.mUpdateListeners != null) {
            for (AnimatorUpdateListener l2 : this.mUpdateListeners) {
                l2.onAnimationUpdate(this);
            }
        }
    }

    @Override
    public ValueAnimator clone() {
        ValueAnimator anim = (ValueAnimator)super.clone();
        if (this.mUpdateListeners != null) {
            anim.mUpdateListeners = new ArrayList<AnimatorUpdateListener>(this.mUpdateListeners);
        }
        anim.mSeekFraction = -1.0f;
        anim.mReversing = false;
        anim.mInitialized = false;
        anim.mStarted = false;
        anim.mRunning = false;
        anim.mPaused = false;
        anim.mResumed = false;
        anim.mStartListenersCalled = false;
        anim.mStartTime = -1L;
        anim.mStartTimeCommitted = false;
        anim.mAnimationEndRequested = false;
        anim.mPauseTime = -1L;
        anim.mLastFrameTime = -1L;
        anim.mOverallFraction = 0.0f;
        anim.mCurrentFraction = 0.0f;
        anim.mSelfPulse = true;
        anim.mSuppressSelfPulseRequested = false;
        PropertyValuesHolder[] oldValues = this.mValues;
        if (oldValues != null) {
            int numValues = oldValues.length;
            anim.mValues = new PropertyValuesHolder[numValues];
            for (int i = 0; i < numValues; ++i) {
                anim.mValues[i] = oldValues[i].clone();
            }
        }
        return anim;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ValueAnimator@" + Integer.toHexString(this.hashCode()));
        if (this.mValues != null) {
            for (PropertyValuesHolder value : this.mValues) {
                sb.append("\n    ").append(value.toString());
            }
        }
        return sb.toString();
    }

    @FunctionalInterface
    public static interface AnimatorUpdateListener {
        public void onAnimationUpdate(@Nonnull ValueAnimator var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @ApiStatus.Internal
    public static @interface RepeatMode {
    }
}

