/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.audio;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FFT {
    public static final int NONE = 0;
    public static final int BARTLETT = 1;
    public static final int HAMMING = 2;
    public static final int HANN = 3;
    public static final int BLACKMAN = 4;
    private static final int LINEAR = 1;
    private static final int LOG = 2;
    private final int mTimeSize;
    private final int mSampleRate;
    private final float mBandWidth;
    private final float[] mReal;
    private final float[] mImag;
    private final float[] mSpectrum;
    private final int[] mReverse;
    @Nullable
    private float[] mWindow;
    @Nullable
    private float[] mAverages;
    private int mAverageMode;
    private int mOctaves;
    private int mAvgPerOctave;

    private FFT(int timeSize, int sampleRate) {
        this.mTimeSize = timeSize;
        this.mSampleRate = sampleRate;
        this.mBandWidth = (float)sampleRate / (float)timeSize;
        this.mReal = new float[timeSize];
        this.mImag = new float[timeSize];
        this.mSpectrum = new float[(timeSize >> 1) + 1];
        int[] reverse = new int[timeSize];
        int limit = 1;
        int bit = timeSize >> 1;
        while (limit < timeSize) {
            for (int i = 0; i < limit; ++i) {
                reverse[i + limit] = reverse[i] + bit;
            }
            limit <<= 1;
            bit >>= 1;
        }
        this.mReverse = reverse;
    }

    @Nonnull
    public static FFT create(int timeSize, int sampleRate) {
        if (timeSize > 0 & (timeSize & timeSize - 1) != 0) {
            throw new IllegalArgumentException("timeSize must be a power of two");
        }
        return new FFT(timeSize, sampleRate);
    }

    public void forward(@Nonnull float[] samples, int offset) {
        if (offset < 0 || offset >= samples.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.mTimeSize; ++i) {
            int j = this.mReverse[i];
            if (j + offset >= samples.length) {
                this.mReal[i] = 0.0f;
            } else {
                float sample = samples[j + offset];
                if (this.mWindow != null) {
                    sample *= this.mWindow[j];
                }
                this.mReal[i] = sample;
            }
            this.mImag[i] = 0.0f;
        }
        this.fft();
        this.fillSpectrum();
    }

    public void forward(@Nonnull float[] real, @Nonnull float[] imag, int offset) {
        if (offset < 0 || real.length != imag.length || offset >= real.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.mTimeSize; ++i) {
            int j = this.mReverse[i];
            if (j + offset >= real.length) {
                this.mReal[i] = 0.0f;
                this.mImag[i] = 0.0f;
                continue;
            }
            this.mReal[i] = real[j + offset];
            this.mImag[i] = imag[j + offset];
        }
        this.fft();
        this.fillSpectrum();
    }

    private void fft() {
        for (int halfSize = 1; halfSize < this.mTimeSize; halfSize <<= 1) {
            double k = -Math.PI / (double)halfSize;
            float phaseShiftStepR = (float)Math.cos(k);
            float phaseShiftStepI = (float)Math.sin(k);
            float currentPhaseShiftR = 1.0f;
            float currentPhaseShiftI = 0.0f;
            for (int fftStep = 0; fftStep < halfSize; ++fftStep) {
                for (int i = fftStep; i < this.mTimeSize; i += halfSize << 1) {
                    int off = i + halfSize;
                    float tr = currentPhaseShiftR * this.mReal[off] - currentPhaseShiftI * this.mImag[off];
                    float ti = currentPhaseShiftR * this.mImag[off] + currentPhaseShiftI * this.mReal[off];
                    this.mReal[off] = this.mReal[i] - tr;
                    this.mImag[off] = this.mImag[i] - ti;
                    int n2 = i;
                    this.mReal[n2] = this.mReal[n2] + tr;
                    int n3 = i;
                    this.mImag[n3] = this.mImag[n3] + ti;
                }
                float tmpR = currentPhaseShiftR;
                currentPhaseShiftR = tmpR * phaseShiftStepR - currentPhaseShiftI * phaseShiftStepI;
                currentPhaseShiftI = tmpR * phaseShiftStepI + currentPhaseShiftI * phaseShiftStepR;
            }
        }
    }

    private void fillSpectrum() {
        block7: {
            int i;
            block6: {
                for (i = 0; i < this.mSpectrum.length; ++i) {
                    this.mSpectrum[i] = (float)Math.sqrt(this.mReal[i] * this.mReal[i] + this.mImag[i] * this.mImag[i]);
                }
                if (this.mAverages == null) {
                    return;
                }
                if (this.mAverageMode != 1) break block6;
                int avgWidth = this.mSpectrum.length / this.mAverages.length;
                for (int i2 = 0; i2 < this.mAverages.length; ++i2) {
                    int offset;
                    int j;
                    float avg = 0.0f;
                    for (j = 0; j < avgWidth && (offset = j + i2 * avgWidth) < this.mSpectrum.length; ++j) {
                        avg += this.mSpectrum[offset];
                    }
                    this.mAverages[i2] = avg /= (float)(j + 1);
                }
                break block7;
            }
            if (this.mAverageMode != 2) break block7;
            for (i = 0; i < this.mOctaves; ++i) {
                float lowFreq = i == 0 ? 0.0f : (float)this.mSampleRate / 2.0f / (float)(1L << this.mOctaves - i);
                float hiFreq = (float)this.mSampleRate / 2.0f / (float)(1L << this.mOctaves - i - 1);
                float freqStep = (hiFreq - lowFreq) / (float)this.mAvgPerOctave;
                float f2 = lowFreq;
                for (int j = 0; j < this.mAvgPerOctave; ++j) {
                    int offset = j + i * this.mAvgPerOctave;
                    this.mAverages[offset] = this.getAverage(f2, f2 + freqStep);
                    f2 += freqStep;
                }
            }
        }
    }

    public void setNoAverages() {
        this.mAverages = null;
        this.mAverageMode = 0;
    }

    public void setLinearAverages(int num) {
        if (num > this.mSpectrum.length / 2) {
            throw new IllegalArgumentException("The number of averages for this transform can be at most " + this.mSpectrum.length / 2 + ".");
        }
        this.mAverages = new float[num];
        this.mAverageMode = 1;
    }

    public void setLogAverages(int minBandwidth, int bandsPerOctave) {
        float nyq = (float)this.mSampleRate / 2.0f;
        this.mOctaves = 1;
        while (true) {
            float f2;
            nyq /= 2.0f;
            if (!(f2 > (float)minBandwidth)) break;
            ++this.mOctaves;
        }
        this.mAvgPerOctave = bandsPerOctave;
        this.mAverages = new float[this.mOctaves * bandsPerOctave];
        this.mAverageMode = 2;
    }

    public void setWindowFunc(int func) {
        if (func == 0) {
            this.mWindow = null;
            return;
        }
        float[] window = this.mWindow;
        if (window == null) {
            window = new float[this.mTimeSize];
        }
        int n2 = window.length - 1;
        switch (func) {
            case 2: {
                for (int i = 0; i <= n2; ++i) {
                    window[i] = (float)((double)0.54f - (double)0.46f * Math.cos(Math.PI * 2 * (double)i / (double)n2));
                }
                break;
            }
            case 4: {
                for (int i = 0; i <= n2; ++i) {
                    window[i] = (float)((double)0.42f - 0.5 * Math.cos(Math.PI * 2 * (double)i / (double)n2) + (double)0.08f * Math.cos(Math.PI * 4 * (double)i / (double)n2));
                }
                break;
            }
            case 3: {
                for (int i = 0; i <= n2; ++i) {
                    float sin = (float)Math.sin(Math.PI * (double)i / (double)n2);
                    window[i] = sin * sin;
                }
                break;
            }
            case 1: {
                for (int i = 0; i <= n2; ++i) {
                    window[i] = 1 - Math.abs((i * 2 - n2) / n2);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized window function " + func);
            }
        }
        this.mWindow = window;
    }

    public int getTimeSize() {
        return this.mTimeSize;
    }

    public int getSampleRate() {
        return this.mSampleRate;
    }

    public int getBandSize() {
        return this.mSpectrum.length;
    }

    public float getBandWidth() {
        return this.mBandWidth;
    }

    public float getBand(int i) {
        return this.mSpectrum[i];
    }

    public void setBand(int band, float amplitude) {
        if (amplitude < 0.0f) {
            throw new IllegalArgumentException("Can't set a frequency band to a negative value.");
        }
        if (this.mReal[band] == 0.0f && this.mImag[band] == 0.0f) {
            this.mReal[band] = amplitude;
            this.mSpectrum[band] = amplitude;
        } else {
            int n2 = band;
            this.mReal[n2] = this.mReal[n2] / this.mSpectrum[band];
            int n3 = band;
            this.mImag[n3] = this.mImag[n3] / this.mSpectrum[band];
            this.mSpectrum[band] = amplitude;
            int n4 = band;
            this.mReal[n4] = this.mReal[n4] * this.mSpectrum[band];
            int n5 = band;
            this.mImag[n5] = this.mImag[n5] * this.mSpectrum[band];
        }
        if (band != 0 && band != this.mTimeSize / 2) {
            this.mReal[this.mTimeSize - band] = this.mReal[band];
            this.mImag[this.mTimeSize - band] = -this.mImag[band];
        }
    }

    public void scaleBand(int band, float scale) {
        if (scale < 0.0f) {
            throw new IllegalArgumentException("Can't scale a frequency band by a negative value.");
        }
        if (this.mSpectrum[band] != 0.0f) {
            int n2 = band;
            this.mReal[n2] = this.mReal[n2] / this.mSpectrum[band];
            int n3 = band;
            this.mImag[n3] = this.mImag[n3] / this.mSpectrum[band];
            int n4 = band;
            this.mSpectrum[n4] = this.mSpectrum[n4] * scale;
            int n5 = band;
            this.mReal[n5] = this.mReal[n5] * this.mSpectrum[band];
            int n6 = band;
            this.mImag[n6] = this.mImag[n6] * this.mSpectrum[band];
        }
        if (band != 0 && band != this.mTimeSize / 2) {
            this.mReal[this.mTimeSize - band] = this.mReal[band];
            this.mImag[this.mTimeSize - band] = -this.mImag[band];
        }
    }

    public int freqToIndex(float freq) {
        if (freq < this.getBandWidth() / 2.0f) {
            return 0;
        }
        if (freq > ((float)this.mSampleRate - this.getBandWidth()) / 2.0f) {
            return this.mSpectrum.length - 1;
        }
        float fraction = freq / (float)this.mSampleRate;
        return Math.round((float)this.mTimeSize * fraction);
    }

    public float indexToFreq(int i) {
        float bw = this.getBandWidth();
        if (i == 0) {
            return bw * 0.25f;
        }
        if (i == this.mSpectrum.length - 1) {
            float lastBinBeginFreq = ((float)this.mSampleRate - bw) / 2.0f;
            float binHalfWidth = bw * 0.25f;
            return lastBinBeginFreq + binHalfWidth;
        }
        return (float)i * bw;
    }

    public float getAverageCenterFrequency(int i) {
        if (this.mAverages == null) {
            return 0.0f;
        }
        if (this.mAverageMode == 1) {
            int avgWidth = this.mSpectrum.length / this.mAverages.length;
            int centerBinIndex = i * avgWidth + avgWidth / 2;
            return this.indexToFreq(centerBinIndex);
        }
        if (this.mAverageMode == 2) {
            int octave = i / this.mAvgPerOctave;
            int offset = i % this.mAvgPerOctave;
            float lowFreq = octave == 0 ? 0.0f : (float)this.mSampleRate / 2.0f / (float)(1L << this.mOctaves - octave);
            float hiFreq = (float)this.mSampleRate / 2.0f / (float)(1L << this.mOctaves - octave - 1);
            float freqStep = (hiFreq - lowFreq) / (float)this.mAvgPerOctave;
            float f2 = lowFreq + (float)offset * freqStep;
            return f2 + freqStep / 2.0f;
        }
        return 0.0f;
    }

    public float getFrequency(float freq) {
        return this.getBand(this.freqToIndex(freq));
    }

    public void setFrequency(float freq, float amplitude) {
        this.setBand(this.freqToIndex(freq), amplitude);
    }

    public void scaleFrequency(float freq, float scale) {
        this.scaleBand(this.freqToIndex(freq), scale);
    }

    public int getAverageSize() {
        return this.mAverages == null ? 0 : this.mAverages.length;
    }

    public float getAverage(int i) {
        return this.mAverages == null ? 0.0f : this.mAverages[i];
    }

    public float getAverage(float lowFreq, float hiFreq) {
        int lowBound = this.freqToIndex(lowFreq);
        int hiBound = this.freqToIndex(hiFreq);
        float avg = 0.0f;
        for (int i = lowBound; i <= hiBound; ++i) {
            avg += this.mSpectrum[i];
        }
        return avg /= (float)(hiBound - lowBound + 1);
    }
}

