/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.audio;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import javax.annotation.Nonnull;
import org.lwjgl.stb.STBVorbis;
import org.lwjgl.stb.STBVorbisInfo;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import yslelf.cloudpick.graphics.audio.SoundSample;

public class VorbisPullDecoder
extends SoundSample {
    private ByteBuffer mPayload;
    private long mHandle;

    public VorbisPullDecoder(@Nonnull ByteBuffer nativeEncodedAudioBuffer) {
        this.mPayload = nativeEncodedAudioBuffer;
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer error = stack.mallocInt(1);
            this.mHandle = STBVorbis.stb_vorbis_open_memory((ByteBuffer)nativeEncodedAudioBuffer, (IntBuffer)error, null);
            int er = error.get(0);
            if (er != 0) {
                throw new IllegalStateException("Failed to open Vorbis file " + er);
            }
            if (this.mHandle == 0L) {
                throw new AssertionError();
            }
            STBVorbisInfo info = STBVorbisInfo.malloc((MemoryStack)stack);
            STBVorbis.stb_vorbis_get_info((long)this.mHandle, (STBVorbisInfo)info);
            this.mSampleRate = info.sample_rate();
            int channels = info.channels();
            if (channels != 1 && channels != 2) {
                throw new IllegalStateException("Not 1 or 2 channels but " + channels);
            }
            this.mChannels = channels;
        }
        this.mTotalSamples = STBVorbis.stb_vorbis_stream_length_in_samples((long)this.mHandle);
    }

    @Override
    public boolean seek(int sampleOffset) {
        return STBVorbis.stb_vorbis_seek((long)this.mHandle, (int)sampleOffset);
    }

    @Override
    public int getSamplesShortInterleaved(ShortBuffer pcmBuffer) {
        return STBVorbis.stb_vorbis_get_samples_short_interleaved((long)this.mHandle, (int)this.mChannels, (ShortBuffer)pcmBuffer);
    }

    @Override
    public void close() {
        MemoryUtil.memFree((Buffer)this.mPayload);
        this.mPayload = null;
        if (this.mHandle != 0L) {
            STBVorbis.stb_vorbis_close((long)this.mHandle);
            this.mHandle = 0L;
        }
    }
}

