/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.audio;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.stb.STBVorbis;
import org.lwjgl.stb.STBVorbisInfo;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import yslelf.cloudpick.graphics.audio.SoundStream;

public class VorbisPushDecoder
extends SoundStream {
    private final FileChannel mChannel;
    private ByteBuffer mBuffer;
    private int mTotalSamples;
    private long mHandle;

    public VorbisPushDecoder(@Nonnull FileChannel channel) throws IOException {
        this.mChannel = channel;
        this.mBuffer = MemoryUtil.memAlloc((int)4096).flip();
        try (MemoryStack stack = MemoryStack.stackPush();){
            long handle;
            IntBuffer consumed = stack.mallocInt(1);
            IntBuffer error = stack.mallocInt(1);
            do {
                if (this.read()) {
                    throw new IOException("No header found");
                }
                handle = STBVorbis.stb_vorbis_open_pushdata((ByteBuffer)this.mBuffer, (IntBuffer)consumed, (IntBuffer)error, null);
                int er = error.get(0);
                if (er == 1) {
                    this.forward();
                    continue;
                }
                if (er == 0) continue;
                throw new IOException("Failed to open Vorbis file " + er);
            } while (handle == 0L);
            this.mHandle = handle;
            int headerSize = consumed.get(0);
            this.mBuffer.position(this.mBuffer.position() + headerSize);
            STBVorbisInfo info = STBVorbisInfo.malloc((MemoryStack)stack);
            STBVorbis.stb_vorbis_get_info((long)handle, (STBVorbisInfo)info);
            this.mSampleRate = info.sample_rate();
            int channels = info.channels();
            if (channels != 1 && channels != 2) {
                throw new IOException("Not 1 or 2 channels but " + channels);
            }
            this.mChannels = channels;
            ByteBuffer temp = stack.malloc(14);
            temp.order(ByteOrder.LITTLE_ENDIAN);
            long size = channel.size();
            for (int i = 1 + temp.capacity(); i <= 16384; ++i) {
                channel.read(temp, size - (long)i);
                if (temp.getInt(0) == 1399285583) {
                    this.mTotalSamples = temp.getInt(6);
                    break;
                }
                temp.clear();
            }
        }
    }

    public int getTotalSamples() {
        return this.mTotalSamples;
    }

    private boolean read() throws IOException {
        ByteBuffer buffer = this.mBuffer;
        int limit = buffer.limit();
        int require = buffer.capacity() - limit;
        if (require > 0) {
            int pos = buffer.position();
            buffer.position(limit);
            buffer.limit(limit + require);
            int read = this.mChannel.read(buffer);
            if (read == -1) {
                return true;
            }
            buffer.position(pos);
            buffer.limit(limit + read);
        }
        return false;
    }

    private void forward() {
        int pos = this.mBuffer.position();
        if (pos > 0 && pos == this.mBuffer.limit()) {
            this.mBuffer.rewind().flip();
        } else {
            ByteBuffer buffer = MemoryUtil.memAlloc((int)(this.mBuffer.capacity() << (pos == 0 ? 1 : 0)));
            buffer.put(this.mBuffer);
            MemoryUtil.memFree((Buffer)this.mBuffer);
            this.mBuffer = buffer.flip();
        }
    }

    @Override
    @Nullable
    public FloatBuffer decodeFrame(@Nullable FloatBuffer output) throws IOException {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer samples = stack.mallocPointer(1);
            IntBuffer count = stack.mallocInt(1);
            while (true) {
                int n2 = STBVorbis.stb_vorbis_decode_frame_pushdata((long)this.mHandle, (ByteBuffer)this.mBuffer, null, (PointerBuffer)samples, (IntBuffer)count);
                this.mBuffer.position(this.mBuffer.position() + n2);
                if (n2 == 0) {
                    this.forward();
                    if (!this.read()) continue;
                    FloatBuffer floatBuffer = null;
                    return floatBuffer;
                }
                n2 = count.get(0);
                if (n2 <= 0) continue;
                this.mSampleOffset = STBVorbis.stb_vorbis_get_sample_offset((long)this.mHandle);
                PointerBuffer data = samples.getPointerBuffer(this.mChannels);
                if (this.mChannels == 1) {
                    FloatBuffer src = data.getFloatBuffer(0, n2);
                    while (src.hasRemaining()) {
                        if (output == null || !output.hasRemaining()) {
                            output = MemoryUtil.memRealloc((FloatBuffer)output, (int)(output == null ? 256 : output.capacity() + 256));
                        }
                        output.put(src.get());
                    }
                } else if (this.mChannels == 2) {
                    FloatBuffer srcR = data.getFloatBuffer(0, n2);
                    FloatBuffer srcL = data.getFloatBuffer(1, n2);
                    while (srcR.hasRemaining()) {
                        if (output == null || output.remaining() < 2) {
                            output = MemoryUtil.memRealloc((FloatBuffer)output, (int)(output == null ? 256 : output.capacity() + 256));
                        }
                        output.put(srcR.get()).put(srcL.get());
                    }
                } else {
                    throw new IllegalStateException();
                }
                FloatBuffer floatBuffer = output;
                return floatBuffer;
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.mHandle != 0L) {
            STBVorbis.stb_vorbis_close((long)this.mHandle);
            this.mHandle = 0L;
        }
        MemoryUtil.memFree((Buffer)this.mBuffer);
        this.mBuffer = null;
        this.mChannel.close();
    }
}

