/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.core;

import java.util.Objects;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.graphics.animation.AnimationUtils;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.core.Core;
import yslelf.cloudpick.graphics.core.Handler;
import yslelf.cloudpick.graphics.core.Looper;
import yslelf.cloudpick.graphics.core.Message;

@ApiStatus.Internal
public final class Choreographer {
    private static final Marker MARKER = MarkerManager.getMarker((String)"Choreographer");
    private static final boolean DEBUG_FRAMES = false;
    private static volatile long sFrameDelay = 1L;
    private static final ThreadLocal<Choreographer> sThreadInstance = ThreadLocal.withInitial(() -> {
        if (Core.isOnRenderThread()) {
            throw new IllegalStateException("The render thread cannot have a choreographer!");
        }
        Looper looper = Looper.myLooper();
        if (looper == null) {
            throw new IllegalStateException("The current thread must have a looper!");
        }
        return new Choreographer(looper);
    });
    private static final int MSG_DO_FRAME = 0;
    private static final int MSG_DO_SCHEDULE_CALLBACK = 1;
    private static final Object FRAME_CALLBACK_TOKEN = new Object(){

        @NonNull
        public String toString() {
            return "FRAME_CALLBACK_TOKEN";
        }
    };
    @ApiStatus.Internal
    public static final int CALLBACK_INPUT = 0;
    @ApiStatus.Internal
    public static final int CALLBACK_ANIMATION = 1;
    @ApiStatus.Internal
    public static final int CALLBACK_TRAVERSAL = 2;
    @ApiStatus.Internal
    public static final int CALLBACK_COMMIT = 3;
    private static final int CALLBACK_LAST = 3;
    private final Object mLock = new Object();
    private final Handler mHandler;
    private CallbackRecord mCallbackPool;
    private final CallbackQueue[] mCallbackQueues;
    private boolean mFrameScheduled;
    private boolean mCallbacksRunning;
    private long mLastFrameTimeNanos;

    private Choreographer(@NonNull Looper looper) {
        this.mHandler = new Handler(looper, this::handleMessage);
        this.mLastFrameTimeNanos = Long.MIN_VALUE;
        this.mCallbackQueues = new CallbackQueue[4];
        for (int i = 0; i <= 3; ++i) {
            this.mCallbackQueues[i] = new CallbackQueue();
        }
    }

    @NonNull
    public static Choreographer getInstance() {
        return sThreadInstance.get();
    }

    @ApiStatus.Internal
    public static long getFrameDelay() {
        return sFrameDelay;
    }

    @ApiStatus.Internal
    public static void setFrameDelay(long frameDelay) {
        sFrameDelay = frameDelay;
    }

    @ApiStatus.Internal
    public static long subtractFrameDelay(long delayMillis) {
        long frameDelay = sFrameDelay;
        return delayMillis <= frameDelay ? 0L : delayMillis - frameDelay;
    }

    @ApiStatus.Internal
    public void postCallback(int callbackType, @NonNull Runnable action, @Nullable Object token) {
        this.postCallbackDelayed(callbackType, action, token, 0L);
    }

    @ApiStatus.Internal
    public void postCallbackDelayed(int callbackType, @NonNull Runnable action, @Nullable Object token, long delayMillis) {
        Objects.requireNonNull(action);
        if (callbackType < 0 || callbackType > 3) {
            throw new AssertionError(callbackType);
        }
        this.postCallbackDelayedInternal(callbackType, action, token, delayMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postCallbackDelayedInternal(int callbackType, @NonNull Object action, @Nullable Object token, long delayMillis) {
        Object object = this.mLock;
        synchronized (object) {
            long now = Core.timeMillis();
            long dueTime = now + delayMillis;
            this.mCallbackQueues[callbackType].addCallbackLocked(dueTime, action, token);
            if (dueTime <= now) {
                this.scheduleFrameLocked(now);
            } else {
                Message msg = this.mHandler.obtainMessage(1, action);
                msg.arg1 = callbackType;
                msg.setAsynchronous(true);
                this.mHandler.sendMessageAtTime(msg, dueTime);
            }
        }
    }

    @ApiStatus.Internal
    public void removeCallbacks(int callbackType, @Nullable Runnable action, @Nullable Object token) {
        if (callbackType < 0 || callbackType > 3) {
            throw new AssertionError(callbackType);
        }
        this.removeCallbacksInternal(callbackType, action, token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCallbacksInternal(int callbackType, @Nullable Object action, @Nullable Object token) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCallbackQueues[callbackType].removeCallbacksLocked(action, token);
            if (action != null && token == null) {
                this.mHandler.removeMessages(1, action);
            }
        }
    }

    public void postFrameCallback(@NonNull FrameCallback callback) {
        this.postFrameCallbackDelayed(callback, 0L);
    }

    public void postFrameCallbackDelayed(@NonNull FrameCallback callback, long delayMillis) {
        Objects.requireNonNull(callback);
        this.postCallbackDelayedInternal(1, callback, FRAME_CALLBACK_TOKEN, delayMillis);
    }

    public void removeFrameCallback(@NonNull FrameCallback callback) {
        Objects.requireNonNull(callback);
        this.removeCallbacksInternal(1, callback, FRAME_CALLBACK_TOKEN);
    }

    @ApiStatus.Internal
    public long getFrameTime() {
        return this.getFrameTimeNanos() / 1000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public long getFrameTimeNanos() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mCallbacksRunning) {
                throw new IllegalStateException("This method must only be called as part of a callback while a frame is in progress.");
            }
            return this.mLastFrameTimeNanos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public long getLastFrameTimeNanos() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mLastFrameTimeNanos;
        }
    }

    private void scheduleFrameLocked(long now) {
        if (!this.mFrameScheduled) {
            this.mFrameScheduled = true;
            long nextFrameTime = Math.max(this.mLastFrameTimeNanos / 1000000L + sFrameDelay, now);
            Message msg = this.mHandler.obtainMessage(0);
            msg.setAsynchronous(true);
            this.mHandler.sendMessageAtTime(msg, nextFrameTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void doFrame() {
        long frameTimeNanos;
        block9: {
            frameTimeNanos = Core.timeNanos();
            Object object = this.mLock;
            // MONITORENTER : object
            if (this.mFrameScheduled) break block9;
            // MONITOREXIT : object
            AnimationUtils.unlockAnimationClock();
            return;
        }
        if (frameTimeNanos < this.mLastFrameTimeNanos) {
            // MONITOREXIT : object
            AnimationUtils.unlockAnimationClock();
            return;
        }
        try {
            this.mFrameScheduled = false;
            this.mLastFrameTimeNanos = frameTimeNanos;
            // MONITOREXIT : object
            AnimationUtils.lockAnimationClock(frameTimeNanos / 1000000L);
            this.doCallbacks(0, frameTimeNanos);
            this.doCallbacks(1, frameTimeNanos);
            this.doCallbacks(2, frameTimeNanos);
            this.doCallbacks(3, frameTimeNanos);
            return;
        }
        finally {
            AnimationUtils.unlockAnimationClock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doCallbacks(int callbackType, long frameTimeNanos) {
        CallbackRecord callbacks;
        Object object = this.mLock;
        synchronized (object) {
            long now = Core.timeMillis();
            callbacks = this.mCallbackQueues[callbackType].extractDueCallbacksLocked(now);
            if (callbacks == null) {
                return;
            }
            this.mCallbacksRunning = true;
        }
        try {
            CallbackRecord c = callbacks;
            while (c != null) {
                c.run(frameTimeNanos);
                c = c.next;
            }
        }
        finally {
            object = this.mLock;
            synchronized (object) {
                CallbackRecord next;
                this.mCallbacksRunning = false;
                do {
                    next = callbacks.next;
                    this.recycleCallbackLocked(callbacks);
                } while ((callbacks = next) != null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doScheduleCallback(int callbackType) {
        Object object = this.mLock;
        synchronized (object) {
            long now;
            if (!this.mFrameScheduled && this.mCallbackQueues[callbackType].hasDueCallbacksLocked(now = Core.timeMillis())) {
                this.scheduleFrameLocked(now);
            }
        }
    }

    @NonNull
    private CallbackRecord obtainCallbackLocked(long dueTime, @NonNull Object action, @Nullable Object token) {
        CallbackRecord callback = this.mCallbackPool;
        if (callback == null) {
            callback = new CallbackRecord();
        } else {
            this.mCallbackPool = callback.next;
            callback.next = null;
        }
        callback.dueTime = dueTime;
        callback.action = action;
        callback.token = token;
        return callback;
    }

    private void recycleCallbackLocked(@NonNull CallbackRecord callback) {
        callback.action = null;
        callback.token = null;
        callback.next = this.mCallbackPool;
        this.mCallbackPool = callback;
    }

    private boolean handleMessage(@NonNull Message msg) {
        switch (msg.what) {
            case 0: {
                this.doFrame();
                break;
            }
            case 1: {
                this.doScheduleCallback(msg.arg1);
            }
        }
        return true;
    }

    private final class CallbackQueue {
        @Nullable
        private CallbackRecord mHead;

        private CallbackQueue() {
        }

        public boolean hasDueCallbacksLocked(long now) {
            return this.mHead != null && this.mHead.dueTime <= now;
        }

        @Nullable
        public CallbackRecord extractDueCallbacksLocked(long now) {
            CallbackRecord callbacks = this.mHead;
            if (callbacks == null || callbacks.dueTime > now) {
                return null;
            }
            CallbackRecord last = callbacks;
            CallbackRecord next = last.next;
            while (next != null) {
                if (next.dueTime > now) {
                    last.next = null;
                    break;
                }
                last = next;
                next = next.next;
            }
            this.mHead = next;
            return callbacks;
        }

        public void addCallbackLocked(long dueTime, @NonNull Object action, @Nullable Object token) {
            CallbackRecord callback = Choreographer.this.obtainCallbackLocked(dueTime, action, token);
            CallbackRecord entry = this.mHead;
            if (entry == null) {
                this.mHead = callback;
                return;
            }
            if (dueTime < entry.dueTime) {
                callback.next = entry;
                this.mHead = callback;
                return;
            }
            while (entry.next != null) {
                if (dueTime < entry.next.dueTime) {
                    callback.next = entry.next;
                    break;
                }
                entry = entry.next;
            }
            entry.next = callback;
        }

        public void removeCallbacksLocked(@Nullable Object action, @Nullable Object token) {
            CallbackRecord predecessor = null;
            CallbackRecord callback = this.mHead;
            while (callback != null) {
                CallbackRecord next = callback.next;
                if (!(action != null && callback.action != action || token != null && callback.token != token)) {
                    if (predecessor != null) {
                        predecessor.next = next;
                    } else {
                        this.mHead = next;
                    }
                    Choreographer.this.recycleCallbackLocked(callback);
                } else {
                    predecessor = callback;
                }
                callback = next;
            }
        }
    }

    @FunctionalInterface
    public static interface FrameCallback {
        public void doFrame(@NonNull Choreographer var1, long var2);
    }

    private final class CallbackRecord {
        public CallbackRecord next;
        public long dueTime;
        public Object action;
        public Object token;

        private CallbackRecord() {
        }

        public void run(long frameTimeNanos) {
            if (this.token == FRAME_CALLBACK_TOKEN) {
                ((FrameCallback)this.action).doFrame(Choreographer.this, frameTimeNanos);
            } else {
                ((Runnable)this.action).run();
            }
        }
    }
}

