/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.Cleaner;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.Version;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.opengl.AMDDebugOutput;
import org.lwjgl.opengl.ARBDebugOutput;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11C;
import org.lwjgl.opengl.GL43C;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLDebugMessageAMDCallback;
import org.lwjgl.opengl.GLDebugMessageAMDCallbackI;
import org.lwjgl.opengl.GLDebugMessageARBCallback;
import org.lwjgl.opengl.GLDebugMessageARBCallbackI;
import org.lwjgl.opengl.GLDebugMessageCallback;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Platform;
import org.lwjgl.util.tinyfd.TinyFileDialogs;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLogger;
import yslelf.cloudpick.graphics.CloudPick;
import yslelf.cloudpick.graphics.annotation.MainThread;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.RenderThread;
import yslelf.cloudpick.graphics.annotation.UiThread;
import yslelf.cloudpick.graphics.core.Handler;
import yslelf.cloudpick.graphics.core.Looper;
import yslelf.cloudpick.graphics.core.VulkanManager;
import yslelf.cloudpick.render.core.RefCounted;
import yslelf.cloudpick.render.engine.ContextOptions;
import yslelf.cloudpick.render.engine.ImmediateContext;
import yslelf.cloudpick.render.engine.RecordingContext;
import yslelf.cloudpick.render.opengl.GLCaps;
import yslelf.cloudpick.render.opengl.GLUtil;

public final class Core {
    private static final Cleaner sCleaner = Cleaner.create();
    private static volatile Thread sMainThread;
    private static volatile Thread sRenderThread;
    private static volatile Thread sUiThread;
    private static volatile Handler sMainHandlerAsync;
    private static volatile Handler sUiHandler;
    private static volatile Handler sUiHandlerAsync;
    private static final ConcurrentLinkedQueue<Runnable> sMainCalls;
    private static final Executor sMainThreadExecutor;
    private static final Executor sUiThreadExecutor;
    private static volatile ImmediateContext sImmediateContext;
    private static volatile RecordingContext sUiRecordingContext;

    private Core() {
    }

    @NonNull
    public static Cleaner.Cleanable registerCleanup(@NonNull Object target, @NonNull Runnable action) {
        return sCleaner.register(target, action);
    }

    @ApiStatus.Internal
    @NonNull
    public static Cleaner.Cleanable registerNativeResource(@NonNull Object target, @NonNull RefCounted resource) {
        return sCleaner.register(target, resource::unref);
    }

    @ApiStatus.Internal
    @NonNull
    public static Cleaner.Cleanable registerNativeResource(@NonNull Object target, @NonNull AutoCloseable resource) {
        return sCleaner.register(target, () -> {
            try {
                resource.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public static void initialize() {
        Class<Core> clazz = Core.class;
        synchronized (Core.class) {
            if (sMainThread == null) {
                GLFWErrorCallback cb = GLFW.glfwSetErrorCallback(null);
                if (cb != null) {
                    GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)cb);
                } else {
                    CloudPick.LOGGER.info(CloudPick.MARKER, "Backend Library: LWJGL {}", (Object)Version.getVersion());
                    GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)new GLFWErrorCallback(){

                        public void invoke(int error, long description) {
                            CloudPick.LOGGER.error(CloudPick.MARKER, "GLFW Error: 0x{} {}", (Object)Integer.toHexString(error), (Object)MemoryUtil.memUTF8Safe((long)description));
                        }
                    });
                }
                if (!GLFW.glfwInit()) {
                    Objects.requireNonNull(GLFW.glfwSetErrorCallback(null)).free();
                    throw new UnsupportedOperationException("Failed to initialize GLFW");
                }
                sMainThread = Thread.currentThread();
            } else assert (false);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @MainThread
    public static void terminate() {
        Core.checkMainThread();
        GLFWErrorCallback cb = GLFW.glfwSetErrorCallback(null);
        if (cb != null) {
            cb.close();
        }
        GLFW.glfwTerminate();
        CloudPick.LOGGER.info(CloudPick.MARKER, "Terminated GLFW");
    }

    public static void checkMainThread() {
        if (Thread.currentThread() != sMainThread) {
            throw new IllegalStateException("Not called from the main thread, current " + Thread.currentThread());
        }
    }

    public static Thread getMainThread() {
        return sMainThread;
    }

    public static boolean isOnMainThread() {
        return Thread.currentThread() == sMainThread;
    }

    @NonNull
    private static ContextOptions initContextOptions(@NonNull ContextOptions options) {
        if (options.mLogger == null || options.mLogger == NOPLogger.NOP_LOGGER) {
            options.mLogger = LoggerFactory.getLogger((String)"Arc3D");
        }
        return options;
    }

    @RenderThread
    public static boolean initOpenGL() {
        return Core.initOpenGL(new ContextOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RenderThread
    public static boolean initOpenGL(@NonNull ContextOptions options) {
        Class<Core> clazz = Core.class;
        synchronized (Core.class) {
            if (sImmediateContext != null) {
                if (sImmediateContext.getBackend() != 0) {
                    throw new IllegalStateException();
                }
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return true;
            }
            if (sRenderThread == null) {
                sRenderThread = Thread.currentThread();
            } else if (Thread.currentThread() != sRenderThread) {
                throw new IllegalStateException();
            }
            Core.initContextOptions(options);
            ImmediateContext dc = GLUtil.makeOpenGL(options);
            if (dc == null) {
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return false;
            }
            sImmediateContext = dc;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            String glVendor = GL11C.glGetString((int)7936);
            String glRenderer = GL11C.glGetString((int)7937);
            String glVersion = GL11C.glGetString((int)7938);
            CloudPick.LOGGER.info(CloudPick.MARKER, "OpenGL vendor: {}", (Object)glVendor);
            CloudPick.LOGGER.info(CloudPick.MARKER, "OpenGL renderer: {}", (Object)glRenderer);
            CloudPick.LOGGER.info(CloudPick.MARKER, "OpenGL version: {}", (Object)glVersion);
            StringBuilder sb = new StringBuilder("\n");
            ((GLCaps)dc.getCaps()).dump(sb, false);
            CloudPick.LOGGER.info(CloudPick.MARKER, "OpenGL caps: {}", (Object)sb);
            return true;
        }
    }

    @RenderThread
    public static void glSetupDebugCallback() {
        GLCapabilities caps = GL.getCapabilities();
        if (GL43C.glGetPointer((int)33348) == 0L) {
            if (caps.OpenGL43 || caps.GL_KHR_debug) {
                CloudPick.LOGGER.debug(CloudPick.MARKER, "Using OpenGL 4.3 for debug logging");
                GL43C.glDebugMessageCallback(Core::glDebugMessage, (long)0L);
                GL43C.glEnable((int)37600);
            } else if (caps.GL_ARB_debug_output) {
                CloudPick.LOGGER.debug(CloudPick.MARKER, "Using ARB_debug_output for debug logging");
                GLDebugMessageARBCallback proc = new GLDebugMessageARBCallback(){

                    public void invoke(int source, int type, int id2, int severity, int length, long message, long userParam) {
                        CloudPick.LOGGER.info(CloudPick.MARKER, "0x{}[{},{},{}]: {}", (Object)Integer.toHexString(id2), (Object)GLUtil.getSourceARB(source), (Object)GLUtil.getTypeARB(type), (Object)GLUtil.getSeverityARB(severity), (Object)GLDebugMessageARBCallback.getMessage((int)length, (long)message));
                    }
                };
                ARBDebugOutput.glDebugMessageCallbackARB((GLDebugMessageARBCallbackI)proc, (long)0L);
            } else if (caps.GL_AMD_debug_output) {
                CloudPick.LOGGER.debug(CloudPick.MARKER, "Using AMD_debug_output for debug logging");
                GLDebugMessageAMDCallback proc = new GLDebugMessageAMDCallback(){

                    public void invoke(int id2, int category, int severity, int length, long message, long userParam) {
                        CloudPick.LOGGER.info(CloudPick.MARKER, "0x{}[{},{}]: {}", (Object)Integer.toHexString(id2), (Object)GLUtil.getCategoryAMD(category), (Object)GLUtil.getSeverityAMD(severity), (Object)GLDebugMessageAMDCallback.getMessage((int)length, (long)message));
                    }
                };
                AMDDebugOutput.glDebugMessageCallbackAMD((GLDebugMessageAMDCallbackI)proc, (long)0L);
            } else {
                CloudPick.LOGGER.debug(CloudPick.MARKER, "No debug callback function was used...");
            }
        } else {
            CloudPick.LOGGER.debug(CloudPick.MARKER, "The debug callback function is already set.");
        }
    }

    public static void glDebugMessage(int source, int type, int id2, int severity, int length, long message, long userParam) {
        switch (severity) {
            case 37190: {
                CloudPick.LOGGER.error(CloudPick.MARKER, "({}|{}|0x{}) {}", (Object)GLUtil.getDebugSource(source), (Object)GLUtil.getDebugType(type), (Object)Integer.toHexString(id2), (Object)GLDebugMessageCallback.getMessage((int)length, (long)message));
                break;
            }
            case 37191: {
                CloudPick.LOGGER.warn(CloudPick.MARKER, "({}|{}|0x{}) {}", (Object)GLUtil.getDebugSource(source), (Object)GLUtil.getDebugType(type), (Object)Integer.toHexString(id2), (Object)GLDebugMessageCallback.getMessage((int)length, (long)message));
                break;
            }
            case 37192: {
                CloudPick.LOGGER.info(CloudPick.MARKER, "({}|{}|0x{}) {}", (Object)GLUtil.getDebugSource(source), (Object)GLUtil.getDebugType(type), (Object)Integer.toHexString(id2), (Object)GLDebugMessageCallback.getMessage((int)length, (long)message));
                break;
            }
            case 33387: {
                CloudPick.LOGGER.debug(CloudPick.MARKER, "({}|{}|0x{}) {}", (Object)GLUtil.getDebugSource(source), (Object)GLUtil.getDebugType(type), (Object)Integer.toHexString(id2), (Object)GLDebugMessageCallback.getMessage((int)length, (long)message));
            }
        }
    }

    @RenderThread
    public static void glShowCapsErrorDialog() {
        Core.checkRenderThread();
        if (sImmediateContext != null) {
            return;
        }
        String glVendor = GL11C.glGetString((int)7936);
        String glRenderer = GL11C.glGetString((int)7937);
        String glVersion = GL11C.glGetString((int)7938);
        new Thread(() -> {
            String solution = "Please make sure you have up-to-date GPU drivers. Also make sure Java applications run with the discrete GPU if you have multiple GPUs.";
            TinyFileDialogs.tinyfd_messageBox((CharSequence)"Failed to launch Modern UI", (CharSequence)("GPU: " + glVendor + " " + glRenderer + ", OpenGL: " + glVersion + ". OpenGL 3.3 or OpenGL ES 3.0 is required.\n" + solution), (CharSequence)"ok", (CharSequence)"error", (boolean)true);
        }, "GL-Error-Dialog").start();
    }

    @RenderThread
    public static boolean initVulkan() {
        return Core.initVulkan(new ContextOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RenderThread
    public static boolean initVulkan(@NonNull ContextOptions options) {
        Class<Core> clazz = Core.class;
        synchronized (Core.class) {
            ImmediateContext dc;
            if (sImmediateContext != null) {
                if (sImmediateContext.getBackend() != 1) {
                    throw new IllegalStateException();
                }
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return true;
            }
            if (sRenderThread == null) {
                sRenderThread = Thread.currentThread();
            } else if (Thread.currentThread() != sRenderThread) {
                throw new IllegalStateException();
            }
            try {
                VulkanManager vkManager = VulkanManager.getInstance();
                vkManager.initialize();
                Core.initContextOptions(options);
                dc = vkManager.createContext(options);
                if (dc == null) {
                    // ** MonitorExit[var2_1] (shouldn't be in output)
                    return false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return false;
            }
            sImmediateContext = dc;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return true;
        }
    }

    public static void checkRenderThread() {
        if (Thread.currentThread() != sRenderThread) {
            Class<Core> clazz = Core.class;
            synchronized (Core.class) {
                if (sRenderThread == null) {
                    throw new IllegalStateException("The render thread has not been initialized yet.");
                }
                throw new IllegalStateException("Not called from the render thread " + sRenderThread + ", current " + Thread.currentThread());
            }
        }
    }

    public static Thread getRenderThread() {
        return sRenderThread;
    }

    public static boolean isOnRenderThread() {
        return Thread.currentThread() == sRenderThread;
    }

    @NonNull
    @RenderThread
    public static ImmediateContext requireImmediateContext() {
        Core.checkRenderThread();
        return Objects.requireNonNull(sImmediateContext, "Immediate context has not been created yet, or creation failed");
    }

    public static ImmediateContext peekImmediateContext() {
        return sImmediateContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static Handler getMainHandlerAsync() {
        if (sMainHandlerAsync != null) return sMainHandlerAsync;
        Class<Core> clazz = Core.class;
        synchronized (Core.class) {
            if (sMainHandlerAsync != null) return sMainHandlerAsync;
            if (Looper.getMainLooper() == null) {
                throw new IllegalStateException("The main event loop does not exist.");
            }
            sMainHandlerAsync = Handler.createAsync(Looper.getMainLooper());
            // ** MonitorExit[var0] (shouldn't be in output)
            return sMainHandlerAsync;
        }
    }

    public static void postOnMainThread(@NonNull Runnable r) {
        if (Looper.getMainLooper() == null) {
            sMainCalls.offer(r);
        } else {
            Core.getMainHandlerAsync().post(r);
        }
    }

    public static void executeOnMainThread(@NonNull Runnable r) {
        if (Core.isOnMainThread()) {
            r.run();
        } else {
            Core.postOnMainThread(r);
        }
    }

    @NonNull
    public static Executor getMainThreadExecutor() {
        return sMainThreadExecutor;
    }

    public static void flushMainCalls() {
        Runnable r;
        ConcurrentLinkedQueue<Runnable> queue = sMainCalls;
        while ((r = queue.poll()) != null) {
            r.run();
        }
    }

    @NonNull
    @UiThread
    public static Looper initUiThread() {
        Class<Core> clazz = Core.class;
        synchronized (Core.class) {
            if (sUiThread == null) {
                sUiThread = Thread.currentThread();
                Looper looper = sUiThread == sMainThread ? Looper.getMainLooper() : Looper.prepare();
                sUiHandler = new Handler(looper);
                sUiHandlerAsync = Handler.createAsync(looper);
                if (sImmediateContext != null) {
                    sUiRecordingContext = sImmediateContext.makeRecordingContext();
                    Objects.requireNonNull(sUiRecordingContext);
                } else {
                    CloudPick.LOGGER.warn(CloudPick.MARKER, "UI thread initializing without a GPU device");
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return looper;
            }
            throw new IllegalStateException();
        }
    }

    public static void checkUiThread() {
        if (Thread.currentThread() != sUiThread) {
            Class<Core> clazz = Core.class;
            synchronized (Core.class) {
                if (sUiThread == null) {
                    throw new IllegalStateException("The UI thread has not been initialized yet.");
                }
                throw new IllegalStateException("Not called from the UI thread " + sRenderThread + ", current " + Thread.currentThread());
            }
        }
    }

    public static Thread getUiThread() {
        return sUiThread;
    }

    public static boolean isOnUiThread() {
        return Thread.currentThread() == sUiThread;
    }

    @NonNull
    @UiThread
    public static RecordingContext requireUiRecordingContext() {
        Core.checkUiThread();
        return Objects.requireNonNull(sUiRecordingContext, "UI recording context has not been created yet, or creation failed");
    }

    public static RecordingContext peekUiRecordingContext() {
        return sUiRecordingContext;
    }

    public static Handler getUiHandler() {
        return sUiHandler;
    }

    public static Handler getUiHandlerAsync() {
        return sUiHandlerAsync;
    }

    public static void postOnUiThread(@NonNull Runnable r) {
        Core.getUiHandlerAsync().post(r);
    }

    public static void executeOnUiThread(@NonNull Runnable r) {
        if (Core.isOnUiThread()) {
            r.run();
        } else {
            Core.postOnUiThread(r);
        }
    }

    @NonNull
    public static Executor getUiThreadExecutor() {
        return sUiThreadExecutor;
    }

    public static long timeNanos() {
        return (long)(GLFW.glfwGetTime() * 1.0E9);
    }

    public static long timeMillis() {
        return (long)(GLFW.glfwGetTime() * 1000.0);
    }

    @NonNull
    public static ByteBuffer readIntoNativeBuffer(@NonNull ReadableByteChannel channel) throws IOException {
        ByteBuffer p2;
        block6: {
            p2 = null;
            try {
                if (channel instanceof SeekableByteChannel) {
                    SeekableByteChannel ch = (SeekableByteChannel)channel;
                    long rem = ch.size() - ch.position() + 1L;
                    p2 = MemoryUtil.memAlloc((int)((int)Math.min(rem, Integer.MAX_VALUE)));
                    while (ch.read(p2) > 0) {
                    }
                    break block6;
                }
                p2 = MemoryUtil.memAlloc((int)4096);
                while (channel.read(p2) != -1) {
                    if (p2.hasRemaining()) continue;
                    long cap = p2.capacity();
                    if (cap != Integer.MAX_VALUE) {
                        p2 = MemoryUtil.memRealloc((ByteBuffer)p2, (int)((int)Math.min(cap + (cap >> 1), Integer.MAX_VALUE)));
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable t2) {
                MemoryUtil.memFree(p2);
                throw t2;
            }
        }
        return p2;
    }

    @NonNull
    public static ByteBuffer readIntoNativeBuffer(@NonNull InputStream stream) throws IOException {
        return Core.readIntoNativeBuffer(Channels.newChannel(stream));
    }

    public static boolean openURI(@NonNull URI uri) {
        try {
            String[] stringArray;
            String s = uri.toString();
            switch (Platform.get()) {
                case WINDOWS: {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = "rundll32";
                    stringArray2[1] = "url.dll,FileProtocolHandler";
                    stringArray = stringArray2;
                    stringArray2[2] = s;
                    break;
                }
                case MACOSX: {
                    String[] stringArray3 = new String[2];
                    stringArray3[0] = "open";
                    stringArray = stringArray3;
                    stringArray3[1] = s;
                    break;
                }
                default: {
                    String[] stringArray4 = new String[2];
                    stringArray4[0] = "xdg-open";
                    stringArray = stringArray4;
                    stringArray4[1] = "file".equals(uri.getScheme()) ? s.replace("file:", "file://") : s;
                }
            }
            String[] cmd = stringArray;
            Process proc = Runtime.getRuntime().exec(cmd);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getErrorStream()));){
                reader.lines().forEach(line -> CloudPick.LOGGER.error(CloudPick.MARKER, line));
            }
            return true;
        }
        catch (Exception e) {
            CloudPick.LOGGER.error(CloudPick.MARKER, "Failed to open URI: {}", (Object)uri, (Object)e);
            return false;
        }
    }

    public static boolean openURI(@NonNull String uri) {
        try {
            return Core.openURI(URI.create(uri));
        }
        catch (Exception e) {
            CloudPick.LOGGER.error(CloudPick.MARKER, "Failed to open URI: {}", (Object)uri, (Object)e);
            return false;
        }
    }

    static {
        sMainCalls = new ConcurrentLinkedQueue();
        sMainThreadExecutor = Core::executeOnMainThread;
        sUiThreadExecutor = Core::executeOnUiThread;
    }
}

