/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.core;

import java.util.ArrayList;
import java.util.concurrent.locks.LockSupport;
import javax.annotation.concurrent.GuardedBy;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.lwjgl.glfw.GLFW;
import yslelf.cloudpick.graphics.CloudPick;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.core.Core;
import yslelf.cloudpick.graphics.core.Handler;
import yslelf.cloudpick.graphics.core.Message;

public final class MessageQueue {
    private static final Marker MARKER = MarkerManager.getMarker((String)"MessageQueue");
    private static final boolean DEBUG = false;
    private final Thread mThread;
    @GuardedBy(value="this")
    Message mMessages;
    @GuardedBy(value="this")
    private final ArrayList<IdleHandler> mIdleHandlers = new ArrayList();
    private IdleHandler[] mPendingIdleHandlers;
    @GuardedBy(value="this")
    private boolean mQuitting;
    private volatile boolean mPolling;
    @GuardedBy(value="this")
    private boolean mBlocked;
    private boolean mDisposed;
    @GuardedBy(value="this")
    private int mNextBarrierToken;

    MessageQueue(Thread thread) {
        this.mThread = thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIdle() {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            long now = Core.timeMillis();
            return this.mMessages == null || now < this.mMessages.when;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIdleHandler(@NonNull IdleHandler handler) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.mIdleHandlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIdleHandler(@NonNull IdleHandler handler) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.mIdleHandlers.remove(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPolling() {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            return !this.mQuitting && this.mPolling;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    Message next() {
        if (this.mDisposed) {
            return null;
        }
        int pendingIdleHandlerCount = -1;
        int nextPollTimeoutMillis = 0;
        while (true) {
            if (this.mThread == null) {
                this.mPolling = true;
                if (nextPollTimeoutMillis < 0) {
                    GLFW.glfwWaitEvents();
                } else if (nextPollTimeoutMillis == 0) {
                    GLFW.glfwPollEvents();
                } else {
                    GLFW.glfwWaitEventsTimeout((double)((double)nextPollTimeoutMillis / 1000.0));
                }
                this.mPolling = false;
            } else {
                this.mPolling = true;
                if (nextPollTimeoutMillis < 0) {
                    LockSupport.park();
                } else if (nextPollTimeoutMillis > 0) {
                    LockSupport.parkNanos((long)nextPollTimeoutMillis * 1000000L);
                }
                this.mPolling = false;
            }
            MessageQueue messageQueue = this;
            synchronized (messageQueue) {
                long now;
                block29: {
                    now = Core.timeMillis();
                    Message prevMsg = null;
                    Message msg = this.mMessages;
                    if (msg != null && msg.target == null) {
                        do {
                            prevMsg = msg;
                        } while ((msg = msg.next) != null && !msg.isAsynchronous());
                    }
                    if (msg != null) {
                        if (now < msg.when) {
                            nextPollTimeoutMillis = (int)Math.min(msg.when - now, Integer.MAX_VALUE);
                            break block29;
                        } else {
                            this.mBlocked = false;
                            if (prevMsg != null) {
                                prevMsg.next = msg.next;
                            } else {
                                this.mMessages = msg.next;
                            }
                            msg.next = null;
                            msg.markInUse();
                            return msg;
                        }
                    }
                    nextPollTimeoutMillis = -1;
                }
                if (this.mQuitting) {
                    this.mDisposed = true;
                    return null;
                }
                if (pendingIdleHandlerCount < 0 && (this.mMessages == null || now < this.mMessages.when)) {
                    pendingIdleHandlerCount = this.mIdleHandlers.size();
                }
                if (pendingIdleHandlerCount <= 0) {
                    this.mBlocked = true;
                    continue;
                }
                if (this.mPendingIdleHandlers == null) {
                    this.mPendingIdleHandlers = new IdleHandler[Math.max(pendingIdleHandlerCount, 4)];
                }
                this.mPendingIdleHandlers = this.mIdleHandlers.toArray(this.mPendingIdleHandlers);
            }
            for (int i = 0; i < pendingIdleHandlerCount; ++i) {
                IdleHandler idler = this.mPendingIdleHandlers[i];
                this.mPendingIdleHandlers[i] = null;
                boolean keep = false;
                try {
                    keep = idler.queueIdle();
                }
                catch (Throwable t2) {
                    CloudPick.LOGGER.fatal(MARKER, "IdleHandler threw exception", t2);
                }
                if (keep) continue;
                MessageQueue messageQueue2 = this;
                synchronized (messageQueue2) {
                    this.mIdleHandlers.remove(idler);
                    continue;
                }
            }
            pendingIdleHandlerCount = 0;
            nextPollTimeoutMillis = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void quit(boolean safe) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            if (this.mQuitting) {
                return;
            }
            this.mQuitting = true;
            if (safe) {
                this.removeAllFutureMessagesLocked();
            } else {
                this.removeAllMessagesLocked();
            }
            if (this.mThread == null) {
                GLFW.glfwPostEmptyEvent();
            } else {
                LockSupport.unpark(this.mThread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int postSyncBarrier() {
        long when = Core.timeMillis();
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            int token = this.mNextBarrierToken++;
            Message msg = Message.obtain();
            msg.markInUse();
            msg.when = when;
            msg.arg1 = token;
            Message prev = null;
            Message p2 = this.mMessages;
            if (when != 0L) {
                while (p2 != null && p2.when <= when) {
                    prev = p2;
                    p2 = p2.next;
                }
            }
            msg.next = p2;
            if (prev != null) {
                prev.next = msg;
            } else {
                this.mMessages = msg;
            }
            return token;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSyncBarrier(int token) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            boolean needWake;
            Message prev = null;
            Message p2 = this.mMessages;
            while (p2 != null && (p2.target != null || p2.arg1 != token)) {
                prev = p2;
                p2 = p2.next;
            }
            if (p2 == null) {
                throw new IllegalStateException("The specified message queue synchronization  barrier token has not been posted or has already been removed.");
            }
            if (prev != null) {
                prev.next = p2.next;
                needWake = false;
            } else {
                this.mMessages = p2.next;
                needWake = this.mMessages == null || this.mMessages.target != null;
            }
            p2.recycleUnchecked();
            if (needWake && !this.mQuitting) {
                if (this.mThread == null) {
                    GLFW.glfwPostEmptyEvent();
                } else {
                    LockSupport.unpark(this.mThread);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean enqueueMessage(@NonNull Message msg, long when) {
        if (msg.target == null) {
            throw new IllegalArgumentException("Message must have a target.");
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            boolean needWake;
            if (msg.isInUse()) {
                throw new IllegalStateException(msg + " This message is already in use.");
            }
            if (this.mQuitting) {
                IllegalStateException e = new IllegalStateException(msg.target + " sending message to a Handler on a dead thread");
                CloudPick.LOGGER.warn(MARKER, e.getMessage(), (Throwable)e);
                msg.recycle();
                return false;
            }
            msg.markInUse();
            msg.when = when;
            Message p2 = this.mMessages;
            if (p2 == null || when == 0L || when < p2.when) {
                msg.next = p2;
                this.mMessages = msg;
                needWake = this.mBlocked;
            } else {
                needWake = this.mBlocked && p2.target == null && msg.isAsynchronous();
                while (true) {
                    Message prev = p2;
                    p2 = p2.next;
                    if (p2 == null || when < p2.when) break;
                    if (!needWake || !p2.isAsynchronous()) continue;
                    needWake = false;
                }
                msg.next = p2;
                prev.next = msg;
            }
            if (needWake) {
                if (this.mThread == null) {
                    GLFW.glfwPostEmptyEvent();
                } else {
                    LockSupport.unpark(this.mThread);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasMessages(Handler h2, int what, Object object) {
        if (h2 == null) {
            return false;
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message p2 = this.mMessages;
            while (p2 != null) {
                if (p2.target == h2 && p2.what == what && (object == null || p2.obj == object)) {
                    return true;
                }
                p2 = p2.next;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasMessages(@NonNull Handler h2, Runnable r) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message p2 = this.mMessages;
            while (p2 != null) {
                if (p2.target == h2 && p2.callback == r) {
                    return true;
                }
                p2 = p2.next;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasMessages(@NonNull Handler h2) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message p2 = this.mMessages;
            while (p2 != null) {
                if (p2.target == h2) {
                    return true;
                }
                p2 = p2.next;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMessages(@NonNull Handler h2, int what, Object object) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message n2;
            Message p2 = this.mMessages;
            while (p2 != null && p2.target == h2 && p2.what == what && (object == null || p2.obj == object)) {
                this.mMessages = n2 = p2.next;
                p2.recycleUnchecked();
                p2 = n2;
            }
            while (p2 != null) {
                n2 = p2.next;
                if (n2 != null && n2.target == h2 && n2.what == what && (object == null || n2.obj == object)) {
                    Message nn = n2.next;
                    n2.recycleUnchecked();
                    p2.next = nn;
                    continue;
                }
                p2 = n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMessages(@NonNull Handler h2, Runnable r, Object object) {
        if (r == null) {
            return;
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message n2;
            Message p2 = this.mMessages;
            while (p2 != null && p2.target == h2 && p2.callback == r && (object == null || p2.obj == object)) {
                this.mMessages = n2 = p2.next;
                p2.recycleUnchecked();
                p2 = n2;
            }
            while (p2 != null) {
                n2 = p2.next;
                if (n2 != null && n2.target == h2 && n2.callback == r && (object == null || n2.obj == object)) {
                    Message nn = n2.next;
                    n2.recycleUnchecked();
                    p2.next = nn;
                    continue;
                }
                p2 = n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCallbacksAndMessages(@NonNull Handler h2, Object object) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message n2;
            Message p2 = this.mMessages;
            while (p2 != null && p2.target == h2 && (object == null || p2.obj == object)) {
                this.mMessages = n2 = p2.next;
                p2.recycleUnchecked();
                p2 = n2;
            }
            while (p2 != null) {
                n2 = p2.next;
                if (n2 != null && n2.target == h2 && (object == null || n2.obj == object)) {
                    Message nn = n2.next;
                    n2.recycleUnchecked();
                    p2.next = nn;
                    continue;
                }
                p2 = n2;
            }
        }
    }

    private void removeAllMessagesLocked() {
        Message p2 = this.mMessages;
        while (p2 != null) {
            Message n2 = p2.next;
            p2.recycleUnchecked();
            p2 = n2;
        }
        this.mMessages = null;
    }

    private void removeAllFutureMessagesLocked() {
        long now = Core.timeMillis();
        Message p2 = this.mMessages;
        if (p2 != null) {
            if (p2.when > now) {
                this.removeAllMessagesLocked();
            } else {
                Message n2;
                while (true) {
                    if ((n2 = p2.next) == null) {
                        return;
                    }
                    if (n2.when > now) break;
                    p2 = n2;
                }
                p2.next = null;
                do {
                    p2 = n2;
                    n2 = p2.next;
                    p2.recycleUnchecked();
                } while (n2 != null);
            }
        }
    }

    @FunctionalInterface
    public static interface IdleHandler {
        public boolean queueIdle();
    }
}

