/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.core;

import it.unimi.dsi.fastutil.longs.Long2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectCollections;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.UnmodifiableView;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWMonitorCallback;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.system.MemoryStack;
import yslelf.cloudpick.graphics.annotation.MainThread;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.core.VideoMode;

@MainThread
public final class Monitor {
    private static final Long2ObjectArrayMap<Monitor> sMonitors;
    private static final ObjectCollection<Monitor> sMonitorsView;
    private static final CopyOnWriteArrayList<MonitorEventListener> sListeners;
    private final long mHandle;
    private final int mXPos;
    private final int mYPos;
    private final VideoMode[] mVideoModes;

    private static void onMonitorCallback(long monitor, int event) {
        block3: {
            Monitor mon;
            block2: {
                if (event != 262145) break block2;
                Monitor mon2 = new Monitor(monitor);
                sMonitors.put(monitor, (Object)mon2);
                for (MonitorEventListener listener : sListeners) {
                    listener.onMonitorConnected(mon2);
                }
                break block3;
            }
            if (event != 262146 || (mon = (Monitor)sMonitors.remove(monitor)) == null) break block3;
            for (MonitorEventListener listener : sListeners) {
                listener.onMonitorDisconnected(mon);
            }
        }
    }

    @Nullable
    public static Monitor get(long handle) {
        return (Monitor)sMonitors.get(handle);
    }

    @Nullable
    public static Monitor getPrimary() {
        return (Monitor)sMonitors.get(GLFW.glfwGetPrimaryMonitor());
    }

    public static @UnmodifiableView Collection<Monitor> getAll() {
        return sMonitorsView;
    }

    public static void addMonitorEventListener(@NonNull MonitorEventListener listener) {
        if (!sListeners.contains(listener)) {
            sListeners.add(listener);
        }
    }

    public static void removeMonitorEventListener(@NonNull MonitorEventListener listener) {
        sListeners.remove(listener);
    }

    private Monitor(long handle) {
        this.mHandle = handle;
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer x = stack.mallocInt(1);
            IntBuffer y = stack.mallocInt(1);
            GLFW.glfwGetMonitorPos((long)handle, (IntBuffer)x, (IntBuffer)y);
            this.mXPos = x.get(0);
            this.mYPos = y.get(0);
        }
        ArrayList<VideoMode> list = new ArrayList<VideoMode>();
        GLFWVidMode.Buffer buffer = GLFW.glfwGetVideoModes((long)handle);
        if (buffer == null) {
            throw new IllegalStateException("Failed to get video modes");
        }
        for (int i = buffer.limit() - 1; i >= 0; --i) {
            buffer.position(i);
            VideoMode m = new VideoMode(buffer);
            if (m.getRedBits() < 8 || m.getGreenBits() < 8 || m.getBlueBits() < 8) continue;
            list.add(m);
        }
        this.mVideoModes = list.toArray(new VideoMode[0]);
    }

    public long getHandle() {
        return this.mHandle;
    }

    public int getXPos() {
        return this.mXPos;
    }

    public int getYPos() {
        return this.mYPos;
    }

    @NonNull
    public VideoMode getCurrentMode() {
        GLFWVidMode mode = GLFW.glfwGetVideoMode((long)this.mHandle);
        if (mode == null) {
            throw new IllegalStateException("Failed to get current video mode");
        }
        return new VideoMode(mode);
    }

    @NonNull
    public String getName() {
        String s = GLFW.glfwGetMonitorName((long)this.mHandle);
        return s == null ? "" : s;
    }

    public int getModeCount() {
        return this.mVideoModes.length;
    }

    @NonNull
    public VideoMode getModeAt(int index) {
        return this.mVideoModes[index];
    }

    @NonNull
    public VideoMode findBestMode(int width, int height) {
        return Arrays.stream(this.mVideoModes).filter(m -> m.getWidth() <= width && m.getHeight() <= height).sorted((c1, c2) -> c2.getWidth() - c1.getWidth()).sorted((c1, c2) -> c2.getHeight() - c1.getHeight()).max(Comparator.comparingInt(VideoMode::getRefreshRate)).orElse(this.mVideoModes[0]);
    }

    static {
        PointerBuffer pointers;
        sMonitors = new Long2ObjectArrayMap();
        sMonitorsView = ObjectCollections.unmodifiable((ObjectCollection)sMonitors.values());
        sListeners = new CopyOnWriteArrayList();
        GLFWMonitorCallback prev = GLFW.glfwSetMonitorCallback(Monitor::onMonitorCallback);
        if (prev != null) {
            prev.close();
        }
        if ((pointers = GLFW.glfwGetMonitors()) != null) {
            for (int i = 0; i < pointers.limit(); ++i) {
                long p2 = pointers.get(i);
                sMonitors.put(p2, (Object)new Monitor(p2));
            }
        }
    }

    public static interface MonitorEventListener {
        public void onMonitorConnected(@NonNull Monitor var1);

        public void onMonitorDisconnected(@NonNull Monitor var1);
    }
}

