/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.core;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFWVulkan;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.util.tinyfd.TinyFileDialogs;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VK11;
import org.lwjgl.vulkan.VkApplicationInfo;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkDeviceCreateInfo;
import org.lwjgl.vulkan.VkDeviceQueueCreateInfo;
import org.lwjgl.vulkan.VkExtensionProperties;
import org.lwjgl.vulkan.VkInstance;
import org.lwjgl.vulkan.VkInstanceCreateInfo;
import org.lwjgl.vulkan.VkPhysicalDevice;
import org.lwjgl.vulkan.VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT;
import org.lwjgl.vulkan.VkPhysicalDeviceFeatures2;
import org.lwjgl.vulkan.VkPhysicalDeviceProperties;
import org.lwjgl.vulkan.VkPhysicalDeviceProperties2;
import org.lwjgl.vulkan.VkQueueFamilyProperties;
import yslelf.cloudpick.graphics.CloudPick;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.engine.ContextOptions;
import yslelf.cloudpick.render.engine.ImmediateContext;
import yslelf.cloudpick.render.vulkan.VKUtil;
import yslelf.cloudpick.render.vulkan.VulkanBackendContext;

public final class VulkanManager
implements AutoCloseable {
    private static volatile VulkanManager sInstance;
    private VkInstance mInstance;
    private VkPhysicalDevice mPhysicalDevice;
    private VkDevice mDevice;
    private int mGraphicsQueueIndex = -1;
    private int mComputeQueueIndex = -1;
    private final Object2IntOpenHashMap<String> mInstanceExtensions = new Object2IntOpenHashMap();
    private final Object2IntOpenHashMap<String> mDeviceExtensions = new Object2IntOpenHashMap();
    private VkPhysicalDeviceFeatures2 mPhysicalDeviceFeatures2;
    private int mDriverVersion;

    private VulkanManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static VulkanManager getInstance() {
        if (sInstance != null) return sInstance;
        Class<VulkanManager> clazz = VulkanManager.class;
        synchronized (VulkanManager.class) {
            if (sInstance != null) return sInstance;
            sInstance = new VulkanManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initialize() {
        PointerBuffer extensionNames;
        IntBuffer pCount;
        if (this.mDevice != null) {
            return;
        }
        if (!GLFWVulkan.glfwVulkanSupported()) {
            TinyFileDialogs.tinyfd_messageBox((CharSequence)"Failed to launch Modern UI", (CharSequence)"Vulkan is not supported on your current platform. Make sure your operating system and graphics card drivers are up-to-date.", (CharSequence)"ok", (CharSequence)"error", (boolean)true);
            throw new RuntimeException("Vulkan is not supported");
        }
        int version = VK.getInstanceVersionSupported();
        CloudPick.LOGGER.info(CloudPick.MARKER, "Vulkan version: {}.{}.{}", (Object)VK11.VK_VERSION_MAJOR((int)version), (Object)VK11.VK_VERSION_MINOR((int)version), (Object)VK11.VK_VERSION_PATCH((int)version));
        if (version < VK11.VK_API_VERSION_1_1) {
            TinyFileDialogs.tinyfd_messageBox((CharSequence)"Failed to launch Modern UI", (CharSequence)"Vulkan 1.1 is not supported on your current platform. Make sure your operating system and graphics card drivers are up-to-date.", (CharSequence)"ok", (CharSequence)"error", (boolean)true);
            throw new RuntimeException("Vulkan 1.1 is not supported");
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            pCount = stack.mallocInt(1);
            VKUtil._CHECK_(VK11.vkEnumerateInstanceExtensionProperties((ByteBuffer)null, (IntBuffer)pCount, null));
            int count = pCount.get(0);
            VkExtensionProperties.Buffer properties = VkExtensionProperties.malloc((int)count, (MemoryStack)stack);
            VKUtil._CHECK_(VK11.vkEnumerateInstanceExtensionProperties((ByteBuffer)null, (IntBuffer)pCount, (VkExtensionProperties.Buffer)properties));
            for (VkExtensionProperties prop : properties) {
                this.mInstanceExtensions.putIfAbsent((Object)prop.extensionNameString(), prop.specVersion());
            }
        }
        CloudPick.LOGGER.info(CloudPick.MARKER, "Enumerated {} instance extensions", (Object)this.mInstanceExtensions.size());
        CloudPick.LOGGER.debug(CloudPick.MARKER, this.mInstanceExtensions);
        stack = MemoryStack.stackPush();
        try {
            ByteBuffer appName = stack.UTF8((CharSequence)"Modern UI", true);
            ByteBuffer engineName = stack.UTF8((CharSequence)"Arc 3D", true);
            VkApplicationInfo appInfo = VkApplicationInfo.calloc((MemoryStack)stack).sType$Default().pApplicationName(appName).pEngineName(engineName).apiVersion(version);
            VkInstanceCreateInfo pCreateInfo = VkInstanceCreateInfo.calloc((MemoryStack)stack).sType$Default().pApplicationInfo(appInfo).ppEnabledLayerNames(null).ppEnabledExtensionNames(GLFWVulkan.glfwGetRequiredInstanceExtensions());
            PointerBuffer pInstance = stack.mallocPointer(1);
            VKUtil._CHECK_ERROR_(VK11.vkCreateInstance((VkInstanceCreateInfo)pCreateInfo, null, (PointerBuffer)pInstance));
            this.mInstance = new VkInstance(pInstance.get(0), pCreateInfo);
        }
        finally {
            if (stack != null) {
                stack.close();
            }
        }
        CloudPick.LOGGER.info(CloudPick.MARKER, "Created Vulkan instance, Engine: {}", (Object)"Arc 3D");
        stack = MemoryStack.stackPush();
        try {
            pCount = stack.mallocInt(1);
            VKUtil._CHECK_(VK11.vkEnumeratePhysicalDevices((VkInstance)this.mInstance, (IntBuffer)pCount, null));
            int deviceCount = pCount.get(0);
            if (deviceCount == 0) {
                throw new RuntimeException("No GPU device was found");
            }
            PointerBuffer pPhysicalDevices = stack.mallocPointer(deviceCount);
            VKUtil._CHECK_(VK11.vkEnumeratePhysicalDevices((VkInstance)this.mInstance, (IntBuffer)pCount, (PointerBuffer)pPhysicalDevices));
            for (int i = 0; i < deviceCount; ++i) {
                VkPhysicalDevice physicalDevice = new VkPhysicalDevice(pPhysicalDevices.get(i), this.mInstance);
                if (!this.choosePhysicalDeviceLocked(physicalDevice)) continue;
                break;
            }
        }
        finally {
            if (stack != null) {
                stack.close();
            }
        }
        if (this.mPhysicalDevice == null) {
            TinyFileDialogs.tinyfd_messageBox((CharSequence)"Failed to launch Modern UI", (CharSequence)"You don't have a device with a Vulkan queue family that supports both graphics and compute.", (CharSequence)"ok", (CharSequence)"error", (boolean)true);
            throw new RuntimeException("No suitable physical device was found");
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer pCount2 = stack.mallocInt(1);
            VKUtil._CHECK_(VK11.vkEnumerateDeviceExtensionProperties((VkPhysicalDevice)this.mPhysicalDevice, (ByteBuffer)null, (IntBuffer)pCount2, null));
            int count = pCount2.get(0);
            VkExtensionProperties.Buffer properties = VkExtensionProperties.malloc((int)count, (MemoryStack)stack);
            VKUtil._CHECK_(VK11.vkEnumerateDeviceExtensionProperties((VkPhysicalDevice)this.mPhysicalDevice, (ByteBuffer)null, (IntBuffer)pCount2, (VkExtensionProperties.Buffer)properties));
            extensionNames = MemoryUtil.memAllocPointer((int)count);
            for (VkExtensionProperties prop : properties) {
                extensionNames.put(prop.extensionName());
                this.mDeviceExtensions.putIfAbsent((Object)prop.extensionNameString(), prop.specVersion());
            }
            extensionNames.flip();
        }
        CloudPick.LOGGER.info(CloudPick.MARKER, "Enumerated {} device extensions", (Object)this.mDeviceExtensions.size());
        CloudPick.LOGGER.debug(CloudPick.MARKER, this.mDeviceExtensions);
        this.mPhysicalDeviceFeatures2 = VkPhysicalDeviceFeatures2.calloc().sType$Default();
        if (this.mDeviceExtensions.getInt((Object)"VK_EXT_blend_operation_advanced") >= 2) {
            CloudPick.LOGGER.info(CloudPick.MARKER, "Enabled {}", (Object)"VK_EXT_blend_operation_advanced");
            this.mPhysicalDeviceFeatures2.pNext(VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT.calloc().sType$Default());
        } else {
            CloudPick.LOGGER.info(CloudPick.MARKER, "Disabled {}", (Object)"VK_EXT_blend_operation_advanced");
        }
        VK11.vkGetPhysicalDeviceFeatures2((VkPhysicalDevice)this.mPhysicalDevice, (VkPhysicalDeviceFeatures2)this.mPhysicalDeviceFeatures2);
        this.mPhysicalDeviceFeatures2.features().robustBufferAccess(false);
        try {
            stack = MemoryStack.stackPush();
            try {
                VkDeviceQueueCreateInfo.Buffer queueInfos = VkDeviceQueueCreateInfo.calloc((int)1, (MemoryStack)stack).sType$Default().queueFamilyIndex(this.mGraphicsQueueIndex).pQueuePriorities(stack.floats(0.0f));
                VkDeviceCreateInfo pCreateInfo = VkDeviceCreateInfo.calloc((MemoryStack)stack).sType$Default().pNext(this.mPhysicalDeviceFeatures2).pQueueCreateInfos(queueInfos).ppEnabledExtensionNames(extensionNames);
                PointerBuffer pDevice = stack.mallocPointer(1);
                VKUtil._CHECK_(VK11.vkCreateDevice((VkPhysicalDevice)this.mPhysicalDevice, (VkDeviceCreateInfo)pCreateInfo, null, (PointerBuffer)pDevice));
                this.mDevice = new VkDevice(pDevice.get(0), this.mPhysicalDevice, pCreateInfo, VK11.VK_API_VERSION_1_1);
            }
            finally {
                if (stack != null) {
                    stack.close();
                }
            }
        }
        finally {
            MemoryUtil.memFree((CustomBuffer)extensionNames);
        }
        CloudPick.LOGGER.info(CloudPick.MARKER, "Created Vulkan device, Queue index: {}", (Object)this.mGraphicsQueueIndex);
    }

    private boolean choosePhysicalDeviceLocked(@NonNull VkPhysicalDevice physicalDevice) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            int driverVersion;
            int j;
            VkPhysicalDeviceProperties2 properties2 = VkPhysicalDeviceProperties2.calloc((MemoryStack)stack).sType$Default();
            VK11.vkGetPhysicalDeviceProperties2((VkPhysicalDevice)physicalDevice, (VkPhysicalDeviceProperties2)properties2);
            VkPhysicalDeviceProperties properties = properties2.properties();
            CloudPick.LOGGER.info(CloudPick.MARKER, "List device ID {}, Name: {}, Type: {}", (Object)properties.deviceID(), (Object)properties.deviceNameString(), (Object)VKUtil.getPhysicalDeviceTypeName(properties.deviceType()));
            if (properties.apiVersion() < VK11.VK_API_VERSION_1_1) {
                CloudPick.LOGGER.info(CloudPick.MARKER, "Skip device ID {} because it does not support Vulkan 1.1", (Object)properties.deviceID());
                boolean bl = false;
                return bl;
            }
            IntBuffer pCount = stack.mallocInt(1);
            VK11.vkGetPhysicalDeviceQueueFamilyProperties((VkPhysicalDevice)physicalDevice, (IntBuffer)pCount, null);
            int count = pCount.get(0);
            if (count == 0) {
                CloudPick.LOGGER.info(CloudPick.MARKER, "Skip device ID {} because no queue family was found", (Object)properties.deviceID());
                boolean bl = false;
                return bl;
            }
            VkQueueFamilyProperties.Buffer queues = VkQueueFamilyProperties.malloc((int)count, (MemoryStack)stack);
            VK11.vkGetPhysicalDeviceQueueFamilyProperties((VkPhysicalDevice)physicalDevice, (IntBuffer)pCount, (VkQueueFamilyProperties.Buffer)queues);
            this.mGraphicsQueueIndex = -1;
            this.mComputeQueueIndex = -1;
            for (j = 0; j < count; ++j) {
                VkQueueFamilyProperties queue = (VkQueueFamilyProperties)queues.get(j);
                if (queue.queueCount() == 0) continue;
                int flags = queue.queueFlags();
                if (this.mGraphicsQueueIndex == -1 && (flags & 1) != 0) {
                    this.mGraphicsQueueIndex = j;
                }
                if (this.mComputeQueueIndex == -1 && (flags & 2) != 0) {
                    this.mComputeQueueIndex = j;
                }
                if (this.mGraphicsQueueIndex > 0 && this.mComputeQueueIndex > 0) break;
            }
            if (this.mGraphicsQueueIndex == -1 || this.mComputeQueueIndex == -1) {
                CloudPick.LOGGER.info(CloudPick.MARKER, "Skip device ID {} because no suitable queue family was found", (Object)properties.deviceID());
                j = 0;
                return j != 0;
            }
            this.mPhysicalDevice = physicalDevice;
            int vendorID = properties.vendorID();
            this.mDriverVersion = driverVersion = properties.driverVersion();
            Integer n2 = properties.deviceID();
            CloudPick.LOGGER.info(CloudPick.MARKER, "Choose device ID {}, vendor ID: {}, driver version: {}", (Object)n2, switch (vendorID) {
                case 4098 -> "AMD";
                case 4112 -> "ImgTec";
                case 4318 -> "NVIDIA";
                case 5045 -> "ARM";
                case 20803 -> "Qualcomm";
                case 32902 -> "INTEL";
                default -> "0x" + Integer.toHexString(vendorID);
            }, switch (vendorID) {
                case 4318 -> String.format("%d.%d.%d.%d", driverVersion >>> 22, driverVersion >>> 14 & 0xFF, driverVersion >> 6 & 0xFF, driverVersion & 0x3F);
                default -> "0x" + Integer.toHexString(vendorID);
            });
            boolean bl = true;
            return bl;
        }
    }

    @Nullable
    @SharedPtr
    public ImmediateContext createContext(@NonNull ContextOptions options) {
        VulkanBackendContext backendContext = new VulkanBackendContext();
        backendContext.mInstance = this.mInstance;
        backendContext.mPhysicalDevice = this.mPhysicalDevice;
        backendContext.mDevice = this.mDevice;
        backendContext.mGraphicsQueueIndex = this.mGraphicsQueueIndex;
        backendContext.mDeviceFeatures2 = this.mPhysicalDeviceFeatures2;
        return VKUtil.makeVulkan(backendContext, options);
    }

    @Override
    public synchronized void close() {
        if (this.mDevice != null) {
            VK11.vkDeviceWaitIdle((VkDevice)this.mDevice);
            VK11.vkDestroyDevice((VkDevice)this.mDevice, null);
        }
        if (this.mInstance != null) {
            VK11.vkDestroyInstance((VkInstance)this.mInstance, null);
        }
        this.mGraphicsQueueIndex = -1;
        this.mComputeQueueIndex = -1;
        this.mDevice = null;
        this.mPhysicalDevice = null;
        this.mInstance = null;
        this.mInstanceExtensions.clear();
        this.mInstanceExtensions.trim();
        this.mDeviceExtensions.clear();
        this.mDeviceExtensions.trim();
        if (this.mPhysicalDeviceFeatures2 != null) {
            VulkanManager.freeFeaturesExtensionsStructs(this.mPhysicalDeviceFeatures2);
            this.mPhysicalDeviceFeatures2.free();
        }
        this.mPhysicalDeviceFeatures2 = null;
        CloudPick.LOGGER.info(CloudPick.MARKER, "Terminated VulkanManager");
    }

    public int getDriverVersion() {
        return this.mDriverVersion;
    }

    public static void freeFeaturesExtensionsStructs(@NonNull VkPhysicalDeviceFeatures2 features) {
        long pNext = features.pNext();
        while (pNext != 0L) {
            long current = pNext;
            pNext = VkPhysicalDeviceFeatures2.npNext((long)current);
            MemoryUtil.nmemFree((long)current);
        }
    }
}

