/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.core.windows;

import java.nio.IntBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.windows.RECT;
import org.lwjgl.system.windows.User32;
import org.lwjgl.system.windows.WindowProc;
import yslelf.cloudpick.graphics.core.windows.Dwmapi;

public class WindowsNativeWindowBorder {

    public static class WndProc
    extends WindowProc {
        private long hwnd;
        private long prevWndProc;

        public WndProc(long hwnd) {
            this.hwnd = hwnd;
            this.prevWndProc = User32.SetWindowLongPtr((long)hwnd, (int)-4, (long)this.address());
            User32.SetWindowPos((long)hwnd, (long)hwnd, (int)0, (int)0, (int)0, (int)0, (int)55);
        }

        public void destroy() {
            User32.SetWindowLongPtr((long)this.hwnd, (int)-4, (long)this.prevWndProc);
            User32.SetWindowPos((long)this.hwnd, (long)this.hwnd, (int)0, (int)0, (int)0, (int)0, (int)55);
            this.free();
        }

        @NativeType(value="LRESULT")
        public long invoke(@NativeType(value="HWND") long hwnd, @NativeType(value="UINT") int uMsg, @NativeType(value="WPARAM") long wParam, @NativeType(value="LPARAM") long lParam) {
            if (uMsg == 131) {
                return this.WmNcCalcSize(hwnd, uMsg, wParam, lParam);
            }
            if (uMsg == 132) {
                return this.WmNcHitTest(hwnd, uMsg, wParam, lParam);
            }
            if (!(uMsg != 161 && uMsg != 162 || wParam != 8L && wParam != 9L && wParam != 20L)) {
                return 0L;
            }
            return User32.nCallWindowProc((long)this.prevWndProc, (long)hwnd, (int)uMsg, (long)wParam, (long)lParam);
        }

        private long WmNcCalcSize(long hwnd, int uMsg, long wParam, long lParam) {
            if (wParam != 1L) {
                return User32.nCallWindowProc((long)this.prevWndProc, (long)hwnd, (int)uMsg, (long)wParam, (long)lParam);
            }
            RECT firstRect = RECT.create((long)lParam);
            int originalTop = firstRect.top();
            long lResult = User32.nCallWindowProc((long)this.prevWndProc, (long)hwnd, (int)uMsg, (long)wParam, (long)lParam);
            if (lResult != 0L) {
                return lResult;
            }
            try (MemoryStack stack = MemoryStack.stackPush();){
                IntBuffer borderThick = stack.mallocInt(1);
                int hResult = Dwmapi.DwmGetWindowAttribute(hwnd, 37, MemoryUtil.memAddress((IntBuffer)borderThick), 4);
                if (hResult == 0) {
                    originalTop += borderThick.get(0);
                }
            }
            firstRect.top(originalTop);
            return lResult;
        }

        private long WmNcHitTest(long hwnd, int uMsg, long wParam, long lParam) {
            long lResult = User32.nCallWindowProc((long)this.prevWndProc, (long)hwnd, (int)uMsg, (long)wParam, (long)lParam);
            if (lResult != 1L) {
                return lResult;
            }
            short x = (short)(lParam & 0xFFFFL);
            short y = (short)(lParam >> 16 & 0xFFFFL);
            if (x >= 600 && x <= 620 && y >= 400 && y <= 420) {
                return 20L;
            }
            return 1L;
        }
    }
}

