/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.fragment;

import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.graphics.animation.Animator;
import yslelf.cloudpick.graphics.animation.AnimatorListener;
import yslelf.cloudpick.graphics.animation.ObjectAnimator;
import yslelf.cloudpick.graphics.animation.TimeInterpolator;
import yslelf.cloudpick.graphics.core.CancellationSignal;
import yslelf.cloudpick.graphics.fragment.Fragment;
import yslelf.cloudpick.graphics.fragment.FragmentTransition;
import yslelf.cloudpick.graphics.fragment.SharedElementCallback;
import yslelf.cloudpick.graphics.fragment.SpecialEffectsController;
import yslelf.cloudpick.graphics.graphics.Rect;
import yslelf.cloudpick.graphics.transition.Transition;
import yslelf.cloudpick.graphics.transition.TransitionManager;
import yslelf.cloudpick.graphics.transition.TransitionSet;
import yslelf.cloudpick.graphics.util.ArrayMap;
import yslelf.cloudpick.graphics.view.OneShotPreDrawListener;
import yslelf.cloudpick.graphics.view.View;
import yslelf.cloudpick.graphics.view.ViewGroup;

class DefaultSpecialEffectsController
extends SpecialEffectsController {
    DefaultSpecialEffectsController(@Nonnull ViewGroup container) {
        super(container);
    }

    @Override
    void executeOperations(@Nonnull List<SpecialEffectsController.Operation> operations, boolean isPop) {
        SpecialEffectsController.Operation firstOut = null;
        SpecialEffectsController.Operation lastIn = null;
        for (SpecialEffectsController.Operation operation : operations) {
            SpecialEffectsController.Operation.State currentState = SpecialEffectsController.Operation.State.from(operation.getFragment().mView);
            switch (operation.getFinalState()) {
                case GONE: 
                case INVISIBLE: 
                case REMOVED: {
                    if (currentState != SpecialEffectsController.Operation.State.VISIBLE || firstOut != null) break;
                    firstOut = operation;
                    break;
                }
                case VISIBLE: {
                    if (currentState == SpecialEffectsController.Operation.State.VISIBLE) break;
                    lastIn = operation;
                }
            }
        }
        ArrayList<AnimationInfo> animations = new ArrayList<AnimationInfo>();
        ArrayList<TransitionInfo> transitions = new ArrayList<TransitionInfo>();
        ArrayList<SpecialEffectsController.Operation> awaitingContainerChanges = new ArrayList<SpecialEffectsController.Operation>(operations);
        for (SpecialEffectsController.Operation operation : operations) {
            CancellationSignal animCancellationSignal = new CancellationSignal();
            operation.markStartedSpecialEffect(animCancellationSignal);
            animations.add(new AnimationInfo(operation, animCancellationSignal, isPop));
            CancellationSignal transitionCancellationSignal = new CancellationSignal();
            operation.markStartedSpecialEffect(transitionCancellationSignal);
            transitions.add(new TransitionInfo(operation, transitionCancellationSignal, isPop, isPop ? operation == firstOut : operation == lastIn));
            operation.addCompletionListener(() -> {
                if (awaitingContainerChanges.contains(operation)) {
                    awaitingContainerChanges.remove(operation);
                    DefaultSpecialEffectsController.applyContainerChanges(operation);
                }
            });
        }
        Object2BooleanMap<SpecialEffectsController.Operation> startedTransitions = this.startTransitions(transitions, awaitingContainerChanges, isPop, firstOut, lastIn);
        this.startAnimations(animations, awaitingContainerChanges, startedTransitions);
        for (SpecialEffectsController.Operation operation : awaitingContainerChanges) {
            DefaultSpecialEffectsController.applyContainerChanges(operation);
        }
        awaitingContainerChanges.clear();
    }

    private void startAnimations(@Nonnull List<AnimationInfo> animationInfos, @Nonnull List<SpecialEffectsController.Operation> awaitingContainerChanges, @Nonnull Object2BooleanMap<SpecialEffectsController.Operation> startedTransitions) {
        final ViewGroup container = this.getContainer();
        for (final AnimationInfo animationInfo : animationInfos) {
            boolean isHideOperation;
            if (animationInfo.isVisibilityUnchanged()) {
                animationInfo.completeSpecialEffect();
                continue;
            }
            Animator animator = animationInfo.getAnimator();
            if (animator == null) {
                animationInfo.completeSpecialEffect();
                continue;
            }
            final SpecialEffectsController.Operation operation = animationInfo.getOperation();
            Fragment fragment = operation.getFragment();
            boolean startedTransition = startedTransitions.getBoolean((Object)operation);
            if (startedTransition) {
                animationInfo.completeSpecialEffect();
                continue;
            }
            boolean bl = isHideOperation = operation.getFinalState() == SpecialEffectsController.Operation.State.GONE;
            if (isHideOperation) {
                awaitingContainerChanges.remove(operation);
            }
            final View viewToAnimate = fragment.mView;
            container.startViewTransition(viewToAnimate);
            animator.addListener(new AnimatorListener(){

                @Override
                public void onAnimationEnd(@Nonnull Animator anim) {
                    container.endViewTransition(viewToAnimate);
                    if (isHideOperation) {
                        operation.getFinalState().applyState(viewToAnimate);
                    }
                    animationInfo.completeSpecialEffect();
                }
            });
            animator.setTarget(viewToAnimate);
            animator.start();
            CancellationSignal signal = animationInfo.getSignal();
            signal.setOnCancelListener(() -> animator.end());
        }
    }

    @Nonnull
    private Object2BooleanMap<SpecialEffectsController.Operation> startTransitions(@Nonnull List<TransitionInfo> transitionInfos, @Nonnull List<SpecialEffectsController.Operation> awaitingContainerChanges, boolean isPop, @Nullable SpecialEffectsController.Operation firstOut, @Nullable SpecialEffectsController.Operation lastIn) {
        SpecialEffectsController.Operation operation;
        Transition transition;
        Object2BooleanOpenHashMap startedTransitions = new Object2BooleanOpenHashMap();
        boolean hasTransition = false;
        for (TransitionInfo transitionInfo : transitionInfos) {
            if (transitionInfo.isVisibilityUnchanged() || transitionInfo.getTransition() == null && transitionInfo.getSharedElementTransition() == null) continue;
            hasTransition = true;
            break;
        }
        if (!hasTransition) {
            for (TransitionInfo transitionInfo : transitionInfos) {
                startedTransitions.put((Object)transitionInfo.getOperation(), false);
                transitionInfo.completeSpecialEffect();
            }
            return startedTransitions;
        }
        View nonExistentView = new View(this.getContainer().getContext());
        Iterator<TransitionInfo> sharedElementTransition = null;
        View firstOutEpicenterView = null;
        boolean hasLastInEpicenter = false;
        Rect lastInEpicenterRect = new Rect();
        ArrayList<View> sharedElementFirstOutViews = new ArrayList<View>();
        ArrayList<View> sharedElementLastInViews = new ArrayList<View>();
        ArrayMap<String, String> sharedElementNameMapping = new ArrayMap<String, String>();
        for (TransitionInfo transitionInfo : transitionInfos) {
            String epicenterViewName;
            View lastInEpicenterView;
            SharedElementCallback enteringCallback;
            SharedElementCallback exitingCallback;
            Transition transition2 = transitionInfo.getSharedElementTransition();
            if (transition2 == null || firstOut == null || lastIn == null) continue;
            Iterator<TransitionInfo> transitionSet = new TransitionSet();
            ((TransitionSet)((Object)transitionSet)).addTransition(transition2.clone());
            sharedElementTransition = transitionSet;
            ArrayList<String> exitingNames = lastIn.getFragment().getSharedElementSourceNames();
            ArrayList<String> firstOutSourceNames = firstOut.getFragment().getSharedElementSourceNames();
            ArrayList<String> firstOutTargetNames = firstOut.getFragment().getSharedElementTargetNames();
            for (int index = 0; index < firstOutTargetNames.size(); ++index) {
                int nameIndex = exitingNames.indexOf(firstOutTargetNames.get(index));
                if (nameIndex == -1) continue;
                exitingNames.set(nameIndex, firstOutSourceNames.get(index));
            }
            ArrayList<String> enteringNames = lastIn.getFragment().getSharedElementTargetNames();
            if (!isPop) {
                exitingCallback = firstOut.getFragment().getExitTransitionCallback();
                enteringCallback = lastIn.getFragment().getEnterTransitionCallback();
            } else {
                exitingCallback = firstOut.getFragment().getEnterTransitionCallback();
                enteringCallback = lastIn.getFragment().getExitTransitionCallback();
            }
            int numSharedElements = exitingNames.size();
            for (int i = 0; i < numSharedElements; ++i) {
                String exitingName = exitingNames.get(i);
                String enteringName = enteringNames.get(i);
                sharedElementNameMapping.put(exitingName, enteringName);
            }
            ArrayMap<String, View> firstOutViews = new ArrayMap<String, View>();
            this.findNamedViews(firstOutViews, firstOut.getFragment().mView);
            firstOutViews.retainAll(exitingNames);
            if (exitingCallback != null) {
                exitingCallback.onMapSharedElements(exitingNames, firstOutViews);
                for (int i = exitingNames.size() - 1; i >= 0; --i) {
                    String name = exitingNames.get(i);
                    View view = firstOutViews.get(name);
                    if (view == null) {
                        sharedElementNameMapping.remove(name);
                        continue;
                    }
                    if (name.equals(view.getTransitionName())) continue;
                    String targetValue = sharedElementNameMapping.remove(name);
                    sharedElementNameMapping.put(view.getTransitionName(), targetValue);
                }
            } else {
                sharedElementNameMapping.retainAll(firstOutViews.keySet());
            }
            ArrayMap<String, View> lastInViews = new ArrayMap<String, View>();
            this.findNamedViews(lastInViews, lastIn.getFragment().mView);
            lastInViews.retainAll(enteringNames);
            lastInViews.retainAll(sharedElementNameMapping.values());
            if (enteringCallback != null) {
                enteringCallback.onMapSharedElements(enteringNames, lastInViews);
                for (int i = enteringNames.size() - 1; i >= 0; --i) {
                    String key;
                    String name = enteringNames.get(i);
                    View view = lastInViews.get(name);
                    if (view == null) {
                        key = FragmentTransition.findKeyForValue(sharedElementNameMapping, name);
                        if (key == null) continue;
                        sharedElementNameMapping.remove(key);
                        continue;
                    }
                    if (name.equals(view.getTransitionName()) || (key = FragmentTransition.findKeyForValue(sharedElementNameMapping, name)) == null) continue;
                    sharedElementNameMapping.put(key, view.getTransitionName());
                }
            } else {
                FragmentTransition.retainValues(sharedElementNameMapping, lastInViews);
            }
            this.retainMatchingViews(firstOutViews, sharedElementNameMapping.keySet());
            this.retainMatchingViews(lastInViews, sharedElementNameMapping.values());
            this.retainMatchingViews(firstOutViews, sharedElementNameMapping.keySet());
            this.retainMatchingViews(lastInViews, sharedElementNameMapping.values());
            if (sharedElementNameMapping.isEmpty()) {
                sharedElementTransition = null;
                sharedElementFirstOutViews.clear();
                sharedElementLastInViews.clear();
                continue;
            }
            FragmentTransition.callSharedElementStartEnd(lastIn.getFragment(), firstOut.getFragment(), isPop, firstOutViews, true);
            OneShotPreDrawListener.add(this.getContainer(), () -> FragmentTransition.callSharedElementStartEnd(lastIn.getFragment(), firstOut.getFragment(), isPop, lastInViews, false));
            sharedElementFirstOutViews.addAll(firstOutViews.values());
            if (!exitingNames.isEmpty()) {
                String epicenterViewName2 = exitingNames.get(0);
                firstOutEpicenterView = firstOutViews.get(epicenterViewName2);
                FragmentTransition.setEpicenter(sharedElementTransition, firstOutEpicenterView);
            }
            sharedElementLastInViews.addAll(lastInViews.values());
            if (!enteringNames.isEmpty() && (lastInEpicenterView = lastInViews.get(epicenterViewName = enteringNames.get(0))) != null) {
                hasLastInEpicenter = true;
                OneShotPreDrawListener.add(this.getContainer(), () -> lastInEpicenterView.getBoundsOnScreen(lastInEpicenterRect));
            }
            FragmentTransition.setSharedElementTargets(sharedElementTransition, nonExistentView, sharedElementFirstOutViews);
            FragmentTransition.scheduleRemoveTargets(sharedElementTransition, null, null, null, null, sharedElementTransition, sharedElementLastInViews);
            startedTransitions.put((Object)firstOut, true);
            startedTransitions.put((Object)lastIn, true);
        }
        ArrayList<View> enteringViews = new ArrayList<View>();
        Transition mergedTransition = null;
        TransitionSet mergedNonOverlappingTransition = null;
        for (TransitionInfo transitionInfo : transitionInfos) {
            boolean involvedInSharedElementTransition;
            if (transitionInfo.isVisibilityUnchanged()) {
                startedTransitions.put((Object)transitionInfo.getOperation(), false);
                transitionInfo.completeSpecialEffect();
                continue;
            }
            transition = transitionInfo.getTransition();
            if (transition != null) {
                transition = transition.clone();
            }
            operation = transitionInfo.getOperation();
            boolean bl = involvedInSharedElementTransition = sharedElementTransition != null && (operation == firstOut || operation == lastIn);
            if (transition == null) {
                if (involvedInSharedElementTransition) continue;
                startedTransitions.put((Object)operation, false);
                transitionInfo.completeSpecialEffect();
                continue;
            }
            ArrayList<View> transitioningViews = new ArrayList<View>();
            this.captureTransitioningViews(transitioningViews, operation.getFragment().mView);
            if (involvedInSharedElementTransition) {
                if (operation == firstOut) {
                    transitioningViews.removeAll(sharedElementFirstOutViews);
                } else {
                    transitioningViews.removeAll(sharedElementLastInViews);
                }
            }
            if (transitioningViews.isEmpty()) {
                transition.addTarget(nonExistentView);
            } else {
                FragmentTransition.addTargets(transition, transitioningViews);
                FragmentTransition.scheduleRemoveTargets(transition, transition, transitioningViews, null, null, null, null);
                if (operation.getFinalState() == SpecialEffectsController.Operation.State.GONE) {
                    awaitingContainerChanges.remove(operation);
                    ArrayList<View> transitioningViewsToHide = new ArrayList<View>(transitioningViews);
                    transitioningViewsToHide.remove(operation.getFragment().mView);
                    FragmentTransition.scheduleHideFragmentView(transition, operation.getFragment().mView, transitioningViewsToHide);
                    OneShotPreDrawListener.add(this.getContainer(), () -> FragmentTransition.setViewVisibility(transitioningViews, 4));
                }
            }
            if (operation.getFinalState() == SpecialEffectsController.Operation.State.VISIBLE) {
                enteringViews.addAll(transitioningViews);
                if (hasLastInEpicenter) {
                    FragmentTransition.setEpicenter(transition, lastInEpicenterRect);
                }
            } else {
                FragmentTransition.setEpicenter(transition, firstOutEpicenterView);
            }
            startedTransitions.put((Object)operation, true);
            if (transitionInfo.isOverlapAllowed()) {
                mergedTransition = FragmentTransition.mergeTransitionsTogether(mergedTransition, transition, null);
                continue;
            }
            mergedNonOverlappingTransition = FragmentTransition.mergeTransitionsTogether(mergedNonOverlappingTransition, transition, null);
        }
        if ((mergedTransition = FragmentTransition.mergeTransitionsInSequence(mergedTransition, mergedNonOverlappingTransition, sharedElementTransition)) == null) {
            return startedTransitions;
        }
        for (TransitionInfo transitionInfo : transitionInfos) {
            boolean involvedInSharedElementTransition;
            if (transitionInfo.isVisibilityUnchanged()) continue;
            transition = transitionInfo.getTransition();
            operation = transitionInfo.getOperation();
            boolean bl = involvedInSharedElementTransition = sharedElementTransition != null && (operation == firstOut || operation == lastIn);
            if (transition == null && !involvedInSharedElementTransition) continue;
            if (!this.getContainer().isLaidOut()) {
                transitionInfo.completeSpecialEffect();
                continue;
            }
            FragmentTransition.setListenerForTransitionEnd(mergedTransition, transitionInfo.getSignal(), () -> transitionInfo.completeSpecialEffect());
        }
        if (!this.getContainer().isLaidOut()) {
            return startedTransitions;
        }
        FragmentTransition.setViewVisibility(enteringViews, 4);
        ArrayList<String> inNames = FragmentTransition.prepareSetNameOverridesReordered(sharedElementLastInViews);
        TransitionManager.beginDelayedTransition(this.getContainer(), mergedTransition);
        FragmentTransition.setNameOverridesReordered(this.getContainer(), sharedElementFirstOutViews, sharedElementLastInViews, inNames, sharedElementNameMapping);
        FragmentTransition.setViewVisibility(enteringViews, 0);
        FragmentTransition.swapSharedElementTargets(sharedElementTransition, sharedElementFirstOutViews, sharedElementLastInViews);
        return startedTransitions;
    }

    void retainMatchingViews(@Nonnull ArrayMap<String, View> sharedElementViews, @Nonnull Collection<String> transitionNames) {
        sharedElementViews.entrySet().removeIf(entry -> !transitionNames.contains(((View)entry.getValue()).getTransitionName()));
    }

    void captureTransitioningViews(@Nonnull ArrayList<View> transitioningViews, View view) {
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            if (viewGroup.isTransitionGroup()) {
                if (!transitioningViews.contains(view)) {
                    transitioningViews.add(viewGroup);
                }
            } else {
                int count = viewGroup.getChildCount();
                for (int i = 0; i < count; ++i) {
                    View child = viewGroup.getChildAt(i);
                    if (child.getVisibility() != 0) continue;
                    this.captureTransitioningViews(transitioningViews, child);
                }
            }
        } else if (!transitioningViews.contains(view)) {
            transitioningViews.add(view);
        }
    }

    void findNamedViews(@Nonnull Map<String, View> namedViews, @Nonnull View view) {
        String transitionName = view.getTransitionName();
        if (transitionName != null) {
            namedViews.put(transitionName, view);
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int count = viewGroup.getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = viewGroup.getChildAt(i);
                if (child.getVisibility() != 0) continue;
                this.findNamedViews(namedViews, child);
            }
        }
    }

    static void applyContainerChanges(@Nonnull SpecialEffectsController.Operation operation) {
        View view = operation.getFragment().mView;
        operation.getFinalState().applyState(view);
    }

    private static class AnimationInfo
    extends SpecialEffectsInfo {
        private static final Animator fragment_open_enter = ObjectAnimator.ofFloat(null, View.ALPHA, 0.0f, 1.0f);
        private static final Animator fragment_open_exit;
        private static final Animator fragment_close_enter;
        private static final Animator fragment_close_exit;
        private static final Animator fragment_fade_enter;
        private static final Animator fragment_fade_exit;
        private final boolean mIsPop;
        private boolean mLoadedAnim = false;
        @Nullable
        private Animator mAnimator;

        AnimationInfo(@Nonnull SpecialEffectsController.Operation operation, @Nonnull CancellationSignal signal, boolean isPop) {
            super(operation, signal);
            this.mIsPop = isPop;
        }

        @Nullable
        Animator getAnimator() {
            if (this.mLoadedAnim) {
                return this.mAnimator;
            }
            this.mAnimator = AnimationInfo.loadAnimator(this.getOperation().getFragment(), this.getOperation().getFinalState() == SpecialEffectsController.Operation.State.VISIBLE, this.mIsPop);
            this.mLoadedAnim = true;
            return this.mAnimator;
        }

        @Nullable
        private static Animator loadAnimator(@Nonnull Fragment fragment, boolean enter, boolean isPop) {
            int transit = fragment.getNextTransition();
            int nextAnim = AnimationInfo.getNextAnim(fragment, enter, isPop);
            fragment.setAnimations(0, 0, 0, 0);
            if (fragment.mContainer != null && fragment.mContainer.getTag(0x2020002) != null) {
                fragment.mContainer.setTag(0x2020002, null);
            }
            if (fragment.mContainer != null && fragment.mContainer.getLayoutTransition() != null) {
                return null;
            }
            Animator animator = fragment.onCreateAnimator(transit, enter, nextAnim);
            if (animator != null) {
                return animator;
            }
            if (nextAnim == 0 && transit != 0) {
                switch (transit) {
                    case 4097: {
                        return enter ? fragment_open_enter.clone() : fragment_open_exit.clone();
                    }
                    case 8194: {
                        return enter ? fragment_close_enter.clone() : fragment_close_exit.clone();
                    }
                    case 4099: {
                        return enter ? fragment_fade_enter.clone() : fragment_fade_exit.clone();
                    }
                    case 4100: {
                        break;
                    }
                }
            }
            return null;
        }

        private static int getNextAnim(Fragment fragment, boolean enter, boolean isPop) {
            if (isPop) {
                if (enter) {
                    return fragment.getPopEnterAnim();
                }
                return fragment.getPopExitAnim();
            }
            if (enter) {
                return fragment.getEnterAnim();
            }
            return fragment.getExitAnim();
        }

        static {
            fragment_open_enter.setInterpolator(TimeInterpolator.DECELERATE_CUBIC);
            fragment_open_enter.setDuration(300L);
            fragment_open_exit = ObjectAnimator.ofFloat(null, View.ALPHA, 1.0f, 0.0f);
            fragment_open_exit.setInterpolator(TimeInterpolator.DECELERATE_CUBIC);
            fragment_open_exit.setDuration(300L);
            fragment_close_enter = fragment_open_enter;
            fragment_close_exit = fragment_open_exit;
            fragment_fade_enter = ObjectAnimator.ofFloat(null, View.ALPHA, 0.0f, 1.0f);
            fragment_fade_enter.setInterpolator(TimeInterpolator.DECELERATE_CUBIC);
            fragment_fade_enter.setDuration(220L);
            fragment_fade_exit = ObjectAnimator.ofFloat(null, View.ALPHA, 1.0f, 0.0f);
            fragment_fade_exit.setInterpolator(TimeInterpolator.DECELERATE_CUBIC);
            fragment_fade_exit.setDuration(150L);
        }
    }

    private static class TransitionInfo
    extends SpecialEffectsInfo {
        @Nullable
        private final Transition mTransition;
        private final boolean mOverlapAllowed;
        @Nullable
        private final Transition mSharedElementTransition;

        TransitionInfo(@Nonnull SpecialEffectsController.Operation operation, @Nonnull CancellationSignal signal, boolean isPop, boolean providesSharedElementTransition) {
            super(operation, signal);
            if (operation.getFinalState() == SpecialEffectsController.Operation.State.VISIBLE) {
                this.mTransition = isPop ? operation.getFragment().getReenterTransition() : operation.getFragment().getEnterTransition();
                this.mOverlapAllowed = isPop ? operation.getFragment().getAllowReturnTransitionOverlap() : operation.getFragment().getAllowEnterTransitionOverlap();
            } else {
                this.mTransition = isPop ? operation.getFragment().getReturnTransition() : operation.getFragment().getExitTransition();
                this.mOverlapAllowed = true;
            }
            this.mSharedElementTransition = providesSharedElementTransition ? (isPop ? operation.getFragment().getSharedElementReturnTransition() : operation.getFragment().getSharedElementEnterTransition()) : null;
        }

        @Nullable
        Transition getTransition() {
            return this.mTransition;
        }

        boolean isOverlapAllowed() {
            return this.mOverlapAllowed;
        }

        @Nullable
        Transition getSharedElementTransition() {
            return this.mSharedElementTransition;
        }
    }

    private static class SpecialEffectsInfo {
        @Nonnull
        private final SpecialEffectsController.Operation mOperation;
        @Nonnull
        private final CancellationSignal mSignal;

        SpecialEffectsInfo(@Nonnull SpecialEffectsController.Operation operation, @Nonnull CancellationSignal signal) {
            this.mOperation = operation;
            this.mSignal = signal;
        }

        @Nonnull
        SpecialEffectsController.Operation getOperation() {
            return this.mOperation;
        }

        @Nonnull
        CancellationSignal getSignal() {
            return this.mSignal;
        }

        boolean isVisibilityUnchanged() {
            SpecialEffectsController.Operation.State finalState;
            SpecialEffectsController.Operation.State currentState = SpecialEffectsController.Operation.State.from(this.mOperation.getFragment().mView);
            return currentState == (finalState = this.mOperation.getFinalState()) || currentState != SpecialEffectsController.Operation.State.VISIBLE && finalState != SpecialEffectsController.Operation.State.VISIBLE;
        }

        void completeSpecialEffect() {
            this.mOperation.completeSpecialEffect(this.mSignal);
        }
    }
}

