/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.fragment;

import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.graphics.fragment.Fragment;
import yslelf.cloudpick.graphics.fragment.FragmentLifecycleCallbacks;
import yslelf.cloudpick.graphics.fragment.FragmentManager;
import yslelf.cloudpick.graphics.util.DataSet;
import yslelf.cloudpick.graphics.view.View;

final class FragmentLifecycleCallbacksDispatcher {
    @Nonnull
    private final CopyOnWriteArrayList<FragmentLifecycleCallbacksHolder> mLifecycleCallbacks = new CopyOnWriteArrayList();
    @Nonnull
    private final FragmentManager mFragmentManager;

    FragmentLifecycleCallbacksDispatcher(@Nonnull FragmentManager fragmentManager) {
        this.mFragmentManager = fragmentManager;
    }

    public void registerFragmentLifecycleCallbacks(@Nonnull FragmentLifecycleCallbacks cb, boolean recursive) {
        this.mLifecycleCallbacks.add(new FragmentLifecycleCallbacksHolder(cb, recursive));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFragmentLifecycleCallbacks(@Nonnull FragmentLifecycleCallbacks cb) {
        CopyOnWriteArrayList<FragmentLifecycleCallbacksHolder> copyOnWriteArrayList = this.mLifecycleCallbacks;
        synchronized (copyOnWriteArrayList) {
            int count = this.mLifecycleCallbacks.size();
            for (int i = 0; i < count; ++i) {
                if (this.mLifecycleCallbacks.get((int)i).mCallback != cb) continue;
                this.mLifecycleCallbacks.remove(i);
                break;
            }
        }
    }

    void dispatchOnFragmentPreAttached(@Nonnull Fragment f2, boolean onlyRecursive) {
        Fragment parent = this.mFragmentManager.getParent();
        if (parent != null) {
            FragmentManager parentManager = parent.getParentFragmentManager();
            parentManager.getLifecycleCallbacksDispatcher().dispatchOnFragmentPreAttached(f2, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentPreAttached(this.mFragmentManager, f2);
        }
    }

    void dispatchOnFragmentAttached(@Nonnull Fragment f2, boolean onlyRecursive) {
        Fragment parent = this.mFragmentManager.getParent();
        if (parent != null) {
            FragmentManager parentManager = parent.getParentFragmentManager();
            parentManager.getLifecycleCallbacksDispatcher().dispatchOnFragmentAttached(f2, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentAttached(this.mFragmentManager, f2);
        }
    }

    void dispatchOnFragmentPreCreated(@Nonnull Fragment f2, @Nullable DataSet savedInstanceState, boolean onlyRecursive) {
        Fragment parent = this.mFragmentManager.getParent();
        if (parent != null) {
            FragmentManager parentManager = parent.getParentFragmentManager();
            parentManager.getLifecycleCallbacksDispatcher().dispatchOnFragmentPreCreated(f2, savedInstanceState, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentPreCreated(this.mFragmentManager, f2, savedInstanceState);
        }
    }

    void dispatchOnFragmentCreated(@Nonnull Fragment f2, @Nullable DataSet savedInstanceState, boolean onlyRecursive) {
        Fragment parent = this.mFragmentManager.getParent();
        if (parent != null) {
            FragmentManager parentManager = parent.getParentFragmentManager();
            parentManager.getLifecycleCallbacksDispatcher().dispatchOnFragmentCreated(f2, savedInstanceState, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentCreated(this.mFragmentManager, f2, savedInstanceState);
        }
    }

    void dispatchOnFragmentViewCreated(@Nonnull Fragment f2, @Nonnull View v, @Nullable DataSet savedInstanceState, boolean onlyRecursive) {
        Fragment parent = this.mFragmentManager.getParent();
        if (parent != null) {
            FragmentManager parentManager = parent.getParentFragmentManager();
            parentManager.getLifecycleCallbacksDispatcher().dispatchOnFragmentViewCreated(f2, v, savedInstanceState, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentViewCreated(this.mFragmentManager, f2, v, savedInstanceState);
        }
    }

    void dispatchOnFragmentStarted(@Nonnull Fragment f2, boolean onlyRecursive) {
        Fragment parent = this.mFragmentManager.getParent();
        if (parent != null) {
            FragmentManager parentManager = parent.getParentFragmentManager();
            parentManager.getLifecycleCallbacksDispatcher().dispatchOnFragmentStarted(f2, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentStarted(this.mFragmentManager, f2);
        }
    }

    void dispatchOnFragmentResumed(@Nonnull Fragment f2, boolean onlyRecursive) {
        Fragment parent = this.mFragmentManager.getParent();
        if (parent != null) {
            FragmentManager parentManager = parent.getParentFragmentManager();
            parentManager.getLifecycleCallbacksDispatcher().dispatchOnFragmentResumed(f2, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentResumed(this.mFragmentManager, f2);
        }
    }

    void dispatchOnFragmentPaused(@Nonnull Fragment f2, boolean onlyRecursive) {
        Fragment parent = this.mFragmentManager.getParent();
        if (parent != null) {
            FragmentManager parentManager = parent.getParentFragmentManager();
            parentManager.getLifecycleCallbacksDispatcher().dispatchOnFragmentPaused(f2, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentPaused(this.mFragmentManager, f2);
        }
    }

    void dispatchOnFragmentStopped(@Nonnull Fragment f2, boolean onlyRecursive) {
        Fragment parent = this.mFragmentManager.getParent();
        if (parent != null) {
            FragmentManager parentManager = parent.getParentFragmentManager();
            parentManager.getLifecycleCallbacksDispatcher().dispatchOnFragmentStopped(f2, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentStopped(this.mFragmentManager, f2);
        }
    }

    void dispatchOnFragmentSaveInstanceState(@Nonnull Fragment f2, @Nonnull DataSet outState, boolean onlyRecursive) {
        Fragment parent = this.mFragmentManager.getParent();
        if (parent != null) {
            FragmentManager parentManager = parent.getParentFragmentManager();
            parentManager.getLifecycleCallbacksDispatcher().dispatchOnFragmentSaveInstanceState(f2, outState, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentSaveInstanceState(this.mFragmentManager, f2, outState);
        }
    }

    void dispatchOnFragmentViewDestroyed(@Nonnull Fragment f2, boolean onlyRecursive) {
        Fragment parent = this.mFragmentManager.getParent();
        if (parent != null) {
            FragmentManager parentManager = parent.getParentFragmentManager();
            parentManager.getLifecycleCallbacksDispatcher().dispatchOnFragmentViewDestroyed(f2, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentViewDestroyed(this.mFragmentManager, f2);
        }
    }

    void dispatchOnFragmentDestroyed(@Nonnull Fragment f2, boolean onlyRecursive) {
        Fragment parent = this.mFragmentManager.getParent();
        if (parent != null) {
            FragmentManager parentManager = parent.getParentFragmentManager();
            parentManager.getLifecycleCallbacksDispatcher().dispatchOnFragmentDestroyed(f2, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentDestroyed(this.mFragmentManager, f2);
        }
    }

    void dispatchOnFragmentDetached(@Nonnull Fragment f2, boolean onlyRecursive) {
        Fragment parent = this.mFragmentManager.getParent();
        if (parent != null) {
            FragmentManager parentManager = parent.getParentFragmentManager();
            parentManager.getLifecycleCallbacksDispatcher().dispatchOnFragmentDetached(f2, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentDetached(this.mFragmentManager, f2);
        }
    }

    private static final class FragmentLifecycleCallbacksHolder {
        @Nonnull
        final FragmentLifecycleCallbacks mCallback;
        final boolean mRecursive;

        FragmentLifecycleCallbacksHolder(@Nonnull FragmentLifecycleCallbacks callback, boolean recursive) {
            this.mCallback = callback;
            this.mRecursive = recursive;
        }
    }
}

