/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.fragment;

import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import yslelf.cloudpick.graphics.CloudPick;
import yslelf.cloudpick.graphics.annotation.UiThread;
import yslelf.cloudpick.graphics.core.LogWriter;
import yslelf.cloudpick.graphics.fragment.BackStackRecord;
import yslelf.cloudpick.graphics.fragment.DefaultSpecialEffectsController;
import yslelf.cloudpick.graphics.fragment.Fragment;
import yslelf.cloudpick.graphics.fragment.FragmentContainer;
import yslelf.cloudpick.graphics.fragment.FragmentContainerView;
import yslelf.cloudpick.graphics.fragment.FragmentFactory;
import yslelf.cloudpick.graphics.fragment.FragmentHostCallback;
import yslelf.cloudpick.graphics.fragment.FragmentLifecycleCallbacks;
import yslelf.cloudpick.graphics.fragment.FragmentLifecycleCallbacksDispatcher;
import yslelf.cloudpick.graphics.fragment.FragmentManagerViewModel;
import yslelf.cloudpick.graphics.fragment.FragmentOnAttachListener;
import yslelf.cloudpick.graphics.fragment.FragmentResultListener;
import yslelf.cloudpick.graphics.fragment.FragmentResultOwner;
import yslelf.cloudpick.graphics.fragment.FragmentStateManager;
import yslelf.cloudpick.graphics.fragment.FragmentStore;
import yslelf.cloudpick.graphics.fragment.FragmentTransaction;
import yslelf.cloudpick.graphics.fragment.OnBackPressedCallback;
import yslelf.cloudpick.graphics.fragment.OnBackPressedDispatcher;
import yslelf.cloudpick.graphics.fragment.OnBackPressedDispatcherOwner;
import yslelf.cloudpick.graphics.fragment.SpecialEffectsController;
import yslelf.cloudpick.graphics.fragment.SpecialEffectsControllerFactory;
import yslelf.cloudpick.graphics.lifecycle.Lifecycle;
import yslelf.cloudpick.graphics.lifecycle.LifecycleObserver;
import yslelf.cloudpick.graphics.lifecycle.LifecycleOwner;
import yslelf.cloudpick.graphics.lifecycle.ViewModelStore;
import yslelf.cloudpick.graphics.lifecycle.ViewModelStoreOwner;
import yslelf.cloudpick.graphics.util.DataSet;
import yslelf.cloudpick.graphics.view.View;
import yslelf.cloudpick.graphics.view.ViewGroup;
import yslelf.cloudpick.graphics.view.ViewParent;

public final class FragmentManager
implements FragmentResultOwner {
    static final boolean DEBUG = false;
    static final boolean TRACE = false;
    static final Marker MARKER = MarkerManager.getMarker((String)"FragmentManager");
    public static final int POP_BACK_STACK_INCLUSIVE = 1;
    private final ArrayList<OpGenerator> mPendingActions = new ArrayList();
    private boolean mExecutingActions;
    private final FragmentStore mFragmentStore = new FragmentStore();
    ArrayList<BackStackRecord> mBackStack;
    private ArrayList<Fragment> mCreatedMenus;
    private OnBackPressedDispatcher mOnBackPressedDispatcher;
    private final OnBackPressedCallback mOnBackPressedCallback = new OnBackPressedCallback(false){

        @Override
        public void handleOnBackPressed() {
            FragmentManager.this.handleOnBackPressed();
        }
    };
    private final AtomicInteger mBackStackIndex = new AtomicInteger();
    private final Map<String, DataSet> mResults = Collections.synchronizedMap(new HashMap());
    private final Map<String, LifecycleAwareResultListener> mResultListeners = Collections.synchronizedMap(new HashMap());
    private ArrayList<OnBackStackChangedListener> mBackStackChangeListeners;
    private final FragmentLifecycleCallbacksDispatcher mLifecycleCallbacksDispatcher = new FragmentLifecycleCallbacksDispatcher(this);
    private final CopyOnWriteArrayList<FragmentOnAttachListener> mOnAttachListeners = new CopyOnWriteArrayList();
    int mCurState = -1;
    private FragmentHostCallback<?> mHost;
    private FragmentContainer mContainer;
    private Fragment mParent;
    @Nullable
    Fragment mPrimaryNav;
    private FragmentFactory mFragmentFactory = null;
    private static final FragmentFactory sHostFragmentFactory = new FragmentFactory();
    private SpecialEffectsControllerFactory mSpecialEffectsControllerFactory = null;
    private static final SpecialEffectsControllerFactory sDefaultSpecialEffectsControllerFactory = DefaultSpecialEffectsController::new;
    private boolean mNeedMenuInvalidate;
    private boolean mStateSaved;
    private boolean mStopped;
    private boolean mDestroyed;
    private boolean mHavePendingDeferredStart;
    private ArrayList<BackStackRecord> mTmpRecords;
    private BooleanArrayList mTmpIsPop;
    private ArrayList<Fragment> mTmpAddedFragments;
    private FragmentManagerViewModel mViewModel;
    private final Runnable mExecCommit = () -> this.execPendingActions(true);

    FragmentManager() {
    }

    private void throwException(@Nonnull RuntimeException ex) {
        PrintWriter w;
        CloudPick.LOGGER.error(MARKER, "FragmentManager throws an exception", (Throwable)ex);
        try (PrintWriter printWriter = w = new PrintWriter((Writer)new LogWriter(CloudPick.LOGGER, Level.DEBUG, MARKER), true);){
            if (this.mHost != null) {
                try {
                    this.mHost.onDump("  ", null, w, new String[0]);
                }
                catch (Exception e) {
                    CloudPick.LOGGER.error(MARKER, "Failed dumping state", (Throwable)e);
                }
            } else {
                try {
                    this.dump("  ", null, w, new String[0]);
                }
                catch (Exception e) {
                    CloudPick.LOGGER.error(MARKER, "Failed dumping state", (Throwable)e);
                }
            }
        }
        throw ex;
    }

    @Nonnull
    public FragmentTransaction beginTransaction() {
        return new BackStackRecord(this);
    }

    public boolean executePendingTransactions() {
        boolean updates = this.execPendingActions(true);
        this.forcePostponedTransactions();
        return updates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOnBackPressedCallbackEnabled() {
        ArrayList<OpGenerator> arrayList = this.mPendingActions;
        synchronized (arrayList) {
            if (!this.mPendingActions.isEmpty()) {
                this.mOnBackPressedCallback.setEnabled(true);
                return;
            }
        }
        this.mOnBackPressedCallback.setEnabled(this.getBackStackEntryCount() > 0 && this.isPrimaryNavigation(this.mParent));
    }

    boolean isPrimaryNavigation(@Nullable Fragment parent) {
        if (parent == null) {
            return true;
        }
        FragmentManager parentFragmentManager = parent.mFragmentManager;
        Fragment primaryNavigationFragment = parentFragmentManager.getPrimaryNavigationFragment();
        return parent.equals(primaryNavigationFragment) && this.isPrimaryNavigation(parentFragmentManager.mParent);
    }

    boolean isParentMenuVisible(@Nullable Fragment parent) {
        if (parent == null) {
            return true;
        }
        return parent.isMenuVisible();
    }

    boolean isParentHidden(@Nullable Fragment parent) {
        if (parent == null) {
            return false;
        }
        return parent.isHidden();
    }

    void handleOnBackPressed() {
        this.execPendingActions(true);
        if (this.mOnBackPressedCallback.isEnabled()) {
            this.popBackStackImmediate();
        } else {
            this.mOnBackPressedDispatcher.onBackPressed();
        }
    }

    public void popBackStack() {
        this.enqueueAction(new PopBackStackState(null, -1, 0), false);
    }

    public boolean popBackStackImmediate() {
        return this.popBackStackImmediate(null, -1, 0);
    }

    public void popBackStack(@Nullable String name, int flags) {
        this.enqueueAction(new PopBackStackState(name, -1, flags), false);
    }

    public boolean popBackStackImmediate(@Nullable String name, int flags) {
        return this.popBackStackImmediate(name, -1, flags);
    }

    public void popBackStack(int id2, int flags) {
        if (id2 < 0) {
            throw new IllegalArgumentException("Bad id: " + id2);
        }
        this.enqueueAction(new PopBackStackState(null, id2, flags), false);
    }

    public boolean popBackStackImmediate(int id2, int flags) {
        if (id2 < 0) {
            throw new IllegalArgumentException("Bad id: " + id2);
        }
        return this.popBackStackImmediate(null, id2, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean popBackStackImmediate(@Nullable String name, int id2, int flags) {
        FragmentManager childManager;
        this.execPendingActions(false);
        this.ensureExecReady(true);
        if (this.mPrimaryNav != null && id2 < 0 && name == null && (childManager = this.mPrimaryNav.getChildFragmentManager()).popBackStackImmediate()) {
            return true;
        }
        boolean executePop = this.popBackStackState(this.mTmpRecords, this.mTmpIsPop, name, id2, flags);
        if (executePop) {
            this.mExecutingActions = true;
            try {
                this.removeRedundantOperationsAndExecute(this.mTmpRecords, this.mTmpIsPop);
            }
            finally {
                this.cleanupExec();
            }
        }
        this.updateOnBackPressedCallbackEnabled();
        this.doPendingDeferredStart();
        this.mFragmentStore.burpActive();
        return executePop;
    }

    public int getBackStackEntryCount() {
        return this.mBackStack != null ? this.mBackStack.size() : 0;
    }

    @Nonnull
    public BackStackEntry getBackStackEntryAt(int index) {
        return this.mBackStack.get(index);
    }

    public void addOnBackStackChangedListener(@Nonnull OnBackStackChangedListener listener) {
        if (this.mBackStackChangeListeners == null) {
            this.mBackStackChangeListeners = new ArrayList();
        }
        this.mBackStackChangeListeners.add(listener);
    }

    public void removeOnBackStackChangedListener(@Nonnull OnBackStackChangedListener listener) {
        if (this.mBackStackChangeListeners != null) {
            this.mBackStackChangeListeners.remove(listener);
        }
    }

    @Override
    public void setFragmentResult(@Nonnull String requestKey, @Nonnull DataSet result) {
        LifecycleAwareResultListener resultListener = this.mResultListeners.get(requestKey);
        if (resultListener != null && resultListener.isAtLeast(Lifecycle.State.STARTED)) {
            resultListener.onFragmentResult(requestKey, result);
        } else {
            this.mResults.put(requestKey, result);
        }
    }

    @Override
    public void clearFragmentResult(@Nonnull String requestKey) {
        this.mResults.remove(requestKey);
    }

    @Override
    public void setFragmentResultListener(final @Nonnull String requestKey, @Nonnull LifecycleOwner lifecycleOwner, final @Nonnull FragmentResultListener listener) {
        final Lifecycle lifecycle = lifecycleOwner.getLifecycle();
        if (lifecycle.getCurrentState() == Lifecycle.State.DESTROYED) {
            return;
        }
        LifecycleObserver observer = new LifecycleObserver(){

            @Override
            public void onStateChanged(@Nonnull LifecycleOwner source, @Nonnull Lifecycle.Event event) {
                DataSet storedResult;
                if (event == Lifecycle.Event.ON_START && (storedResult = FragmentManager.this.mResults.get(requestKey)) != null) {
                    listener.onFragmentResult(requestKey, storedResult);
                    FragmentManager.this.clearFragmentResult(requestKey);
                }
                if (event == Lifecycle.Event.ON_DESTROY) {
                    lifecycle.removeObserver(this);
                    FragmentManager.this.mResultListeners.remove(requestKey);
                }
            }
        };
        lifecycle.addObserver(observer);
        LifecycleAwareResultListener storedListener = this.mResultListeners.put(requestKey, new LifecycleAwareResultListener(lifecycle, listener, observer));
        if (storedListener != null) {
            storedListener.removeObserver();
        }
    }

    @Override
    public void clearFragmentResultListener(@Nonnull String requestKey) {
        LifecycleAwareResultListener listener = this.mResultListeners.remove(requestKey);
        if (listener != null) {
            listener.removeObserver();
        }
    }

    public void putFragment(@Nonnull DataSet bundle, @Nonnull String key, @Nonnull Fragment fragment) {
        if (fragment.mFragmentManager != this) {
            this.throwException(new IllegalStateException("Fragment " + fragment + " is not currently in the FragmentManager"));
        }
        bundle.putString(key, fragment.mWho);
    }

    @Nullable
    public Fragment getFragment(@Nonnull DataSet bundle, @Nonnull String key) {
        String who = bundle.getString(key);
        if (who == null) {
            return null;
        }
        Fragment f2 = this.findActiveFragment(who);
        if (f2 == null) {
            this.throwException(new IllegalStateException("Fragment no longer exists for key " + key + ": unique id " + who));
        }
        return f2;
    }

    @Nonnull
    public static <F extends Fragment> F findFragment(@Nonnull View view) {
        Fragment fragment = FragmentManager.findViewFragment(view);
        if (fragment == null) {
            throw new IllegalStateException("View " + view + " does not have a Fragment set");
        }
        return (F)fragment;
    }

    @Nullable
    private static Fragment findViewFragment(@Nonnull View view) {
        while (true) {
            Fragment fragment;
            if ((fragment = FragmentManager.getViewFragment(view)) != null) {
                return fragment;
            }
            ViewParent parent = view.getParent();
            if (!(parent instanceof View)) break;
            view = (View)((Object)parent);
        }
        return null;
    }

    @Nullable
    static Fragment getViewFragment(@Nonnull View view) {
        Object tag = view.getTag(0x2020001);
        if (tag instanceof Fragment) {
            return (Fragment)tag;
        }
        return null;
    }

    void onContainerAvailable(@Nonnull FragmentContainerView container) {
        for (FragmentStateManager fragmentStateManager : this.mFragmentStore.getActiveFragmentStateManagers()) {
            Fragment fragment = fragmentStateManager.getFragment();
            if (fragment.mContainerId != container.getId() || fragment.mView == null || fragment.mView.getParent() != null) continue;
            fragment.mContainer = container;
            fragmentStateManager.addViewToContainer();
        }
    }

    @Nonnull
    static FragmentManager findFragmentManager(@Nonnull View view) {
        Fragment fragment = FragmentManager.findViewFragment(view);
        if (fragment != null) {
            if (!fragment.isAdded()) {
                throw new IllegalStateException("The Fragment " + fragment + " that owns View " + view + " has already been destroyed. Nested fragments should always use the child FragmentManager.");
            }
            return fragment.getChildFragmentManager();
        }
        throw new IllegalStateException("View " + view + " is not associated with a Fragment");
    }

    @Nonnull
    public List<Fragment> getFragments() {
        return this.mFragmentStore.getFragments();
    }

    @Nonnull
    ViewModelStore getViewModelStore(@Nonnull Fragment f2) {
        return this.mViewModel.getViewModelStore(f2);
    }

    @Nonnull
    private FragmentManagerViewModel getChildViewModel(@Nonnull Fragment f2) {
        return this.mViewModel.getChildViewModel(f2);
    }

    void addRetainedFragment(@Nonnull Fragment f2) {
        this.mViewModel.addRetainedFragment(f2);
    }

    void removeRetainedFragment(@Nonnull Fragment f2) {
        this.mViewModel.removeRetainedFragment(f2);
    }

    @Nonnull
    List<Fragment> getActiveFragments() {
        return this.mFragmentStore.getActiveFragments();
    }

    int getActiveFragmentCount() {
        return this.mFragmentStore.getActiveFragmentCount();
    }

    public boolean isDestroyed() {
        return this.mDestroyed;
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("FragmentManager{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(" in ");
        if (this.mParent != null) {
            Class<?> cls = this.mParent.getClass();
            sb.append(cls.getSimpleName());
            sb.append("{");
            sb.append(Integer.toHexString(System.identityHashCode(this.mParent)));
            sb.append("}");
        } else if (this.mHost != null) {
            Class<?> cls = this.mHost.getClass();
            sb.append(cls.getSimpleName());
            sb.append("{");
            sb.append(Integer.toHexString(System.identityHashCode(this.mHost)));
            sb.append("}");
        } else {
            sb.append("null");
        }
        sb.append("}}");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(@Nonnull String prefix, @Nullable FileDescriptor fd, @Nonnull PrintWriter writer, String ... args) {
        int i;
        int count;
        String innerPrefix = prefix + "    ";
        this.mFragmentStore.dump(prefix, fd, writer, args);
        if (this.mCreatedMenus != null && (count = this.mCreatedMenus.size()) > 0) {
            writer.print(prefix);
            writer.println("Fragments Created Menus:");
            for (i = 0; i < count; ++i) {
                Fragment f2 = this.mCreatedMenus.get(i);
                writer.print(prefix);
                writer.print("  #");
                writer.print(i);
                writer.print(": ");
                writer.println(f2.toString());
            }
        }
        if (this.mBackStack != null && (count = this.mBackStack.size()) > 0) {
            writer.print(prefix);
            writer.println("Back Stack:");
            for (i = 0; i < count; ++i) {
                BackStackRecord bs = this.mBackStack.get(i);
                writer.print(prefix);
                writer.print("  #");
                writer.print(i);
                writer.print(": ");
                writer.println(bs.toString());
                bs.dump(innerPrefix, writer);
            }
        }
        writer.print(prefix);
        writer.println("Back Stack Index: " + this.mBackStackIndex.get());
        ArrayList<OpGenerator> arrayList = this.mPendingActions;
        synchronized (arrayList) {
            count = this.mPendingActions.size();
            if (count > 0) {
                writer.print(prefix);
                writer.println("Pending Actions:");
                for (int i2 = 0; i2 < count; ++i2) {
                    OpGenerator r = this.mPendingActions.get(i2);
                    writer.print(prefix);
                    writer.print("  #");
                    writer.print(i2);
                    writer.print(": ");
                    writer.println(r);
                }
            }
        }
        writer.print(prefix);
        writer.println("FragmentManager misc state:");
        writer.print(prefix);
        writer.print("  mHost=");
        writer.println(this.mHost);
        writer.print(prefix);
        writer.print("  mContainer=");
        writer.println(this.mContainer);
        if (this.mParent != null) {
            writer.print(prefix);
            writer.print("  mParent=");
            writer.println(this.mParent);
        }
        writer.print(prefix);
        writer.print("  mCurState=");
        writer.print(this.mCurState);
        writer.print(" mStateSaved=");
        writer.print(this.mStateSaved);
        writer.print(" mStopped=");
        writer.print(this.mStopped);
        writer.print(" mDestroyed=");
        writer.println(this.mDestroyed);
        if (this.mNeedMenuInvalidate) {
            writer.print(prefix);
            writer.print("  mNeedMenuInvalidate=");
            writer.println(this.mNeedMenuInvalidate);
        }
    }

    void performPendingDeferredStart(@Nonnull FragmentStateManager fragmentStateManager) {
        Fragment f2 = fragmentStateManager.getFragment();
        if (f2.mDeferStart) {
            if (this.mExecutingActions) {
                this.mHavePendingDeferredStart = true;
                return;
            }
            f2.mDeferStart = false;
            fragmentStateManager.moveToExpectedState();
        }
    }

    boolean isStateAtLeast(int state) {
        return this.mCurState >= state;
    }

    void setExitAnimationOrder(@Nonnull Fragment f2, boolean isPop) {
        ViewGroup container = this.getFragmentContainer(f2);
        if (container != null && container instanceof FragmentContainerView) {
            ((FragmentContainerView)container).setDrawDisappearingViewsLast(!isPop);
        }
    }

    void moveToState(int newState, boolean always) {
        if (this.mHost == null && newState != -1) {
            throw new IllegalStateException("No activity");
        }
        if (!always && newState == this.mCurState) {
            return;
        }
        this.mCurState = newState;
        this.mFragmentStore.moveToExpectedState();
        this.startPendingDeferredFragments();
        if (this.mNeedMenuInvalidate && this.mHost != null && this.mCurState == 7) {
            this.mNeedMenuInvalidate = false;
        }
    }

    private void startPendingDeferredFragments() {
        for (FragmentStateManager fragmentStateManager : this.mFragmentStore.getActiveFragmentStateManagers()) {
            this.performPendingDeferredStart(fragmentStateManager);
        }
    }

    @Nonnull
    FragmentStateManager createOrGetFragmentStateManager(@Nonnull Fragment f2) {
        FragmentStateManager existing = this.mFragmentStore.getFragmentStateManager(f2.mWho);
        if (existing != null) {
            return existing;
        }
        FragmentStateManager fragmentStateManager = new FragmentStateManager(this.mLifecycleCallbacksDispatcher, this.mFragmentStore, f2);
        fragmentStateManager.setFragmentManagerState(this.mCurState);
        return fragmentStateManager;
    }

    @Nonnull
    FragmentStateManager addFragment(@Nonnull Fragment fragment) {
        FragmentStateManager fragmentStateManager = this.createOrGetFragmentStateManager(fragment);
        fragment.mFragmentManager = this;
        this.mFragmentStore.makeActive(fragmentStateManager);
        if (!fragment.mDetached) {
            this.mFragmentStore.addFragment(fragment);
            fragment.mRemoving = false;
            if (fragment.mView == null) {
                fragment.mHiddenChanged = false;
            }
            if (this.isMenuAvailable(fragment)) {
                this.mNeedMenuInvalidate = true;
            }
        }
        return fragmentStateManager;
    }

    void removeFragment(@Nonnull Fragment fragment) {
        boolean inactive;
        boolean bl = inactive = !fragment.isInBackStack();
        if (!fragment.mDetached || inactive) {
            this.mFragmentStore.removeFragment(fragment);
            if (this.isMenuAvailable(fragment)) {
                this.mNeedMenuInvalidate = true;
            }
            fragment.mRemoving = true;
            this.setVisibleRemovingFragment(fragment);
        }
    }

    void hideFragment(@Nonnull Fragment fragment) {
        if (!fragment.mHidden) {
            fragment.mHidden = true;
            fragment.mHiddenChanged = !fragment.mHiddenChanged;
            this.setVisibleRemovingFragment(fragment);
        }
    }

    void showFragment(@Nonnull Fragment fragment) {
        if (fragment.mHidden) {
            fragment.mHidden = false;
            fragment.mHiddenChanged = !fragment.mHiddenChanged;
        }
    }

    void detachFragment(@Nonnull Fragment fragment) {
        if (!fragment.mDetached) {
            fragment.mDetached = true;
            if (fragment.mAdded) {
                this.mFragmentStore.removeFragment(fragment);
                if (this.isMenuAvailable(fragment)) {
                    this.mNeedMenuInvalidate = true;
                }
                this.setVisibleRemovingFragment(fragment);
            }
        }
    }

    void attachFragment(@Nonnull Fragment fragment) {
        if (fragment.mDetached) {
            fragment.mDetached = false;
            if (!fragment.mAdded) {
                this.mFragmentStore.addFragment(fragment);
                if (this.isMenuAvailable(fragment)) {
                    this.mNeedMenuInvalidate = true;
                }
            }
        }
    }

    @Nullable
    public Fragment findFragmentById(int id2) {
        return this.mFragmentStore.findFragmentById(id2);
    }

    @Nullable
    public Fragment findFragmentByTag(@Nullable String tag) {
        return this.mFragmentStore.findFragmentByTag(tag);
    }

    @Nullable
    Fragment findFragmentByWho(@Nonnull String who) {
        return this.mFragmentStore.findFragmentByWho(who);
    }

    @Nullable
    Fragment findActiveFragment(@Nonnull String who) {
        return this.mFragmentStore.findActiveFragment(who);
    }

    private void checkStateLoss() {
        if (this.isStateSaved()) {
            throw new IllegalStateException("Can not perform this action after onSaveInstanceState");
        }
    }

    public boolean isStateSaved() {
        return this.mStateSaved || this.mStopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueueAction(@Nonnull OpGenerator action, boolean allowStateLoss) {
        if (!allowStateLoss) {
            if (this.mHost == null) {
                if (this.mDestroyed) {
                    throw new IllegalStateException("FragmentManager has been destroyed");
                }
                throw new IllegalStateException("FragmentManager has not been attached to a host.");
            }
            this.checkStateLoss();
        }
        ArrayList<OpGenerator> arrayList = this.mPendingActions;
        synchronized (arrayList) {
            if (this.mHost == null) {
                if (allowStateLoss) {
                    return;
                }
                throw new IllegalStateException("Activity has been destroyed");
            }
            this.mPendingActions.add(action);
            this.scheduleCommit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleCommit() {
        ArrayList<OpGenerator> arrayList = this.mPendingActions;
        synchronized (arrayList) {
            boolean pendingReady;
            boolean bl = pendingReady = this.mPendingActions.size() == 1;
            if (pendingReady) {
                this.mHost.mHandler.removeCallbacks(this.mExecCommit);
                this.mHost.mHandler.post(this.mExecCommit);
                this.updateOnBackPressedCallbackEnabled();
            }
        }
    }

    int allocBackStackIndex() {
        return this.mBackStackIndex.getAndIncrement();
    }

    private void ensureExecReady(boolean allowStateLoss) {
        if (this.mExecutingActions) {
            throw new IllegalStateException("FragmentManager is already executing transactions");
        }
        if (this.mHost == null) {
            if (this.mDestroyed) {
                throw new IllegalStateException("FragmentManager has been destroyed");
            }
            throw new IllegalStateException("FragmentManager has not been attached to a host.");
        }
        if (!this.mHost.mHandler.isCurrentThread()) {
            throw new IllegalStateException("Must be called from main thread of fragment host");
        }
        if (!allowStateLoss) {
            this.checkStateLoss();
        }
        if (this.mTmpRecords == null) {
            this.mTmpRecords = new ArrayList();
            this.mTmpIsPop = new BooleanArrayList();
        }
    }

    void execSingleAction(@Nonnull OpGenerator action, boolean allowStateLoss) {
        if (allowStateLoss && (this.mHost == null || this.mDestroyed)) {
            return;
        }
        this.ensureExecReady(allowStateLoss);
        if (action.generateOps(this.mTmpRecords, this.mTmpIsPop)) {
            this.mExecutingActions = true;
            try {
                this.removeRedundantOperationsAndExecute(this.mTmpRecords, this.mTmpIsPop);
            }
            finally {
                this.cleanupExec();
            }
        }
        this.updateOnBackPressedCallbackEnabled();
        this.doPendingDeferredStart();
        this.mFragmentStore.burpActive();
    }

    private void cleanupExec() {
        this.mExecutingActions = false;
        this.mTmpIsPop.clear();
        this.mTmpRecords.clear();
    }

    boolean execPendingActions(boolean allowStateLoss) {
        this.ensureExecReady(allowStateLoss);
        boolean didSomething = false;
        while (this.generateOpsForPendingActions(this.mTmpRecords, this.mTmpIsPop)) {
            this.mExecutingActions = true;
            try {
                this.removeRedundantOperationsAndExecute(this.mTmpRecords, this.mTmpIsPop);
            }
            finally {
                this.cleanupExec();
            }
            didSomething = true;
        }
        this.updateOnBackPressedCallbackEnabled();
        this.doPendingDeferredStart();
        this.mFragmentStore.burpActive();
        return didSomething;
    }

    private void removeRedundantOperationsAndExecute(@Nonnull ArrayList<BackStackRecord> records, @Nonnull BooleanArrayList isRecordPop) {
        if (records.isEmpty()) {
            return;
        }
        if (records.size() != isRecordPop.size()) {
            throw new IllegalStateException("Internal error with the back stack records");
        }
        int numRecords = records.size();
        int startIndex = 0;
        for (int recordNum = 0; recordNum < numRecords; ++recordNum) {
            int reorderingEnd;
            boolean canReorder = records.get((int)recordNum).mReorderingAllowed;
            if (canReorder) continue;
            if (startIndex != recordNum) {
                this.executeOpsTogether(records, isRecordPop, startIndex, recordNum);
            }
            if (isRecordPop.getBoolean(recordNum)) {
                for (reorderingEnd = recordNum + 1; reorderingEnd < numRecords && isRecordPop.getBoolean(reorderingEnd) && !records.get((int)reorderingEnd).mReorderingAllowed; ++reorderingEnd) {
                }
            }
            this.executeOpsTogether(records, isRecordPop, recordNum, reorderingEnd);
            startIndex = reorderingEnd;
            recordNum = reorderingEnd - 1;
        }
        if (startIndex != numRecords) {
            this.executeOpsTogether(records, isRecordPop, startIndex, numRecords);
        }
    }

    private void executeOpsTogether(@Nonnull ArrayList<BackStackRecord> records, @Nonnull BooleanArrayList isRecordPop, int startIndex, int endIndex) {
        BackStackRecord record;
        boolean allowReordering = records.get((int)startIndex).mReorderingAllowed;
        boolean addToBackStack = false;
        if (this.mTmpAddedFragments == null) {
            this.mTmpAddedFragments = new ArrayList();
        } else {
            this.mTmpAddedFragments.clear();
        }
        this.mTmpAddedFragments.addAll(this.mFragmentStore.getFragments());
        Fragment oldPrimaryNav = this.getPrimaryNavigationFragment();
        for (int recordNum = startIndex; recordNum < endIndex; ++recordNum) {
            record = records.get(recordNum);
            boolean isPop = isRecordPop.getBoolean(recordNum);
            oldPrimaryNav = !isPop ? record.expandOps(this.mTmpAddedFragments, oldPrimaryNav) : record.trackAddedFragmentsInPop(this.mTmpAddedFragments, oldPrimaryNav);
            addToBackStack = addToBackStack || record.mAddToBackStack;
        }
        this.mTmpAddedFragments.clear();
        if (!allowReordering && this.mCurState >= 1) {
            for (int index = startIndex; index < endIndex; ++index) {
                record = records.get(index);
                for (FragmentTransaction.Op op : record.mOps) {
                    Fragment fragment = op.mFragment;
                    if (fragment == null || fragment.mFragmentManager == null) continue;
                    FragmentStateManager fragmentStateManager = this.createOrGetFragmentStateManager(fragment);
                    this.mFragmentStore.makeActive(fragmentStateManager);
                }
            }
        }
        FragmentManager.executeOps(records, isRecordPop, startIndex, endIndex);
        boolean isPop = isRecordPop.getBoolean(endIndex - 1);
        for (int index = startIndex; index < endIndex; ++index) {
            FragmentStateManager fragmentStateManager;
            Fragment fragment;
            BackStackRecord record2 = records.get(index);
            if (isPop) {
                for (int opIndex = record2.mOps.size() - 1; opIndex >= 0; --opIndex) {
                    FragmentTransaction.Op op = (FragmentTransaction.Op)record2.mOps.get(opIndex);
                    fragment = op.mFragment;
                    if (fragment == null) continue;
                    fragmentStateManager = this.createOrGetFragmentStateManager(fragment);
                    fragmentStateManager.moveToExpectedState();
                }
                continue;
            }
            for (FragmentTransaction.Op op : record2.mOps) {
                fragment = op.mFragment;
                if (fragment == null) continue;
                fragmentStateManager = this.createOrGetFragmentStateManager(fragment);
                fragmentStateManager.moveToExpectedState();
            }
        }
        this.moveToState(this.mCurState, true);
        Set<SpecialEffectsController> changedControllers = this.collectChangedControllers(records, startIndex, endIndex);
        for (SpecialEffectsController controller : changedControllers) {
            controller.updateOperationDirection(isPop);
            controller.markPostponedState();
            controller.executePendingOperations();
        }
        for (int recordNum = startIndex; recordNum < endIndex; ++recordNum) {
            BackStackRecord record3 = records.get(recordNum);
            isPop = isRecordPop.getBoolean(recordNum);
            if (isPop && record3.mIndex >= 0) {
                record3.mIndex = -1;
            }
            record3.runOnCommitRunnables();
        }
        if (addToBackStack) {
            this.reportBackStackChanged();
        }
    }

    @Nonnull
    private Set<SpecialEffectsController> collectChangedControllers(@Nonnull ArrayList<BackStackRecord> records, int startIndex, int endIndex) {
        HashSet<SpecialEffectsController> controllers = new HashSet<SpecialEffectsController>();
        for (int index = startIndex; index < endIndex; ++index) {
            BackStackRecord record = records.get(index);
            for (FragmentTransaction.Op op : record.mOps) {
                ViewGroup container;
                Fragment fragment = op.mFragment;
                if (fragment == null || (container = fragment.mContainer) == null) continue;
                controllers.add(SpecialEffectsController.getOrCreateController(container, this));
            }
        }
        return controllers;
    }

    private static void executeOps(@Nonnull ArrayList<BackStackRecord> records, @Nonnull BooleanArrayList isRecordPop, int startIndex, int endIndex) {
        for (int i = startIndex; i < endIndex; ++i) {
            BackStackRecord record = records.get(i);
            boolean isPop = isRecordPop.getBoolean(i);
            if (isPop) {
                record.bumpBackStackNesting(-1);
                record.executePopOps();
                continue;
            }
            record.bumpBackStackNesting(1);
            record.executeOps();
        }
    }

    private void setVisibleRemovingFragment(@Nonnull Fragment f2) {
        ViewGroup container = this.getFragmentContainer(f2);
        if (container != null && f2.getEnterAnim() + f2.getExitAnim() + f2.getPopEnterAnim() + f2.getPopExitAnim() > 0) {
            if (container.getTag(0x2020002) == null) {
                container.setTag(0x2020002, f2);
            }
            f2.setPopDirection(f2.getPopDirection());
        }
    }

    @Nullable
    private ViewGroup getFragmentContainer(@Nonnull Fragment f2) {
        View view;
        if (f2.mContainer != null) {
            return f2.mContainer;
        }
        if (f2.mContainerId <= 0) {
            return null;
        }
        if (this.mContainer.onHasView() && (view = this.mContainer.onFindViewById(f2.mContainerId)) instanceof ViewGroup) {
            return (ViewGroup)view;
        }
        return null;
    }

    private void forcePostponedTransactions() {
        Set<SpecialEffectsController> controllers = this.collectAllSpecialEffectsController();
        for (SpecialEffectsController controller : controllers) {
            controller.forcePostponedExecutePendingOperations();
        }
    }

    private void endAnimatingAwayFragments() {
        Set<SpecialEffectsController> controllers = this.collectAllSpecialEffectsController();
        for (SpecialEffectsController controller : controllers) {
            controller.forceCompleteAllOperations();
        }
    }

    @Nonnull
    private Set<SpecialEffectsController> collectAllSpecialEffectsController() {
        HashSet<SpecialEffectsController> controllers = new HashSet<SpecialEffectsController>();
        for (FragmentStateManager fragmentStateManager : this.mFragmentStore.getActiveFragmentStateManagers()) {
            ViewGroup container = fragmentStateManager.getFragment().mContainer;
            if (container == null) continue;
            controllers.add(SpecialEffectsController.getOrCreateController(container, this.getSpecialEffectsControllerFactory()));
        }
        return controllers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean generateOpsForPendingActions(@Nonnull ArrayList<BackStackRecord> records, @Nonnull BooleanArrayList isPop) {
        boolean didSomething = false;
        ArrayList<OpGenerator> arrayList = this.mPendingActions;
        synchronized (arrayList) {
            if (this.mPendingActions.isEmpty()) {
                return false;
            }
            try {
                for (OpGenerator generator : this.mPendingActions) {
                    didSomething |= generator.generateOps(records, isPop);
                }
            }
            finally {
                this.mPendingActions.clear();
                this.mHost.mHandler.removeCallbacks(this.mExecCommit);
            }
        }
        return didSomething;
    }

    private void doPendingDeferredStart() {
        if (this.mHavePendingDeferredStart) {
            this.mHavePendingDeferredStart = false;
            this.startPendingDeferredFragments();
        }
    }

    private void reportBackStackChanged() {
        if (this.mBackStackChangeListeners != null) {
            for (int i = 0; i < this.mBackStackChangeListeners.size(); ++i) {
                this.mBackStackChangeListeners.get(i).onBackStackChanged();
            }
        }
    }

    void addBackStackState(@Nonnull BackStackRecord state) {
        if (this.mBackStack == null) {
            this.mBackStack = new ArrayList();
        }
        this.mBackStack.add(state);
    }

    boolean popBackStackState(@Nonnull ArrayList<BackStackRecord> records, @Nonnull BooleanArrayList isRecordPop, @Nullable String name, int id2, int flags) {
        int index = this.findBackStackIndex(name, id2, (flags & 1) != 0);
        if (index < 0) {
            return false;
        }
        for (int i = this.mBackStack.size() - 1; i >= index; --i) {
            records.add(this.mBackStack.remove(i));
            isRecordPop.add(true);
        }
        return true;
    }

    private int findBackStackIndex(@Nullable String name, int id2, boolean inclusive) {
        BackStackRecord bss;
        int index;
        if (this.mBackStack == null || this.mBackStack.isEmpty()) {
            return -1;
        }
        if (name == null && id2 < 0) {
            if (inclusive) {
                return 0;
            }
            return this.mBackStack.size() - 1;
        }
        for (index = this.mBackStack.size() - 1; index >= 0; --index) {
            bss = this.mBackStack.get(index);
            if (name != null && name.equals(bss.getName()) || id2 >= 0 && id2 == bss.mIndex) break;
        }
        if (index < 0) {
            return index;
        }
        if (inclusive) {
            while (index > 0) {
                bss = this.mBackStack.get(index - 1);
                if (name != null && name.equals(bss.getName()) || id2 >= 0 && id2 == bss.mIndex) {
                    --index;
                    continue;
                }
                break;
            }
        } else {
            if (index == this.mBackStack.size() - 1) {
                return -1;
            }
            ++index;
        }
        return index;
    }

    @Nonnull
    FragmentHostCallback<?> getHost() {
        return this.mHost;
    }

    @Nullable
    Fragment getParent() {
        return this.mParent;
    }

    @Nonnull
    FragmentContainer getContainer() {
        return this.mContainer;
    }

    @Nonnull
    FragmentStore getFragmentStore() {
        return this.mFragmentStore;
    }

    void attachController(@Nonnull FragmentHostCallback<?> host, @Nonnull FragmentContainer container, @Nullable Fragment parent) {
        if (this.mHost != null) {
            throw new IllegalStateException("Already attached");
        }
        this.mHost = host;
        this.mContainer = container;
        this.mParent = parent;
        if (host instanceof FragmentOnAttachListener) {
            this.addFragmentOnAttachListener((FragmentOnAttachListener)((Object)host));
        }
        if (this.mParent != null) {
            this.updateOnBackPressedCallbackEnabled();
        }
        if (host instanceof OnBackPressedDispatcherOwner) {
            OnBackPressedDispatcherOwner dispatcherOwner = (OnBackPressedDispatcherOwner)((Object)host);
            this.mOnBackPressedDispatcher = dispatcherOwner.getOnBackPressedDispatcher();
            LifecycleOwner owner = parent != null ? parent : dispatcherOwner;
            this.mOnBackPressedDispatcher.addCallback(owner, this.mOnBackPressedCallback);
        }
        if (parent != null) {
            this.mViewModel = parent.mFragmentManager.getChildViewModel(parent);
        } else if (host instanceof ViewModelStoreOwner) {
            ViewModelStore viewModelStore = ((ViewModelStoreOwner)((Object)host)).getViewModelStore();
            this.mViewModel = FragmentManagerViewModel.getInstance(viewModelStore);
        } else {
            throw new IllegalStateException();
        }
        this.mViewModel.setIsStateSaved(this.isStateSaved());
        this.mFragmentStore.setViewModel(this.mViewModel);
    }

    void noteStateNotSaved() {
        if (this.mHost == null) {
            return;
        }
        this.mStateSaved = false;
        this.mStopped = false;
        this.mViewModel.setIsStateSaved(false);
        for (Fragment fragment : this.mFragmentStore.getFragments()) {
            if (fragment == null) continue;
            fragment.noteStateNotSaved();
        }
    }

    void dispatchAttach() {
        this.mStateSaved = false;
        this.mStopped = false;
        this.mViewModel.setIsStateSaved(false);
        this.dispatchStateChange(0);
    }

    void dispatchCreate() {
        this.mStateSaved = false;
        this.mStopped = false;
        this.mViewModel.setIsStateSaved(false);
        this.dispatchStateChange(1);
    }

    void dispatchViewCreated() {
        this.dispatchStateChange(2);
    }

    void dispatchActivityCreated() {
        this.mStateSaved = false;
        this.mStopped = false;
        this.mViewModel.setIsStateSaved(false);
        this.dispatchStateChange(4);
    }

    void dispatchStart() {
        this.mStateSaved = false;
        this.mStopped = false;
        this.mViewModel.setIsStateSaved(false);
        this.dispatchStateChange(5);
    }

    void dispatchResume() {
        this.mStateSaved = false;
        this.mStopped = false;
        this.mViewModel.setIsStateSaved(false);
        this.dispatchStateChange(7);
    }

    void dispatchPause() {
        this.dispatchStateChange(5);
    }

    void dispatchStop() {
        this.mStopped = true;
        this.mViewModel.setIsStateSaved(true);
        this.dispatchStateChange(4);
    }

    void dispatchDestroyView() {
        this.dispatchStateChange(1);
    }

    void dispatchDestroy() {
        this.mDestroyed = true;
        this.execPendingActions(true);
        this.endAnimatingAwayFragments();
        this.dispatchStateChange(-1);
        this.mHost = null;
        this.mContainer = null;
        this.mParent = null;
        if (this.mOnBackPressedDispatcher != null) {
            this.mOnBackPressedCallback.remove();
            this.mOnBackPressedDispatcher = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchStateChange(int nextState) {
        try {
            this.mExecutingActions = true;
            this.mFragmentStore.dispatchStateChange(nextState);
            this.moveToState(nextState, false);
            Set<SpecialEffectsController> controllers = this.collectAllSpecialEffectsController();
            for (SpecialEffectsController controller : controllers) {
                controller.forceCompleteAllOperations();
            }
        }
        finally {
            this.mExecutingActions = false;
        }
        this.execPendingActions(true);
    }

    void setPrimaryNavigationFragment(@Nullable Fragment f2) {
        if (f2 != null && (!f2.equals(this.findActiveFragment(f2.mWho)) || f2.mHost != null && f2.mFragmentManager != this)) {
            throw new IllegalArgumentException("Fragment " + f2 + " is not an active fragment of FragmentManager " + this);
        }
        Fragment previousPrimaryNav = this.mPrimaryNav;
        this.mPrimaryNav = f2;
        this.dispatchParentPrimaryNavigationFragmentChanged(previousPrimaryNav);
        this.dispatchParentPrimaryNavigationFragmentChanged(this.mPrimaryNav);
    }

    private void dispatchParentPrimaryNavigationFragmentChanged(@Nullable Fragment f2) {
        if (f2 != null && f2.equals(this.findActiveFragment(f2.mWho))) {
            f2.performPrimaryNavigationFragmentChanged();
        }
    }

    void dispatchPrimaryNavigationFragmentChanged() {
        this.updateOnBackPressedCallbackEnabled();
        this.dispatchParentPrimaryNavigationFragmentChanged(this.mPrimaryNav);
    }

    @Nullable
    public Fragment getPrimaryNavigationFragment() {
        return this.mPrimaryNav;
    }

    void setMaxLifecycle(@Nonnull Fragment f2, @Nonnull Lifecycle.State state) {
        if (!f2.equals(this.findActiveFragment(f2.mWho)) || f2.mHost != null && f2.mFragmentManager != this) {
            throw new IllegalArgumentException("Fragment " + f2 + " is not an active fragment of FragmentManager " + this);
        }
        f2.mMaxState = state;
    }

    public void setFragmentFactory(@Nonnull FragmentFactory fragmentFactory) {
        this.mFragmentFactory = fragmentFactory;
    }

    @Nonnull
    public FragmentFactory getFragmentFactory() {
        if (this.mFragmentFactory != null) {
            return this.mFragmentFactory;
        }
        if (this.mParent != null) {
            return this.mParent.mFragmentManager.getFragmentFactory();
        }
        return sHostFragmentFactory;
    }

    void setSpecialEffectsControllerFactory(@Nonnull SpecialEffectsControllerFactory specialEffectsControllerFactory) {
        this.mSpecialEffectsControllerFactory = specialEffectsControllerFactory;
    }

    @Nonnull
    SpecialEffectsControllerFactory getSpecialEffectsControllerFactory() {
        if (this.mSpecialEffectsControllerFactory != null) {
            return this.mSpecialEffectsControllerFactory;
        }
        if (this.mParent != null) {
            return this.mParent.mFragmentManager.getSpecialEffectsControllerFactory();
        }
        return sDefaultSpecialEffectsControllerFactory;
    }

    @Nonnull
    FragmentLifecycleCallbacksDispatcher getLifecycleCallbacksDispatcher() {
        return this.mLifecycleCallbacksDispatcher;
    }

    public void registerFragmentLifecycleCallbacks(@Nonnull FragmentLifecycleCallbacks cb, boolean recursive) {
        this.mLifecycleCallbacksDispatcher.registerFragmentLifecycleCallbacks(cb, recursive);
    }

    public void unregisterFragmentLifecycleCallbacks(@Nonnull FragmentLifecycleCallbacks cb) {
        this.mLifecycleCallbacksDispatcher.unregisterFragmentLifecycleCallbacks(cb);
    }

    public void addFragmentOnAttachListener(@Nonnull FragmentOnAttachListener listener) {
        this.mOnAttachListeners.add(listener);
    }

    void dispatchOnAttachFragment(@Nonnull Fragment fragment) {
        for (FragmentOnAttachListener listener : this.mOnAttachListeners) {
            listener.onAttachFragment(this, fragment);
        }
    }

    public void removeFragmentOnAttachListener(@Nonnull FragmentOnAttachListener listener) {
        this.mOnAttachListeners.remove(listener);
    }

    void dispatchOnHiddenChanged() {
        for (Fragment fragment : this.mFragmentStore.getActiveFragments()) {
            if (fragment == null) continue;
            fragment.onHiddenChanged(fragment.isHidden());
            fragment.mChildFragmentManager.dispatchOnHiddenChanged();
        }
    }

    boolean checkForMenus() {
        boolean hasMenu = false;
        for (Fragment fragment : this.mFragmentStore.getActiveFragments()) {
            if (fragment != null) {
                hasMenu = this.isMenuAvailable(fragment);
            }
            if (!hasMenu) continue;
            return true;
        }
        return false;
    }

    private boolean isMenuAvailable(@Nonnull Fragment f2) {
        return f2.mHasMenu && f2.mMenuVisible || f2.mChildFragmentManager.checkForMenus();
    }

    void invalidateMenuForFragment(@Nonnull Fragment f2) {
        if (f2.mAdded && this.isMenuAvailable(f2)) {
            this.mNeedMenuInvalidate = true;
        }
    }

    static int reverseTransit(int transit) {
        return switch (transit) {
            case 4097 -> 8194;
            case 8194 -> 4097;
            case 4099 -> 4099;
            case 4100 -> 8197;
            case 8197 -> 4100;
            default -> 0;
        };
    }

    private class PopBackStackState
    implements OpGenerator {
        final String mName;
        final int mId;
        final int mFlags;

        PopBackStackState(String name, int id2, int flags) {
            this.mName = name;
            this.mId = id2;
            this.mFlags = flags;
        }

        @Override
        public boolean generateOps(@Nonnull ArrayList<BackStackRecord> records, @Nonnull BooleanArrayList isRecordPop) {
            FragmentManager childManager;
            if (FragmentManager.this.mPrimaryNav != null && this.mId < 0 && this.mName == null && (childManager = FragmentManager.this.mPrimaryNav.getChildFragmentManager()).popBackStackImmediate()) {
                return false;
            }
            return FragmentManager.this.popBackStackState(records, isRecordPop, this.mName, this.mId, this.mFlags);
        }
    }

    static interface OpGenerator {
        public boolean generateOps(@Nonnull ArrayList<BackStackRecord> var1, @Nonnull BooleanArrayList var2);
    }

    public static interface BackStackEntry {
        public int getId();

        @Nullable
        public String getName();
    }

    private static class LifecycleAwareResultListener
    implements FragmentResultListener {
        private final Lifecycle mLifecycle;
        private final FragmentResultListener mListener;
        private final LifecycleObserver mObserver;

        LifecycleAwareResultListener(@Nonnull Lifecycle lifecycle, @Nonnull FragmentResultListener listener, @Nonnull LifecycleObserver observer) {
            this.mLifecycle = lifecycle;
            this.mListener = listener;
            this.mObserver = observer;
        }

        public boolean isAtLeast(Lifecycle.State state) {
            return this.mLifecycle.getCurrentState().isAtLeast(state);
        }

        @Override
        public void onFragmentResult(@Nonnull String requestKey, @Nonnull DataSet result) {
            this.mListener.onFragmentResult(requestKey, result);
        }

        public void removeObserver() {
            this.mLifecycle.removeObserver(this.mObserver);
        }
    }

    @FunctionalInterface
    public static interface OnBackStackChangedListener {
        @UiThread
        public void onBackStackChanged();
    }
}

