/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.fragment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Marker;
import yslelf.cloudpick.graphics.fragment.Fragment;
import yslelf.cloudpick.graphics.fragment.FragmentManager;
import yslelf.cloudpick.graphics.lifecycle.ViewModel;
import yslelf.cloudpick.graphics.lifecycle.ViewModelProvider;
import yslelf.cloudpick.graphics.lifecycle.ViewModelStore;

final class FragmentManagerViewModel
extends ViewModel {
    private static final Marker MARKER = FragmentManager.MARKER;
    private static final ViewModelProvider.Factory FACTORY = new ViewModelProvider.Factory(){

        @Override
        @Nonnull
        public <T extends ViewModel> T create(@Nonnull Class<T> modelClass) {
            FragmentManagerViewModel viewModel = new FragmentManagerViewModel();
            return (T)viewModel;
        }
    };
    private final HashMap<String, Fragment> mRetainedFragments = new HashMap();
    private final HashMap<String, FragmentManagerViewModel> mChildViewModels = new HashMap();
    private final HashMap<String, ViewModelStore> mViewModelStores = new HashMap();
    private boolean mHasBeenCleared = false;
    private boolean mIsStateSaved = false;

    @Nonnull
    static FragmentManagerViewModel getInstance(ViewModelStore viewModelStore) {
        return new ViewModelProvider(viewModelStore, FACTORY).get(FragmentManagerViewModel.class);
    }

    FragmentManagerViewModel() {
    }

    void setIsStateSaved(boolean isStateSaved) {
        this.mIsStateSaved = isStateSaved;
    }

    @Override
    protected void onCleared() {
        this.mHasBeenCleared = true;
    }

    boolean isCleared() {
        return this.mHasBeenCleared;
    }

    void addRetainedFragment(@Nonnull Fragment fragment) {
        if (!this.mIsStateSaved) {
            this.mRetainedFragments.putIfAbsent(fragment.mWho, fragment);
        }
    }

    @Nullable
    Fragment findRetainedFragmentByWho(@Nonnull String who) {
        return this.mRetainedFragments.get(who);
    }

    @Nonnull
    Collection<Fragment> getRetainedFragments() {
        return new ArrayList<Fragment>(this.mRetainedFragments.values());
    }

    boolean shouldDestroy(@Nonnull Fragment fragment) {
        return this.mHasBeenCleared || !this.mRetainedFragments.containsKey(fragment.mWho);
    }

    void removeRetainedFragment(@Nonnull Fragment fragment) {
        if (!this.mIsStateSaved) {
            this.mRetainedFragments.remove(fragment.mWho);
        }
    }

    @Nonnull
    FragmentManagerViewModel getChildViewModel(@Nonnull Fragment f2) {
        return this.mChildViewModels.computeIfAbsent(f2.mWho, i -> new FragmentManagerViewModel());
    }

    @Nonnull
    ViewModelStore getViewModelStore(@Nonnull Fragment f2) {
        return this.mViewModelStores.computeIfAbsent(f2.mWho, i -> new ViewModelStore());
    }

    void clearViewModelState(@Nonnull Fragment f2) {
        ViewModelStore viewModelStore;
        FragmentManagerViewModel childViewModel = this.mChildViewModels.remove(f2.mWho);
        if (childViewModel != null) {
            childViewModel.onCleared();
        }
        if ((viewModelStore = this.mViewModelStores.remove(f2.mWho)) != null) {
            viewModelStore.clear();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FragmentManagerViewModel that = (FragmentManagerViewModel)o;
        return this.mRetainedFragments.equals(that.mRetainedFragments) && this.mChildViewModels.equals(that.mChildViewModels) && this.mViewModelStores.equals(that.mViewModelStores);
    }

    public int hashCode() {
        int result = this.mRetainedFragments.hashCode();
        result = 31 * result + this.mChildViewModels.hashCode();
        result = 31 * result + this.mViewModelStores.hashCode();
        return result;
    }

    @Nonnull
    public String toString() {
        StringBuilder s = new StringBuilder("FragmentManagerViewModel{");
        s.append(Integer.toHexString(super.hashCode()));
        s.append("} Fragments (");
        Iterator<Fragment> fragmentIterator = this.mRetainedFragments.values().iterator();
        while (fragmentIterator.hasNext()) {
            s.append(fragmentIterator.next());
            if (!fragmentIterator.hasNext()) continue;
            s.append(',').append(' ');
        }
        s.append(") ChildViewModels (");
        Iterator<String> it = this.mChildViewModels.keySet().iterator();
        while (it.hasNext()) {
            s.append(it.next());
            if (!it.hasNext()) continue;
            s.append(',').append(' ');
        }
        s.append(") ViewModelStores (");
        it = this.mViewModelStores.keySet().iterator();
        while (it.hasNext()) {
            s.append(it.next());
            if (!it.hasNext()) continue;
            s.append(',').append(' ');
        }
        s.append(')');
        return s.toString();
    }
}

