/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.fragment;

import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Marker;
import yslelf.cloudpick.graphics.fragment.Fragment;
import yslelf.cloudpick.graphics.fragment.FragmentManager;
import yslelf.cloudpick.graphics.fragment.FragmentManagerViewModel;
import yslelf.cloudpick.graphics.fragment.FragmentStateManager;
import yslelf.cloudpick.graphics.view.ViewGroup;

final class FragmentStore {
    private static final Marker MARKER = FragmentManager.MARKER;
    private final ArrayList<Fragment> mAdded = new ArrayList();
    private final HashMap<String, FragmentStateManager> mActive = new HashMap();
    private FragmentManagerViewModel mViewModel;

    FragmentStore() {
    }

    void setViewModel(@Nonnull FragmentManagerViewModel viewModel) {
        this.mViewModel = viewModel;
    }

    FragmentManagerViewModel getViewModel() {
        return this.mViewModel;
    }

    void resetActiveFragments() {
        this.mActive.clear();
    }

    void restoreAddedFragments(@Nullable List<String> added) {
        this.mAdded.clear();
        if (added != null) {
            for (String who : added) {
                Fragment f2 = this.findActiveFragment(who);
                if (f2 == null) {
                    throw new IllegalStateException("No instantiated fragment for (" + who + ")");
                }
                this.addFragment(f2);
            }
        }
    }

    void makeActive(@Nonnull FragmentStateManager active) {
        Fragment f2 = active.getFragment();
        if (this.mActive.put(f2.mWho, active) == null && f2.mRetainInstanceChangedWhileDetached) {
            if (f2.mRetainInstance) {
                this.mViewModel.addRetainedFragment(f2);
            } else {
                this.mViewModel.removeRetainedFragment(f2);
            }
            f2.mRetainInstanceChangedWhileDetached = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFragment(@Nonnull Fragment fragment) {
        if (this.mAdded.contains(fragment)) {
            throw new IllegalStateException("Fragment already added: " + fragment);
        }
        ArrayList<Fragment> arrayList = this.mAdded;
        synchronized (arrayList) {
            this.mAdded.add(fragment);
        }
        fragment.mAdded = true;
    }

    void dispatchStateChange(int state) {
        for (FragmentStateManager manager : this.mActive.values()) {
            if (manager == null) continue;
            manager.setFragmentManagerState(state);
        }
    }

    void moveToExpectedState() {
        for (Fragment f2 : this.mAdded) {
            FragmentStateManager fragmentStateManager = this.mActive.get(f2.mWho);
            if (fragmentStateManager == null) continue;
            fragmentStateManager.moveToExpectedState();
        }
        for (FragmentStateManager fragmentStateManager : this.mActive.values()) {
            if (fragmentStateManager == null) continue;
            fragmentStateManager.moveToExpectedState();
            Fragment f3 = fragmentStateManager.getFragment();
            boolean beingRemoved = f3.mRemoving && !f3.isInBackStack();
            if (!beingRemoved) continue;
            this.makeInactive(fragmentStateManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFragment(@Nonnull Fragment fragment) {
        ArrayList<Fragment> arrayList = this.mAdded;
        synchronized (arrayList) {
            this.mAdded.remove(fragment);
        }
        fragment.mAdded = false;
    }

    void makeInactive(@Nonnull FragmentStateManager inactive) {
        Fragment f2 = inactive.getFragment();
        if (f2.mRetainInstance) {
            this.mViewModel.removeRetainedFragment(f2);
        }
        if (this.mActive.put(f2.mWho, null) != null) {
            // empty if block
        }
    }

    void burpActive() {
        Collection<FragmentStateManager> values = this.mActive.values();
        values.removeAll(Collections.singleton(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    ArrayList<String> saveAddedFragments() {
        ArrayList<Fragment> arrayList = this.mAdded;
        synchronized (arrayList) {
            if (this.mAdded.isEmpty()) {
                return null;
            }
            ArrayList<String> added = new ArrayList<String>(this.mAdded.size());
            for (Fragment f2 : this.mAdded) {
                added.add(f2.mWho);
            }
            return added;
        }
    }

    @Nonnull
    List<FragmentStateManager> getActiveFragmentStateManagers() {
        ArrayList<FragmentStateManager> list = new ArrayList<FragmentStateManager>();
        for (FragmentStateManager manager : this.mActive.values()) {
            if (manager == null) continue;
            list.add(manager);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    List<Fragment> getFragments() {
        if (this.mAdded.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Fragment> arrayList = this.mAdded;
        synchronized (arrayList) {
            return new ArrayList<Fragment>(this.mAdded);
        }
    }

    @Nonnull
    List<Fragment> getActiveFragments() {
        ArrayList<Fragment> list = new ArrayList<Fragment>();
        for (FragmentStateManager manager : this.mActive.values()) {
            if (manager != null) {
                list.add(manager.getFragment());
                continue;
            }
            list.add(null);
        }
        return list;
    }

    int getActiveFragmentCount() {
        return this.mActive.size();
    }

    @Nullable
    Fragment findFragmentById(int id2) {
        Fragment f2;
        for (int i = this.mAdded.size() - 1; i >= 0; --i) {
            f2 = this.mAdded.get(i);
            if (f2.mFragmentId != id2) continue;
            return f2;
        }
        for (FragmentStateManager manager : this.mActive.values()) {
            if (manager == null) continue;
            f2 = manager.getFragment();
            if (f2.mFragmentId != id2) continue;
            return f2;
        }
        return null;
    }

    @Nullable
    Fragment findFragmentByTag(@Nullable String tag) {
        Fragment f2;
        if (tag == null) {
            return null;
        }
        for (int i = this.mAdded.size() - 1; i >= 0; --i) {
            f2 = this.mAdded.get(i);
            if (!tag.equals(f2.mTag)) continue;
            return f2;
        }
        for (FragmentStateManager manager : this.mActive.values()) {
            if (manager == null) continue;
            f2 = manager.getFragment();
            if (!tag.equals(f2.mTag)) continue;
            return f2;
        }
        return null;
    }

    boolean containsActiveFragment(@Nonnull String who) {
        return this.mActive.get(who) != null;
    }

    @Nullable
    FragmentStateManager getFragmentStateManager(@Nonnull String who) {
        return this.mActive.get(who);
    }

    @Nullable
    Fragment findFragmentByWho(@Nonnull String who) {
        for (FragmentStateManager manager : this.mActive.values()) {
            if (manager == null) continue;
            Fragment f2 = manager.getFragment();
            if ((f2 = f2.findFragmentByWho(who)) == null) continue;
            return f2;
        }
        return null;
    }

    @Nullable
    Fragment findActiveFragment(@Nonnull String who) {
        FragmentStateManager manager = this.mActive.get(who);
        if (manager != null) {
            return manager.getFragment();
        }
        return null;
    }

    int findFragmentIndexInContainer(@Nonnull Fragment f2) {
        int i;
        ViewGroup container = f2.mContainer;
        if (container == null) {
            return -1;
        }
        int fragmentIndex = this.mAdded.indexOf(f2);
        for (i = fragmentIndex - 1; i >= 0; --i) {
            Fragment underFragment = this.mAdded.get(i);
            if (underFragment.mContainer != container || underFragment.mView == null) continue;
            int underIndex = container.indexOfChild(underFragment.mView);
            return underIndex + 1;
        }
        for (i = fragmentIndex + 1; i < this.mAdded.size(); ++i) {
            Fragment overFragment = this.mAdded.get(i);
            if (overFragment.mContainer != container || overFragment.mView == null) continue;
            return container.indexOfChild(overFragment.mView);
        }
        return -1;
    }

    void dump(@Nonnull String prefix, @Nullable FileDescriptor fd, @Nonnull PrintWriter writer, String ... args) {
        int count;
        Fragment f2;
        String innerPrefix = prefix + "    ";
        if (!this.mActive.isEmpty()) {
            writer.print(prefix);
            writer.println("Active Fragments:");
            for (FragmentStateManager fragmentStateManager : this.mActive.values()) {
                writer.print(prefix);
                if (fragmentStateManager != null) {
                    f2 = fragmentStateManager.getFragment();
                    writer.println(f2);
                    f2.dump(innerPrefix, fd, writer, args);
                    continue;
                }
                writer.println("null");
            }
        }
        if ((count = this.mAdded.size()) > 0) {
            writer.print(prefix);
            writer.println("Added Fragments:");
            for (int i = 0; i < count; ++i) {
                f2 = this.mAdded.get(i);
                writer.print(prefix);
                writer.print("  #");
                writer.print(i);
                writer.print(": ");
                writer.println(f2.toString());
            }
        }
    }
}

