/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.graphics;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.Cleaner;
import java.lang.ref.Reference;
import java.nio.Buffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Date;
import java.util.function.LongConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.PointerBuffer;
import org.lwjgl.stb.STBIWriteCallback;
import org.lwjgl.stb.STBIWriteCallbackI;
import org.lwjgl.stb.STBImage;
import org.lwjgl.stb.STBImageWrite;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.util.tinyfd.TinyFileDialogs;
import sun.misc.Unsafe;
import yslelf.cloudpick.graphics.CloudPick;
import yslelf.cloudpick.graphics.annotation.ColorInt;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.annotation.Size;
import yslelf.cloudpick.graphics.annotation.WorkerThread;
import yslelf.cloudpick.graphics.core.Core;
import yslelf.cloudpick.graphics.graphics.Rect;
import yslelf.cloudpick.render.core.ColorInfo;
import yslelf.cloudpick.render.core.ColorSpace;
import yslelf.cloudpick.render.core.ImageInfo;
import yslelf.cloudpick.render.core.Pixels;
import yslelf.cloudpick.render.core.Pixmap;
import yslelf.cloudpick.render.core.RawPtr;
import yslelf.cloudpick.render.core.Rect2i;

public final class Bitmap
implements AutoCloseable {
    public static final Marker MARKER = MarkerManager.getMarker((String)"Bitmap");
    public static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
    @NonNull
    private Format mFormat;
    @NonNull
    private Pixmap mPixmap;
    private volatile Pixels mPixels;
    private final Cleaner.Cleanable mCleanup;
    private boolean mRequestPremultiplied;

    Bitmap(@NonNull Format format, @NonNull ImageInfo info, long addr, int rowBytes, @Nullable LongConsumer freeFn) {
        this.mFormat = format;
        this.mPixmap = new Pixmap(info, null, addr, rowBytes);
        this.mRequestPremultiplied = info.alphaType() == 2;
        Pixels pixels = new Pixels(info.width(), info.height(), null, addr, rowBytes, freeFn);
        this.mCleanup = Core.registerNativeResource((Object)this, pixels);
        this.mPixels = pixels;
    }

    @NonNull
    public static Bitmap createBitmap(@Size(min=1L) int width, @Size(min=1L) int height, @NonNull Format format) {
        ColorSpace colorSpace = format.isChannelHDR() ? ColorSpace.get(ColorSpace.Named.LINEAR_EXTENDED_SRGB) : ColorSpace.get(ColorSpace.Named.SRGB);
        return Bitmap.createBitmap(width, height, format, false, colorSpace);
    }

    @NonNull
    public static Bitmap createBitmap(@Size(min=1L) int width, @Size(min=1L) int height, @NonNull Format format, boolean isPremultiplied, @Nullable ColorSpace colorSpace) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Image dimensions " + width + "x" + height + " must be positive");
        }
        int bpp = format.getBytesPerPixel();
        if (bpp == 0) {
            throw new IllegalArgumentException("Cannot create bitmap with format " + format);
        }
        if (width > Integer.MAX_VALUE / bpp) {
            throw new IllegalArgumentException("Image width " + width + " is too large for format " + format);
        }
        int rowBytes = width * bpp;
        long size = (long)rowBytes * (long)height;
        long address = MemoryUtil.nmemCalloc((long)size, (long)1L);
        if (address == 0L) {
            System.gc();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            address = MemoryUtil.nmemCalloc((long)size, (long)1L);
            if (address == 0L) {
                throw new OutOfMemoryError("Failed to allocate " + size + " bytes for bitmap");
            }
        }
        int alphaType = format.hasAlpha() ? (isPremultiplied ? 2 : 3) : 1;
        alphaType = ColorInfo.validateAlphaType(format.getColorType(), alphaType);
        ImageInfo info = ImageInfo.make(width, height, format.getColorType(), alphaType, colorSpace);
        return new Bitmap(format, info, address, rowBytes, MemoryUtil::nmemFree);
    }

    @ApiStatus.Experimental
    @NonNull
    public static Bitmap wrap(@NativeType(value="const void *") long address, int rowBytes, @Nullable LongConsumer freeFn, @Size(min=1L) int width, @Size(min=1L) int height, @NonNull Format format, boolean isPremultiplied, @Nullable ColorSpace colorSpace) {
        int alphaType = format.hasAlpha() ? (isPremultiplied ? 2 : 3) : 1;
        alphaType = ColorInfo.validateAlphaType(format.getColorType(), alphaType);
        ImageInfo info = ImageInfo.make(width, height, format.getColorType(), alphaType, colorSpace);
        return new Bitmap(format, info, address, rowBytes, freeFn);
    }

    @Nullable
    public static String openDialogGet(@Nullable SaveFormat format, @Nullable CharSequence title, @Nullable CharSequence defaultPathAndFile) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer filters = format != null ? format.getFilters(stack) : SaveFormat.getAllFilters(stack);
            String string = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)title, (CharSequence)defaultPathAndFile, (PointerBuffer)filters, (CharSequence)(format != null ? format.getDescription() : SaveFormat.getAllDescription()), (boolean)false);
            return string;
        }
    }

    @Nullable
    public static String[] openDialogGets(@Nullable SaveFormat format, @Nullable CharSequence title, @Nullable CharSequence defaultPathAndFile) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer filters = format != null ? format.getFilters(stack) : SaveFormat.getAllFilters(stack);
            String s = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)title, (CharSequence)defaultPathAndFile, (PointerBuffer)filters, (CharSequence)(format != null ? format.getDescription() : SaveFormat.getAllDescription()), (boolean)true);
            String[] stringArray = s != null ? s.split("\\|") : null;
            return stringArray;
        }
    }

    @Nullable
    public static String saveDialogGet(@Nullable SaveFormat format, @Nullable CharSequence title, @Nullable String name) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer filters = format != null ? format.getFilters(stack) : SaveFormat.getAllFilters(stack);
            String string = TinyFileDialogs.tinyfd_saveFileDialog((CharSequence)title, (CharSequence)SaveFormat.getFileName(format, name), (PointerBuffer)filters, (CharSequence)(format != null ? format.getDescription() : SaveFormat.getAllDescription()));
            return string;
        }
    }

    @ApiStatus.Internal
    @NonNull
    public ImageInfo getInfo() {
        return this.mPixmap.getInfo();
    }

    public int getWidth() {
        if (this.mPixels == null) {
            CloudPick.LOGGER.warn(MARKER, "Called getWidth() on a recycle()'d bitmap! This is undefined behavior!");
        }
        return this.mPixmap.getWidth();
    }

    public int getHeight() {
        if (this.mPixels == null) {
            CloudPick.LOGGER.warn(MARKER, "Called getHeight() on a recycle()'d bitmap! This is undefined behavior!");
        }
        return this.mPixmap.getHeight();
    }

    public long getSize() {
        if (this.mPixels == null) {
            CloudPick.LOGGER.warn(MARKER, "Called getSize() on a recycle()'d bitmap! This is undefined behavior!");
            return 0L;
        }
        return (long)this.getRowBytes() * (long)this.getHeight();
    }

    @ApiStatus.Internal
    public int getColorType() {
        return this.mPixmap.getColorType();
    }

    @ApiStatus.Internal
    public int getAlphaType() {
        return this.mPixmap.getAlphaType();
    }

    @NonNull
    public Format getFormat() {
        return this.mFormat;
    }

    public void setFormat(@NonNull Format format) {
        if (format.getBytesPerPixel() == 0) {
            throw new IllegalArgumentException("Format " + format + " is not supported");
        }
        if (format.getBytesPerPixel() != this.mFormat.getBytesPerPixel()) {
            throw new IllegalArgumentException("Bpp mismatch between new format " + format + " and old format " + this.mFormat);
        }
        ImageInfo info = this.getInfo();
        int newColorType = format.getColorType();
        if (info.colorType() != newColorType) {
            int newAlphaType = ColorInfo.validateAlphaType(newColorType, this.mRequestPremultiplied ? 2 : 3);
            ImageInfo newInfo = new ImageInfo(info.width(), info.height(), newColorType, newAlphaType, info.colorSpace());
            this.mPixmap = new Pixmap(newInfo, this.mPixmap);
            this.mFormat = format;
        }
    }

    public int getChannels() {
        return this.mFormat.getChannels();
    }

    public boolean hasAlpha() {
        assert (this.mPixels != null);
        return !this.getInfo().isOpaque();
    }

    public boolean isPremultiplied() {
        assert (this.mPixels != null);
        return this.getAlphaType() == 2;
    }

    public void setPremultiplied(boolean premultiplied) {
        assert (this.mPixels != null);
        this.mRequestPremultiplied = premultiplied;
        if (this.hasAlpha()) {
            ImageInfo info = this.getInfo();
            int newAlphaType = ColorInfo.validateAlphaType(info.colorType(), premultiplied ? 2 : 3);
            if (info.alphaType() != newAlphaType) {
                this.mPixmap = new Pixmap(info.makeAlphaType(newAlphaType), this.mPixmap);
            }
        }
    }

    @Nullable
    public ColorSpace getColorSpace() {
        return this.mPixmap.getColorSpace();
    }

    public void setColorSpace(@Nullable ColorSpace newColorSpace) {
        ImageInfo oldInfo = this.getInfo();
        ColorSpace oldColorSpace = oldInfo.colorSpace();
        if (oldColorSpace == newColorSpace) {
            return;
        }
        if (newColorSpace != null) {
            if (!(newColorSpace instanceof ColorSpace.Rgb)) {
                throw new IllegalArgumentException("The new ColorSpace must use the RGB color model");
            }
            ColorSpace.Rgb rgbColorSpace = (ColorSpace.Rgb)newColorSpace;
            if (rgbColorSpace.getTransferParameters() == null) {
                throw new IllegalArgumentException("The new ColorSpace must use an ICC parametric transfer function");
            }
        }
        if (oldColorSpace != null && newColorSpace != null) {
            for (int i = 0; i < oldColorSpace.getComponentCount(); ++i) {
                if (oldColorSpace.getMinValue(i) < newColorSpace.getMinValue(i)) {
                    throw new IllegalArgumentException("The new ColorSpace cannot increase the minimum value for any of the components compared to the current ColorSpace. To perform this type of conversion create a new Bitmap in the desired ColorSpace and draw this Bitmap into it.");
                }
                if (!(oldColorSpace.getMaxValue(i) > newColorSpace.getMaxValue(i))) continue;
                throw new IllegalArgumentException("The new ColorSpace cannot decrease the maximum value for any of the components compared to the current ColorSpace/ To perform this type of conversion create a new Bitmap in the desired ColorSpace and draw this Bitmap into it.");
            }
        }
        this.mPixmap = new Pixmap(oldInfo.makeColorSpace(newColorSpace), this.mPixmap);
    }

    @ApiStatus.Internal
    public long getAddress() {
        if (this.mPixels == null) {
            return 0L;
        }
        return this.mPixmap.getAddress();
    }

    @ApiStatus.Obsolete
    public int getRowStride() {
        return this.getRowBytes();
    }

    public int getRowBytes() {
        if (this.mPixels == null) {
            CloudPick.LOGGER.warn(MARKER, "Called getRowBytes() on a recycle()'d bitmap! This is undefined behavior!");
        }
        return this.mPixmap.getRowBytes();
    }

    public boolean isImmutable() {
        if (this.mPixels != null) {
            return this.mPixels.isImmutable();
        }
        assert (false);
        return false;
    }

    public void setImmutable() {
        if (this.mPixels != null) {
            this.mPixels.setImmutable();
        }
    }

    private void checkOutOfBounds(int x, int y) {
        if (x < 0) {
            throw new IllegalArgumentException("x " + x + " must be >= 0");
        }
        if (y < 0) {
            throw new IllegalArgumentException("y " + y + " must be >= 0");
        }
        if (x >= this.getWidth()) {
            throw new IllegalArgumentException("x " + x + " must be < bitmap.width() " + this.getWidth());
        }
        if (y >= this.getHeight()) {
            throw new IllegalArgumentException("y " + y + " must be < bitmap.height() " + this.getHeight());
        }
    }

    private void checkOutOfBounds(int x, int y, int width, int height) {
        if (x < 0) {
            throw new IllegalArgumentException("x " + x + " must be >= 0");
        }
        if (y < 0) {
            throw new IllegalArgumentException("y " + y + " must be >= 0");
        }
        if (width < 0) {
            throw new IllegalArgumentException("width " + width + " must be >= 0");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height " + height + " must be >= 0");
        }
        if (x + width > this.getWidth()) {
            throw new IllegalArgumentException(String.format("x %d + width %d must be <= bitmap.width() %d", x, width, this.getWidth()));
        }
        if (y + height > this.getHeight()) {
            throw new IllegalArgumentException(String.format("y %d + height %d must be <= bitmap.height() %d", y, height, this.getHeight()));
        }
    }

    private void checkOutOfBounds(int x, int y, int width, int height, int offset, int stride, int length) {
        this.checkOutOfBounds(x, y, width, height);
        if (stride < width) {
            throw new IllegalArgumentException("stride " + stride + " must be >= width" + width);
        }
        int lastScanline = offset + (height - 1) * stride;
        if (offset < 0 || offset + width > length || lastScanline < 0 || lastScanline + width > length) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ColorInt
    public int getPixelARGB(int x, int y) {
        this.checkReleased();
        this.checkOutOfBounds(x, y);
        if (this.getColorType() == 0) {
            return 0;
        }
        try {
            int n2 = this.mPixmap.getColor(x, y);
            return n2;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    @Size(value=4L)
    public float[] getColor4f(int x, int y, @NonNull @Size(value=4L) float[] dst) {
        this.checkReleased();
        this.checkOutOfBounds(x, y);
        if (this.getColorType() == 0) {
            for (int i = 0; i < 4; ++i) {
                dst[i] = 0.0f;
            }
        } else {
            try {
                this.mPixmap.getColor4f(x, y, dst);
            }
            finally {
                Reference.reachabilityFence(this);
            }
        }
        return dst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColor4f(int x, int y, @NonNull @Size(value=4L) float[] src) {
        this.checkReleased();
        if (this.isImmutable()) {
            throw new IllegalStateException("Cannot write to immutable bitmap");
        }
        this.checkOutOfBounds(x, y);
        if (this.getColorType() != 0) {
            try {
                this.mPixmap.setColor4f(x, y, src);
            }
            finally {
                Reference.reachabilityFence(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getPixels(@NonNull @ColorInt int[] dst, int offset, int stride, int srcX, int srcY, int width, int height) {
        this.checkReleased();
        if (width == 0 || height == 0) {
            return;
        }
        this.checkOutOfBounds(srcX, srcY, width, height, offset, stride, dst.length);
        if (this.getColorType() == 0) {
            for (int j = 0; j < height; ++j) {
                int index = offset + stride * j;
                Arrays.fill(dst, index, index + width, 0);
            }
        } else {
            try {
                ImageInfo dstInfo = new ImageInfo(width, height, ColorInfo.CT_BGRA_8888_NATIVE, 3, ColorSpace.get(ColorSpace.Named.SRGB));
                Pixmap dstPixmap = new Pixmap(dstInfo, dst, (long)Unsafe.ARRAY_INT_BASE_OFFSET + (long)offset << 2, stride << 2);
                boolean res = this.mPixmap.readPixels(dstPixmap, srcX, srcY);
                assert (res);
            }
            finally {
                Reference.reachabilityFence(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPixels(@NonNull @ColorInt int[] src, int offset, int stride, int dstX, int dstY, int width, int height) {
        this.checkReleased();
        if (this.isImmutable()) {
            throw new IllegalStateException("Cannot write to immutable bitmap");
        }
        if (width == 0 || height == 0) {
            return;
        }
        this.checkOutOfBounds(dstX, dstY, width, height, offset, stride, src.length);
        if (this.getColorType() != 0) {
            try {
                ImageInfo srcInfo = new ImageInfo(width, height, ColorInfo.CT_BGRA_8888_NATIVE, 3, ColorSpace.get(ColorSpace.Named.SRGB));
                Pixmap srcPixmap = new Pixmap(srcInfo, src, (long)Unsafe.ARRAY_INT_BASE_OFFSET + (long)offset << 2, stride << 2);
                boolean res = this.mPixmap.writePixels(srcPixmap, dstX, dstY);
                assert (res);
            }
            finally {
                Reference.reachabilityFence(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getPixels(@NonNull @Size(multiple=4L) float[] dst, int offset, int stride, int srcX, int srcY, int width, int height) {
        this.checkReleased();
        if (width == 0 || height == 0) {
            return;
        }
        this.checkOutOfBounds(srcX, srcY, width, height, offset, stride, dst.length >> 2);
        if (this.getColorType() == 0) {
            for (int j = 0; j < height; ++j) {
                int index = offset + stride * j << 2;
                Arrays.fill(dst, index, index + (width << 2), 0.0f);
            }
        } else {
            try {
                ImageInfo dstInfo = new ImageInfo(width, height, 18, this.getAlphaType(), this.getColorSpace());
                Pixmap dstPixmap = new Pixmap(dstInfo, dst, (long)Unsafe.ARRAY_FLOAT_BASE_OFFSET + (long)offset << 4, stride << 4);
                boolean res = this.mPixmap.readPixels(dstPixmap, srcX, srcY);
                assert (res);
            }
            finally {
                Reference.reachabilityFence(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPixels(@NonNull @Size(multiple=4L) float[] src, int offset, int stride, int dstX, int dstY, int width, int height) {
        this.checkReleased();
        if (this.isImmutable()) {
            throw new IllegalStateException("Cannot write to immutable bitmap");
        }
        if (width == 0 || height == 0) {
            return;
        }
        this.checkOutOfBounds(dstX, dstY, width, height, offset, stride, src.length >> 2);
        if (this.getColorType() != 0) {
            try {
                ImageInfo srcInfo = new ImageInfo(width, height, 18, this.getAlphaType(), this.getColorSpace());
                Pixmap srcPixmap = new Pixmap(srcInfo, src, (long)Unsafe.ARRAY_FLOAT_BASE_OFFSET + (long)offset << 4, stride << 4);
                boolean res = this.mPixmap.writePixels(srcPixmap, dstX, dstY);
                assert (res);
            }
            finally {
                Reference.reachabilityFence(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getPixels(@NonNull Bitmap dst, int dstX, int dstY, int srcX, int srcY, int width, int height) {
        this.checkReleased();
        dst.checkReleased();
        if (dst.isImmutable()) {
            throw new IllegalStateException("Cannot write to immutable bitmap");
        }
        if (width == 0 || height == 0) {
            return;
        }
        this.checkOutOfBounds(srcX, srcY, width, height);
        dst.checkOutOfBounds(dstX, dstY, width, height);
        Rect2i dstRect = new Rect2i(dstX, dstY, dstX + width, dstY + height);
        try {
            if (this.getColorType() == 0) {
                dst.getPixmap().clear(new float[]{0.0f, 0.0f, 0.0f, 0.0f}, dstRect);
            } else {
                Pixmap dstPixmap = dst.getPixmap().makeSubset(dstRect);
                assert (dstPixmap != null);
                boolean res = this.mPixmap.readPixels(dstPixmap, srcX, srcY);
                assert (res);
            }
        }
        finally {
            Reference.reachabilityFence(this);
            Reference.reachabilityFence(dst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPixels(@NonNull Bitmap src, int srcX, int srcY, int dstX, int dstY, int width, int height) {
        this.checkReleased();
        src.checkReleased();
        if (this.isImmutable()) {
            throw new IllegalStateException("Cannot write to immutable bitmap");
        }
        if (width == 0 || height == 0) {
            return;
        }
        this.checkOutOfBounds(srcX, srcY, width, height);
        src.checkOutOfBounds(dstX, dstY, width, height);
        Rect2i srcRect = new Rect2i(srcX, srcY, srcX + width, srcY + height);
        try {
            if (this.getColorType() == 0) {
                this.mPixmap.clear(new float[]{0.0f, 0.0f, 0.0f, 0.0f}, srcRect);
            } else {
                Pixmap srcPixmap = src.getPixmap().makeSubset(srcRect);
                assert (srcPixmap != null);
                boolean res = this.mPixmap.writePixels(srcPixmap, dstX, dstY);
                assert (res);
            }
        }
        finally {
            Reference.reachabilityFence(this);
            Reference.reachabilityFence(src);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyPixelsToBuffer(@NonNull Buffer dst, int rowBytes, int srcX, int srcY, int width, int height) {
        this.checkReleased();
        if (dst.isReadOnly()) {
            throw new IllegalArgumentException("Cannot copy to read-only buffer");
        }
        if (width == 0 || height == 0) {
            return false;
        }
        this.checkOutOfBounds(srcX, srcY, width, height);
        try {
            ImageInfo dstInfo = this.getInfo().makeWH(width, height);
            Pixmap dstPixmap = new Pixmap(dstInfo, dst.hasArray() ? dst.array() : null, MemoryUtil.memAddress((Buffer)dst), rowBytes);
            boolean bl = this.mPixmap.readPixels(dstPixmap, srcX, srcY);
            return bl;
        }
        finally {
            Reference.reachabilityFence(dst);
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyPixelsFromBuffer(@NonNull Buffer src, int rowBytes, int dstX, int dstY, int width, int height) {
        this.checkReleased();
        if (this.isImmutable()) {
            throw new IllegalStateException("Cannot write to immutable bitmap");
        }
        if (src.isReadOnly()) {
            throw new IllegalArgumentException("Cannot copy from read-only buffer");
        }
        if (width == 0 || height == 0) {
            return false;
        }
        this.checkOutOfBounds(dstX, dstY, width, height);
        try {
            ImageInfo srcInfo = this.getInfo().makeWH(width, height);
            Pixmap srcPixmap = new Pixmap(srcInfo, src.hasArray() ? src.array() : null, MemoryUtil.memAddress((Buffer)src), rowBytes);
            boolean bl = this.mPixmap.writePixels(srcPixmap, dstX, dstY);
            return bl;
        }
        finally {
            Reference.reachabilityFence(src);
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clear(@NonNull @Size(value=4L) float[] color, @Nullable Rect area) {
        this.checkReleased();
        if (this.isImmutable()) {
            throw new IllegalStateException("Cannot clear immutable bitmaps");
        }
        try {
            boolean bl = this.mPixmap.clear(color, area == null ? null : new Rect2i(area.left, area.top, area.right, area.bottom));
            return bl;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @ApiStatus.Internal
    @NonNull
    public Pixmap getPixmap() {
        return this.mPixmap;
    }

    @ApiStatus.Internal
    @RawPtr
    @Nullable
    public Pixels getPixels() {
        return this.mPixels;
    }

    @WorkerThread
    public boolean saveDialog(@NonNull SaveFormat format, int quality, @Nullable String name) throws IOException {
        String path = Bitmap.saveDialogGet(format, null, name);
        if (path != null) {
            this.saveToPath(format, quality, Path.of(path, new String[0]));
            return true;
        }
        return false;
    }

    @WorkerThread
    public void saveToFile(@NonNull SaveFormat format, int quality, @NonNull File file) throws IOException {
        this.checkReleased();
        try (FileOutputStream stream = new FileOutputStream(file);){
            this.saveToChannel(format, quality, stream.getChannel());
        }
        catch (IOException e) {
            throw new IOException("Failed to save image to path \"" + file.getAbsolutePath() + "\"", e);
        }
    }

    @WorkerThread
    public void saveToPath(@NonNull SaveFormat format, int quality, @NonNull Path path) throws IOException {
        this.checkReleased();
        try (FileChannel channel = FileChannel.open(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            this.saveToChannel(format, quality, channel);
        }
        catch (IOException e) {
            throw new IOException("Failed to save image to path \"" + path.toAbsolutePath() + "\"", e);
        }
    }

    @WorkerThread
    public void saveToStream(@NonNull SaveFormat format, int quality, @NonNull OutputStream stream) throws IOException {
        this.saveToChannel(format, quality, Channels.newChannel(stream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public void saveToChannel(@NonNull SaveFormat format, int quality, final @NonNull WritableByteChannel channel) throws IOException {
        block14: {
            this.checkReleased();
            if (quality < 0 || quality > 100) {
                throw new IllegalArgumentException("Bad quality " + quality + ", must be 0..100");
            }
            if (Core.isOnMainThread() || Core.isOnRenderThread()) {
                CloudPick.LOGGER.warn(MARKER, "Called save() on core thread! This will hang the application!", new Exception().fillInStackTrace());
            }
            if (this.getRowBytes() != this.getWidth() * this.getFormat().getBytesPerPixel()) {
                throw new IOException("Pixel data is not tightly packed");
            }
            var callback = new STBIWriteCallback(){
                private IOException exception;

                public void invoke(long context, long data, int size) {
                    try {
                        int n2 = channel.write(STBIWriteCallback.getData((long)data, (int)size));
                        if (n2 != size) {
                            this.exception = new IOException("Channel does not consume all the data");
                        }
                    }
                    catch (IOException e) {
                        this.exception = e;
                    }
                }
            };
            try (1 var5_5 = callback;){
                boolean success = format.write((STBIWriteCallbackI)callback, this.getWidth(), this.getHeight(), this.mFormat, this.getAddress(), quality);
                if (success) {
                    if (callback.exception != null) {
                        throw new IOException("Failed to save image", callback.exception);
                    }
                    break block14;
                }
                throw new IOException("Failed to encode image: " + STBImage.stbi_failure_reason());
            }
            finally {
                Reference.reachabilityFence(this);
            }
        }
    }

    private void checkReleased() {
        if (this.mPixels == null) {
            throw new IllegalStateException("Cannot operate a recycled bitmap!");
        }
    }

    @Override
    public void close() {
        this.mPixels = null;
        this.mCleanup.clean();
    }

    public void recycle() {
        this.close();
    }

    public boolean isClosed() {
        return this.mPixels == null;
    }

    public boolean isRecycled() {
        return this.mPixels == null;
    }

    @NonNull
    public String toString() {
        return "Bitmap{mFormat=" + this.mFormat + ", mInfo=" + this.getInfo() + ", mPixels=" + this.mPixels + "}";
    }

    public static enum Format {
        GRAY_8(1, 22),
        GRAY_ALPHA_88(2, 23),
        RGB_888(3, 4),
        RGBA_8888(4, 6),
        GRAY_16(1, 0),
        GRAY_ALPHA_1616(2, 0),
        RGB_161616(3, 0),
        RGBA_16161616(4, 15),
        GRAY_F32(1, 0),
        GRAY_ALPHA_F32(2, 0),
        RGB_F32(3, 0),
        RGBA_F32(4, 18),
        ALPHA_8(1, 19),
        R_8(1, 2),
        RG_88(2, 3),
        ALPHA_16(1, 20),
        R_16(1, 11),
        RG_1616(2, 13),
        ALPHA_F16(1, 21),
        R_F16(1, 12),
        RG_F16(2, 14),
        RGBA_F16(4, 16),
        BGR_565(3, 1),
        RGBA_1010102(4, 9),
        BGRA_1010102(4, 10),
        RGBX_8888(4, 5),
        BGRA_8888(4, 7),
        ABGR_8888(4, 24),
        ARGB_8888(4, 25),
        RGBA_8888_PACK32(4, ColorInfo.CT_RGBA_8888_NATIVE),
        BGRA_8888_PACK32(4, ColorInfo.CT_BGRA_8888_NATIVE);

        private static final Format[] FORMATS;
        private final int mChannels;
        private final int mColorType;

        private Format(int chs, int ct) {
            this.mChannels = chs;
            this.mColorType = ct;
        }

        public int getChannels() {
            return this.mChannels;
        }

        public int getColorType() {
            return this.mColorType;
        }

        public int getBytesPerPixel() {
            if (this.mColorType != 0) {
                return ColorInfo.bytesPerPixel(this.mColorType);
            }
            return switch (this) {
                case GRAY_16 -> 2;
                case GRAY_ALPHA_1616, GRAY_F32 -> 4;
                case RGB_161616 -> 6;
                case GRAY_ALPHA_F32 -> 8;
                case RGB_F32 -> 12;
                default -> 0;
            };
        }

        public boolean isChannelU8() {
            return switch (this) {
                case GRAY_8, GRAY_ALPHA_88, RGB_888, RGBA_8888, ALPHA_8, R_8, RG_88, RGBX_8888, BGRA_8888, ABGR_8888, ARGB_8888 -> true;
                default -> false;
            };
        }

        public boolean isChannelU16() {
            return switch (this) {
                case GRAY_16, GRAY_ALPHA_1616, RGB_161616, RGBA_16161616, ALPHA_16, R_16, RG_1616 -> true;
                default -> false;
            };
        }

        public boolean isChannelHDR() {
            return this.ordinal() >> 2 == 2;
        }

        public boolean hasAlpha() {
            if (this.mColorType != 0) {
                return (ColorInfo.colorTypeChannelFlags(this.mColorType) & 8) != 0;
            }
            return (this.ordinal() & 1) == 1;
        }

        @ApiStatus.Internal
        @NonNull
        public static Format get(int chs, boolean u16, boolean hdr) {
            if (chs < 1 || chs > 4) {
                throw new IllegalArgumentException();
            }
            if (u16 && hdr) {
                throw new IllegalArgumentException();
            }
            return FORMATS[chs - 1 | (u16 ? 4 : 0) | (hdr ? 8 : 0)];
        }

        static {
            FORMATS = Format.values();
        }
    }

    public static enum SaveFormat {
        PNG("*.png"),
        TGA("*.tga", "*.icb", "*.vda", "*.vst"),
        BMP("*.bmp", "*.dib"),
        JPEG("*.jpg", "*.jpeg", "*.jpe", "*.jif", "*.jfif", "*.jfi"),
        HDR("*.hdr"),
        RAW("*.bin");

        private static final SaveFormat[] OPEN_FORMATS;
        private static final String[] EXTRA_FILTERS;
        @NonNull
        private final String[] filters;

        private SaveFormat(String ... filters) {
            this.filters = filters;
        }

        public boolean write(@NonNull STBIWriteCallbackI func, int width, int height, @NonNull Format format, long data, int quality) throws IOException {
            switch (this) {
                case PNG: {
                    if (!format.isChannelU8()) {
                        throw new IOException("Only 8-bit per channel images can be saved as " + this + ", found " + format);
                    }
                    return STBImageWrite.nstbi_write_png_to_func((long)func.address(), (long)0L, (int)width, (int)height, (int)format.getChannels(), (long)data, (int)0) != 0;
                }
                case TGA: {
                    if (!format.isChannelU8()) {
                        throw new IOException("Only 8-bit per channel images can be saved as " + this + ", found " + format);
                    }
                    return STBImageWrite.nstbi_write_tga_to_func((long)func.address(), (long)0L, (int)width, (int)height, (int)format.getChannels(), (long)data) != 0;
                }
                case BMP: {
                    if (!format.isChannelU8()) {
                        throw new IOException("Only 8-bit per channel images can be saved as " + this + ", found " + format);
                    }
                    return STBImageWrite.nstbi_write_bmp_to_func((long)func.address(), (long)0L, (int)width, (int)height, (int)format.getChannels(), (long)data) != 0;
                }
                case JPEG: {
                    if (!format.isChannelU8()) {
                        throw new IOException("Only 8-bit per channel images can be saved as " + this + ", found " + format);
                    }
                    return STBImageWrite.nstbi_write_jpg_to_func((long)func.address(), (long)0L, (int)width, (int)height, (int)format.getChannels(), (long)data, (int)quality) != 0;
                }
                case HDR: {
                    if (!format.isChannelHDR()) {
                        throw new IOException("Only 32-bit per channel images can be saved as " + this + ", found " + format);
                    }
                    return STBImageWrite.nstbi_write_hdr_to_func((long)func.address(), (long)0L, (int)width, (int)height, (int)format.getChannels(), (long)data) != 0;
                }
                case RAW: {
                    func.invoke(0L, data, width * height * format.getBytesPerPixel());
                    return true;
                }
            }
            return false;
        }

        @NonNull
        public static PointerBuffer getAllFilters(@NonNull MemoryStack stack) {
            int length = EXTRA_FILTERS.length;
            for (SaveFormat format : OPEN_FORMATS) {
                length += format.filters.length;
            }
            PointerBuffer buffer = stack.mallocPointer(length);
            for (SaveFormat saveFormat : OPEN_FORMATS) {
                for (String filter : saveFormat.filters) {
                    stack.nUTF8((CharSequence)filter, true);
                    buffer.put(stack.getPointerAddress());
                }
            }
            for (String string : EXTRA_FILTERS) {
                stack.nUTF8((CharSequence)string, true);
                buffer.put(stack.getPointerAddress());
            }
            return (PointerBuffer)buffer.rewind();
        }

        @NonNull
        public static String getAllDescription() {
            return SaveFormat.getAllDescription("Image Files");
        }

        @NonNull
        public static String getAllDescription(@NonNull String header) {
            return header + " (" + Stream.concat(Arrays.stream(OPEN_FORMATS).flatMap(f2 -> Arrays.stream(f2.filters)), Arrays.stream(EXTRA_FILTERS)).sorted().collect(Collectors.joining(";")) + ")";
        }

        @NonNull
        public PointerBuffer getFilters(@NonNull MemoryStack stack) {
            PointerBuffer buffer = stack.mallocPointer(this.filters.length);
            for (String filter : this.filters) {
                stack.nUTF8((CharSequence)filter, true);
                buffer.put(stack.getPointerAddress());
            }
            return (PointerBuffer)buffer.rewind();
        }

        @NonNull
        public String getDescription() {
            return this.name() + " (" + String.join((CharSequence)";", this.filters) + ")";
        }

        @NonNull
        public String getDefaultExtension() {
            return this.filters[0].substring(1);
        }

        @NonNull
        public static String getFileName(@Nullable SaveFormat format, @Nullable String name) {
            String s;
            String string = s = name != null ? name : "image-" + DATE_FORMAT.format(new Date());
            if (format != null) {
                return s + format.getDefaultExtension();
            }
            return s;
        }

        static {
            SaveFormat[] values = SaveFormat.values();
            OPEN_FORMATS = Arrays.copyOf(values, values.length - 1);
            EXTRA_FILTERS = new String[]{"*.psd", "*.gif", "*.pic", "*.pnm", "*.pgm", "*.ppm"};
        }
    }
}

