/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.graphics;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Predicate;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.stb.STBIEOFCallback;
import org.lwjgl.stb.STBIEOFCallbackI;
import org.lwjgl.stb.STBIIOCallbacks;
import org.lwjgl.stb.STBIReadCallback;
import org.lwjgl.stb.STBIReadCallbackI;
import org.lwjgl.stb.STBISkipCallback;
import org.lwjgl.stb.STBISkipCallbackI;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.jni.JNINativeInterface;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.core.Core;
import yslelf.cloudpick.graphics.graphics.Bitmap;
import yslelf.cloudpick.render.core.ColorSpace;
import yslelf.cloudpick.render.core.ImageInfo;

public final class BitmapFactory {
    private static volatile STBIIOCallbacks g_io_callbacks;

    private static void validate(Options opts) {
        if (opts == null) {
            return;
        }
        if (opts.inPreferredColorSpace != null) {
            ColorSpace colorSpace = opts.inPreferredColorSpace;
            if (!(colorSpace instanceof ColorSpace.Rgb)) {
                throw new IllegalArgumentException("The destination color space must use the RGB color model");
            }
            ColorSpace.Rgb rgbColorSpace = (ColorSpace.Rgb)colorSpace;
            if (rgbColorSpace.getTransferParameters() == null) {
                throw new IllegalArgumentException("The destination color space must use an ICC parametric transfer function");
            }
        }
    }

    @NonNull
    public static Bitmap decodeFile(@NonNull File file) throws IOException {
        return BitmapFactory.decodeFile(file, null);
    }

    @NonNull
    public static Bitmap decodeFile(@NonNull File file, @Nullable Options opts) throws IOException {
        Bitmap bm;
        BitmapFactory.validate(opts);
        if (opts != null && opts.inDecodeMimeType) {
            BitmapFactory.decodeMimeType(opts, file);
        }
        try (FileInputStream stream = new FileInputStream(file);){
            bm = BitmapFactory.decodeSeekableChannel(stream.getChannel(), opts, false);
        }
        assert (bm != null);
        return bm;
    }

    public static void decodeFileInfo(@NonNull File file, @NonNull Options opts) throws IOException {
        if (opts.inDecodeMimeType) {
            BitmapFactory.decodeMimeType(opts, file);
        }
        try (FileInputStream stream = new FileInputStream(file);){
            BitmapFactory.decodeSeekableChannel(stream.getChannel(), opts, true);
        }
    }

    @NonNull
    public static Bitmap decodePath(@NonNull Path path) throws IOException {
        return BitmapFactory.decodePath(path, null);
    }

    @NonNull
    public static Bitmap decodePath(@NonNull Path path, @Nullable Options opts) throws IOException {
        Bitmap bm;
        BitmapFactory.validate(opts);
        if (opts != null && opts.inDecodeMimeType) {
            BitmapFactory.decodeMimeType(opts, path.toFile());
        }
        try (FileChannel channel = FileChannel.open(path, StandardOpenOption.READ);){
            bm = BitmapFactory.decodeSeekableChannel(channel, opts, false);
        }
        assert (bm != null);
        return bm;
    }

    public static void decodePathInfo(@NonNull Path path, @NonNull Options opts) throws IOException {
        if (opts.inDecodeMimeType) {
            BitmapFactory.decodeMimeType(opts, path.toFile());
        }
        try (FileChannel channel = FileChannel.open(path, StandardOpenOption.READ);){
            BitmapFactory.decodeSeekableChannel(channel, opts, true);
        }
    }

    @NonNull
    public static Bitmap decodeStream(@NonNull InputStream stream) throws IOException {
        return BitmapFactory.decodeStream(stream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static Bitmap decodeStream(@NonNull InputStream stream, @Nullable Options opts) throws IOException {
        Bitmap bm;
        BitmapFactory.validate(opts);
        if (stream.getClass() == FileInputStream.class) {
            FileChannel ch = ((FileInputStream)stream).getChannel();
            if (opts != null && opts.inDecodeMimeType) {
                long pos = ch.position();
                BitmapFactory.decodeMimeType(opts, stream);
                ch.position(pos);
            }
            bm = BitmapFactory.decodeSeekableChannel(ch, opts, false);
        } else {
            ByteBuffer p2 = null;
            try {
                p2 = Core.readIntoNativeBuffer(stream);
                bm = BitmapFactory.decodeBuffer(p2.rewind(), opts);
            }
            finally {
                MemoryUtil.memFree((Buffer)p2);
            }
        }
        assert (bm != null);
        return bm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeStreamInfo(@NonNull InputStream stream, @NonNull Options opts) throws IOException {
        if (stream.getClass() == FileInputStream.class) {
            FileChannel ch = ((FileInputStream)stream).getChannel();
            if (opts.inDecodeMimeType) {
                long pos = ch.position();
                BitmapFactory.decodeMimeType(opts, stream);
                ch.position(pos);
            }
            BitmapFactory.decodeSeekableChannel(ch, opts, true);
        } else {
            ByteBuffer p2 = null;
            try {
                p2 = Core.readIntoNativeBuffer(stream);
                BitmapFactory.decodeBufferInfo(p2.rewind(), opts);
            }
            finally {
                MemoryUtil.memFree((Buffer)p2);
            }
        }
    }

    @NonNull
    public static Bitmap decodeChannel(@NonNull ReadableByteChannel channel) throws IOException {
        return BitmapFactory.decodeChannel(channel, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static Bitmap decodeChannel(@NonNull ReadableByteChannel channel, @Nullable Options opts) throws IOException {
        Bitmap bm;
        BitmapFactory.validate(opts);
        if (channel instanceof SeekableByteChannel) {
            SeekableByteChannel ch = (SeekableByteChannel)channel;
            if (opts != null && opts.inDecodeMimeType) {
                long pos = ch.position();
                BitmapFactory.decodeMimeType(opts, Channels.newInputStream(channel));
                ch.position(pos);
            }
            bm = BitmapFactory.decodeSeekableChannel(ch, opts, false);
        } else {
            ByteBuffer p2 = null;
            try {
                p2 = Core.readIntoNativeBuffer(channel);
                bm = BitmapFactory.decodeBuffer(p2.rewind(), opts);
            }
            finally {
                MemoryUtil.memFree((Buffer)p2);
            }
        }
        assert (bm != null);
        return bm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeChannelInfo(@NonNull ReadableByteChannel channel, @NonNull Options opts) throws IOException {
        if (channel instanceof SeekableByteChannel) {
            SeekableByteChannel ch = (SeekableByteChannel)channel;
            if (opts.inDecodeMimeType) {
                long pos = ch.position();
                BitmapFactory.decodeMimeType(opts, Channels.newInputStream(channel));
                ch.position(pos);
            }
            BitmapFactory.decodeSeekableChannel(ch, opts, true);
        } else {
            ByteBuffer p2 = null;
            try {
                p2 = Core.readIntoNativeBuffer(channel);
                BitmapFactory.decodeBufferInfo(p2.rewind(), opts);
            }
            finally {
                MemoryUtil.memFree((Buffer)p2);
            }
        }
    }

    @NonNull
    public static Bitmap decodeByteArray(byte[] data, int offset, int length) throws IOException {
        return Objects.requireNonNull(BitmapFactory.decodeByteArray(data, offset, length, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static Bitmap decodeByteArray(byte[] data, int offset, int length, @Nullable Options opts) throws IOException {
        Bitmap bm;
        if ((offset | length) < 0 || data.length < offset + length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        BitmapFactory.validate(opts);
        if (opts != null && opts.inDecodeMimeType) {
            BitmapFactory.decodeMimeType(opts, new ByteArrayInputStream(data, offset, length));
        }
        ByteBuffer p2 = null;
        try {
            p2 = MemoryUtil.memAlloc((int)length);
            bm = BitmapFactory.decodeBuffer0(p2.put(data, offset, length).rewind(), opts);
        }
        finally {
            MemoryUtil.memFree((Buffer)p2);
        }
        return bm;
    }

    @ApiStatus.Internal
    @NonNull
    public static Bitmap decodeBuffer(@NonNull ByteBuffer buffer, @Nullable Options opts) throws IOException {
        BitmapFactory.validate(opts);
        assert (buffer.isDirect() && !buffer.isReadOnly());
        if (opts != null && opts.inDecodeMimeType) {
            byte[] seek = new byte[Math.min(buffer.limit(), 96)];
            buffer.get(0, seek, 0, seek.length);
            BitmapFactory.decodeMimeType(opts, new ByteArrayInputStream(seek));
        }
        return BitmapFactory.decodeBuffer0(buffer, opts);
    }

    @ApiStatus.Internal
    public static void decodeBufferInfo(@NonNull ByteBuffer buffer, @NonNull Options opts) throws IOException {
        assert (buffer.isDirect() && !buffer.isReadOnly());
        long buf = MemoryUtil.memAddress((ByteBuffer)buffer);
        int len = buffer.remaining();
        if (opts.inDecodeMimeType) {
            byte[] seek = new byte[Math.min(len, 96)];
            buffer.get(buffer.position(), seek, 0, seek.length);
            BitmapFactory.decodeMimeType(opts, new ByteArrayInputStream(seek));
        }
        boolean isHDR = STBImage.nstbi_is_hdr_from_memory((long)buf, (int)len) != 0;
        boolean isU16 = !isHDR && STBImage.nstbi_is_16_bit_from_memory((long)buf, (int)len) != 0;
        BitmapFactory.decodeInfo0(0L, 0L, buf, len, opts, isU16, isHDR);
    }

    @NonNull
    private static Bitmap decodeBuffer0(@NonNull ByteBuffer buffer, @Nullable Options opts) throws IOException {
        boolean isHDR;
        boolean isU16;
        long buf = MemoryUtil.memAddress((ByteBuffer)buffer);
        int len = buffer.remaining();
        if (opts != null && opts.inPreferredFormat != null) {
            isU16 = opts.inPreferredFormat.isChannelU16();
            isHDR = opts.inPreferredFormat.isChannelHDR();
        } else {
            isHDR = STBImage.nstbi_is_hdr_from_memory((long)buf, (int)len) != 0;
            isU16 = !isHDR && STBImage.nstbi_is_16_bit_from_memory((long)buf, (int)len) != 0;
        }
        return BitmapFactory.decode0(0L, 0L, buf, len, opts, isU16, isHDR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static long get_io_callbacks() {
        if (g_io_callbacks != null) return g_io_callbacks.address();
        Class<BitmapFactory> clazz = BitmapFactory.class;
        synchronized (BitmapFactory.class) {
            if (g_io_callbacks != null) return g_io_callbacks.address();
            STBIReadCallback readcb = new STBIReadCallback(){

                public int invoke(long user, long data, int size) {
                    int n2;
                    SeekableContext ctx = (SeekableContext)MemoryUtil.memGlobalRefToObject((long)user);
                    if (ctx.eof) {
                        return 0;
                    }
                    try {
                        n2 = ctx.channel.read(STBIReadCallback.getData((long)data, (int)size));
                    }
                    catch (IOException e) {
                        ctx.ioe = e;
                        ctx.eof = true;
                        return 0;
                    }
                    if (n2 < 0) {
                        ctx.eof = true;
                        return 0;
                    }
                    return n2;
                }
            };
            STBISkipCallback skipcb = new STBISkipCallback(){

                public void invoke(long user, int n2) {
                    SeekableContext ctx = (SeekableContext)MemoryUtil.memGlobalRefToObject((long)user);
                    if (ctx.eof) {
                        return;
                    }
                    try {
                        ctx.channel.position(ctx.channel.position() + (long)n2);
                    }
                    catch (IOException e) {
                        ctx.ioe = e;
                        ctx.eof = true;
                    }
                }
            };
            STBIEOFCallback eofcb = new STBIEOFCallback(){

                public int invoke(long user) {
                    SeekableContext ctx = (SeekableContext)MemoryUtil.memGlobalRefToObject((long)user);
                    return ctx.eof ? 1 : 0;
                }
            };
            g_io_callbacks = STBIIOCallbacks.malloc().set((STBIReadCallbackI)readcb, (STBISkipCallbackI)skipcb, (STBIEOFCallbackI)eofcb);
            // ** MonitorExit[var0] (shouldn't be in output)
            return g_io_callbacks.address();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Bitmap decodeSeekableChannel(@NonNull SeekableByteChannel channel, @Nullable Options opts, boolean info) throws IOException {
        long callbacks = BitmapFactory.get_io_callbacks();
        SeekableContext context = new SeekableContext(channel);
        long user = JNINativeInterface.NewGlobalRef((Object)context);
        try {
            boolean isHDR;
            boolean isU16;
            if (!info && opts != null && opts.inPreferredFormat != null) {
                isU16 = opts.inPreferredFormat.isChannelU16();
                isHDR = opts.inPreferredFormat.isChannelHDR();
            } else {
                long start = channel.position();
                isHDR = STBImage.nstbi_is_hdr_from_callbacks((long)callbacks, (long)user) != 0;
                channel.position(start);
                if (isHDR) {
                    isU16 = false;
                } else {
                    isU16 = STBImage.nstbi_is_16_bit_from_callbacks((long)callbacks, (long)user) != 0;
                    channel.position(start);
                }
            }
            if (info) {
                assert (opts != null);
                BitmapFactory.decodeInfo0(callbacks, user, 0L, 0, opts, isU16, isHDR);
                Bitmap bitmap = null;
                return bitmap;
            }
            Bitmap bitmap = BitmapFactory.decode0(callbacks, user, 0L, 0, opts, isU16, isHDR);
            return bitmap;
        }
        finally {
            JNINativeInterface.DeleteGlobalRef((long)user);
        }
    }

    @NonNull
    private static Bitmap decode0(long callbacks, long context, long buffer, int length, @Nullable Options opts, boolean isU16, boolean isHDR) throws IOException {
        assert (callbacks != 0L || buffer != 0L);
        Bitmap.Format requiredFormat = null;
        if (opts != null && opts.inPreferredFormat != null) {
            requiredFormat = opts.inPreferredFormat;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            ColorSpace cs;
            int requiredChannels;
            long pOuts = stack.nmalloc(4, 12);
            int n2 = requiredChannels = requiredFormat != null ? requiredFormat.getChannels() : 0;
            long address = callbacks != 0L ? (isHDR ? STBImage.nstbi_loadf_from_callbacks((long)callbacks, (long)context, (long)pOuts, (long)(pOuts + 4L), (long)(pOuts + 8L), (int)requiredChannels) : (isU16 ? STBImage.nstbi_load_16_from_callbacks((long)callbacks, (long)context, (long)pOuts, (long)(pOuts + 4L), (long)(pOuts + 8L), (int)requiredChannels) : STBImage.nstbi_load_from_callbacks((long)callbacks, (long)context, (long)pOuts, (long)(pOuts + 4L), (long)(pOuts + 8L), (int)requiredChannels))) : (isHDR ? STBImage.nstbi_loadf_from_memory((long)buffer, (int)length, (long)pOuts, (long)(pOuts + 4L), (long)(pOuts + 8L), (int)requiredChannels) : (isU16 ? STBImage.nstbi_load_16_from_memory((long)buffer, (int)length, (long)pOuts, (long)(pOuts + 4L), (long)(pOuts + 8L), (int)requiredChannels) : STBImage.nstbi_load_from_memory((long)buffer, (int)length, (long)pOuts, (long)(pOuts + 4L), (long)(pOuts + 8L), (int)requiredChannels)));
            if (address == 0L) {
                throw new IOException("Failed to decode image: " + STBImage.stbi_failure_reason());
            }
            if (callbacks != 0L && context != 0L) {
                SeekableContext ctx = (SeekableContext)MemoryUtil.memGlobalRefToObject((long)context);
                if (ctx.ioe != null) {
                    throw new IOException("Failed to read image", ctx.ioe);
                }
            }
            int width = MemoryUtil.memGetInt((long)pOuts);
            int height = MemoryUtil.memGetInt((long)(pOuts + 4L));
            int channels_in_file = MemoryUtil.memGetInt((long)(pOuts + 8L));
            Bitmap.Format format = requiredFormat != null ? requiredFormat : Bitmap.Format.get(channels_in_file, isU16, isHDR);
            ColorSpace colorSpace = cs = isHDR ? ColorSpace.get(ColorSpace.Named.LINEAR_EXTENDED_SRGB) : ColorSpace.get(ColorSpace.Named.SRGB);
            if (opts != null) {
                opts.outWidth = width;
                opts.outHeight = height;
                opts.outFormat = format;
                opts.outColorSpace = cs;
            }
            int at = !isHDR && (channels_in_file == 2 || channels_in_file == 4) && format.hasAlpha() ? 3 : 1;
            Bitmap bitmap = new Bitmap(format, ImageInfo.make(width, height, format.getColorType(), at, cs), address, width * format.getBytesPerPixel(), STBImage::nstbi_image_free);
            if (opts == null || opts.inImmutable) {
                bitmap.setImmutable();
            }
            Bitmap bitmap2 = bitmap;
            return bitmap2;
        }
    }

    private static void decodeInfo0(long callbacks, long context, long buffer, int length, @NonNull Options opts, boolean isU16, boolean isHDR) throws IOException {
        assert (callbacks != 0L || buffer != 0L);
        try (MemoryStack stack = MemoryStack.stackPush();){
            boolean success;
            long pOuts = stack.nmalloc(4, 12);
            if (callbacks != 0L) {
                success = STBImage.nstbi_info_from_callbacks((long)callbacks, (long)context, (long)pOuts, (long)(pOuts + 4L), (long)(pOuts + 8L)) != 0;
            } else {
                boolean bl = success = STBImage.nstbi_info_from_memory((long)buffer, (int)length, (long)pOuts, (long)(pOuts + 4L), (long)(pOuts + 8L)) != 0;
            }
            if (!success) {
                throw new IOException("Failed to decode image: " + STBImage.stbi_failure_reason());
            }
            if (callbacks != 0L && context != 0L) {
                SeekableContext ctx = (SeekableContext)MemoryUtil.memGlobalRefToObject((long)context);
                if (ctx.ioe != null) {
                    throw new IOException("Failed to read image", ctx.ioe);
                }
            }
            int width = MemoryUtil.memGetInt((long)pOuts);
            int height = MemoryUtil.memGetInt((long)(pOuts + 4L));
            int channels_in_file = MemoryUtil.memGetInt((long)(pOuts + 8L));
            Bitmap.Format format = Bitmap.Format.get(channels_in_file, isU16, isHDR);
            ColorSpace cs = isHDR ? ColorSpace.get(ColorSpace.Named.LINEAR_EXTENDED_SRGB) : ColorSpace.get(ColorSpace.Named.SRGB);
            opts.outWidth = width;
            opts.outHeight = height;
            opts.outFormat = format;
            opts.outColorSpace = cs;
        }
    }

    @ApiStatus.Internal
    public static void decodeMimeType(@NonNull Options opts, @NonNull Object input) {
        try (ImageInputStream stream = ImageIO.createImageInputStream(input);){
            if (stream != null) {
                String[] mimeTypes;
                Iterator<ImageReader> readers = ImageIO.getImageReaders(stream);
                if (readers.hasNext() && (mimeTypes = readers.next().getOriginatingProvider().getMIMETypes()) != null) {
                    opts.outMimeType = mimeTypes[0];
                    return;
                }
                if (BitmapFactory.test(stream, BitmapFactory::filterPSD)) {
                    opts.outMimeType = "image/vnd.adobe.photoshop";
                } else if (BitmapFactory.test(stream, BitmapFactory::filterPIC)) {
                    opts.outMimeType = "image/x-pict";
                } else if (BitmapFactory.test(stream, BitmapFactory::filterPGM)) {
                    opts.outMimeType = "image/x-portable-graymap";
                } else if (BitmapFactory.test(stream, BitmapFactory::filterPPM)) {
                    opts.outMimeType = "image/x-portable-pixmap";
                } else if (BitmapFactory.test(stream, BitmapFactory::filterHDR)) {
                    opts.outMimeType = "image/vnd.radiance";
                } else if (BitmapFactory.test(stream, BitmapFactory::filterTGA)) {
                    opts.outMimeType = "image/x-tga";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @ApiStatus.Internal
    public static boolean test(@NonNull ImageInputStream stream, @NonNull Predicate<ImageInputStream> filter) {
        boolean bl;
        stream.mark();
        try {
            bl = filter.test(stream);
        }
        catch (Throwable throwable) {
            try {
                stream.reset();
                throw throwable;
            }
            catch (Exception e) {
                return false;
            }
        }
        stream.reset();
        return bl;
    }

    @ApiStatus.Internal
    public static boolean filterPSD(@NonNull ImageInputStream stream) {
        try {
            return stream.read() == 56 && stream.read() == 66 && stream.read() == 80 && stream.read() == 83;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean filterPIC(@NonNull ImageInputStream stream) {
        try {
            if (stream.read() != 83 || stream.read() != 128 || stream.read() != 246 || stream.read() != 52) {
                return false;
            }
            stream.seek(stream.getStreamPosition() + 84L);
            return stream.read() == 80 && stream.read() == 73 && stream.read() == 67 && stream.read() == 84;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @ApiStatus.Internal
    public static boolean filterPGM(@NonNull ImageInputStream stream) {
        try {
            return stream.read() == 80 && stream.read() == 53;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @ApiStatus.Internal
    public static boolean filterPPM(@NonNull ImageInputStream stream) {
        try {
            return stream.read() == 80 && stream.read() == 54;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @ApiStatus.Internal
    public static boolean filterHDR(@NonNull ImageInputStream stream) {
        try {
            return stream.read() == 35 && stream.read() == 63 && stream.read() == 82 && stream.read() == 65 && stream.read() == 68 && stream.read() == 73 && stream.read() == 65 && stream.read() == 78 && stream.read() == 67 && stream.read() == 69 && stream.read() == 10;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @ApiStatus.Internal
    public static boolean filterTGA(@NonNull ImageInputStream stream) {
        try {
            stream.read();
            int color_map_type = stream.read();
            if (color_map_type != 0 && color_map_type != 1) {
                return false;
            }
            int data_type_code = stream.read();
            if (color_map_type == 1) {
                if (data_type_code != 1 && data_type_code != 9) {
                    return false;
                }
                stream.readInt();
                int color_map_depth = stream.read();
                if (color_map_depth != 16 && color_map_depth != 24 && color_map_depth != 32) {
                    return false;
                }
            } else {
                if (data_type_code != 2 && data_type_code != 3 && data_type_code != 10 && data_type_code != 11) {
                    return false;
                }
                stream.readInt();
                stream.read();
            }
            stream.readInt();
            stream.readInt();
            int bits_per_pixel = stream.read();
            if (color_map_type == 1 && bits_per_pixel != 8 && bits_per_pixel != 16) {
                return false;
            }
            return bits_per_pixel == 16 || bits_per_pixel == 24 || bits_per_pixel == 32;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Options {
        public boolean inImmutable = true;
        public boolean inDecodeMimeType = false;
        public Bitmap.Format inPreferredFormat = null;
        public ColorSpace inPreferredColorSpace = null;
        public int outWidth;
        public int outHeight;
        public String outMimeType;
        public Bitmap.Format outFormat;
        public ColorSpace outColorSpace;
    }

    static class SeekableContext {
        boolean eof = false;
        IOException ioe = null;
        final SeekableByteChannel channel;

        SeekableContext(SeekableByteChannel channel) {
            this.channel = channel;
        }
    }
}

