/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.graphics;

import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.graphics.annotation.ColorInt;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.annotation.Size;
import yslelf.cloudpick.graphics.graphics.BlendMode;
import yslelf.cloudpick.graphics.graphics.CustomDrawable;
import yslelf.cloudpick.graphics.graphics.Image;
import yslelf.cloudpick.graphics.graphics.Matrix;
import yslelf.cloudpick.graphics.graphics.Paint;
import yslelf.cloudpick.graphics.graphics.PointF;
import yslelf.cloudpick.graphics.graphics.Rect;
import yslelf.cloudpick.graphics.graphics.RectF;
import yslelf.cloudpick.graphics.graphics.text.Font;
import yslelf.cloudpick.graphics.graphics.text.OutlineFont;
import yslelf.cloudpick.graphics.graphics.text.ShapedText;
import yslelf.cloudpick.render.core.Matrix4;
import yslelf.cloudpick.render.core.TextBlob;

public abstract class Canvas {
    public static final Marker MARKER = MarkerManager.getMarker((String)"Canvas");

    protected Canvas() {
    }

    public abstract int save();

    @Deprecated
    public final int saveLayer(@Nullable RectF bounds, int alpha) {
        if (bounds == null) {
            return this.saveLayer(0.0f, 0.0f, 32768.0f, 32768.0f, alpha);
        }
        return this.saveLayer(bounds.left, bounds.top, bounds.right, bounds.bottom, alpha);
    }

    @Deprecated
    public abstract int saveLayer(float var1, float var2, float var3, float var4, int var5);

    public abstract void restore();

    public abstract int getSaveCount();

    public abstract void restoreToCount(int var1);

    public abstract void translate(float var1, float var2);

    public abstract void translate(float var1, float var2, float var3);

    public abstract void scale(float var1, float var2);

    public abstract void scale(float var1, float var2, float var3);

    public abstract void scale(float var1, float var2, float var3, float var4);

    public abstract void rotate(float var1);

    public abstract void rotate(float var1, float var2, float var3);

    public final void skew(float sx, float sy) {
        this.shear(sx, sy);
    }

    public final void skew(float sx, float sy, float px, float py) {
        this.shear(sx, sy, px, py);
    }

    public abstract void shear(float var1, float var2);

    public abstract void shear(float var1, float var2, float var3, float var4);

    public abstract void concat(@NonNull Matrix var1);

    @ApiStatus.Experimental
    public abstract void concat(@NonNull Matrix4 var1);

    @Deprecated
    @ApiStatus.Internal
    @NonNull
    public Matrix4 getMatrix() {
        return new Matrix4();
    }

    public final boolean clipRect(@NonNull Rect rect) {
        return this.clipRect(rect.left, rect.top, rect.right, rect.bottom);
    }

    public final boolean clipRect(@NonNull RectF rect) {
        return this.clipRect(rect.left, rect.top, rect.right, rect.bottom);
    }

    public abstract boolean clipRect(float var1, float var2, float var3, float var4);

    public final boolean clipOutRect(@NonNull Rect rect) {
        return this.clipOutRect(rect.left, rect.top, rect.right, rect.bottom);
    }

    public final boolean clipOutRect(@NonNull RectF rect) {
        return this.clipOutRect(rect.left, rect.top, rect.right, rect.bottom);
    }

    public abstract boolean clipOutRect(float var1, float var2, float var3, float var4);

    public final boolean quickReject(@NonNull RectF rect) {
        return this.quickReject(rect.left, rect.top, rect.right, rect.bottom);
    }

    public abstract boolean quickReject(float var1, float var2, float var3, float var4);

    public abstract boolean getLocalClipBounds(@NonNull RectF var1);

    public final void clear(@ColorInt int color) {
        this.drawColor(color, BlendMode.SRC);
    }

    public final void clear(float r, float g, float b, float a) {
        this.drawColor(r, g, b, a, BlendMode.SRC);
    }

    public final void drawColor(@ColorInt int color) {
        this.drawColor(color, BlendMode.SRC_OVER);
    }

    public final void drawColor(float r, float g, float b, float a) {
        this.drawColor(r, g, b, a, BlendMode.SRC_OVER);
    }

    public abstract void drawColor(@ColorInt int var1, @NonNull BlendMode var2);

    public abstract void drawColor(float var1, float var2, float var3, float var4, @NonNull BlendMode var5);

    public abstract void drawPaint(@NonNull Paint var1);

    public abstract void drawPoint(float var1, float var2, @NonNull Paint var3);

    public final void drawPoint(@NonNull PointF p2, @NonNull Paint paint) {
        this.drawPoint(p2.x, p2.y, paint);
    }

    public abstract void drawPoints(@Size(multiple=2L) @NonNull float[] var1, int var2, int var3, @NonNull Paint var4);

    public final void drawPoints(@Size(multiple=2L) @NonNull float[] pts, @NonNull Paint paint) {
        this.drawPoints(pts, 0, pts.length, paint);
    }

    public abstract void drawLine(float var1, float var2, float var3, float var4, @NonNull Paint var5);

    public final void drawLine(@NonNull PointF p0, @NonNull PointF p1, @NonNull Paint paint) {
        this.drawLine(p0.x, p0.y, p1.x, p1.y, paint);
    }

    public abstract void drawLine(float var1, float var2, float var3, float var4, @NonNull Paint.Cap var5, float var6, @NonNull Paint var7);

    public final void drawLine(float x0, float y0, float x1, float y1, float thickness, @NonNull Paint paint) {
        this.drawLine(x0, y0, x1, y1, Paint.Cap.ROUND, thickness, paint);
    }

    public final void drawLine(@NonNull PointF p0, @NonNull PointF p1, float thickness, @NonNull Paint paint) {
        this.drawLine(p0.x, p0.y, p1.x, p1.y, thickness, paint);
    }

    public abstract void drawLines(@Size(multiple=2L) @NonNull float[] var1, int var2, int var3, boolean var4, @NonNull Paint var5);

    @Deprecated
    public void drawRoundLines(float[] pts, int offset, int count, boolean strip, Paint paint) {
        this.drawLines(pts, offset, count, strip, paint);
    }

    public final void drawRect(@NonNull RectF r, @NonNull Paint paint) {
        this.drawRect(r.left, r.top, r.right, r.bottom, paint);
    }

    public final void drawRect(@NonNull Rect r, @NonNull Paint paint) {
        this.drawRect(r.left, r.top, r.right, r.bottom, paint);
    }

    public abstract void drawRect(float var1, float var2, float var3, float var4, @NonNull Paint var5);

    @ApiStatus.Experimental
    public abstract void drawRectGradient(float var1, float var2, float var3, float var4, int var5, int var6, int var7, int var8, Paint var9);

    public final void drawRoundRect(@NonNull RectF rect, float radius, @NonNull Paint paint) {
        this.drawRoundRect(rect.left, rect.top, rect.right, rect.bottom, radius, paint);
    }

    public abstract void drawRoundRect(float var1, float var2, float var3, float var4, float var5, @NonNull Paint var6);

    public final void drawRoundRect(@NonNull RectF rect, float radius, int sides, @NonNull Paint paint) {
        this.drawRoundRect(rect.left, rect.top, rect.right, rect.bottom, radius, sides, paint);
    }

    public abstract void drawRoundRect(float var1, float var2, float var3, float var4, float var5, int var6, @NonNull Paint var7);

    public final void drawRoundRect(@NonNull RectF rect, float topLeftRadius, float topRightRadius, float bottomRightRadius, float bottomLeftRadius, @NonNull Paint paint) {
        this.drawRoundRect(rect.left, rect.top, rect.right, rect.bottom, topLeftRadius, topRightRadius, bottomRightRadius, bottomLeftRadius, paint);
    }

    public abstract void drawRoundRect(float var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8, @NonNull Paint var9);

    @ApiStatus.Experimental
    public abstract void drawRoundRectGradient(float var1, float var2, float var3, float var4, int var5, int var6, int var7, int var8, float var9, Paint var10);

    public abstract void drawCircle(float var1, float var2, float var3, @NonNull Paint var4);

    public final void drawCircle(@NonNull PointF center, float radius, @NonNull Paint paint) {
        this.drawCircle(center.x, center.y, radius, paint);
    }

    public abstract void drawArc(float var1, float var2, float var3, float var4, float var5, @NonNull Paint var6);

    public final void drawArc(@NonNull PointF center, float radius, float startAngle, float sweepAngle, @NonNull Paint paint) {
        this.drawArc(center.x, center.y, radius, startAngle, sweepAngle, paint);
    }

    public abstract void drawArc(float var1, float var2, float var3, float var4, float var5, @NonNull Paint.Cap var6, float var7, @NonNull Paint var8);

    public abstract void drawPie(float var1, float var2, float var3, float var4, float var5, @NonNull Paint var6);

    public final void drawPie(@NonNull PointF center, float radius, float startAngle, float sweepAngle, @NonNull Paint paint) {
        this.drawPie(center.x, center.y, radius, startAngle, sweepAngle, paint);
    }

    public abstract void drawChord(float var1, float var2, float var3, float var4, float var5, @NonNull Paint var6);

    public final void drawChord(@NonNull PointF center, float radius, float startAngle, float sweepAngle, @NonNull Paint paint) {
        this.drawChord(center.x, center.y, radius, startAngle, sweepAngle, paint);
    }

    @Deprecated
    public abstract void drawBezier(float var1, float var2, float var3, float var4, float var5, float var6, Paint var7);

    @Deprecated
    public final void drawBezier(PointF p0, PointF p1, PointF p2, Paint paint) {
        this.drawBezier(p0.x, p0.y, p1.x, p1.y, p2.x, p2.y, paint);
    }

    public abstract void drawImage(Image var1, float var2, float var3, @Nullable Paint var4);

    public final void drawImage(Image image, @Nullable Rect src, @NonNull Rect dst, @Nullable Paint paint) {
        if (image == null) {
            return;
        }
        if (src == null) {
            this.drawImage(image, 0.0f, 0.0f, image.getWidth(), image.getHeight(), dst.left, dst.top, dst.right, dst.bottom, paint);
        } else {
            this.drawImage(image, src.left, src.top, src.right, src.bottom, dst.left, dst.top, dst.right, dst.bottom, paint);
        }
    }

    public final void drawImage(Image image, @Nullable Rect src, @NonNull RectF dst, @Nullable Paint paint) {
        if (image == null) {
            return;
        }
        if (src == null) {
            this.drawImage(image, 0.0f, 0.0f, image.getWidth(), image.getHeight(), dst.left, dst.top, dst.right, dst.bottom, paint);
        } else {
            this.drawImage(image, src.left, src.top, src.right, src.bottom, dst.left, dst.top, dst.right, dst.bottom, paint);
        }
    }

    public abstract void drawImage(Image var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, @Nullable Paint var10);

    @Deprecated
    public abstract void drawRoundImage(Image var1, float var2, float var3, float var4, @Nullable Paint var5);

    public abstract void drawGlyphs(@NonNull int[] var1, int var2, @NonNull float[] var3, int var4, int var5, @NonNull Font var6, float var7, float var8, @NonNull Paint var9);

    @ApiStatus.Experimental
    public abstract void drawTextBlob(TextBlob var1, float var2, float var3, @NonNull Paint var4);

    public final void drawShapedText(@NonNull ShapedText text, float x, float y, @NonNull Paint paint) {
        this.drawTextBlob(text.getTextBlob(), x, y, paint);
    }

    public final void drawSimpleText(@NonNull char[] text, @NonNull Font font, float x, float y, @NonNull Paint paint) {
        if (text.length == 0) {
            return;
        }
        if (font instanceof OutlineFont) {
            OutlineFont outlineFont = (OutlineFont)font;
            java.awt.Font face = outlineFont.chooseFont(paint);
            FontRenderContext frc = OutlineFont.getFontRenderContext(paint);
            GlyphVector gv = face.createGlyphVector(frc, text);
            int nGlyphs = gv.getNumGlyphs();
            this.drawGlyphs(gv.getGlyphCodes(0, nGlyphs, null), 0, gv.getGlyphPositions(0, nGlyphs, null), 0, nGlyphs, font, x, y, paint);
        }
    }

    public final void drawSimpleText(@NonNull String text, @NonNull Font font, float x, float y, @NonNull Paint paint) {
        if (!text.isBlank()) {
            this.drawSimpleText(text.toCharArray(), font, x, y, paint);
        }
    }

    public abstract void drawVertices(@NonNull VertexMode var1, int var2, @Size(multiple=2L) @NonNull float[] var3, int var4, @Size(multiple=2L) @Nullable float[] var5, int var6, @Nullable int[] var7, int var8, @Nullable short[] var9, int var10, int var11, @Nullable BlendMode var12, @NonNull Paint var13);

    public abstract void drawMesh(@NonNull VertexMode var1, @NonNull FloatBuffer var2, @Nullable FloatBuffer var3, @Nullable IntBuffer var4, @Nullable ShortBuffer var5, @Nullable BlendMode var6, @NonNull Paint var7);

    public final void drawPointListMesh(@NonNull FloatBuffer pos, @Nullable IntBuffer color, @NonNull Paint paint) {
        this.drawMesh(VertexMode.POINTS, pos, null, color, null, null, paint);
    }

    public final void drawLineListMesh(@NonNull FloatBuffer pos, @Nullable IntBuffer color, @NonNull Paint paint) {
        this.drawMesh(VertexMode.LINES, pos, null, color, null, null, paint);
    }

    public final void drawTriangleListMesh(@NonNull FloatBuffer pos, @Nullable IntBuffer color, @NonNull Paint paint) {
        this.drawMesh(VertexMode.TRIANGLES, pos, null, color, null, null, paint);
    }

    @Deprecated
    public void drawCustomDrawable(@NonNull CustomDrawable drawable, @Nullable Matrix4 matrix) {
    }

    @Deprecated
    public final void drawCustomDrawable(@NonNull CustomDrawable drawable) {
        this.drawCustomDrawable(drawable, null);
    }

    public abstract boolean isClipEmpty();

    public abstract boolean isClipRect();

    public static enum VertexMode {
        POINTS(0),
        LINES(1),
        LINE_STRIP(2),
        TRIANGLES(3),
        TRIANGLE_STRIP(4);

        final int nativeInt;

        private VertexMode(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }
}

