/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.graphics;

import java.nio.FloatBuffer;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL45C;
import yslelf.cloudpick.graphics.core.Core;
import yslelf.cloudpick.render.core.RefCnt;
import yslelf.cloudpick.render.engine.ImmediateContext;
import yslelf.cloudpick.render.opengl.GLBackendFormat;
import yslelf.cloudpick.render.opengl.GLDevice;
import yslelf.cloudpick.render.opengl.GLRenderbuffer;
import yslelf.cloudpick.render.opengl.GLTexture;

@Deprecated
public final class GLSurface
implements AutoCloseable {
    public static final int NUM_RENDER_TARGETS = 3;
    private final FloatBuffer mClearColor = BufferUtils.createFloatBuffer((int)4);
    private final GLTexture[] mColorAttachments = new GLTexture[3];
    private GLRenderbuffer mStencilAttachment;
    private int mBackingWidth;
    private int mBackingHeight;
    private int mFramebuffer;

    public int get() {
        if (this.mFramebuffer == 0) {
            this.mFramebuffer = GL45C.glGenFramebuffers();
        }
        return this.mFramebuffer;
    }

    public void bind() {
        GL45C.glBindFramebuffer((int)36160, (int)this.get());
    }

    public void bindDraw() {
        GL45C.glBindFramebuffer((int)36009, (int)this.get());
    }

    public void bindRead() {
        GL45C.glBindFramebuffer((int)36008, (int)this.get());
    }

    public void clearColorBuffer() {
        GL45C.glClearBufferfv((int)6144, (int)0, (FloatBuffer)this.mClearColor);
    }

    public void clearStencilBuffer() {
        GL45C.glClearBufferfi((int)34041, (int)0, (float)1.0f, (int)0);
    }

    public void setDrawBuffer(int buffer) {
        GL45C.glDrawBuffer((int)buffer);
    }

    public void setReadBuffer(int buffer) {
        GL45C.glReadBuffer((int)buffer);
    }

    public int getBackingWidth() {
        return this.mBackingWidth;
    }

    public int getBackingHeight() {
        return this.mBackingHeight;
    }

    @Nonnull
    public GLTexture getAttachedTexture(int attachment) {
        return Objects.requireNonNull(this.mColorAttachments[attachment - 36064]);
    }

    public void makeBuffers(int width, int height, boolean exact) {
        if (width <= 0 || height <= 0) {
            return;
        }
        if (exact ? this.mBackingWidth == width && this.mBackingHeight == height : this.mBackingWidth >= width && this.mBackingHeight >= height) {
            return;
        }
        this.mBackingWidth = width;
        this.mBackingHeight = height;
        ImmediateContext dContext = Core.requireImmediateContext();
        for (int i = 0; i < 3; ++i) {
            if (this.mColorAttachments[i] != null) {
                this.mColorAttachments[i].unref();
            }
            this.mColorAttachments[i] = (GLTexture)dContext.getResourceProvider().createTexture(width, height, GLBackendFormat.make(32856), 1, 1, null);
            Objects.requireNonNull(this.mColorAttachments[i], "Failed to create G-buffer " + i);
            GL45C.glFramebufferTexture((int)36160, (int)(36064 + i), (int)this.mColorAttachments[i].getHandle(), (int)0);
        }
        if (this.mStencilAttachment != null) {
            this.mStencilAttachment.unref();
        }
        this.mStencilAttachment = GLRenderbuffer.makeStencil((GLDevice)dContext.getDevice(), width, height, 1, 36168);
        Objects.requireNonNull(this.mStencilAttachment, "Failed to create depth/stencil");
        GL45C.glFramebufferRenderbuffer((int)36160, (int)36128, (int)36161, (int)this.mStencilAttachment.getHandle());
        int status = GL45C.glCheckFramebufferStatus((int)36160);
        if (status != 36053) {
            throw new IllegalStateException("Framebuffer is not complete: " + status);
        }
    }

    @Override
    public void close() {
        if (this.mFramebuffer != 0) {
            GL45C.glDeleteFramebuffers((int)this.mFramebuffer);
        }
        this.mFramebuffer = 0;
        for (int i = 0; i < 3; ++i) {
            this.mColorAttachments[i] = RefCnt.move(this.mColorAttachments[i]);
        }
        this.mStencilAttachment = RefCnt.move(this.mStencilAttachment);
    }
}

