/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.graphics;

import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.graphics.annotation.ColorInt;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.graphics.Shader;

public abstract class GradientShader
extends Shader {
    @ApiStatus.Internal
    protected static float[] convertColors(@NonNull @ColorInt int[] colors) {
        if (colors.length < 1) {
            throw new IllegalArgumentException("needs >= 1 number of colors");
        }
        if (colors.length > 0x1FFFFFFF) {
            throw new IllegalArgumentException("needs <= 536,870,911 number of colors");
        }
        float[] result = new float[colors.length * 4];
        int i = 0;
        int j = 0;
        while (i < colors.length) {
            int color = colors[i];
            result[j] = (float)(color >> 16 & 0xFF) * 0.003921569f;
            result[j | 1] = (float)(color >> 8 & 0xFF) * 0.003921569f;
            result[j | 2] = (float)(color & 0xFF) * 0.003921569f;
            result[j | 3] = (float)(color >>> 24) * 0.003921569f;
            ++i;
            j += 4;
        }
        return result;
    }

    public static abstract class Builder {
        boolean mInterpolationInPremul = true;
        @NonNull
        InterpolationColorSpace mInterpolationColorSpace = InterpolationColorSpace.DESTINATION;
        @NonNull
        HueInterpolationMethod mHueInterpolationMethod = HueInterpolationMethod.SHORTER;

        public boolean isInterpolationInPremul() {
            return this.mInterpolationInPremul;
        }

        public Builder setInterpolationInPremul(boolean interpolationInPremul) {
            this.mInterpolationInPremul = interpolationInPremul;
            return this;
        }

        @NonNull
        public InterpolationColorSpace getInterpolationColorSpace() {
            return this.mInterpolationColorSpace;
        }

        public Builder setInterpolationColorSpace(@NonNull InterpolationColorSpace interpolationColorSpace) {
            this.mInterpolationColorSpace = interpolationColorSpace;
            return this;
        }

        @NonNull
        public HueInterpolationMethod getHueInterpolationMethod() {
            return this.mHueInterpolationMethod;
        }

        public Builder setHueInterpolationMethod(@NonNull HueInterpolationMethod hueInterpolationMethod) {
            this.mHueInterpolationMethod = hueInterpolationMethod;
            return this;
        }

        @NonNull
        public abstract GradientShader build();
    }

    public static enum HueInterpolationMethod {
        SHORTER(0),
        LONGER(1),
        INCREASING(2),
        DECREASING(3);

        final byte nativeByte;

        private HueInterpolationMethod(byte nativeByte) {
            this.nativeByte = nativeByte;
        }
    }

    public static enum InterpolationColorSpace {
        DESTINATION(0),
        SRGB(1),
        SRGB_LINEAR(2),
        LAB(3),
        OKLAB(4),
        HSL(6),
        HWB(7),
        LCH(8),
        OKLCH(9);

        final byte nativeByte;

        private InterpolationColorSpace(byte nativeByte) {
            this.nativeByte = nativeByte;
        }
    }
}

