/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.graphics;

import java.lang.ref.Cleaner;
import java.lang.ref.Reference;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.core.Core;
import yslelf.cloudpick.graphics.graphics.Bitmap;
import yslelf.cloudpick.graphics.graphics.ImageStore;
import yslelf.cloudpick.render.core.ColorSpace;
import yslelf.cloudpick.render.core.ImageInfo;
import yslelf.cloudpick.render.core.RawPtr;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.engine.RecordingContext;
import yslelf.cloudpick.render.granite.GraniteImage;
import yslelf.cloudpick.render.granite.TextureUtils;

public class Image
implements AutoCloseable {
    public static final int DENSITY_NONE = 0;
    private volatile yslelf.cloudpick.render.core.Image mImage;
    private final Cleaner.Cleanable mCleanup;
    int mDensity = 72;

    private Image(@SharedPtr yslelf.cloudpick.render.core.Image image) {
        this.mCleanup = Core.registerNativeResource((Object)this, image);
        this.mImage = Objects.requireNonNull(image);
    }

    @Nullable
    public static Image createTextureFromBitmap(Bitmap bitmap) {
        if (bitmap == null || bitmap.isClosed()) {
            return null;
        }
        return Image.createTextureFromBitmap(Core.requireUiRecordingContext(), bitmap);
    }

    @ApiStatus.Experimental
    @Nullable
    public static Image createTextureFromBitmap(@NonNull RecordingContext recordingContext, @NonNull Bitmap bitmap) {
        GraniteImage nativeImage;
        recordingContext.checkOwnerThread();
        assert (!bitmap.isClosed());
        try {
            nativeImage = TextureUtils.makeFromPixmap(recordingContext, bitmap.getPixmap(), false, true, "ImageFromBitmap");
        }
        finally {
            Reference.reachabilityFence(bitmap);
        }
        if (nativeImage == null) {
            return null;
        }
        return new Image(nativeImage);
    }

    @Nullable
    public static Image create(@NonNull String namespace, @NonNull String entry) {
        return ImageStore.getInstance().getOrCreate(namespace, "textures/" + entry);
    }

    @ApiStatus.Experimental
    @NonNull
    public ImageInfo getInfo() {
        return this.mImage.getInfo();
    }

    public int getWidth() {
        return this.mImage.getWidth();
    }

    public int getHeight() {
        return this.mImage.getHeight();
    }

    public int getScaledWidth(int targetDensity) {
        return Image.scaleFromDensity(this.getWidth(), this.mDensity, targetDensity);
    }

    public int getScaledHeight(int targetDensity) {
        return Image.scaleFromDensity(this.getHeight(), this.mDensity, targetDensity);
    }

    @ApiStatus.Internal
    public static int scaleFromDensity(int size, int sourceDensity, int targetDensity) {
        if (sourceDensity == 0 || targetDensity == 0 || sourceDensity == targetDensity) {
            return size;
        }
        return (size * targetDensity + (sourceDensity >> 1)) / sourceDensity;
    }

    public int getDensity() {
        return this.mDensity;
    }

    public void setDensity(int density) {
        this.mDensity = density;
    }

    @Nullable
    public ColorSpace getColorSpace() {
        return this.mImage.getColorSpace();
    }

    @Override
    public void close() {
        this.mImage = null;
        this.mCleanup.clean();
    }

    public boolean isClosed() {
        return this.mImage == null;
    }

    @ApiStatus.Internal
    @RawPtr
    public yslelf.cloudpick.render.core.Image getNativeImage() {
        return this.mImage;
    }
}

