/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.graphics;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.core.Core;
import yslelf.cloudpick.graphics.graphics.Image;
import yslelf.cloudpick.graphics.graphics.Matrix;
import yslelf.cloudpick.graphics.graphics.Shader;
import yslelf.cloudpick.render.core.RefCnt;
import yslelf.cloudpick.render.core.SamplingOptions;

public class ImageShader
extends Shader {
    public static final int FILTER_MODE_NEAREST = 0;
    public static final int FILTER_MODE_LINEAR = 1;
    public static final int MIPMAP_MODE_NONE = 0;
    public static final int MIPMAP_MODE_NEAREST = 0;
    public static final int MIPMAP_MODE_LINEAR = 2;
    public static final Object FILTER_POINT = SamplingOptions.POINT;
    public static final Object FILTER_LINEAR = SamplingOptions.LINEAR;
    public static final Object FILTER_CUBIC_BSPLINE = SamplingOptions.CUBIC_BSPLINE;
    public static final Object FILTER_MITCHELL = SamplingOptions.MITCHELL;
    public static final Object FILTER_PHOTOSHOP_BICUBIC = SamplingOptions.PHOTOSHOP_BICUBIC;
    public static final Object FILTER_CATMULLROM = SamplingOptions.CATMULLROM;
    private final Matrix mLocalMatrix;

    public ImageShader(@NonNull Image image, @NonNull Shader.TileMode tileModeX, @NonNull Shader.TileMode tileModeY, int filter, @Nullable Matrix localMatrix) {
        this(image, tileModeX, tileModeY, SamplingOptions.make(filter), localMatrix);
    }

    public ImageShader(@NonNull Image image, @NonNull Shader.TileMode tileModeX, @NonNull Shader.TileMode tileModeY, int filter, int mipmap, @Nullable Matrix localMatrix) {
        this(image, tileModeX, tileModeY, SamplingOptions.make(filter, mipmap), localMatrix);
    }

    public ImageShader(@NonNull Image image, @NonNull Shader.TileMode tileModeX, @NonNull Shader.TileMode tileModeY, @NonNull Object filter, @Nullable Matrix localMatrix) {
        this(image, tileModeX, tileModeY, filter instanceof Integer ? SamplingOptions.make((Integer)filter) : (SamplingOptions)filter, localMatrix);
    }

    private ImageShader(@NonNull Image image, @NonNull Shader.TileMode tileModeX, @NonNull Shader.TileMode tileModeY, @NonNull SamplingOptions sampling, @Nullable Matrix localMatrix) {
        yslelf.cloudpick.render.core.shaders.Shader shader = yslelf.cloudpick.render.core.shaders.ImageShader.make(RefCnt.create(image.getNativeImage()), tileModeX.nativeInt, tileModeY.nativeInt, sampling, localMatrix);
        if (shader == null) {
            throw new IllegalArgumentException();
        }
        this.mLocalMatrix = localMatrix != null && !localMatrix.isIdentity() ? new Matrix(localMatrix) : null;
        this.mCleanup = Core.registerNativeResource((Object)this, shader);
        this.mShader = shader;
    }

    public boolean getLocalMatrix(@NonNull Matrix localMatrix) {
        if (this.mLocalMatrix != null) {
            localMatrix.set(this.mLocalMatrix);
            return true;
        }
        return false;
    }

    public boolean localMatrixEquals(@Nullable Matrix localMatrix) {
        if (localMatrix == null || localMatrix.isIdentity()) {
            return this.mLocalMatrix == null;
        }
        if (this.mLocalMatrix == null) {
            return false;
        }
        return this.mLocalMatrix.equals(localMatrix);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MipmapMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FilterMode {
    }
}

