/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.graphics;

import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.graphics.Point;

public class PointF {
    public float x;
    public float y;

    public PointF() {
    }

    public PointF(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public PointF(@NonNull Point p2) {
        this.x = p2.x;
        this.y = p2.y;
    }

    public PointF(@NonNull PointF p2) {
        this.x = p2.x;
        this.y = p2.y;
    }

    @NonNull
    public static PointF copy(@Nullable PointF p2) {
        return p2 == null ? new PointF() : p2.copy();
    }

    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void set(@NonNull Point p2) {
        this.x = p2.x;
        this.y = p2.y;
    }

    public void set(@NonNull PointF p2) {
        this.x = p2.x;
        this.y = p2.y;
    }

    public void negate() {
        this.x = -this.x;
        this.y = -this.y;
    }

    public void offset(float dx, float dy) {
        this.x += dx;
        this.y += dy;
    }

    public float length() {
        return yslelf.cloudpick.render.core.Point.length(this.x, this.y);
    }

    public boolean normalize() {
        float newY;
        double x = this.x;
        double y = this.y;
        double dmag = Math.sqrt(x * x + y * y);
        double dscale = 1.0 / dmag;
        float newX = (float)(x * dscale);
        if (yslelf.cloudpick.render.core.Point.isDegenerate(newX, newY = (float)(y * dscale))) {
            return false;
        }
        this.x = newX;
        this.y = newY;
        return true;
    }

    public void round(@NonNull Point dst) {
        dst.set(Math.round(this.x), Math.round(this.y));
    }

    public int hashCode() {
        int result = this.x != 0.0f ? Float.floatToIntBits(this.x) : 0;
        result = 31 * result + (this.y != 0.0f ? Float.floatToIntBits(this.y) : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PointF) {
            PointF p2 = (PointF)o;
            return this.x == p2.x && this.y == p2.y;
        }
        return false;
    }

    public String toString() {
        return "PointF(" + this.x + ", " + this.y + ")";
    }

    @NonNull
    public PointF copy() {
        return new PointF(this.x, this.y);
    }
}

